#ifndef __INCNETDEV_INCLUDE__
#define __INCNETDEV_INCLUDE__

#include <linux/if_ether.h>
#include <linux/inc.h>

struct incnetdev_packet {
	struct inc_hdr *hdr;
	int len;
	unsigned char *buf;
	void *priv; /*netdev private*/
};


struct inc_ndev {
	struct net_device *ndev;	/*attached netdevice*/
	void *port_handle;
};

struct inc_ndev *inc_netdev_create(void *port_handle, char mac,
		unsigned int mtu, char *ifname);
int inc_netdev_destroy(struct inc_ndev *incndev);
void incnetdev_configure(struct net_device *ndev, __be32 addr);

/*tx*/
void incnetdev_next_tx_packets(struct inc_ndev *incndev);
void incnetdev_stop_tx_packets(struct inc_ndev *incndev);
void incnetdev_tx_err_ind(struct inc_ndev *incndev);

int incnetdev_sent_tx_packet(struct inc_ndev *,
		struct sk_buff *skb, int success);

void incnetdev_carrier_err_ind(struct inc_ndev *incndev);
/*rx*/
unsigned int incnetdev_mtu(struct inc_ndev *incndev);

struct sk_buff *incnetdev_rx_packet_alloc(struct inc_ndev *incndev,
		struct inc_hdr *hdr, unsigned int length);
void incnetdev_rx_err_ind(struct inc_ndev *incndev);

int incnetdev_rx_packet_cpy(struct inc_ndev *incndev,
		struct sk_buff *skb, unsigned char *buf, unsigned int length);
int incnetdev_rx_packet_put(struct inc_ndev *incndev,
		struct sk_buff *skb);
int incnetdev_rx_packet_drop(struct inc_ndev *incndev,
		struct sk_buff *skb);
int incnetdev_rx_packet_reset(struct inc_ndev *incndev,
			struct sk_buff *skb);


#endif /*__INCNETDEV_INCLUDE__*/
