/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2014
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

/* Note: this is an auto-generated file. */

#include "csr_synergy.h"

#include "csr_pmem.h"
#include "csr_wifi_router_ctrl_prim.h"
#include "csr_wifi_router_ctrl_lib.h"

static void CsrWifiRouterCtrlHipIndFreeContents(CsrWifiRouterCtrlHipInd *message)
{
    CsrPmemFree(message->mlmeCommand);
    message->mlmeCommand = NULL;
    CsrPmemFree(message->dataRef1);
    message->dataRef1 = NULL;
    CsrPmemFree(message->dataRef2);
    message->dataRef2 = NULL;
}

static void CsrWifiRouterCtrlMulticastAddressIndFreeContents(CsrWifiRouterCtrlMulticastAddressInd *message)
{
    CsrPmemFree(message->setAddresses);
    message->setAddresses = NULL;
}

static void CsrWifiRouterCtrlWifiOnIndFreeContents(CsrWifiRouterCtrlWifiOnInd *message)
{
    CsrPmemFree(message->versions.routerBuild);
    message->versions.routerBuild = NULL;
}

static void CsrWifiRouterCtrlWapiRxMicCheckIndFreeContents(CsrWifiRouterCtrlWapiRxMicCheckInd *message)
{
    CsrPmemFree(message->signal);
    message->signal = NULL;
    CsrPmemFree(message->data);
    message->data = NULL;
}

/*----------------------------------------------------------------------------*
 *  NAME
 *      CsrWifiRouterCtrlFreeUpstreamMessageContents
 *
 *  DESCRIPTION
 *
 *
 *  PARAMETERS
 *      eventClass: only the value CSR_WIFI_ROUTER_CTRL_PRIM will be handled
 *      message:    the message to free
 *----------------------------------------------------------------------------*/
void CsrWifiRouterCtrlFreeUpstreamMessageContents(CsrUint16 eventClass, void *message)
{
    CsrWifiFsmEvent *evt = (CsrWifiFsmEvent *) message;
    if (evt && (eventClass == CSR_WIFI_ROUTER_CTRL_PRIM))
    {
        switch (evt->type)
        {
            case CSR_WIFI_ROUTER_CTRL_HIP_IND:
                CsrWifiRouterCtrlHipIndFreeContents((CsrWifiRouterCtrlHipInd *) message);
                break;
            case CSR_WIFI_ROUTER_CTRL_MULTICAST_ADDRESS_IND:
                CsrWifiRouterCtrlMulticastAddressIndFreeContents((CsrWifiRouterCtrlMulticastAddressInd *) message);
                break;
            case CSR_WIFI_ROUTER_CTRL_WIFI_ON_IND:
                CsrWifiRouterCtrlWifiOnIndFreeContents((CsrWifiRouterCtrlWifiOnInd *) message);
                break;
            case CSR_WIFI_ROUTER_CTRL_WAPI_RX_MIC_CHECK_IND:
                CsrWifiRouterCtrlWapiRxMicCheckIndFreeContents((CsrWifiRouterCtrlWapiRxMicCheckInd *) message);
                break;
            default:
                break;
        }
    }
}
