/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#ifndef CSR_WIFI_PS_QSIG_H__
#define CSR_WIFI_PS_QSIG_H__

#include "csr_synergy.h"

#ifdef __cplusplus
extern "C" {
#endif

#define UNIFI_QSIG_BUF 400

#ifdef PS_USPACE
#define UNIFI_MAX_DATA_REFERENCES 2
#define UNIFI_PACKED_SIGBUF_SIZE   64

typedef struct card_signal
{
    CsrUint8 sigbuf[UNIFI_PACKED_SIGBUF_SIZE];

    /* Length of the SIGNAL inside sigbuf */
    CsrUint16 signal_length;

    CsrWifiHipBulkDataDesc bulkdata[UNIFI_MAX_DATA_REFERENCES];

    CsrInt16 cfm;
} card_signal_t;
#endif


struct csrWifiPacketSchedulerCommonPart;
typedef struct csrWifiHipPacketSchedulerQsig
{
    CsrWifiHipPacketSchedulerListEntry       qptr;
    card_signal_t                            signal;
    struct csrWifiPacketSchedulerCommonPart *cp;
    CsrUint16                                data_len;
    enum
    {
        SIGNAL_CTRL = 0,
        SIGNAL_MGMT = 1,
        SIGNAL_UNICAST = 2,
        SIGNAL_MULTICAST = 3
    } type;
    CsrUint16 pri;
    CsrUint16 ref;
} CsrWifiHipPacketSchedulerQsig;

#define qsig_get_signal_ptr(qsig) (&(qsig->signal))
#define qsig_set_signal_copy(qsig, signal) (qsig->signal = *signal)
#define qsig_get_signal_datalen(qsig) (qsig->data_len)
#define qsig_set_signal_datalen(qsig, len) (qsig->data_len = len)
#define qsig_get_signal_type(qsig) (qsig->type)
#define qsig_set_signal_type(qsig, typ) (qsig->type = typ)
#define qsig_set_signal_pri(qsig, pr) (qsig->pri = pr)
#define qsig_get_signal_pri(qsig) (qsig->pri)

#ifdef __cplusplus
}
#endif
#endif
