/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#ifndef CSR_WIFI_PS_Q_H__
#define CSR_WIFI_PS_Q_H__

#include "csr_synergy.h"
#include "csr_wifi_hip_list.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
 * This structure must be placed first in a structure to be added
 * to a list so that the address of the structure and the address
 * of this structure coincide.
 */
struct csrWifiHipPacketSchedulerList;

typedef struct csrWifiHipPacketSchedulerListEntry
{
    struct listHeader                     list_pointers;
    struct csrWifiHipPacketSchedulerList *list;
} CsrWifiHipPacketSchedulerListEntry;

typedef struct csrWifiHipPacketSchedulerList
{
    struct listHeader  list_pointers;
    struct listHeader *currentp;
    CsrInt32           entries;
} CsrWifiHipPacketSchedulerList;

extern void csrWifiHipPacketSchedulerListAddTail(CsrWifiHipPacketSchedulerList *list, CsrWifiHipPacketSchedulerListEntry *q);
extern void ps_list_del(CsrWifiHipPacketSchedulerList *list, CsrWifiHipPacketSchedulerListEntry *q);
extern CsrWifiHipPacketSchedulerListEntry *csrWifiHipPacketSchedulerListTakeFirst(CsrWifiHipPacketSchedulerList *list);
extern CsrWifiHipPacketSchedulerListEntry *csrWifiHipPacketSchedulerListGetFirst(CsrWifiHipPacketSchedulerList *list);
extern CsrWifiHipPacketSchedulerListEntry *csrWifiHipPacketSchedulerListGetNext(CsrWifiHipPacketSchedulerList *list);
extern CsrWifiHipPacketSchedulerListEntry *csrWifiHipPacketSchedulerListPeek(CsrWifiHipPacketSchedulerList *list);
extern CsrWifiHipPacketSchedulerListEntry *csrWifiHipPacketSchedulerListNext(CsrWifiHipPacketSchedulerListEntry *entry);
extern void csrWifiHipPacketSchedulerListTake(CsrWifiHipPacketSchedulerList *list, CsrWifiHipPacketSchedulerListEntry *ptr);
extern void csrWifiHipPacketSchedulerListInit(CsrWifiHipPacketSchedulerList *list);

#ifdef __cplusplus
}
#endif
#endif
