/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#include "csr_synergy.h"

#ifdef PS_USPACE
#include "csr_wifi_ps_types.h"
#else
#include "csr_wifi_hip_unifi.h"
#include "csr_wifi_hip_conversions.h"
#include "csr_wifi_hip_card.h"
#endif
#include "csr_wifi_ps_q.h"
#include "csr_wifi_ps_circ.h"
#include "csr_wifi_ps_qsig.h"

#include "csr_wifi_ps_if.h"
#include "csr_wifi_ps.h"

#ifdef PS_USPACE
#include "csr_wifi_ps_card.h"
#endif

CsrResult ps_circ_add_tail(ps_circ_buffer_t *buf, CsrWifiHipPacketSchedulerQsig *qsig)
{
    CsrUint16 index;
    if (!(CSR_WIFI_PS_Q_SLOTS_FREE(buf)))
    {
        return CSR_RESULT_FAILURE;
    }

    index = CSR_WIFI_PS_Q_NEXT_W_SLOT(buf);
    CSR_WIFI_PS_Q_SLOT_DATA(buf, index) = qsig;
    CSR_WIFI_PS_Q_INC_W(buf);
    return CSR_RESULT_SUCCESS;
}

CsrWifiHipPacketSchedulerQsig *ps_circ_peek(ps_circ_buffer_t *buf)
{
    CsrUint16 index;
    if (CSR_WIFI_PS_Q_SLOTS_USED(buf))
    {
        index = CSR_WIFI_PS_Q_NEXT_R_SLOT(buf);

        return CSR_WIFI_PS_Q_SLOT_DATA(buf, index);
    }
    return 0;
}
