/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2012
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

/* Note: this is an auto-generated file. */

#include "csr_synergy.h"

#include "csr_wifi_hip_signals.h"
#include "csr_wifi_hip_unifi.h"
#include "csr_wifi_hip_conversions.h"


/*
 * ---------------------------------------------------------------------------
 *  get_packed_struct_size
 *
 *      Examine a buffer containing a UniFi signal in wire-format.
 *      The first two bytes contain the signal ID, decode the signal ID and
 *      return the size, in  bytes, of the signal, not including any bulk
 *      data.
 *
 *      WARNING: This function is auto-generated, DO NOT EDIT!
 *
 *  Arguments:
 *      buf     Pointer to buffer to decode.
 *
 *  Returns:
 *      0 if the signal ID is not recognised (i.e. zero length),
 *      otherwise the number of bytes occupied by the signal in the buffer.
 *      This is useful for stepping past the signal to the object in the buffer.
 * ---------------------------------------------------------------------------
 */
CsrInt32 get_packed_struct_size(const CsrUint8 *buf)
{
    CsrInt32 size = 0;
    CsrUint16 sig_id;

    sig_id = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(buf);

    size += SIZEOF_UINT16;
    size += SIZEOF_UINT16;
    size += SIZEOF_UINT16;
    switch (sig_id)
    {
        case CSR_CME_DELETE_BLE_ADVERTISEMENT_INFO_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_PACKET_FILTER_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SETKEYS_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONFIG_QUEUE_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_AUTONOMOUS_SCAN_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_ACL_CONNECTION_INFO_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_BLACKOUT_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_BLACKOUT_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_GET_KEY_SEQUENCE_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_STOP_AGGREGATION_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_TSPEC_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_INQUIRY_PAGE_INFO_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
        case CSR_DEBUG_WORD16_INDICATION_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
        case CSR_DEBUG_GENERIC_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
        case CSR_MA_PACKET_INDICATION_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT64;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONFIG_CHANNELS_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_FILE_GET_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_BLE_ADVERTISEMENT_INFO_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_VIF_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_ESCO_INFO_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_RX_TRIGGER_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_VIF_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_TRIGGERED_GET_INDICATION_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SCAN_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT32;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DELETEKEYS_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_CHANNEL_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_START_AGGREGATION_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_HL_SYNC_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            break;
#endif
        case CSR_DEBUG_GENERIC_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
        case CSR_CME_ADD_BLE_SCAN_INFO_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
        case CSR_CME_ADD_BLE_ADVERTISEMENT_INFO_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_TRIGGERED_GET_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_MULTICAST_ADDRESS_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_BLE_ADVERTISEMENT_INFO_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
        case CSR_CME_ADD_ESCO_INFO_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_RESET_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SCAN_CANCEL_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_START_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_ACL_CONNECTION_INFO_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            break;
        case CSR_CME_GENERIC_COMMAND_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TRIGGERED_GET_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_PACKET_FILTER_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT32;
            break;
#endif
        case CSR_CME_ADD_ESCO_INFO_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_RX_TRIGGER_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONNECT_STATUS_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONFIG_QUEUE_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_TSPEC_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_GENERIC_COMMAND_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_BLACKOUT_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_TRIGGERED_GET_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_DEBUG_GENERIC_INDICATION_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
        case CSR_MA_PACKET_CANCEL_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT32;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_MODIFY_BSS_PARAMETER_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_BLE_SCAN_INFO_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_PAUSE_AUTONOMOUS_SCAN_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_PROBE_REQUEST_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_START_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT32;
            break;
#endif
        case CSR_MA_PACKET_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT32;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_MODIFY_BSS_PARAMETER_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            break;
#endif
        case CSR_CME_ADD_A2DP_INFO_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_RX_TRIGGER_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_ACL_CONNECTION_INFO_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_HL_SYNC_CANCEL_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CANCEL_VIF_TIME_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_AUTONOMOUS_SCAN_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_BLACKOUT_ENDED_INDICATION_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_MIB_ERROR_INDICATION_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_BLE_CONNECTION_INFO_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_AUTONOMOUS_SCAN_DONE_INDICATION_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_INQUIRY_PAGE_INFO_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_GET_KEY_SEQUENCE_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_INQUIRY_PAGE_INFO_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_CHANNEL_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT32;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TRIGGERED_GET_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_AUTONOMOUS_SCAN_LOSS_INDICATION_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            break;
#endif
        case CSR_CME_DELETE_BLE_CONNECTION_INFO_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TEMPLATE_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_POWERMGT_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_PERIODIC_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SYNCHRONISATION_INDICATION_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_GET_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONFIG_CHANNELS_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_STOP_AGGREGATION_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_VIF_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            size += 48 / 8;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CANCEL_VIF_TIME_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_RX_TRIGGER_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_BLACKOUT_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT32;
            size += SIZEOF_UINT32;
            size += SIZEOF_UINT32;
            size += 48 / 8;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DELETEKEYS_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            break;
#endif
        case CSR_CME_ADD_ACL_CONNECTION_INFO_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_RESET_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_HL_SYNC_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_AUTONOMOUS_SCAN_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT32;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_ESCO_INFO_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_GENERIC_COMMAND_INDICATION_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
        case CSR_CME_DELETE_BLE_CONNECTION_INFO_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONNECT_STATUS_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_AUTONOMOUS_SCAN_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_PERIODIC_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SETKEYS_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 32 / 8;
            break;
#endif
        case CSR_CME_DELETE_BLE_SCAN_INFO_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
        case CSR_CME_DELETE_A2DP_INFO_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_PAUSE_AUTONOMOUS_SCAN_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_BLE_CONNECTION_INFO_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_GET_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_POWERMGT_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_MA_PACKET_ERROR_INDICATION_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_PERIODIC_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT32;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TSPEC_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT32;
            size += SIZEOF_UINT32;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_FILE_GET_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_BLE_SCAN_INFO_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_MULTICAST_ADDRESS_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TSPEC_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_HL_SYNC_CANCEL_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SCAN_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_DEBUG_STRING_INDICATION_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
        case CSR_CME_CLOCK_SYNCHRONISATION_INDICATION_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            size += SIZEOF_UINT32;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TEMPLATE_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_BLOCKACK_ERROR_INDICATION_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_START_AGGREGATION_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_PROBE_REQUEST_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += 48 / 8;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_VIF_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_A2DP_INFO_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
        case CSR_MA_PACKET_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT32;
            break;
        case CSR_CME_DELETE_INQUIRY_PAGE_INFO_REQUEST_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
        case CSR_CME_DELETE_A2DP_INFO_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_PERIODIC_CONFIRM_ID:
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            size += SIZEOF_UINT16;
            break;
#endif
        default:
            size = 0;
    }
    return size;
} /* get_packed_struct_size() */

/*
 * ---------------------------------------------------------------------------
 *  read_unpack_signal
 *
 *      Unpack a wire-format signal into a host-native structure.
 *      This function handles any necessary conversions for endianness and
 *      places no restrictions on packing or alignment for the structure
 *      definition.
 *
 *      WARNING: This function is auto-generated, DO NOT EDIT!
 *
 *  Arguments:
 *      ptr             Signal buffer to unpack.
 *      sig             Pointer to destination structure to populate.
 *
 *  Returns:
 *      CSR_RESULT_SUCCESS on success,
 *      CSR_WIFI_HIP_RESULT_INVALID_VALUE if the ID of signal was not recognised.
 * ---------------------------------------------------------------------------
 */
CsrResult read_unpack_signal(const CsrUint8 *ptr, CSR_SIGNAL *sig)
{
    CsrInt32 index = 0;

    sig->SignalPrimitiveHeader.SignalId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
    index += SIZEOF_UINT16;

    sig->SignalPrimitiveHeader.ReceiverProcessId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
    index += SIZEOF_UINT16;

    sig->SignalPrimitiveHeader.SenderProcessId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
    index += SIZEOF_UINT16;

    switch (sig->SignalPrimitiveHeader.SignalId)
    {
        case CSR_CME_DELETE_BLE_ADVERTISEMENT_INFO_CONFIRM_ID:
            sig->u.CmeDeleteBleAdvertisementInfoConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleAdvertisementInfoConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleAdvertisementInfoConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleAdvertisementInfoConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleAdvertisementInfoConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_PACKET_FILTER_CONFIRM_ID:
            sig->u.MlmeSetPacketFilterConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetPacketFilterConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetPacketFilterConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetPacketFilterConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetPacketFilterConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetPacketFilterConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SETKEYS_CONFIRM_ID:
            sig->u.MlmeSetkeysConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetkeysConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetkeysConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetkeysConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetkeysConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetkeysConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONFIG_QUEUE_CONFIRM_ID:
            sig->u.MlmeConfigQueueConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigQueueConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigQueueConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigQueueConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigQueueConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigQueueConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_AUTONOMOUS_SCAN_CONFIRM_ID:
            sig->u.MlmeAddAutonomousScanConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddAutonomousScanConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddAutonomousScanConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddAutonomousScanConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddAutonomousScanConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddAutonomousScanConfirm.AutonomousScanId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_ACL_CONNECTION_INFO_CONFIRM_ID:
            sig->u.CmeAddAclConnectionInfoConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddAclConnectionInfoConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddAclConnectionInfoConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddAclConnectionInfoConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddAclConnectionInfoConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_BLACKOUT_CONFIRM_ID:
            sig->u.MlmeAddBlackoutConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddBlackoutConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddBlackoutConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddBlackoutConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddBlackoutConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddBlackoutConfirm.BlackoutId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddBlackoutConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_BLACKOUT_REQUEST_ID:
            sig->u.MlmeDelBlackoutRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelBlackoutRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelBlackoutRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelBlackoutRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelBlackoutRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelBlackoutRequest.BlackoutId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_GET_KEY_SEQUENCE_CONFIRM_ID:
            sig->u.MlmeGetKeySequenceConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetKeySequenceConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetKeySequenceConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetKeySequenceConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetKeySequenceConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetKeySequenceConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetKeySequenceConfirm.SequenceNumber[0] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetKeySequenceConfirm.SequenceNumber[1] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetKeySequenceConfirm.SequenceNumber[2] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetKeySequenceConfirm.SequenceNumber[3] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetKeySequenceConfirm.SequenceNumber[4] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetKeySequenceConfirm.SequenceNumber[5] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetKeySequenceConfirm.SequenceNumber[6] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetKeySequenceConfirm.SequenceNumber[7] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_STOP_AGGREGATION_CONFIRM_ID:
            sig->u.MlmeStopAggregationConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStopAggregationConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStopAggregationConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStopAggregationConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStopAggregationConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.MlmeStopAggregationConfirm.PeerQstaAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.MlmeStopAggregationConfirm.UserPriority = (CSR_PRIORITY) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStopAggregationConfirm.Direction = (CSR_DIRECTION) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStopAggregationConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_TSPEC_REQUEST_ID:
            sig->u.MlmeDelTspecRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTspecRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTspecRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTspecRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTspecRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTspecRequest.UserPriority = (CSR_PRIORITY) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTspecRequest.Direction = (CSR_DIRECTION) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_INQUIRY_PAGE_INFO_REQUEST_ID:
            sig->u.CmeAddInquiryPageInfoRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddInquiryPageInfoRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddInquiryPageInfoRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddInquiryPageInfoRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddInquiryPageInfoRequest.Type = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_DEBUG_WORD16_INDICATION_ID:
            sig->u.DebugWord16Indication.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugWord16Indication.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugWord16Indication.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugWord16Indication.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugWord16Indication.DebugWords[0] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugWord16Indication.DebugWords[1] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugWord16Indication.DebugWords[2] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugWord16Indication.DebugWords[3] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugWord16Indication.DebugWords[4] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugWord16Indication.DebugWords[5] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugWord16Indication.DebugWords[6] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugWord16Indication.DebugWords[7] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugWord16Indication.DebugWords[8] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugWord16Indication.DebugWords[9] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugWord16Indication.DebugWords[10] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugWord16Indication.DebugWords[11] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugWord16Indication.DebugWords[12] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugWord16Indication.DebugWords[13] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugWord16Indication.DebugWords[14] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugWord16Indication.DebugWords[15] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_DEBUG_GENERIC_CONFIRM_ID:
            sig->u.DebugGenericConfirm.DebugVariable.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericConfirm.DebugVariable.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericConfirm.DebugWords[0] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericConfirm.DebugWords[1] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericConfirm.DebugWords[2] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericConfirm.DebugWords[3] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericConfirm.DebugWords[4] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericConfirm.DebugWords[5] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericConfirm.DebugWords[6] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericConfirm.DebugWords[7] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_MA_PACKET_INDICATION_ID:
            sig->u.MaPacketIndication.Data.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketIndication.Data.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketIndication.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketIndication.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketIndication.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.MaPacketIndication.LocalTime.x, &ptr[index], 64 / 8);
            index += 64 / 8;
            sig->u.MaPacketIndication.ChannelFrequency = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketIndication.ChannelInformation = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketIndication.ReceptionStatus = (CSR_RECEPTION_STATUS) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketIndication.Rssi = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketIndication.Snr = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketIndication.ReceivedRate = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONFIG_CHANNELS_CONFIRM_ID:
            sig->u.MlmeConfigChannelsConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigChannelsConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigChannelsConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigChannelsConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigChannelsConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_FILE_GET_CONFIRM_ID:
            sig->u.MlmeFileGetConfirm.Data.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeFileGetConfirm.Data.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeFileGetConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeFileGetConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeFileGetConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeFileGetConfirm.FileIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeFileGetConfirm.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_BLE_ADVERTISEMENT_INFO_CONFIRM_ID:
            sig->u.CmeAddBleAdvertisementInfoConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleAdvertisementInfoConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleAdvertisementInfoConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleAdvertisementInfoConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleAdvertisementInfoConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_VIF_CONFIRM_ID:
            sig->u.MlmeAddVifConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddVifConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddVifConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddVifConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddVifConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddVifConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_ESCO_INFO_CONFIRM_ID:
            sig->u.CmeDeleteEscoInfoConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteEscoInfoConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteEscoInfoConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteEscoInfoConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteEscoInfoConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_RX_TRIGGER_REQUEST_ID:
            sig->u.MlmeDelRxTriggerRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelRxTriggerRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelRxTriggerRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelRxTriggerRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelRxTriggerRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelRxTriggerRequest.TriggerId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_VIF_CONFIRM_ID:
            sig->u.MlmeDelVifConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelVifConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelVifConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelVifConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelVifConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelVifConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_TRIGGERED_GET_INDICATION_ID:
            sig->u.MlmeTriggeredGetIndication.MibVariableElement.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeTriggeredGetIndication.MibVariableElement.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeTriggeredGetIndication.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeTriggeredGetIndication.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeTriggeredGetIndication.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeTriggeredGetIndication.TriggeredId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SCAN_REQUEST_ID:
            sig->u.MlmeScanRequest.ChannelList.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeScanRequest.ChannelList.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeScanRequest.SsidElements.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeScanRequest.SsidElements.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeScanRequest.ProbeRequestId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeScanRequest.ProbeDelay = CSR_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT32;
            sig->u.MlmeScanRequest.MinChannelTimeActiveScan = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeScanRequest.MaxChannelTimeActiveScan = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeScanRequest.MinChannelTimePassiveScan = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeScanRequest.MaxChannelTimePassiveScan = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DELETEKEYS_CONFIRM_ID:
            sig->u.MlmeDeletekeysConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDeletekeysConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDeletekeysConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDeletekeysConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDeletekeysConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDeletekeysConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_CHANNEL_CONFIRM_ID:
            sig->u.MlmeSetChannelConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetChannelConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetChannelConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetChannelConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetChannelConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetChannelConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_START_AGGREGATION_REQUEST_ID:
            sig->u.MlmeStartAggregationRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartAggregationRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartAggregationRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartAggregationRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartAggregationRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.MlmeStartAggregationRequest.PeerQstaAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.MlmeStartAggregationRequest.UserPriority = (CSR_PRIORITY) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartAggregationRequest.Direction = (CSR_DIRECTION) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartAggregationRequest.StartingSequenceNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartAggregationRequest.BufferSize = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartAggregationRequest.BlockAckTimeout = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_HL_SYNC_REQUEST_ID:
            sig->u.MlmeHlSyncRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeHlSyncRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeHlSyncRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeHlSyncRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.MlmeHlSyncRequest.GroupAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            break;
#endif
        case CSR_DEBUG_GENERIC_REQUEST_ID:
            sig->u.DebugGenericRequest.DebugVariable.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericRequest.DebugVariable.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericRequest.DebugWords[0] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericRequest.DebugWords[1] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericRequest.DebugWords[2] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericRequest.DebugWords[3] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericRequest.DebugWords[4] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericRequest.DebugWords[5] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericRequest.DebugWords[6] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericRequest.DebugWords[7] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_ADD_BLE_SCAN_INFO_REQUEST_ID:
            sig->u.CmeAddBleScanInfoRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleScanInfoRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleScanInfoRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleScanInfoRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleScanInfoRequest.ScanType = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleScanInfoRequest.Period = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleScanInfoRequest.Window = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_ADD_BLE_ADVERTISEMENT_INFO_REQUEST_ID:
            sig->u.CmeAddBleAdvertisementInfoRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleAdvertisementInfoRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleAdvertisementInfoRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleAdvertisementInfoRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleAdvertisementInfoRequest.Type = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleAdvertisementInfoRequest.MinPeriod = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleAdvertisementInfoRequest.MaxPeriod = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleAdvertisementInfoRequest.ChannelMap = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_TRIGGERED_GET_REQUEST_ID:
            sig->u.MlmeDelTriggeredGetRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTriggeredGetRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTriggeredGetRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTriggeredGetRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTriggeredGetRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTriggeredGetRequest.TriggeredId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_MULTICAST_ADDRESS_REQUEST_ID:
            sig->u.MlmeAddMulticastAddressRequest.Data.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddMulticastAddressRequest.Data.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddMulticastAddressRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddMulticastAddressRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddMulticastAddressRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddMulticastAddressRequest.NumberOfMulticastGroupAddresses = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_BLE_ADVERTISEMENT_INFO_REQUEST_ID:
            sig->u.CmeDeleteBleAdvertisementInfoRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleAdvertisementInfoRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleAdvertisementInfoRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleAdvertisementInfoRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_ADD_ESCO_INFO_REQUEST_ID:
            sig->u.CmeAddEscoInfoRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddEscoInfoRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddEscoInfoRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddEscoInfoRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddEscoInfoRequest.AclHandle = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.CmeAddEscoInfoRequest.BluetoothAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.CmeAddEscoInfoRequest.ScoHandle = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddEscoInfoRequest.Period = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddEscoInfoRequest.Window = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddEscoInfoRequest.RetransmissionWindow = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddEscoInfoRequest.TxSize = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddEscoInfoRequest.RxSize = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddEscoInfoRequest.AirMode = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_RESET_REQUEST_ID:
            sig->u.MlmeResetRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeResetRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeResetRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeResetRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SCAN_CANCEL_REQUEST_ID:
            sig->u.MlmeScanCancelRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeScanCancelRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeScanCancelRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeScanCancelRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_START_CONFIRM_ID:
            sig->u.MlmeStartConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_ACL_CONNECTION_INFO_REQUEST_ID:
            sig->u.CmeDeleteAclConnectionInfoRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteAclConnectionInfoRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteAclConnectionInfoRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteAclConnectionInfoRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteAclConnectionInfoRequest.AclHandle = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.CmeDeleteAclConnectionInfoRequest.BluetoothAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            break;
        case CSR_CME_GENERIC_COMMAND_CONFIRM_ID:
            sig->u.CmeGenericCommandConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeGenericCommandConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeGenericCommandConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeGenericCommandConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeGenericCommandConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TRIGGERED_GET_CONFIRM_ID:
            sig->u.MlmeAddTriggeredGetConfirm.MibVariableStatus.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTriggeredGetConfirm.MibVariableStatus.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTriggeredGetConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTriggeredGetConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTriggeredGetConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTriggeredGetConfirm.TriggeredId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_PACKET_FILTER_REQUEST_ID:
            sig->u.MlmeSetPacketFilterRequest.InformationElements.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetPacketFilterRequest.InformationElements.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetPacketFilterRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetPacketFilterRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetPacketFilterRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetPacketFilterRequest.PacketFilterMode = (CSR_PACKET_FILTER_MODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetPacketFilterRequest.ArpFilterAddress = CSR_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT32;
            break;
#endif
        case CSR_CME_ADD_ESCO_INFO_CONFIRM_ID:
            sig->u.CmeAddEscoInfoConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddEscoInfoConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddEscoInfoConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddEscoInfoConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddEscoInfoConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_RX_TRIGGER_CONFIRM_ID:
            sig->u.MlmeDelRxTriggerConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelRxTriggerConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelRxTriggerConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelRxTriggerConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelRxTriggerConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelRxTriggerConfirm.TriggerId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelRxTriggerConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONNECT_STATUS_REQUEST_ID:
            sig->u.MlmeConnectStatusRequest.InformationElements.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConnectStatusRequest.InformationElements.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConnectStatusRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConnectStatusRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConnectStatusRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConnectStatusRequest.ConnectionStatus = (CSR_CONNECTION_STATUS) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.MlmeConnectStatusRequest.StaAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.MlmeConnectStatusRequest.AssociationInformation = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConnectStatusRequest.AssociationCapabilityInformation = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONFIG_QUEUE_REQUEST_ID:
            sig->u.MlmeConfigQueueRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigQueueRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigQueueRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigQueueRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigQueueRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigQueueRequest.QueueIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigQueueRequest.Aifs = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigQueueRequest.Ecwmin = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigQueueRequest.Ecwmax = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigQueueRequest.TxopLimit = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_TSPEC_CONFIRM_ID:
            sig->u.MlmeDelTspecConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTspecConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTspecConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTspecConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTspecConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTspecConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_GENERIC_COMMAND_REQUEST_ID:
            sig->u.CmeGenericCommandRequest.CommandData.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeGenericCommandRequest.CommandData.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeGenericCommandRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeGenericCommandRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_BLACKOUT_CONFIRM_ID:
            sig->u.MlmeDelBlackoutConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelBlackoutConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelBlackoutConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelBlackoutConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelBlackoutConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelBlackoutConfirm.BlackoutId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelBlackoutConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_TRIGGERED_GET_CONFIRM_ID:
            sig->u.MlmeDelTriggeredGetConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTriggeredGetConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTriggeredGetConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTriggeredGetConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTriggeredGetConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTriggeredGetConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelTriggeredGetConfirm.TriggeredId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_DEBUG_GENERIC_INDICATION_ID:
            sig->u.DebugGenericIndication.DebugVariable.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericIndication.DebugVariable.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericIndication.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericIndication.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericIndication.DebugWords[0] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericIndication.DebugWords[1] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericIndication.DebugWords[2] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericIndication.DebugWords[3] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericIndication.DebugWords[4] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericIndication.DebugWords[5] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericIndication.DebugWords[6] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugGenericIndication.DebugWords[7] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_MA_PACKET_CANCEL_REQUEST_ID:
            sig->u.MaPacketCancelRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketCancelRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketCancelRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketCancelRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketCancelRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketCancelRequest.HostTag = CSR_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT32;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_MODIFY_BSS_PARAMETER_CONFIRM_ID:
            sig->u.MlmeModifyBssParameterConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeModifyBssParameterConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeModifyBssParameterConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeModifyBssParameterConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeModifyBssParameterConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeModifyBssParameterConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_BLE_SCAN_INFO_CONFIRM_ID:
            sig->u.CmeDeleteBleScanInfoConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleScanInfoConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleScanInfoConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleScanInfoConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleScanInfoConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_PAUSE_AUTONOMOUS_SCAN_CONFIRM_ID:
            sig->u.MlmePauseAutonomousScanConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePauseAutonomousScanConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePauseAutonomousScanConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePauseAutonomousScanConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePauseAutonomousScanConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePauseAutonomousScanConfirm.AutonomousScanId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_PROBE_REQUEST_CONFIRM_ID:
            sig->u.MlmeAddProbeRequestConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddProbeRequestConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddProbeRequestConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddProbeRequestConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddProbeRequestConfirm.ProbeRequestId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddProbeRequestConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_START_REQUEST_ID:
            sig->u.MlmeStartRequest.Beacon.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartRequest.Beacon.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartRequest.BssParameters.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartRequest.BssParameters.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.MlmeStartRequest.Bssid.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.MlmeStartRequest.BeaconPeriod = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartRequest.DtimPeriod = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartRequest.CapabilityInformation = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartRequest.Delay = CSR_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT32;
            break;
#endif
        case CSR_MA_PACKET_REQUEST_ID:
            sig->u.MaPacketRequest.Data.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketRequest.Data.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketRequest.TransmitRate = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketRequest.HostTag = CSR_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT32;
            sig->u.MaPacketRequest.Priority = (CSR_PRIORITY) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.MaPacketRequest.Ra.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.MaPacketRequest.TransmissionControlBitmap = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketRequest.MinVifDuration = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_MODIFY_BSS_PARAMETER_REQUEST_ID:
            sig->u.MlmeModifyBssParameterRequest.Data.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeModifyBssParameterRequest.Data.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeModifyBssParameterRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeModifyBssParameterRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeModifyBssParameterRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeModifyBssParameterRequest.BeaconPeriod = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeModifyBssParameterRequest.DtimPeriod = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeModifyBssParameterRequest.CapabilityInformation = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.MlmeModifyBssParameterRequest.Bssid.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            break;
#endif
        case CSR_CME_ADD_A2DP_INFO_REQUEST_ID:
            sig->u.CmeAddA2DpInfoRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddA2DpInfoRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddA2DpInfoRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddA2DpInfoRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddA2DpInfoRequest.AclHandle = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.CmeAddA2DpInfoRequest.BluetoothAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.CmeAddA2DpInfoRequest.ChannelId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddA2DpInfoRequest.BurstStartStop = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddA2DpInfoRequest.Window = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddA2DpInfoRequest.Period = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddA2DpInfoRequest.EstimatedBitRate = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_RX_TRIGGER_REQUEST_ID:
            sig->u.MlmeAddRxTriggerRequest.InformationElements.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddRxTriggerRequest.InformationElements.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddRxTriggerRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddRxTriggerRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddRxTriggerRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddRxTriggerRequest.TriggerId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddRxTriggerRequest.Priority = (CSR_PRIORITY) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_ACL_CONNECTION_INFO_CONFIRM_ID:
            sig->u.CmeDeleteAclConnectionInfoConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteAclConnectionInfoConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteAclConnectionInfoConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteAclConnectionInfoConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteAclConnectionInfoConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_HL_SYNC_CANCEL_REQUEST_ID:
            sig->u.MlmeHlSyncCancelRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeHlSyncCancelRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeHlSyncCancelRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeHlSyncCancelRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.MlmeHlSyncCancelRequest.GroupAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CANCEL_VIF_TIME_CONFIRM_ID:
            sig->u.MlmeCancelVifTimeConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeCancelVifTimeConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeCancelVifTimeConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeCancelVifTimeConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeCancelVifTimeConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeCancelVifTimeConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_AUTONOMOUS_SCAN_REQUEST_ID:
            sig->u.MlmeDelAutonomousScanRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelAutonomousScanRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelAutonomousScanRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelAutonomousScanRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelAutonomousScanRequest.AutonomousScanId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_BLACKOUT_ENDED_INDICATION_ID:
            sig->u.MlmeBlackoutEndedIndication.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeBlackoutEndedIndication.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeBlackoutEndedIndication.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeBlackoutEndedIndication.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeBlackoutEndedIndication.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeBlackoutEndedIndication.BlackoutId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_MIB_ERROR_INDICATION_ID:
            sig->u.MlmeMibErrorIndication.MibVariableStatus.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeMibErrorIndication.MibVariableStatus.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeMibErrorIndication.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeMibErrorIndication.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_BLE_CONNECTION_INFO_REQUEST_ID:
            sig->u.CmeAddBleConnectionInfoRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleConnectionInfoRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleConnectionInfoRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleConnectionInfoRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.CmeAddBleConnectionInfoRequest.BluetoothAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.CmeAddBleConnectionInfoRequest.MasterSlave = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleConnectionInfoRequest.Accuracy = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleConnectionInfoRequest.Period = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleConnectionInfoRequest.ConnectionLatency = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleConnectionInfoRequest.LinkSupervisionTimeout = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_AUTONOMOUS_SCAN_DONE_INDICATION_ID:
            sig->u.MlmeAutonomousScanDoneIndication.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAutonomousScanDoneIndication.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAutonomousScanDoneIndication.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAutonomousScanDoneIndication.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAutonomousScanDoneIndication.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAutonomousScanDoneIndication.AutonomousScanId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_INQUIRY_PAGE_INFO_CONFIRM_ID:
            sig->u.CmeDeleteInquiryPageInfoConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteInquiryPageInfoConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteInquiryPageInfoConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteInquiryPageInfoConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteInquiryPageInfoConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_GET_KEY_SEQUENCE_REQUEST_ID:
            sig->u.MlmeGetKeySequenceRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetKeySequenceRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetKeySequenceRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetKeySequenceRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetKeySequenceRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetKeySequenceRequest.KeyId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetKeySequenceRequest.KeyType = (CSR_KEY_TYPE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_INQUIRY_PAGE_INFO_CONFIRM_ID:
            sig->u.CmeAddInquiryPageInfoConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddInquiryPageInfoConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddInquiryPageInfoConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddInquiryPageInfoConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddInquiryPageInfoConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_CHANNEL_REQUEST_ID:
            sig->u.MlmeSetChannelRequest.ChannelConfiguration.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetChannelRequest.ChannelConfiguration.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetChannelRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetChannelRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetChannelRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetChannelRequest.AvailabilityDuration = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetChannelRequest.AvailabilityInterval = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetChannelRequest.Delay = CSR_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT32;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TRIGGERED_GET_REQUEST_ID:
            sig->u.MlmeAddTriggeredGetRequest.MibVariableIdentifier.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTriggeredGetRequest.MibVariableIdentifier.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTriggeredGetRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTriggeredGetRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTriggeredGetRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTriggeredGetRequest.TriggeredId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_AUTONOMOUS_SCAN_LOSS_INDICATION_ID:
            sig->u.MlmeAutonomousScanLossIndication.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAutonomousScanLossIndication.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAutonomousScanLossIndication.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAutonomousScanLossIndication.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.MlmeAutonomousScanLossIndication.Bssid.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            break;
#endif
        case CSR_CME_DELETE_BLE_CONNECTION_INFO_CONFIRM_ID:
            sig->u.CmeDeleteBleConnectionInfoConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleConnectionInfoConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleConnectionInfoConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleConnectionInfoConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleConnectionInfoConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TEMPLATE_REQUEST_ID:
            sig->u.MlmeAddTemplateRequest.Data1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTemplateRequest.Data1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTemplateRequest.Data2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTemplateRequest.Data2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTemplateRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTemplateRequest.FrameType = (CSR_FRAME_TYPE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTemplateRequest.TransmitRate = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_POWERMGT_CONFIRM_ID:
            sig->u.MlmePowermgtConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePowermgtConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePowermgtConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePowermgtConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePowermgtConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePowermgtConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_PERIODIC_CONFIRM_ID:
            sig->u.MlmeAddPeriodicConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddPeriodicConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddPeriodicConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddPeriodicConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddPeriodicConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddPeriodicConfirm.PeriodicId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddPeriodicConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SYNCHRONISATION_INDICATION_ID:
            sig->u.MlmeSynchronisationIndication.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSynchronisationIndication.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSynchronisationIndication.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSynchronisationIndication.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSynchronisationIndication.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSynchronisationIndication.ConnectionStatus = (CSR_CONNECTION_STATUS) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_GET_CONFIRM_ID:
            sig->u.MlmeGetConfirm.MibVariableElement.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetConfirm.MibVariableElement.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetConfirm.MibVariableStatus.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetConfirm.MibVariableStatus.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONFIG_CHANNELS_REQUEST_ID:
            sig->u.MlmeConfigChannelsRequest.InformationElements.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigChannelsRequest.InformationElements.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigChannelsRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConfigChannelsRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_STOP_AGGREGATION_REQUEST_ID:
            sig->u.MlmeStopAggregationRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStopAggregationRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStopAggregationRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStopAggregationRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStopAggregationRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.MlmeStopAggregationRequest.PeerQstaAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.MlmeStopAggregationRequest.UserPriority = (CSR_PRIORITY) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStopAggregationRequest.Direction = (CSR_DIRECTION) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_VIF_REQUEST_ID:
            sig->u.MlmeAddVifRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddVifRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddVifRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddVifRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddVifRequest.VirtualInterfaceType = (CSR_VIF_TYPE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.MlmeAddVifRequest.InterfaceAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            CsrMemCpy(sig->u.MlmeAddVifRequest.DeviceAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.MlmeAddVifRequest.ClonedVirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CANCEL_VIF_TIME_REQUEST_ID:
            sig->u.MlmeCancelVifTimeRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeCancelVifTimeRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeCancelVifTimeRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeCancelVifTimeRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeCancelVifTimeRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_RX_TRIGGER_CONFIRM_ID:
            sig->u.MlmeAddRxTriggerConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddRxTriggerConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddRxTriggerConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddRxTriggerConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddRxTriggerConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddRxTriggerConfirm.TriggerId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddRxTriggerConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_BLACKOUT_REQUEST_ID:
            sig->u.MlmeAddBlackoutRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddBlackoutRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddBlackoutRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddBlackoutRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddBlackoutRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddBlackoutRequest.BlackoutId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddBlackoutRequest.BlackoutType = (CSR_BLACKOUT_TYPE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddBlackoutRequest.BlackoutSource = (CSR_BLACKOUT_SOURCE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddBlackoutRequest.BlackoutStartReference = CSR_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT32;
            sig->u.MlmeAddBlackoutRequest.BlackoutPeriod = CSR_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT32;
            sig->u.MlmeAddBlackoutRequest.BlackoutDuration = CSR_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT32;
            CsrMemCpy(sig->u.MlmeAddBlackoutRequest.PeerStaAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.MlmeAddBlackoutRequest.BlackoutCount = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DELETEKEYS_REQUEST_ID:
            sig->u.MlmeDeletekeysRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDeletekeysRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDeletekeysRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDeletekeysRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDeletekeysRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDeletekeysRequest.KeyId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDeletekeysRequest.KeyType = (CSR_KEY_TYPE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.MlmeDeletekeysRequest.Address.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            break;
#endif
        case CSR_CME_ADD_ACL_CONNECTION_INFO_REQUEST_ID:
            sig->u.CmeAddAclConnectionInfoRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddAclConnectionInfoRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddAclConnectionInfoRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddAclConnectionInfoRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddAclConnectionInfoRequest.AclHandle = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.CmeAddAclConnectionInfoRequest.BluetoothAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.CmeAddAclConnectionInfoRequest.MasterSlave = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddAclConnectionInfoRequest.Mode = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddAclConnectionInfoRequest.SniffInterval = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddAclConnectionInfoRequest.TxLatency = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddAclConnectionInfoRequest.RxLatency = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddAclConnectionInfoRequest.RemoteTimeout = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddAclConnectionInfoRequest.LocalTimeout = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddAclConnectionInfoRequest.Edr = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddAclConnectionInfoRequest.LinkSupervisionTimeout = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_RESET_CONFIRM_ID:
            sig->u.MlmeResetConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeResetConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeResetConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeResetConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeResetConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_HL_SYNC_CONFIRM_ID:
            sig->u.MlmeHlSyncConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeHlSyncConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeHlSyncConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeHlSyncConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.MlmeHlSyncConfirm.GroupAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.MlmeHlSyncConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_AUTONOMOUS_SCAN_REQUEST_ID:
            sig->u.MlmeAddAutonomousScanRequest.ChannelList.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddAutonomousScanRequest.ChannelList.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddAutonomousScanRequest.InformationElements.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddAutonomousScanRequest.InformationElements.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddAutonomousScanRequest.ProbeRequestId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddAutonomousScanRequest.AutonomousScanId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddAutonomousScanRequest.ProbeDelay = CSR_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT32;
            sig->u.MlmeAddAutonomousScanRequest.MinChannelTimeActiveScan = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddAutonomousScanRequest.MaxChannelTimeActiveScan = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddAutonomousScanRequest.MinChannelTimePassiveScan = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddAutonomousScanRequest.MaxChannelTimePassiveScan = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_ESCO_INFO_REQUEST_ID:
            sig->u.CmeDeleteEscoInfoRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteEscoInfoRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteEscoInfoRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteEscoInfoRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteEscoInfoRequest.AclHandle = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.CmeDeleteEscoInfoRequest.BluetoothAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.CmeDeleteEscoInfoRequest.ScoHandle = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_REQUEST_ID:
            sig->u.MlmeSetRequest.MibVariableElement.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetRequest.MibVariableElement.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_GENERIC_COMMAND_INDICATION_ID:
            sig->u.CmeGenericCommandIndication.EventData.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeGenericCommandIndication.EventData.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeGenericCommandIndication.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeGenericCommandIndication.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_DELETE_BLE_CONNECTION_INFO_REQUEST_ID:
            sig->u.CmeDeleteBleConnectionInfoRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleConnectionInfoRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleConnectionInfoRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleConnectionInfoRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.CmeDeleteBleConnectionInfoRequest.BluetoothAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONNECT_STATUS_CONFIRM_ID:
            sig->u.MlmeConnectStatusConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConnectStatusConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConnectStatusConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConnectStatusConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConnectStatusConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeConnectStatusConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_AUTONOMOUS_SCAN_CONFIRM_ID:
            sig->u.MlmeDelAutonomousScanConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelAutonomousScanConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelAutonomousScanConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelAutonomousScanConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelAutonomousScanConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelAutonomousScanConfirm.AutonomousScanId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_PERIODIC_REQUEST_ID:
            sig->u.MlmeDelPeriodicRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelPeriodicRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelPeriodicRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelPeriodicRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelPeriodicRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelPeriodicRequest.PeriodicId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SETKEYS_REQUEST_ID:
            sig->u.MlmeSetkeysRequest.Key.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetkeysRequest.Key.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetkeysRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetkeysRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetkeysRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetkeysRequest.Length = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetkeysRequest.KeyId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetkeysRequest.KeyType = (CSR_KEY_TYPE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.MlmeSetkeysRequest.Address.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.MlmeSetkeysRequest.SequenceNumber[0] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetkeysRequest.SequenceNumber[1] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetkeysRequest.SequenceNumber[2] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetkeysRequest.SequenceNumber[3] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetkeysRequest.SequenceNumber[4] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetkeysRequest.SequenceNumber[5] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetkeysRequest.SequenceNumber[6] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetkeysRequest.SequenceNumber[7] = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(&sig->u.MlmeSetkeysRequest.CipherSuiteSelector, &ptr[index], 32 / 8);
            index += 32 / 8;
            break;
#endif
        case CSR_CME_DELETE_BLE_SCAN_INFO_REQUEST_ID:
            sig->u.CmeDeleteBleScanInfoRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleScanInfoRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleScanInfoRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteBleScanInfoRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_DELETE_A2DP_INFO_REQUEST_ID:
            sig->u.CmeDeleteA2DpInfoRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteA2DpInfoRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteA2DpInfoRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteA2DpInfoRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteA2DpInfoRequest.AclHandle = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.CmeDeleteA2DpInfoRequest.BluetoothAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.CmeDeleteA2DpInfoRequest.ChannelId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_PAUSE_AUTONOMOUS_SCAN_REQUEST_ID:
            sig->u.MlmePauseAutonomousScanRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePauseAutonomousScanRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePauseAutonomousScanRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePauseAutonomousScanRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePauseAutonomousScanRequest.AutonomousScanId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePauseAutonomousScanRequest.Pause = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_BLE_CONNECTION_INFO_CONFIRM_ID:
            sig->u.CmeAddBleConnectionInfoConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleConnectionInfoConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleConnectionInfoConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleConnectionInfoConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleConnectionInfoConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_GET_REQUEST_ID:
            sig->u.MlmeGetRequest.MibVariableIdentifier.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetRequest.MibVariableIdentifier.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeGetRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_POWERMGT_REQUEST_ID:
            sig->u.MlmePowermgtRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePowermgtRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePowermgtRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePowermgtRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePowermgtRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePowermgtRequest.PowerManagementMode = (CSR_POWER_MANAGEMENT_MODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePowermgtRequest.ReceiveDtims = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePowermgtRequest.ListenInterval = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmePowermgtRequest.TrafficWindow = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_MA_PACKET_ERROR_INDICATION_ID:
            sig->u.MaPacketErrorIndication.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketErrorIndication.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketErrorIndication.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketErrorIndication.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketErrorIndication.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.MaPacketErrorIndication.PeerQstaAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.MaPacketErrorIndication.UserPriority = (CSR_PRIORITY) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketErrorIndication.SequenceNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_PERIODIC_REQUEST_ID:
            sig->u.MlmeAddPeriodicRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddPeriodicRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddPeriodicRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddPeriodicRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddPeriodicRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddPeriodicRequest.PeriodicId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddPeriodicRequest.MaximumLatency = CSR_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT32;
            sig->u.MlmeAddPeriodicRequest.WakeHost = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TSPEC_REQUEST_ID:
            sig->u.MlmeAddTspecRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTspecRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTspecRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTspecRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTspecRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTspecRequest.UserPriority = (CSR_PRIORITY) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTspecRequest.Direction = (CSR_DIRECTION) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTspecRequest.PsScheme = (CSR_PS_SCHEME) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTspecRequest.MediumTime = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTspecRequest.ServiceStartTime = CSR_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT32;
            sig->u.MlmeAddTspecRequest.ServiceInterval = CSR_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT32;
            sig->u.MlmeAddTspecRequest.MinimumDataRate = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_FILE_GET_REQUEST_ID:
            sig->u.MlmeFileGetRequest.FileName.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeFileGetRequest.FileName.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeFileGetRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeFileGetRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeFileGetRequest.FileIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_BLE_SCAN_INFO_CONFIRM_ID:
            sig->u.CmeAddBleScanInfoConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleScanInfoConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleScanInfoConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleScanInfoConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddBleScanInfoConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_MULTICAST_ADDRESS_CONFIRM_ID:
            sig->u.MlmeAddMulticastAddressConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddMulticastAddressConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddMulticastAddressConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddMulticastAddressConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddMulticastAddressConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddMulticastAddressConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TSPEC_CONFIRM_ID:
            sig->u.MlmeAddTspecConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTspecConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTspecConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTspecConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTspecConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTspecConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_HL_SYNC_CANCEL_CONFIRM_ID:
            sig->u.MlmeHlSyncCancelConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeHlSyncCancelConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeHlSyncCancelConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeHlSyncCancelConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeHlSyncCancelConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SCAN_CONFIRM_ID:
            sig->u.MlmeScanConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeScanConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeScanConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeScanConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeScanConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_DEBUG_STRING_INDICATION_ID:
            sig->u.DebugStringIndication.DebugMessage.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugStringIndication.DebugMessage.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugStringIndication.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.DebugStringIndication.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_CLOCK_SYNCHRONISATION_INDICATION_ID:
            sig->u.CmeClockSynchronisationIndication.EventData.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeClockSynchronisationIndication.EventData.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeClockSynchronisationIndication.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeClockSynchronisationIndication.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeClockSynchronisationIndication.AclHandle = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.CmeClockSynchronisationIndication.BluetoothAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.CmeClockSynchronisationIndication.ClockValue = CSR_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT32;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TEMPLATE_CONFIRM_ID:
            sig->u.MlmeAddTemplateConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTemplateConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTemplateConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTemplateConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTemplateConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddTemplateConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_BLOCKACK_ERROR_INDICATION_ID:
            sig->u.MlmeBlockackErrorIndication.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeBlockackErrorIndication.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeBlockackErrorIndication.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeBlockackErrorIndication.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeBlockackErrorIndication.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeBlockackErrorIndication.ResultCode = (CSR_REASON_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.MlmeBlockackErrorIndication.PeerQstaAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.MlmeBlockackErrorIndication.UserPriority = (CSR_PRIORITY) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeBlockackErrorIndication.Direction = (CSR_DIRECTION) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_CONFIRM_ID:
            sig->u.MlmeSetConfirm.MibVariableStatus.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetConfirm.MibVariableStatus.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeSetConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_START_AGGREGATION_CONFIRM_ID:
            sig->u.MlmeStartAggregationConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartAggregationConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartAggregationConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartAggregationConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartAggregationConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.MlmeStartAggregationConfirm.PeerQstaAddress.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            sig->u.MlmeStartAggregationConfirm.UserPriority = (CSR_PRIORITY) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartAggregationConfirm.Direction = (CSR_DIRECTION) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartAggregationConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeStartAggregationConfirm.SequenceNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_PROBE_REQUEST_REQUEST_ID:
            sig->u.MlmeAddProbeRequestRequest.Data1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddProbeRequestRequest.Data1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddProbeRequestRequest.Data2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddProbeRequestRequest.Data2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddProbeRequestRequest.ProbeRequestId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeAddProbeRequestRequest.TransmitRate = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(sig->u.MlmeAddProbeRequestRequest.Address.x, &ptr[index], 48 / 8);
            index += 48 / 8;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_VIF_REQUEST_ID:
            sig->u.MlmeDelVifRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelVifRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelVifRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelVifRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelVifRequest.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_A2DP_INFO_CONFIRM_ID:
            sig->u.CmeAddA2DpInfoConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddA2DpInfoConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddA2DpInfoConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddA2DpInfoConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeAddA2DpInfoConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_MA_PACKET_CONFIRM_ID:
            sig->u.MaPacketConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketConfirm.TransmissionStatus = (CSR_TRANSMISSION_STATUS) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketConfirm.RetryCount = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketConfirm.Rate = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MaPacketConfirm.HostTag = CSR_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT32;
            break;
        case CSR_CME_DELETE_INQUIRY_PAGE_INFO_REQUEST_ID:
            sig->u.CmeDeleteInquiryPageInfoRequest.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteInquiryPageInfoRequest.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteInquiryPageInfoRequest.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteInquiryPageInfoRequest.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_DELETE_A2DP_INFO_CONFIRM_ID:
            sig->u.CmeDeleteA2DpInfoConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteA2DpInfoConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteA2DpInfoConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteA2DpInfoConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.CmeDeleteA2DpInfoConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_PERIODIC_CONFIRM_ID:
            sig->u.MlmeDelPeriodicConfirm.Dummydataref1.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelPeriodicConfirm.Dummydataref1.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelPeriodicConfirm.Dummydataref2.SlotNumber = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelPeriodicConfirm.Dummydataref2.DataLength = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelPeriodicConfirm.VirtualInterfaceIndex = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelPeriodicConfirm.PeriodicId = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            sig->u.MlmeDelPeriodicConfirm.ResultCode = (CSR_RESULT_CODE) CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif

        default:
            return CSR_WIFI_HIP_RESULT_INVALID_VALUE;
    }
    return CSR_RESULT_SUCCESS;
} /* read_unpack_signal() */

/*
 * ---------------------------------------------------------------------------
 *  read_vif_from_packed
 *
 *      Unpack a wire-format signal into a host-native structure.
 *      This function handles any necessary conversions for endianness and
 *      places no restrictions on packing or alignment for the structure
 *      definition.
 *
 *      WARNING: This function is auto-generated, DO NOT EDIT!
 *
 *  Arguments:
 *      ptr             Signal buffer to unpack.
 *      sig             Pointer to destination structure to populate.
 *
 *  Returns:
 *      vif on success,
 *      0 if signal does not have a vif,
 *      CSR_WIFI_HIP_RESULT_INVALID_VALUE if the ID of signal was not recognised.
 * ---------------------------------------------------------------------------
 */
CsrResult read_vif_from_packed(const CsrUint8 *ptr, CsrUint16 *vif)
{
    CsrInt32 index = 0;

    index += SIZEOF_UINT16;
    index += SIZEOF_UINT16;
    index += SIZEOF_UINT16;

    switch (CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr))
    {
        case CSR_CME_DELETE_BLE_ADVERTISEMENT_INFO_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_PACKET_FILTER_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SETKEYS_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONFIG_QUEUE_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_AUTONOMOUS_SCAN_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_ACL_CONNECTION_INFO_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_BLACKOUT_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_BLACKOUT_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_GET_KEY_SEQUENCE_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_STOP_AGGREGATION_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_TSPEC_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_INQUIRY_PAGE_INFO_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
        case CSR_DEBUG_WORD16_INDICATION_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
        case CSR_DEBUG_GENERIC_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
        case CSR_MA_PACKET_INDICATION_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONFIG_CHANNELS_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_FILE_GET_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_BLE_ADVERTISEMENT_INFO_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_VIF_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_ESCO_INFO_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_RX_TRIGGER_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_VIF_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_TRIGGERED_GET_INDICATION_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SCAN_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT32;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DELETEKEYS_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_CHANNEL_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_START_AGGREGATION_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_HL_SYNC_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += 48 / 8;
            break;
#endif
        case CSR_DEBUG_GENERIC_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_ADD_BLE_SCAN_INFO_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_ADD_BLE_ADVERTISEMENT_INFO_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_TRIGGERED_GET_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_MULTICAST_ADDRESS_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_BLE_ADVERTISEMENT_INFO_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_ADD_ESCO_INFO_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += 48 / 8;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_RESET_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SCAN_CANCEL_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_START_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_ACL_CONNECTION_INFO_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += 48 / 8;
            break;
        case CSR_CME_GENERIC_COMMAND_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TRIGGERED_GET_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_PACKET_FILTER_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_ESCO_INFO_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_RX_TRIGGER_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONNECT_STATUS_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONFIG_QUEUE_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_TSPEC_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_GENERIC_COMMAND_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_BLACKOUT_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_TRIGGERED_GET_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_DEBUG_GENERIC_INDICATION_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
        case CSR_MA_PACKET_CANCEL_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_MODIFY_BSS_PARAMETER_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_BLE_SCAN_INFO_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_PAUSE_AUTONOMOUS_SCAN_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_PROBE_REQUEST_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_START_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_MA_PACKET_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_MODIFY_BSS_PARAMETER_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_A2DP_INFO_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += 48 / 8;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_RX_TRIGGER_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_ACL_CONNECTION_INFO_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_HL_SYNC_CANCEL_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += 48 / 8;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CANCEL_VIF_TIME_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_AUTONOMOUS_SCAN_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_BLACKOUT_ENDED_INDICATION_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_MIB_ERROR_INDICATION_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_BLE_CONNECTION_INFO_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += 48 / 8;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_AUTONOMOUS_SCAN_DONE_INDICATION_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_INQUIRY_PAGE_INFO_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_GET_KEY_SEQUENCE_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_INQUIRY_PAGE_INFO_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_CHANNEL_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TRIGGERED_GET_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_AUTONOMOUS_SCAN_LOSS_INDICATION_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += 48 / 8;
            break;
#endif
        case CSR_CME_DELETE_BLE_CONNECTION_INFO_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TEMPLATE_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_POWERMGT_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_PERIODIC_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SYNCHRONISATION_INDICATION_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_GET_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONFIG_CHANNELS_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_STOP_AGGREGATION_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_VIF_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += 48 / 8;
            index += 48 / 8;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CANCEL_VIF_TIME_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_RX_TRIGGER_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_BLACKOUT_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DELETEKEYS_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_ACL_CONNECTION_INFO_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += 48 / 8;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_RESET_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_HL_SYNC_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += 48 / 8;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_AUTONOMOUS_SCAN_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT32;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_ESCO_INFO_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += 48 / 8;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_GENERIC_COMMAND_INDICATION_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_DELETE_BLE_CONNECTION_INFO_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += 48 / 8;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONNECT_STATUS_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_AUTONOMOUS_SCAN_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_PERIODIC_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SETKEYS_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_BLE_SCAN_INFO_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_DELETE_A2DP_INFO_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += 48 / 8;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_PAUSE_AUTONOMOUS_SCAN_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_BLE_CONNECTION_INFO_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_GET_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_POWERMGT_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_MA_PACKET_ERROR_INDICATION_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_PERIODIC_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TSPEC_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_FILE_GET_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_BLE_SCAN_INFO_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_MULTICAST_ADDRESS_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TSPEC_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_HL_SYNC_CANCEL_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SCAN_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_DEBUG_STRING_INDICATION_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_CLOCK_SYNCHRONISATION_INDICATION_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += 48 / 8;
            index += SIZEOF_UINT32;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TEMPLATE_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_BLOCKACK_ERROR_INDICATION_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_START_AGGREGATION_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_PROBE_REQUEST_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += 48 / 8;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_VIF_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_A2DP_INFO_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
        case CSR_MA_PACKET_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_DELETE_INQUIRY_PAGE_INFO_REQUEST_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_DELETE_A2DP_INFO_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_PERIODIC_CONFIRM_ID:
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            index += SIZEOF_UINT16;
            break;
#endif

        default:
            return CSR_WIFI_HIP_RESULT_INVALID_VALUE;
    }
    if (index > get_packed_struct_size(ptr) - SIZEOF_UINT16)
    {
        *vif = 1;
    }
    else
    {
        *vif = CSR_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
    }
    return CSR_RESULT_SUCCESS;
} /* read_vif_from_packed() */

/*
 * ---------------------------------------------------------------------------
 *  write_pack
 *
 *      Convert a signal structure, in host-native format, to the
 *      little-endian wire format specified in the UniFi Host Interface
 *      Protocol Specification.
 *
 *      WARNING: This function is auto-generated, DO NOT EDIT!
 *
 *  Arguments:
 *      sig             Pointer to signal structure to pack.
 *      ptr             Destination buffer to pack into.
 *      sig_len         Returns the length of the packed signal, i.e. the
 *                      number of bytes written to ptr.
 *
 *  Returns:
 *      CSR_RESULT_SUCCESS on success,
 *      CSR_WIFI_HIP_RESULT_INVALID_VALUE if the ID of signal was not recognised.
 * ---------------------------------------------------------------------------
 */
CsrResult write_pack(const CSR_SIGNAL *sig, CsrUint8 *ptr, CsrUint16 *sig_len)
{
    CsrInt16 index = 0;

    CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->SignalPrimitiveHeader.SignalId, ptr + index);
    index += SIZEOF_UINT16;

    CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->SignalPrimitiveHeader.ReceiverProcessId, ptr + index);
    index += SIZEOF_UINT16;

    CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->SignalPrimitiveHeader.SenderProcessId, ptr + index);
    index += SIZEOF_UINT16;

    switch (sig->SignalPrimitiveHeader.SignalId)
    {
        case CSR_CME_DELETE_BLE_ADVERTISEMENT_INFO_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleAdvertisementInfoConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleAdvertisementInfoConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleAdvertisementInfoConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleAdvertisementInfoConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleAdvertisementInfoConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_PACKET_FILTER_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetPacketFilterConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetPacketFilterConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetPacketFilterConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetPacketFilterConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetPacketFilterConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetPacketFilterConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SETKEYS_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONFIG_QUEUE_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigQueueConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigQueueConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigQueueConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigQueueConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigQueueConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigQueueConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_AUTONOMOUS_SCAN_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanConfirm.AutonomousScanId, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_ACL_CONNECTION_INFO_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddAclConnectionInfoConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddAclConnectionInfoConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddAclConnectionInfoConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddAclConnectionInfoConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddAclConnectionInfoConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_BLACKOUT_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutConfirm.BlackoutId, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_BLACKOUT_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutRequest.BlackoutId, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_GET_KEY_SEQUENCE_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceConfirm.SequenceNumber[0], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceConfirm.SequenceNumber[1], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceConfirm.SequenceNumber[2], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceConfirm.SequenceNumber[3], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceConfirm.SequenceNumber[4], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceConfirm.SequenceNumber[5], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceConfirm.SequenceNumber[6], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceConfirm.SequenceNumber[7], ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_STOP_AGGREGATION_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStopAggregationConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStopAggregationConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStopAggregationConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStopAggregationConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStopAggregationConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.MlmeStopAggregationConfirm.PeerQstaAddress.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStopAggregationConfirm.UserPriority, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStopAggregationConfirm.Direction, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStopAggregationConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_TSPEC_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTspecRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTspecRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTspecRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTspecRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTspecRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTspecRequest.UserPriority, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTspecRequest.Direction, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_INQUIRY_PAGE_INFO_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddInquiryPageInfoRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddInquiryPageInfoRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddInquiryPageInfoRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddInquiryPageInfoRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddInquiryPageInfoRequest.Type, ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_DEBUG_WORD16_INDICATION_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[0], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[1], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[2], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[3], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[4], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[5], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[6], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[7], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[8], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[9], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[10], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[11], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[12], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[13], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[14], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[15], ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_DEBUG_GENERIC_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugVariable.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugVariable.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugWords[0], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugWords[1], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugWords[2], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugWords[3], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugWords[4], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugWords[5], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugWords[6], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugWords[7], ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_MA_PACKET_INDICATION_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.Data.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.Data.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.MaPacketIndication.LocalTime.x, 64 / 8);
            index += 64 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.ChannelFrequency, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.ChannelInformation, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.ReceptionStatus, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.Rssi, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.Snr, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.ReceivedRate, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONFIG_CHANNELS_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigChannelsConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigChannelsConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigChannelsConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigChannelsConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigChannelsConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_FILE_GET_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFileGetConfirm.Data.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFileGetConfirm.Data.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFileGetConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFileGetConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFileGetConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFileGetConfirm.FileIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFileGetConfirm.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_BLE_ADVERTISEMENT_INFO_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleAdvertisementInfoConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleAdvertisementInfoConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleAdvertisementInfoConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleAdvertisementInfoConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleAdvertisementInfoConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_VIF_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddVifConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddVifConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddVifConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddVifConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddVifConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddVifConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_ESCO_INFO_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteEscoInfoConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteEscoInfoConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteEscoInfoConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteEscoInfoConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteEscoInfoConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_RX_TRIGGER_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerRequest.TriggerId, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_VIF_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelVifConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelVifConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelVifConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelVifConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelVifConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelVifConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_TRIGGERED_GET_INDICATION_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTriggeredGetIndication.MibVariableElement.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTriggeredGetIndication.MibVariableElement.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTriggeredGetIndication.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTriggeredGetIndication.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTriggeredGetIndication.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTriggeredGetIndication.TriggeredId, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SCAN_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.ChannelList.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.ChannelList.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.SsidElements.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.SsidElements.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.ProbeRequestId, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.ProbeDelay, ptr + index);
            index += SIZEOF_UINT32;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.MinChannelTimeActiveScan, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.MaxChannelTimeActiveScan, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.MinChannelTimePassiveScan, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.MaxChannelTimePassiveScan, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DELETEKEYS_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_CHANNEL_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetChannelConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetChannelConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetChannelConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetChannelConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetChannelConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetChannelConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_START_AGGREGATION_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartAggregationRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartAggregationRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartAggregationRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartAggregationRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartAggregationRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.MlmeStartAggregationRequest.PeerQstaAddress.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartAggregationRequest.UserPriority, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartAggregationRequest.Direction, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartAggregationRequest.StartingSequenceNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartAggregationRequest.BufferSize, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartAggregationRequest.BlockAckTimeout, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_HL_SYNC_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.MlmeHlSyncRequest.GroupAddress.x, 48 / 8);
            index += 48 / 8;
            break;
#endif
        case CSR_DEBUG_GENERIC_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugVariable.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugVariable.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugWords[0], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugWords[1], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugWords[2], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugWords[3], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugWords[4], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugWords[5], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugWords[6], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugWords[7], ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_ADD_BLE_SCAN_INFO_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleScanInfoRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleScanInfoRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleScanInfoRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleScanInfoRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleScanInfoRequest.ScanType, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleScanInfoRequest.Period, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleScanInfoRequest.Window, ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_ADD_BLE_ADVERTISEMENT_INFO_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleAdvertisementInfoRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleAdvertisementInfoRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleAdvertisementInfoRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleAdvertisementInfoRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleAdvertisementInfoRequest.Type, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleAdvertisementInfoRequest.MinPeriod, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleAdvertisementInfoRequest.MaxPeriod, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleAdvertisementInfoRequest.ChannelMap, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_TRIGGERED_GET_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetRequest.TriggeredId, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_MULTICAST_ADDRESS_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddMulticastAddressRequest.Data.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddMulticastAddressRequest.Data.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddMulticastAddressRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddMulticastAddressRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddMulticastAddressRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddMulticastAddressRequest.NumberOfMulticastGroupAddresses, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_BLE_ADVERTISEMENT_INFO_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleAdvertisementInfoRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleAdvertisementInfoRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleAdvertisementInfoRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleAdvertisementInfoRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_ADD_ESCO_INFO_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddEscoInfoRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddEscoInfoRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddEscoInfoRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddEscoInfoRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddEscoInfoRequest.AclHandle, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.CmeAddEscoInfoRequest.BluetoothAddress.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddEscoInfoRequest.ScoHandle, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddEscoInfoRequest.Period, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddEscoInfoRequest.Window, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddEscoInfoRequest.RetransmissionWindow, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddEscoInfoRequest.TxSize, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddEscoInfoRequest.RxSize, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddEscoInfoRequest.AirMode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_RESET_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResetRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResetRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResetRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResetRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SCAN_CANCEL_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanCancelRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanCancelRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanCancelRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanCancelRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_START_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_ACL_CONNECTION_INFO_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteAclConnectionInfoRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteAclConnectionInfoRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteAclConnectionInfoRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteAclConnectionInfoRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteAclConnectionInfoRequest.AclHandle, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.CmeDeleteAclConnectionInfoRequest.BluetoothAddress.x, 48 / 8);
            index += 48 / 8;
            break;
        case CSR_CME_GENERIC_COMMAND_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeGenericCommandConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeGenericCommandConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeGenericCommandConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeGenericCommandConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeGenericCommandConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TRIGGERED_GET_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetConfirm.MibVariableStatus.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetConfirm.MibVariableStatus.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetConfirm.TriggeredId, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_PACKET_FILTER_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetPacketFilterRequest.InformationElements.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetPacketFilterRequest.InformationElements.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetPacketFilterRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetPacketFilterRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetPacketFilterRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetPacketFilterRequest.PacketFilterMode, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeSetPacketFilterRequest.ArpFilterAddress, ptr + index);
            index += SIZEOF_UINT32;
            break;
#endif
        case CSR_CME_ADD_ESCO_INFO_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddEscoInfoConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddEscoInfoConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddEscoInfoConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddEscoInfoConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddEscoInfoConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_RX_TRIGGER_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerConfirm.TriggerId, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONNECT_STATUS_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConnectStatusRequest.InformationElements.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConnectStatusRequest.InformationElements.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConnectStatusRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConnectStatusRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConnectStatusRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConnectStatusRequest.ConnectionStatus, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.MlmeConnectStatusRequest.StaAddress.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConnectStatusRequest.AssociationInformation, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConnectStatusRequest.AssociationCapabilityInformation, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONFIG_QUEUE_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigQueueRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigQueueRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigQueueRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigQueueRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigQueueRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigQueueRequest.QueueIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigQueueRequest.Aifs, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigQueueRequest.Ecwmin, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigQueueRequest.Ecwmax, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigQueueRequest.TxopLimit, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_TSPEC_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTspecConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTspecConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTspecConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTspecConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTspecConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTspecConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_GENERIC_COMMAND_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeGenericCommandRequest.CommandData.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeGenericCommandRequest.CommandData.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeGenericCommandRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeGenericCommandRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_BLACKOUT_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutConfirm.BlackoutId, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_TRIGGERED_GET_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetConfirm.TriggeredId, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_DEBUG_GENERIC_INDICATION_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugVariable.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugVariable.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugWords[0], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugWords[1], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugWords[2], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugWords[3], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugWords[4], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugWords[5], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugWords[6], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugWords[7], ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_MA_PACKET_CANCEL_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketCancelRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketCancelRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketCancelRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketCancelRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketCancelRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MaPacketCancelRequest.HostTag, ptr + index);
            index += SIZEOF_UINT32;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_MODIFY_BSS_PARAMETER_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeModifyBssParameterConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeModifyBssParameterConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeModifyBssParameterConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeModifyBssParameterConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeModifyBssParameterConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeModifyBssParameterConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_BLE_SCAN_INFO_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleScanInfoConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleScanInfoConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleScanInfoConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleScanInfoConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleScanInfoConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_PAUSE_AUTONOMOUS_SCAN_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanConfirm.AutonomousScanId, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_PROBE_REQUEST_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddProbeRequestConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddProbeRequestConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddProbeRequestConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddProbeRequestConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddProbeRequestConfirm.ProbeRequestId, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddProbeRequestConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_START_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartRequest.Beacon.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartRequest.Beacon.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartRequest.BssParameters.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartRequest.BssParameters.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.MlmeStartRequest.Bssid.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartRequest.BeaconPeriod, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartRequest.DtimPeriod, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartRequest.CapabilityInformation, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeStartRequest.Delay, ptr + index);
            index += SIZEOF_UINT32;
            break;
#endif
        case CSR_MA_PACKET_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketRequest.Data.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketRequest.Data.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketRequest.TransmitRate, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MaPacketRequest.HostTag, ptr + index);
            index += SIZEOF_UINT32;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketRequest.Priority, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.MaPacketRequest.Ra.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketRequest.TransmissionControlBitmap, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketRequest.MinVifDuration, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_MODIFY_BSS_PARAMETER_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeModifyBssParameterRequest.Data.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeModifyBssParameterRequest.Data.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeModifyBssParameterRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeModifyBssParameterRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeModifyBssParameterRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeModifyBssParameterRequest.BeaconPeriod, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeModifyBssParameterRequest.DtimPeriod, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeModifyBssParameterRequest.CapabilityInformation, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.MlmeModifyBssParameterRequest.Bssid.x, 48 / 8);
            index += 48 / 8;
            break;
#endif
        case CSR_CME_ADD_A2DP_INFO_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddA2DpInfoRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddA2DpInfoRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddA2DpInfoRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddA2DpInfoRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddA2DpInfoRequest.AclHandle, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.CmeAddA2DpInfoRequest.BluetoothAddress.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddA2DpInfoRequest.ChannelId, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddA2DpInfoRequest.BurstStartStop, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddA2DpInfoRequest.Window, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddA2DpInfoRequest.Period, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddA2DpInfoRequest.EstimatedBitRate, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_RX_TRIGGER_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerRequest.InformationElements.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerRequest.InformationElements.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerRequest.TriggerId, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerRequest.Priority, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_ACL_CONNECTION_INFO_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteAclConnectionInfoConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteAclConnectionInfoConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteAclConnectionInfoConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteAclConnectionInfoConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteAclConnectionInfoConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_HL_SYNC_CANCEL_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncCancelRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncCancelRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncCancelRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncCancelRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.MlmeHlSyncCancelRequest.GroupAddress.x, 48 / 8);
            index += 48 / 8;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CANCEL_VIF_TIME_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeCancelVifTimeConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeCancelVifTimeConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeCancelVifTimeConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeCancelVifTimeConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeCancelVifTimeConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeCancelVifTimeConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_AUTONOMOUS_SCAN_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanRequest.AutonomousScanId, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_BLACKOUT_ENDED_INDICATION_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeBlackoutEndedIndication.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeBlackoutEndedIndication.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeBlackoutEndedIndication.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeBlackoutEndedIndication.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeBlackoutEndedIndication.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeBlackoutEndedIndication.BlackoutId, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_MIB_ERROR_INDICATION_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMibErrorIndication.MibVariableStatus.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMibErrorIndication.MibVariableStatus.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMibErrorIndication.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMibErrorIndication.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_BLE_CONNECTION_INFO_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleConnectionInfoRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleConnectionInfoRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleConnectionInfoRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleConnectionInfoRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.CmeAddBleConnectionInfoRequest.BluetoothAddress.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleConnectionInfoRequest.MasterSlave, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleConnectionInfoRequest.Accuracy, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleConnectionInfoRequest.Period, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleConnectionInfoRequest.ConnectionLatency, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleConnectionInfoRequest.LinkSupervisionTimeout, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_AUTONOMOUS_SCAN_DONE_INDICATION_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanDoneIndication.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanDoneIndication.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanDoneIndication.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanDoneIndication.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanDoneIndication.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanDoneIndication.AutonomousScanId, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_INQUIRY_PAGE_INFO_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteInquiryPageInfoConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteInquiryPageInfoConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteInquiryPageInfoConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteInquiryPageInfoConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteInquiryPageInfoConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_GET_KEY_SEQUENCE_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceRequest.KeyId, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetKeySequenceRequest.KeyType, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_INQUIRY_PAGE_INFO_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddInquiryPageInfoConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddInquiryPageInfoConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddInquiryPageInfoConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddInquiryPageInfoConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddInquiryPageInfoConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_CHANNEL_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetChannelRequest.ChannelConfiguration.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetChannelRequest.ChannelConfiguration.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetChannelRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetChannelRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetChannelRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetChannelRequest.AvailabilityDuration, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetChannelRequest.AvailabilityInterval, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeSetChannelRequest.Delay, ptr + index);
            index += SIZEOF_UINT32;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TRIGGERED_GET_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetRequest.MibVariableIdentifier.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetRequest.MibVariableIdentifier.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetRequest.TriggeredId, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_AUTONOMOUS_SCAN_LOSS_INDICATION_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanLossIndication.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanLossIndication.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanLossIndication.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanLossIndication.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.MlmeAutonomousScanLossIndication.Bssid.x, 48 / 8);
            index += 48 / 8;
            break;
#endif
        case CSR_CME_DELETE_BLE_CONNECTION_INFO_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleConnectionInfoConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleConnectionInfoConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleConnectionInfoConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleConnectionInfoConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleConnectionInfoConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TEMPLATE_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTemplateRequest.Data1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTemplateRequest.Data1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTemplateRequest.Data2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTemplateRequest.Data2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTemplateRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTemplateRequest.FrameType, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTemplateRequest.TransmitRate, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_POWERMGT_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_PERIODIC_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicConfirm.PeriodicId, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SYNCHRONISATION_INDICATION_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSynchronisationIndication.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSynchronisationIndication.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSynchronisationIndication.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSynchronisationIndication.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSynchronisationIndication.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSynchronisationIndication.ConnectionStatus, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_GET_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetConfirm.MibVariableElement.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetConfirm.MibVariableElement.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetConfirm.MibVariableStatus.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetConfirm.MibVariableStatus.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONFIG_CHANNELS_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigChannelsRequest.InformationElements.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigChannelsRequest.InformationElements.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigChannelsRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConfigChannelsRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_STOP_AGGREGATION_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStopAggregationRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStopAggregationRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStopAggregationRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStopAggregationRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStopAggregationRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.MlmeStopAggregationRequest.PeerQstaAddress.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStopAggregationRequest.UserPriority, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStopAggregationRequest.Direction, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_VIF_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddVifRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddVifRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddVifRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddVifRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddVifRequest.VirtualInterfaceType, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.MlmeAddVifRequest.InterfaceAddress.x, 48 / 8);
            index += 48 / 8;
            CsrMemCpy(ptr + index, sig->u.MlmeAddVifRequest.DeviceAddress.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddVifRequest.ClonedVirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CANCEL_VIF_TIME_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeCancelVifTimeRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeCancelVifTimeRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeCancelVifTimeRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeCancelVifTimeRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeCancelVifTimeRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_RX_TRIGGER_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerConfirm.TriggerId, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_BLACKOUT_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.BlackoutId, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.BlackoutType, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.BlackoutSource, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.BlackoutStartReference, ptr + index);
            index += SIZEOF_UINT32;
            CSR_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.BlackoutPeriod, ptr + index);
            index += SIZEOF_UINT32;
            CSR_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.BlackoutDuration, ptr + index);
            index += SIZEOF_UINT32;
            CsrMemCpy(ptr + index, sig->u.MlmeAddBlackoutRequest.PeerStaAddress.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.BlackoutCount, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DELETEKEYS_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysRequest.KeyId, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysRequest.KeyType, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.MlmeDeletekeysRequest.Address.x, 48 / 8);
            index += 48 / 8;
            break;
#endif
        case CSR_CME_ADD_ACL_CONNECTION_INFO_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddAclConnectionInfoRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddAclConnectionInfoRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddAclConnectionInfoRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddAclConnectionInfoRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddAclConnectionInfoRequest.AclHandle, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.CmeAddAclConnectionInfoRequest.BluetoothAddress.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddAclConnectionInfoRequest.MasterSlave, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddAclConnectionInfoRequest.Mode, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddAclConnectionInfoRequest.SniffInterval, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddAclConnectionInfoRequest.TxLatency, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddAclConnectionInfoRequest.RxLatency, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddAclConnectionInfoRequest.RemoteTimeout, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddAclConnectionInfoRequest.LocalTimeout, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddAclConnectionInfoRequest.Edr, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddAclConnectionInfoRequest.LinkSupervisionTimeout, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_RESET_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResetConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResetConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResetConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResetConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResetConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_HL_SYNC_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.MlmeHlSyncConfirm.GroupAddress.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_AUTONOMOUS_SCAN_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.ChannelList.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.ChannelList.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.InformationElements.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.InformationElements.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.ProbeRequestId, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.AutonomousScanId, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.ProbeDelay, ptr + index);
            index += SIZEOF_UINT32;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.MinChannelTimeActiveScan, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.MaxChannelTimeActiveScan, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.MinChannelTimePassiveScan, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.MaxChannelTimePassiveScan, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_DELETE_ESCO_INFO_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteEscoInfoRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteEscoInfoRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteEscoInfoRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteEscoInfoRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteEscoInfoRequest.AclHandle, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.CmeDeleteEscoInfoRequest.BluetoothAddress.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteEscoInfoRequest.ScoHandle, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetRequest.MibVariableElement.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetRequest.MibVariableElement.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_GENERIC_COMMAND_INDICATION_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeGenericCommandIndication.EventData.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeGenericCommandIndication.EventData.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeGenericCommandIndication.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeGenericCommandIndication.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_DELETE_BLE_CONNECTION_INFO_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleConnectionInfoRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleConnectionInfoRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleConnectionInfoRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleConnectionInfoRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.CmeDeleteBleConnectionInfoRequest.BluetoothAddress.x, 48 / 8);
            index += 48 / 8;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_CONNECT_STATUS_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConnectStatusConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConnectStatusConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConnectStatusConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConnectStatusConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConnectStatusConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConnectStatusConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_AUTONOMOUS_SCAN_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanConfirm.AutonomousScanId, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_PERIODIC_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicRequest.PeriodicId, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SETKEYS_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.Key.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.Key.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.Length, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.KeyId, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.KeyType, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.MlmeSetkeysRequest.Address.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.SequenceNumber[0], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.SequenceNumber[1], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.SequenceNumber[2], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.SequenceNumber[3], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.SequenceNumber[4], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.SequenceNumber[5], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.SequenceNumber[6], ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.SequenceNumber[7], ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, &sig->u.MlmeSetkeysRequest.CipherSuiteSelector, 32 / 8);
            index += 32 / 8;
            break;
#endif
        case CSR_CME_DELETE_BLE_SCAN_INFO_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleScanInfoRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleScanInfoRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleScanInfoRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteBleScanInfoRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_DELETE_A2DP_INFO_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteA2DpInfoRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteA2DpInfoRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteA2DpInfoRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteA2DpInfoRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteA2DpInfoRequest.AclHandle, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.CmeDeleteA2DpInfoRequest.BluetoothAddress.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteA2DpInfoRequest.ChannelId, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_PAUSE_AUTONOMOUS_SCAN_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanRequest.AutonomousScanId, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanRequest.Pause, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_BLE_CONNECTION_INFO_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleConnectionInfoConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleConnectionInfoConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleConnectionInfoConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleConnectionInfoConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleConnectionInfoConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_GET_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetRequest.MibVariableIdentifier.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetRequest.MibVariableIdentifier.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_POWERMGT_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtRequest.PowerManagementMode, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtRequest.ReceiveDtims, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtRequest.ListenInterval, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtRequest.TrafficWindow, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_MA_PACKET_ERROR_INDICATION_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketErrorIndication.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketErrorIndication.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketErrorIndication.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketErrorIndication.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketErrorIndication.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.MaPacketErrorIndication.PeerQstaAddress.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketErrorIndication.UserPriority, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketErrorIndication.SequenceNumber, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_PERIODIC_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicRequest.PeriodicId, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicRequest.MaximumLatency, ptr + index);
            index += SIZEOF_UINT32;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicRequest.WakeHost, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TSPEC_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTspecRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTspecRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTspecRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTspecRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTspecRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTspecRequest.UserPriority, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTspecRequest.Direction, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTspecRequest.PsScheme, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTspecRequest.MediumTime, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeAddTspecRequest.ServiceStartTime, ptr + index);
            index += SIZEOF_UINT32;
            CSR_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeAddTspecRequest.ServiceInterval, ptr + index);
            index += SIZEOF_UINT32;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTspecRequest.MinimumDataRate, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_FILE_GET_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFileGetRequest.FileName.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFileGetRequest.FileName.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFileGetRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFileGetRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFileGetRequest.FileIndex, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_BLE_SCAN_INFO_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleScanInfoConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleScanInfoConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleScanInfoConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleScanInfoConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddBleScanInfoConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_MULTICAST_ADDRESS_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddMulticastAddressConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddMulticastAddressConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddMulticastAddressConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddMulticastAddressConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddMulticastAddressConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddMulticastAddressConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TSPEC_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTspecConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTspecConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTspecConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTspecConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTspecConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTspecConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_HL_SYNC_CANCEL_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncCancelConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncCancelConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncCancelConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncCancelConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncCancelConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SCAN_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_DEBUG_STRING_INDICATION_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugStringIndication.DebugMessage.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugStringIndication.DebugMessage.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugStringIndication.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugStringIndication.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_CLOCK_SYNCHRONISATION_INDICATION_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeClockSynchronisationIndication.EventData.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeClockSynchronisationIndication.EventData.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeClockSynchronisationIndication.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeClockSynchronisationIndication.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeClockSynchronisationIndication.AclHandle, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.CmeClockSynchronisationIndication.BluetoothAddress.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.CmeClockSynchronisationIndication.ClockValue, ptr + index);
            index += SIZEOF_UINT32;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_TEMPLATE_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTemplateConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTemplateConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTemplateConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTemplateConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTemplateConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTemplateConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_BLOCKACK_ERROR_INDICATION_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeBlockackErrorIndication.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeBlockackErrorIndication.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeBlockackErrorIndication.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeBlockackErrorIndication.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeBlockackErrorIndication.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeBlockackErrorIndication.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.MlmeBlockackErrorIndication.PeerQstaAddress.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeBlockackErrorIndication.UserPriority, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeBlockackErrorIndication.Direction, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_SET_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetConfirm.MibVariableStatus.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetConfirm.MibVariableStatus.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_START_AGGREGATION_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartAggregationConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartAggregationConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartAggregationConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartAggregationConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartAggregationConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.MlmeStartAggregationConfirm.PeerQstaAddress.x, 48 / 8);
            index += 48 / 8;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartAggregationConfirm.UserPriority, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartAggregationConfirm.Direction, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartAggregationConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartAggregationConfirm.SequenceNumber, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_ADD_PROBE_REQUEST_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddProbeRequestRequest.Data1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddProbeRequestRequest.Data1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddProbeRequestRequest.Data2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddProbeRequestRequest.Data2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddProbeRequestRequest.ProbeRequestId, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddProbeRequestRequest.TransmitRate, ptr + index);
            index += SIZEOF_UINT16;
            CsrMemCpy(ptr + index, sig->u.MlmeAddProbeRequestRequest.Address.x, 48 / 8);
            index += 48 / 8;
            break;
#endif
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_VIF_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelVifRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelVifRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelVifRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelVifRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelVifRequest.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif
        case CSR_CME_ADD_A2DP_INFO_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddA2DpInfoConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddA2DpInfoConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddA2DpInfoConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddA2DpInfoConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeAddA2DpInfoConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_MA_PACKET_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketConfirm.TransmissionStatus, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketConfirm.RetryCount, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketConfirm.Rate, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MaPacketConfirm.HostTag, ptr + index);
            index += SIZEOF_UINT32;
            break;
        case CSR_CME_DELETE_INQUIRY_PAGE_INFO_REQUEST_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteInquiryPageInfoRequest.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteInquiryPageInfoRequest.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteInquiryPageInfoRequest.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteInquiryPageInfoRequest.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            break;
        case CSR_CME_DELETE_A2DP_INFO_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteA2DpInfoConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteA2DpInfoConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteA2DpInfoConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteA2DpInfoConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.CmeDeleteA2DpInfoConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#ifdef CSR_WIFI_HIP_FULL_SIGNAL_SET
        case CSR_MLME_DEL_PERIODIC_CONFIRM_ID:
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicConfirm.Dummydataref1.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicConfirm.Dummydataref1.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicConfirm.Dummydataref2.SlotNumber, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicConfirm.Dummydataref2.DataLength, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicConfirm.VirtualInterfaceIndex, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicConfirm.PeriodicId, ptr + index);
            index += SIZEOF_UINT16;
            CSR_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicConfirm.ResultCode, ptr + index);
            index += SIZEOF_UINT16;
            break;
#endif

        default:
            return CSR_WIFI_HIP_RESULT_INVALID_VALUE;
    }

    *sig_len = index;

    return CSR_RESULT_SUCCESS;
} /* write_pack() */
