/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

/*
 * ---------------------------------------------------------------------------
 *  FILE:    csr_wifi_hip_log.h
 *
 *  PURPOSE:
 *      logging definitions shared between HIP and kernel driver
 *
 * ---------------------------------------------------------------------------
 */

#ifndef CSR_WIFI_HIP_LOG_TEXT_H__
#define CSR_WIFI_HIP_LOG_TEXT_H__

#include "csr_synergy.h"
#include "csr_log_text_2.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef CSR_LOG_ENABLE
extern CsrLogTextHandle *CSR_WIFI_HIP_LOG_ID;

/* Legacy suborigins.  These are deprecated and will be replaced.  New messages should not use these.
   Note the values defined for each must match its position in the CSR_WIFI_HIP_LOG_LEGACY_SUBORIGINS initialiser defined below.
   Beware the +1 offset.  So the first array element has index value 1.  This is defined by the synergy framework.
*/
#define CSR_WIFI_HIP_UDBG1      0x0001
#define CSR_WIFI_HIP_UDBG2      0x0002
#define CSR_WIFI_HIP_UDBG3      0x0003
#define CSR_WIFI_HIP_UDBG4      0x0004
#define CSR_WIFI_HIP_UDBG5      0x0005
#define CSR_WIFI_HIP_UDBG6      0x0006
#define CSR_WIFI_HIP_UDBG7      0x0007
#define CSR_WIFI_HIP_LOG_DEF    0x0008

/* Positions must match the index values defined above.  But beware +1 offset */
#define CSR_WIFI_HIP_LOG_LEGACY_SUBORIGINS {"UDBG1", "UDBG2", "UDBG3", "UDBG4", "UDBG5", "UDBG6", "UDBG7", "DEFAULT"}

#define func_enter()        do {} while (0)
#define func_exit()         do {} while (0)
#define func_exit_r(_rc)    do {} while (0)

#ifndef ASSERT
#define ASSERT(cond)                                            \
    do {                                                            \
        if (!(cond)) {                                              \
            CSR_LOG_TEXT_CRITICAL((CSR_WIFI_HIP_LOG_ID, CSR_WIFI_HIP_LOG_DEF, "unifi : Assertion failed at %s:%d: %s\n", __FILE__, __LINE__, #cond)); \
        }                                                           \
    } while (0)
#endif /* ASSERT*/

#else
#define ASSERT(cond)            /* as nothing */
#define func_enter()            /* as nothing */
#define func_exit()             /* as nothing */
#define func_exit_r(_rc)        /* as nothing */
#endif

#ifdef __cplusplus
}
#endif

#endif
