/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#ifndef CSR_WIFI_HIP_UTIL_H__
#define CSR_WIFI_HIP_UTIL_H__

#include "csr_synergy.h"

#include "csr_types.h"
#include "csr_wifi_hip_hal_priv.h"

#ifdef __cplusplus
extern "C" {
#endif

/* 802.11 sizes */
#define MAC_HEADER_SIZE  24
#define FRAME_CONTROL_HEADER_SIZE 2
#define QOS_CONTROL_HEADER_SIZE 2
#define HT_CONTROL_HEADER_SIZE  4

/* Frame control & Qos control structures */
#define CSR_WIFI_HIP_IEEE80211_FCTL_PROTO_VERSION_MASK 0x0003
#define CSR_WIFI_HIP_IEEE80211_FCTL_TYPE_MASK        0x000C
#define CSR_WIFI_HIP_IEEE80211_FCTL_TYPE_MGMT   0x0000
#define CSR_WIFI_HIP_IEEE80211_FCTL_TYPE_CTRL   0x0004
#define CSR_WIFI_HIP_IEEE80211_FCTL_TYPE_DATA   0x0008

#define CSR_WIFI_HIP_IEEE80211_FCTL_SUB_TYPE_MASK    0x00F0
#define CSR_WIFI_HIP_IEEE80211_FCTL_SUB_TYPE_DATA    0x0000
#define CSR_WIFI_HIP_IEEE80211_FCTL_SUB_TYPE_NULL    0x0040
#define CSR_WIFI_HIP_IEEE80211_FCTL_SUB_TYPE_QOS_DATA    0x0080
#define CSR_WIFI_HIP_IEEE80211_FCTL_SUB_TYPE_QOS_NULL    0x00C0

#define CSR_WIFI_HIP_IEEE80211_FCTL_SUB_TYPE_CTRL_PS_POLL    0x00A0

#define CSR_WIFI_HIP_IEEE80211_FCTL_TO_DS       0x0100
#define CSR_WIFI_HIP_IEEE80211_FCTL_FROM_DS     0x0200
#define CSR_WIFI_HIP_IEEE80211_FCTL_MORE_FRAG   0x0400
#define CSR_WIFI_HIP_IEEE80211_FCTL_RETRY       0x0800
#define CSR_WIFI_HIP_IEEE80211_FCTL_POWER_MGMT  0x1000
#define CSR_WIFI_HIP_IEEE80211_FCTL_MORE_DATA   0x2000
#define CSR_WIFI_HIP_IEEE80211_FCTL_PROTECTED_FRAME   0x4000
#define CSR_WIFI_HIP_IEEE80211_FCTL_ORDER       0x8000

/* QoS Control field constants and masks */
#define CSR_WIFI_HIP_IEEE80211_QOS_CONTROL_ACK_POLICY_NORMAL_ACK    0x0000
#define CSR_WIFI_HIP_IEEE80211_QOS_CONTROL_ACK_POLICY_NO_ACK        0x0020
#define CSR_WIFI_HIP_IEEE80211_QOS_CONTROL_ACK_POLICY_EXP_ACK       0x0040
#define CSR_WIFI_HIP_IEEE80211_QOS_CONTROL_ACK_POLICY_BA            0x0060

#define CSR_WIFI_HIP_IEEE80211_QOS_CONTROL_EOSP                 0x0010
#define CSR_WIFI_HIP_IEEE80211_QOS_CONTROL_TXOP_LIMIT_MASK      0xFF00


#define CSR_WIFI_HIP_IEEE80211_QOS_CONTROL_A_MSDU_PRESENT 0x0080
#define CSR_WIFI_HIP_IEEE80211_MAX_DATA_LEN                 2304
#define CSR_WIFI_HIP_IEEE80211_LLC_HEADER_LEN                  8

#define CSR_WIFI_HIP_IEEE80211_HAS_TO_DS(fc)   (((fc & CSR_WIFI_HIP_IEEE80211_FCTL_TO_DS)) ? 1 : 0)
#define CSR_WIFI_HIP_IEEE80211_HAS_FROM_DS(fc) (((fc & CSR_WIFI_HIP_IEEE80211_FCTL_FROM_DS)) ? 1 : 0)
#define CSR_WIFI_HIP_IEEE80211_HAS_A4(fc)     ((((CSR_WIFI_HIP_IEEE80211_FCTL_TO_DS | CSR_WIFI_HIP_IEEE80211_FCTL_FROM_DS) & fc)   \
                                                == (CSR_WIFI_HIP_IEEE80211_FCTL_TO_DS | CSR_WIFI_HIP_IEEE80211_FCTL_FROM_DS)) ? 1 : 0)

#define CSR_WIFI_HIP_IEEE80211_QOS_CTL_TID_MASK 0x000F
#define CSR_WIFI_HIP_IEEE80211_SCTL_SEQ         0xFFF0

/* MAC header offsets */
#define CSR_WIFI_HIP_MAC_HEADER_ADDR1_OFFSET  4
#define CSR_WIFI_HIP_MAC_HEADER_ADDR2_OFFSET 10
#define CSR_WIFI_HIP_MAC_HEADER_SEQ_CTRL_OFFSET 22


typedef struct
{
    CsrUint16         frameControl;
    CsrUint16         durationId;
    CsrWifiMacAddress addr1;
    CsrWifiMacAddress addr2;
    CsrWifiMacAddress addr3;
    CsrUint16         seqCtrl;
    CsrWifiMacAddress addr4;
} CsrWifiHipIeee80211Hdr;


CsrResult csrWifiHipUpdateInterfaceTagAndVifIndexMap(CsrWifiHipHalPriv *priv, CsrUint16 interfaceTag,
                                                     CsrUint16 vifIndex, CsrBool primaryVifIndex,
                                                     CsrUint8 action, CsrUint16 newVifIndex);

CsrResult csrWifiHipPrepareAndAddMacheader(CsrWifiHipHalPriv       *priv,
                                           CsrWifiHipVifInstance   *vif,
                                           CSR_PRIORITY             priority,
                                           CsrUint16                protocol,
                                           const CsrUint8          *daddr,
                                           const CsrUint8          *saddr,
                                           CsrUint8                 macHeaderMem,
                                           CsrUint32                hostTag,
                                           CsrWifiHipBulkDataParam *bulkdata,
                                           CsrWifiHipStaPeerInfo   *dstStaInfo);


void CsrWifiHipProcessDataRx(CsrWifiHipHalPriv       *priv,
                             CsrWifiHipVifInstance   *vif,
                             CsrUint16                interfaceTag,
                             CSR_SIGNAL              *sigptr,
                             CsrResult                receptionResult,
                             CsrWifiHipBulkDataParam *bulkdata,
                             CsrUint16                frameControl,
                             CsrUint8                *dMac,
                             CsrUint8                *sMac);

CsrWifiHipMaPacketPriority csrWifiHipPacketPriorityGet(CsrWifiHipHalPriv     *priv,
                                                       CsrWifiHipVifInstance *vif,
                                                       CsrUint8              *frame,
                                                       CsrUint16              protocol);

#define GET_INTERFACE_TAG(VIF)   (VIF & 0xFF)

/* Extract info from MA Packet Inds */

#define UDI_SENDER_ID_SHIFT 8
#define CSR_WIFI_HIP_MA_PACKET_EXTRACT_RECEIVER_ID(_buf) (CSR_GET_UINT16_FROM_LITTLE_ENDIAN(((CsrUint8 *) (_buf)) + sizeof(CsrInt16)) & 0xFFF0)

void csrWifiHipResetVif(CsrWifiHipHalPriv *priv, CsrWifiHipVifInstance *vif, CsrBool flushControlledPortQueues);


/* Block ack */
CsrResult csrWifiHipBaSessionStart(CsrWifiHipHalPriv               *priv,
                                   CsrWifiHipVifInstance           *vif,
                                   CsrWifiRouterCtrlTrafficStreamId trafficStreamID,
                                   CsrUint16                        timeout,
                                   CsrWifiRouterCtrlBlockAckRole    role,
                                   CsrUint16                        bufferSize,
                                   CsrUint16                        ssn,
                                   CsrWifiMacAddress                macAddress);

CsrResult csrWifiHipBaSessionStop(CsrWifiHipHalPriv *priv, CsrWifiHipVifInstance *vif,
                                  CsrWifiRouterCtrlBlockAckRole role,
                                  CsrWifiRouterCtrlTrafficStreamId trafficStreamID,
                                  CsrWifiMacAddress macAddress);

void csrWifiHipBaProcessFrame(CsrWifiHipHalPriv *priv, CsrWifiHipVifInstance *vif,
                              CsrWifiHipBaSessionRx *baSession, CsrWifiHipBaFrameDesc *frameDesc);

void csrWifiHipBaProcessComplete(CsrWifiHipHalPriv *priv, CsrWifiHipVifInstance *vif);
void csrWifiHipAmsduProcess(CsrWifiHipHalPriv *priv, CsrWifiHipVifInstance *vif, CSR_SIGNAL *signal, CsrWifiHipBulkDataParam *bulkdata);
void csrWifiHipBaCheckFrameAgeTimeout(CsrWifiHipHalPriv *priv, CsrWifiHipVifInstance *vif, CsrWifiHipBaSessionRx *baSession);
void csrWifiHipProcessMaPacketErrorInd(CsrWifiHipHalPriv *priv, CsrWifiHipVifInstance *vif, CSR_SIGNAL *signal);

/* Record manipulation */
void csrWifiHipApStaRecordInitialise(CsrWifiHipHalPriv *priv, CsrWifiHipStaPeerInfo *staRecord);

/* Power handling */
CsrBool csrWifiHipPowerChipOff(CsrWifiHipHalPriv *priv);

#ifdef __cplusplus
}
#endif

#endif /* CSR_WIFI_HIP_UTIL_H__ */
