/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#ifndef CSR_WIFI_HIP_AP_UTIL_H__
#define CSR_WIFI_HIP_AP_UTIL_H__

#include "csr_synergy.h"
#include "csr_wifi_hip_hal_priv.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef CSR_WIFI_AP_ENABLE

/* Defines used in beacon filtering in P2P device mode */
#define CSR_WIFI_HIP_IEEE80211_FRAME_SUBTYPE_BEACON             0x0080
#define CSR_WIFI_HIP_IEEE80211_BEACON_SSID_OFFSET               12
#define CSR_WIFI_HIP_IEEE80211_P2P_WILDCARD_SSID_LENGTH         0x7

CsrResult csrWifiHipApProcessDataPdu(CsrWifiHipHalPriv *priv, CsrWifiHipVifInstance *vif,
                                     CsrUint8 *daddr, CsrWifiHipStaPeerInfo *srcStaInfo,
                                     CSR_SIGNAL *signal, CsrWifiHipBulkDataParam *bulkdata,
                                     CsrUint8 macHeaderLengthInBytes);

CsrResult csrWifiHipProcessMaPacketConfirm(CsrWifiHipHalPriv *priv, CsrUint16 interfaceTag, CSR_SIGNAL *signal);

void csrWifiHipApFrameAndsendNullFrame(CsrWifiHipHalPriv     *priv,
                                       CsrWifiHipVifInstance *vif,
                                       CsrWifiHipStaPeerInfo *staInfo,
                                       CSR_PRIORITY           priority);
#endif
#ifdef __cplusplus
}
#endif

#endif /* CSR_WIFI_HIP_AP_UTIL_H__ */
