/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#ifndef CSR_WIFI_FSM_EVENT_H__
#define CSR_WIFI_FSM_EVENT_H__

#include "csr_synergy.h"

#ifdef __cplusplus
extern "C" {
#endif

#include "csr_types.h"
#include "csr_prim_defs.h"
#include "csr_sched.h"

/**
 * @brief
 *   FSM event header.
 *
 * @par Description
 *   All events MUST have this struct as the FIRST member.
 *   The next member is used internally for linked lists
 */
typedef struct CsrWifiFsmEvent
{
    CsrPrim     type;
    CsrUint16   primtype;
    CsrSchedQid destination;
    CsrSchedQid source;

    /* Private pointer to allow an optimal Event list */
    /* NOTE: Ignore this pointer.
     *       Do not waste code initializing OR freeing it.
     *       The pointer is used internally in the CsrWifiFsm code
     *       to avoid a second malloc when queuing events.
     */
    struct CsrWifiFsmEvent *next;
} CsrWifiFsmEvent;

#ifdef __cplusplus
}
#endif

#endif /* CSR_WIFI_FSM_EVENT_H */
