/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#ifndef __LINUX_UNIFI_SME_H__
#define __LINUX_UNIFI_SME_H__ 1

#include "csr_synergy.h"

#include <linux/kernel.h>

#ifdef CSR_SME_USERSPACE
#include "sme_csr/sme_userspace.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

enum sme_reply_type
{
    SME_REPLY_NONE,
    SME_REPLY_SUSPEND,
    SME_REPLY_RESUME
};

enum sme_request_status
{
    SME_REQUEST_EMPTY,
    SME_REQUEST_PENDING,
    SME_REQUEST_RECEIVED,
    SME_REQUEST_TIMEDOUT,
    SME_REQUEST_CANCELLED,
};

/* Structure to hold a UDI logged signal */
typedef struct
{
    /* The current status of the request */
    enum sme_request_status request_status;

    /* The status the SME has passed to us */
    CsrResult reply_status;

    /* SME's reply to a get request */
    CsrWifiDataBlock mibData;

    /* SME's reply to a scan request */
    CsrUint16             reply_scan_results_count;
    CsrWifiSmeScanResult *reply_scan_results;
} sme_reply_t;


typedef struct
{
    CsrUint16                  appHandle;
    CsrWifiRouterEncapsulation encapsulation;
    CsrUint16                  protocol;
    CsrUint8                   oui[3];
    CsrUint8                   in_use;
} sme_ma_packet_ind_filter_t;


CsrWifiRouterCtrlPortAction uf_sme_port_state(os_linux_priv_t *priv,
                                              unsigned char   *address,
                                              int              queue,
                                              CsrUint16        interfaceTag);

/* The workqueue task to the set the multicast addresses list */
void uf_multicast_list_wq(struct work_struct *work);

/* The workqueue task to execute the TA module */
void uf_ta_wq(struct work_struct *work);


/*
 * SME blocking helper functions
 */
#ifdef UNIFI_DEBUG
# define sme_complete_request(priv, status)   uf_sme_complete_request(priv, status, __func__)
#else
# define sme_complete_request(priv, status)   uf_sme_complete_request(priv, status, NULL)
#endif

void uf_sme_cancel_request(os_linux_priv_t *priv, CsrResult reply_status);
int uf_sme_complete_request(os_linux_priv_t *priv, CsrResult reply_status, const char *func);


/*
 * Blocking functions using the SME SYS API.
 */
int sme_sys_suspend(os_linux_priv_t *priv);
int sme_sys_resume(os_linux_priv_t *priv);


/*
 * Traffic Analysis workqueue jobs
 */
void uf_ta_ind_wq(struct work_struct *work);
void uf_ta_sample_ind_wq(struct work_struct *work);

/*
 * SME config workqueue job
 */
void uf_sme_config_wq(struct work_struct *work);

/*
 * To send M4 read to send IND
 */
void uf_send_m4_ready_wq(struct work_struct *work);

int sme_mgt_mib_set(os_linux_priv_t *priv, CsrUint16 InterfaceTag, CsrWifiDataBlock *mibData);
int sme_mgt_mib_get(os_linux_priv_t *priv, CsrUint16 InterfaceTag, CsrWifiDataBlock *mibData);
int sme_mgt_packet_filter_set(os_linux_priv_t *priv, CsrUint16 InterfaceTag);
int sme_mgt_tspec(os_linux_priv_t *priv, CsrUint16 InterfaceTag, CsrWifiSmeListAction action,
                  CsrUint32 tid, CsrWifiDataBlock *tspec, CsrWifiDataBlock *tclas);

#ifdef CSR_SUPPORT_WEXT
/*
 * Blocking functions using the SME MGT API.
 */
int sme_mgt_wifi_on(os_linux_priv_t *priv);
int sme_mgt_wifi_off(os_linux_priv_t *priv);

int sme_mgt_scan_full(os_linux_priv_t *priv, CsrWifiSsid *specific_ssid,
                      int num_channels, unsigned char *channel_list);
int sme_mgt_scan_results_get_async(os_linux_priv_t        *priv,
                                   struct iw_request_info *info,
                                   char                   *scan_results,
                                   long                    scan_results_len);
int sme_mgt_disconnect(os_linux_priv_t *priv, CsrUint16 InterfaceTag);
int sme_mgt_connect(os_linux_priv_t *priv, CsrUint16 InterfaceTag);
int sme_mgt_key(os_linux_priv_t *priv, CsrUint16 InterfaceTag, CsrWifiSmeKey *sme_key,
                CsrWifiSmeListAction action);
int sme_mgt_pmkid(os_linux_priv_t *priv, CsrUint16 InterfaceTag, CsrWifiSmeListAction action,
                  CsrWifiSmePmkidList *pmkid_list);
#ifdef CSR_SUPPORT_WEXT_AP
int sme_ap_start(os_linux_priv_t *priv, CsrUint16 interface_tag, CsrWifiSmeApConfig_t *ap_config);
int sme_ap_stop(os_linux_priv_t *priv, CsrUint16 interface_tag);
int sme_ap_config(os_linux_priv_t *priv, CsrUint16 interface_tag, CsrWifiWextApMacConfig *ap_mac_config, CsrWifiWextApConfig *group_security_config);
#endif
int unifi_translate_scan(struct net_device *dev,
                         struct iw_request_info *info,
                         char *current_ev, char *end_buf,
                         CsrWifiSmeScanResult *scan_data,
                         int scan_index);

#endif /* CSR_SUPPORT_WEXT */

int unifi_cfg_power(os_linux_priv_t *priv, unsigned char *arg);
int unifi_cfg_power_save(os_linux_priv_t *priv, CsrUint16 InterfaceTag, unsigned char *arg);
int unifi_cfg_power_supply(os_linux_priv_t *priv, CsrUint16 InterfaceTag, unsigned char *arg);
int unifi_cfg_packet_filters(os_linux_priv_t *priv, CsrUint16 InterfaceTag, unsigned char *arg);
int unifi_cfg_wmm_qos_info(os_linux_priv_t *priv, CsrUint16 InterfaceTag, unsigned char *arg);
int unifi_cfg_wmm_addts(os_linux_priv_t *priv, CsrUint16 InterfaceTag, unsigned char *arg);
int unifi_cfg_wmm_delts(os_linux_priv_t *priv, CsrUint16 InterfaceTag, unsigned char *arg);
int unifi_cfg_get_info(os_linux_priv_t *priv, CsrUint16 InterfaceTag, unsigned char *arg);
int unifi_cfg_strict_draft_n(os_linux_priv_t *priv, CsrUint16 InterfaceTag, unsigned char *arg);

#ifdef CSR_SUPPORT_WEXT_AP
int unifi_cfg_set_ap_config(os_linux_priv_t *priv, unsigned char *arg);
#endif


int convert_sme_error(CsrResult error);


#ifdef __cplusplus
}
#endif
#endif /* __LINUX_UNIFI_SME_H__ */
