/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2013
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

#ifndef __LINUX_SME_USERSPACE_H__
#define __LINUX_SME_USERSPACE_H__ 1

#include "csr_synergy.h"

#include "os_linux_priv.h"
#include <linux/kernel.h>

#ifdef __cplusplus
extern "C" {
#endif

int uf_sme_init(os_linux_priv_t *priv);
void uf_sme_deinit(os_linux_priv_t *priv);
int uf_sme_queue_message(os_linux_priv_t *priv, u8 *buffer, int length);

#include "csr_wifi_router_lib.h"
#include "csr_wifi_router_sef.h"
#include "csr_wifi_router_ctrl_lib.h"
#include "csr_wifi_router_ctrl_sef.h"
#include "csr_wifi_sme_task.h"
#ifdef CSR_SUPPORT_WEXT_AP
#include "csr_wifi_nme_ap_lib.h"
#endif
#include "csr_wifi_sme_lib.h"
#include "csr_wifi_mib.h"

void CsrWifiRouterTransportInit(os_linux_priv_t *priv);
void CsrWifiRouterTransportRecv(void *inst, CsrUint8 *buffer, CsrSize bufferLength);
void CsrWifiRouterTransportDeInit(os_linux_priv_t *priv);

#ifdef __cplusplus
}
#endif
#endif /* __LINUX_SME_USERSPACE_H__ */
