#ifndef _GC_HAL_KERNEL_DEBUG_LOGLEVEL_H_
#define _GC_HAL_KERNEL_DEBUG_LOGLEVEL_H_

#include <linux/device.h>
#include <linux/platform_device.h>

#include "../os/linux/kernel/gc_hal_kernel_linux.h"
#include "../os/linux/kernel/gc_hal_kernel_debug.h"

extern gckGALDEVICE galDevice;

/* Adapt standard kernel log mechanism */
gcmINLINE void gc_print_debug_msg(gctUINT32, gctCONST_STRING, gctPOINTER);

gcmINLINE void gc_print_debug_msg(gctUINT32 level, gctCONST_STRING msg,
		gctPOINTER data)
{
	gctCHAR buffer[768];
	gctINT len;

	/* Format the string. */
	len = gcmkVSPRINTF(buffer, gcmSIZEOF(buffer), msg, data);
	len = (likely(len < gcmSIZEOF(buffer)))? len:gcmSIZEOF(buffer) - 1;
	/* Add end-of-line if missing. */
	buffer[len++] = '\n';
	buffer[len] = '\0';

	if (galDevice != NULL) {
		if (level == gcvLEVEL_ERROR)
			dev_err(&(galDevice->platform->device->dev), "%s", buffer);
		else if (level == gcvLEVEL_WARNING)
			dev_warn(&(galDevice->platform->device->dev), "%s", buffer);
		else if (level == gcvLEVEL_INFO)
			dev_info(&(galDevice->platform->device->dev), "%s", buffer);
		else if (level == gcvLEVEL_FATAL)
			dev_alert(&(galDevice->platform->device->dev), "%s", buffer);
		else
			dev_dbg(&(galDevice->platform->device->dev), "%s", buffer);
	}
}

#endif /* _GC_HAL_KERNEL_DEBUG_LOGLEVEL_H_ */
