/*
 * masca_helper.h file exports api's for timers, msf, lab conversion
 *
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License ,  or
 * (at your option) any later version.
 */

#ifndef MASCA_HELPER_H
#define MASCA_HELPER_H

/*all alarms of the MASCA driver*/
enum masca_alm_id {
	ALM_DIAG = 0,
	ALM_DRVCTRL,
	ALM_TOCTEXTHASH,
	ALM_EJECT,
	ALM_STOP_DRV,
	ALM_AUTO_REINSERT,
	ALM_DRV_SM,
	ALM_BLK_RD,
	MASCA_MAX_ALMS
};

#define SECTOR_SIZE_CD			2048
#define FRAMES_PER_MIN			4500
#define FRAMES_PER_SEC			75
#define DATA_STRT_OFFSET		150
#define MASK_UPPER_NIBBLE		0xF0
#define MASK_LOWER_NIBBLE		0x0F

#define BCD_BASE_MULTIPLIER		10

#define GET_LBA(min, sec, frm)		((unsigned int)(((unsigned int)min * \
					FRAMES_PER_MIN) + \
					((unsigned int)sec * FRAMES_PER_SEC) +\
					(unsigned int)frm))
#define GET_PHY_ADDR(logical_addr)	(logical_addr + DATA_STRT_OFFSET)

#define BCD_TO_HEX(bcd)			(((((bcd) & MASK_UPPER_NIBBLE) >> 4) * \
					BCD_BASE_MULTIPLIER) + \
					((bcd) & MASK_LOWER_NIBBLE))

#define SHIFT_24		24
#define SHIFT_16		16
#define SHIFT_8			8
#define SHIFT_5			5

/*Memory elements from Command handler*/
enum masca_cmd_lst_stat {
	EXECUTING,
	PENDING,
	EMPTY
};

struct masca_cmd_lst_elem {
	struct masca_cmd_params            acpptd_cmd;
	enum masca_cmd_lst_stat		elem_stat;
	struct masca_cmd_lst_elem  *p_nxt;
};

struct masca_configuration {
	unsigned int     pllel_maxreq;
	unsigned int     life_time_tmout;
	unsigned int     auto_reinsrt_tmout;
	unsigned int     diag_tmout;
	unsigned int     diag_rty_cnt;
	unsigned int     diag_rst_cnt;
	unsigned int     drvctrl_tmout;
	unsigned int     drvctrl_rty_cnt;
	unsigned int     drvctrl_rst_cnt;
	unsigned int     eject_tmout;
	unsigned int     eject_rty_cnt;
	unsigned int     eject_rst_cnt;
	unsigned int     toctext_tmout;
	unsigned int     toctext_rty_cnt;
	unsigned int     toctext_rst_cnt;
	unsigned int     blkrd_tmout;
	unsigned int     blkrd_rty_cnt;
	unsigned int     temp_rd_interval;
	/*no of elements is defined by pllel_maxreq variable for cmd handler*/
	struct masca_cmd_lst_elem *p_cmd_hndlr_lst;
	/*no of elements is defined by pllel_maxreq variable for diag handler*/
	struct masca_cmd_lst_elem *p_diag_hndlr_lst;
};

void masca_helper_init(void);
void masca_helper_deinit(void);
void masca_read_configuration(struct masca_configuration *
							const p_config);
void masca_util_set_event(const unsigned int evt_pattern);
void masca_util_clr_event(const unsigned int evt_pattern);
int masca_util_get_event(void);
int masca_util_read_event(void);
unsigned int masca_util_ref_ptn(void);
void masca_util_sta_alm(const unsigned int alm_interval,
						const enum masca_alm_id alm_id);
void masca_util_stp_alm(const enum masca_alm_id alm_id);
extern void masca_get_msf(const unsigned int lba,
			unsigned char *const p_min,
			unsigned char *const p_sec,
			unsigned char *const p_frame
			);

/*List all the alarm functions over here*/
void masca_diag_alm_cbk(void);
void masca_drvctrl_alm_cbk(void);
void masca_eject_alm_cbk(void);
void masca_toctexthash_alm_cbk(void);
void masca_mngr_sm_cbk(void);
void masca_temp_read_cbk(void);
void masca_auto_stop_alm_hndlr(void);
void masca_blkrd_alm_cbk(void);
void masca_auto_reinsrt_alm_hndlr(void);
#endif /*end of MASCA_HELPER_H*/

