/*
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License ,  or
 * (at your option) any later version.
 */

#ifndef __MASCA_HAL_H_
#define __MASCA_HAL_H_

#include <linux/interrupt.h>

int masca_initialize_hal(void);
void masca_deinitialize_hal(void);
int masca_configure_irq(int gpio_num, irqreturn_t (*handlr)(int irq,
			void *data), const char *hndlname);
int masca_gpio_init(void);
bool masca_priority_change(void);
void masca_cs_on(void);
void masca_cs_off(void);
bool masca_check_req(void);
void masca_intr_spireq_on(void);
void masca_intr_spireq_off(void);
void masca_drv_reset(bool rst_line_on);
void masca_hal_rst_pulse(void);
enum masca_error masca_prepare_sndbuf(const char * const sndbuf, const int len);
enum masca_error masca_prepare_recvbuf(char *rcvbuf, int *len);
enum masca_error masca_hal_rcv(char * const rcvbuf);
enum masca_error masca_hal_snd(char *sndbuf, int len);
void masca_gpio_deinit(int gpio_num);

/*GPIO pins*/
extern int masca_chipselect_num;
extern int masca_reqline_num;
extern int masca_lstart_num;
extern int masca_reset_num;

/*low/high GPIO pins configuration*/
/*default configurations for GPIO's is low active*/
extern int cs_low_active;	/*low active logic for CS pin by default*/
extern int reset_low_active;	/*low active logic for RESET pin by default*/
extern int req_low_active;	/*low active logic for request line by default*/

#endif /* __MASCA_HAL_H_ */

