/*
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#ifndef MASCA_DISPATCH_I_H
#define MASCA_DISPATCH_I_H

#include "masca_helper.h"
#include "masca_drv_mngr.h"

enum masca_media_status {
	MASCA_NO_MEDIA,
	MASCA_MEDIA_INSERTED,
	MASCA_MEDIA_EJECT_PROCESSED,
	MASCA_NO_UPDATE
};

union masca_response_params {
	struct masca_cd_toc		*p_cd_toc;
	struct masca_cd_text		*p_cd_text;
	struct masca_session_info	*p_cd_session_info;
	struct masca_version_info	cd_version_info;
	unsigned int			cd_capacity;
	union masca_diag_param		cd_diag_params;
	enum masca_media_status		mda_stat;
	enum masca_spin_speed		spin_speed;
};

struct masca_output {
	enum masca_cmd replied_command;
	enum masca_error reply_status;
	int response_id;
	union masca_response_params output_params;
	unsigned char *cmdbuf;
	int cmd_len;
};

enum masca_event {
	CD_ABSENT,
	CD_INSERTING,
	CD_AUTO_REINSERTING,
	CD_INSERTED,
	CD_LOAD_ERROR,
	CD_LOADING,
	CD_ACCESSIBLE,
	CD_EJECTING,
	CD_IN_SLOT,
	CD_PLAY_INFO,
	CD_TRACK_END,
	CD_END,
	CD_PLAY_COMPLETE,
	CD_DEFECTIVE,
	CD_MECHA_LOAD_ERR,
	DRIVE_OVER_TEMPERATURE,
	DRIVE_NORMAL_TEMPERATURE,
	DRIVE_UNDER_VOLT,
	DRIVE_NORMAL_VOLT,
	NO_EVENT
};

enum masca_media_type {
	DISC_CDDA,
	DISC_CDROM,
	DISC_MIXED_MODE,
	DISC_BAD_MEDIA,
	DISC_MAX
};

struct masca_cd_identification {
	enum masca_media_type	cd_type;
	unsigned int		unique_id;
	bool			same_as_previous;
	bool			auto_reinsert;
	bool			was_cd_accessible;
};

struct masca_evt_param {
	struct masca_cd_identification	cd_identify;
	struct masca_drv_play_info	play_info;
};

struct masca_event_info {
	enum masca_event	evt;
	struct masca_evt_param	event_info;
};

extern struct masca_event_info out_event_global;

void masca_dispatch_cmd(const struct masca_cmd_params * const p_cmd,
				struct masca_output * const p_output);

enum masca_error masca_dispatch_event(
				const unsigned int evt_pattern,
				struct masca_event_info * const p_evt_info,
				struct masca_output * const p_output);

enum masca_error masca_dispatch_abort_req(const unsigned int abort_req);

#endif/*end of MASCA_DISPATCH_I_H*/

