/*
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#ifndef MASCA_COMMON_TYPES_H
#define MASCA_COMMON_TYPES_H

#include <linux/module.h>
#include "masca_trace.h"

#define COMPONENT_NAME_MASCA	"MASCA"
#define TRUE		1/* True */
#define FALSE		0/* False */

#define DRIVE_MSG_ID_BYTE	0x02
#define MSG_STATUS_ID		0x53
#define COMMAND_STATUS_ID	0x10
#define COMMAND_PLAY_ID		0x12
#define COMMAND_PALY_CONT	0x09
#define COMMAND_ID_POS		0
#define COMMAND_IGN_AUDIO_POS	2
#define SWAP_NIBBLE(x) ((x) >> 0x04 | (x) << 0x04)

#define BYTE_MASK		0x00ff
#define BYTE_1_START		0
#define BYTE_2_START		8
#define BYTE_3_START		16
#define BYTE_4_START		24

#define DIAG_CMD_WIRTE_STICKER	7

#define DIAG_CHECKSUM_SIZE	1
#define MAX_JUMP_CNT_SIZE	5 /* jump count byte size*/

#define E_OK		0

#define DRIVE_MSG_ID	0
#define DRIVE_REJ_CMD_ID_POS 8
#define DRIVE_REJ_CMD_PARAM1 9
#define DRIVE_REJ_CMD_PARAM2 10

#define MAX_CD_TRKS_INFO 100	/* 1 CD disc info + 99 tracks info = 100 */
#define MIN_TRACK	1	/* Minimum track number */
#define MAX_TRACK	99	/* Maximum track number */
#define MAX_TEXT_INFO	128
#define CD_DISC_INFO	0	/* arr[0] contain the whole CD info */
#define ADR_CTRL_AUDIO	0x10
#define ADR_CTRL_DATA	0x14
#define ADR_CTRL_HYBRID 0x45

/*!!!!!!!!!!!!!!!!!!!IMPORTANT!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
/*The order of the enums has dependency in masca_drv_mngr_cnfg.c, Refer */
/*Refer to app_cmd_mapping array in masca_drv_mngr.c and adjust it */
/*!!!!!!!!!!!!!!!!!!!IMPORTANT!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
enum masca_cmd {
	PLAY_LBA = 0,		/*0*/
	PLAY_LBA_CONTINUOUS,
	PLAY_MSF,
	PLAY_MSF_CONTINUOUS,
	PAUSE,
	FFWD_MSF,		/*5*/
	FFWD_LBA,
	FWD_MSF,
	FWD_LBA,
	BWD_MSF,
	BWD_LBA,		/*10*/
	FBWD_MSF,
	FBWD_LBA,
	INSERT,
	EJECT,
	PWR_ACTIVE,		/*15*/
	PWR_STANDBY,
	PWR_STANDBY_NO_CD,
	PWR_SLEEP,
	STOP,
	RESET_DRIVE,		/*20*/
	READ_SECTORS,
	GET_CD_CAPACITY,
	GET_MEDIA_STAT,
	GET_VERSION_INFO,
	GET_TOC,		/*25*/
	GET_SESSION_INFO,
	GET_TITLE_ALBUM_AUTHOR,
	READ_SECTORS_HASH,
	RESUME,
	STOP_DISC,		/*30*/
	EN_IGN_AUDIO,
	DIS_IGN_AUDIO,
	CMD_SET_CD_SPEED,
	GET_TEST_UNIT_READY,
	GET_REQUEST_SENSE,	/*35*/
	CMD_RESERVE,
	CMD_RELEASE,
	CMD_SEND_DIAGNOSTIC,
	CMD_RECEIVE_DIAGNOSTIC,
	CMD_READ_DISK_INFO,	/*40*/
	CMD_GET_EVT_STAT,
	READ_SUBCHANNEL,
	DIAG_GET_TEMPERATURE,
	DIAG_GET_LASER_CURRENT,
	DIAG_GET_SWITCH_STATUS,	/*45*/
	DIAG_CMD_ADJUSTMENT,
	DIAG_CMD_CD_TEXT_OFF,
	DIAG_CMD_CD_TEXT_MODE2,
	DIAG_CMD_C1C2_ERR_COUNT_ON,
	DIAG_CMD_TIME_READOUT,		/*50*/
	DIAG_CMD_EJECT_LOAD_CYCLES,
	DIAG_CMD_JUMP_COUNTER,
	DIAG_CMD_EEPROM_READOUT,
	DIAG_CMD_WRITE_STICKER,
	DIAG_CMD_READ_STICKER,		/*55*/
	DIAG_CMD_JITTER_MEASURE,
	DIAG_CMD_VERTICAL_DEV_MEASURE,
	DIAG_CMD_ECCENTRIC_MEASURE,
	DIAG_CMD_REFLECTIVE_MEASURE,
	DIAG_CMD_INTERNAL_SELF_TEST,	/*60*/
	DIAG_CMD_EXTERNAL_SDRAM_TEST,
	DIAG_CMD_INIT_LASER_CURRENT,
	DIAG_CMD_NUM_READ_ERRS,
	DIAG_CMD_DATE_PRODUCTION_READ,
	DIAG_CMD_DATE_INSTALL_WRITE,	/*65*/
	DIAG_CMD_DATE_INSTALL_READ,
	DIAG_CMD_SERIAL_NO_READ,
	DIAG_CMD_STATUS_MSG_ERR_HISTROY,
	DIAG_CMD_STATUS_MSG_LAST_ERRS,
	DIAG_CMD_USED_CD_TYPE_COUNT,	/*70*/
	DIAG_CMD_USER_PROFILE_USED_CDS,
	DIAG_CACHE_DISABLE,
	INVALID_CMD,
	PLAY_NON_CONTINUOUS,
	MAX_COMMAND			/*75*/
};

/******* Inquiry Command start ************/
/* Further details can be referred in SPC3 document
 * Section: 6.4 - Inquiry general command
 * Section: 7.6.9 - VPD page 0x00
 * Section: 7.6.10 - VPD page 0x80
 */

enum INQ_REQ {
	INQ_REQ_EVPD = 1,
	INQ_REQ_PAGE_CODE = 2,
	INQ_REQ_ALLOC_LENGTH = 3,
	INQ_REQ_CONTROL = 5
};

enum INQ_VPD_RESP {
	INQ_VPD_RESP_DEVICE_TYPE = 0,
	INQ_VPD_RESP_PAGE_CODE = 1,
	INQ_VPD_RESP_PAGE_LEN = 3
};

enum INQ_VPD80_RESP {
	INQ_VPD80_RESP_SRL_NUM = 4,
	INQ_VPD80_RESP_HW_VER = 10,
	INQ_VPD80_RESP_SW_VER = 12
};

enum INQ_VPD00_RESP {
	INQ_VPD00_RESP_PAGE_LIST = 4
};
/******* Inquiry Command end ************/

/*******  Read Capacity Command start ************/
/* Further details can be referred in MMC3 document
 * Section: 5.16 - Read Capacity
 */

enum READCAP_REQ {
	READCAP_REQ_RELADDR = 1,
	READCAP_REQ_LBA = 2,
	READCAP_REQ_PMI = 8,
	READCAP_REQ_CTRL = 9
};

enum READCAP_RESP {
	READCAP_RESP_LBA = 0,
	READCAP_RESP_LEN = 4

};
/******* Read Capacity Command end ************/

/******* Start Stop Command start ************/
/* Further details can be referred in SBC document
 * Section: 6.1.14 START STOP UNIT command
 */

enum START_STOP_REQ {
	START_STOP_REQ_IMMED = 1,
	START_STOP_REQ_PWR_LOAD_EJCT = 4,
	START_STOP_REQ_CTRL = 5
};
/******* Start Stop Command end ************/

/******* Read 10 Command start ************not implemented*/
/* Further details can be referred in SBC document
 * Section: 6.1.5 Read 10 command
 */

enum READ10_REQ {
	READ10_REQ_FUA_RELADR = 1,
	READ10_REQ_LBA = 2,
	READ10_REQ_TXLEN = 7,
	READ10_REQ_CTRL = 9
};
/******* Read 10 Command end ************/

/******* Scan Command Start ************/
/* Further details can be referred in MMC3 document
 * Section: 5.28 Scan command
 */

enum SCAN_REQ {
	SCAN_REQ_DIR_RELADR = 1,
	SCAN_REQ_SCAN_ADDR = 2,
	SCAN_REQ_TYPE = 9,
	SCAN_REQ_CTRL = 11
};
/******* Scan Command end ************/

/******* Get Configuration Command Start ************/
/* Further details can be referred in MMC3 document
 * Section: 5.5 Get Config
 */

enum GETCONFIG_REQ {
	GETCONFIG_REQ_RT = 1,
	GETCONFIG_REQ_FEAT_NUM = 2,
	GETCONFIG_REQ_ALLOCLEN = 7,
	GETCONFIG_REQ_CTRL = 9
};

enum GETCONFIG_RESP_HDR {
	GETCONFIG_RESP_HDR_DAT_LEN = 0,
	GETCONFIG_RESP_HDR_CUR_PRFL = 6
};
enum GETCONFIG_RESP_FEATDES {
	GETCONFIG_RESP_FEATDES_FCODE = 0,
	GETCONFIG_RESP_FEATDES_VER_CUR_PERS = 2,
	GETCONFIG_RESP_FEATDES_ADDLEN = 3,
	GETCONFIG_RESP_FEATDES_DEP_DATA = 4
};

enum GETCONFIG_RESP_PROF_DESC {
	GETCONFIG_RESP_PROF_DESC_PRO_NUM = 0,
	GETCONFIG_RESP_PROF_DESC_CURP = 2
};
/******* Get Configuration Command end ************/

/******* Set CD Speed Command start ************/
/* Further details can be referred in MMC3 document
 * Section: 5.34 Set CD Speed
 */

enum SET_SPEED_REQ {
	SET_SPEED_REQ_ROT_CTRL = 1,
	SET_SPEED_REQ_READ_SPEED = 2
};

/******* Set CD Speed Command end ************/

/******* Mode Sense 10 Command start ************/
/* Further details can be referred in SPC3 document
 * Section: 6.10 Mode Sense 10
 * Section: Table 240 — Mode parameter header(10)
 */

enum MODESENSE10_REQ {
	MODESENSE10_REQ_PAGE_CODE = 2
};

enum MODESENSE10_RESP {
	MODESENSE10_RESP_MEDIUM_TYPE = 2
};

/******* Mode Sense 10 Command end ************/

/******* Play MSF Command start ************/
/* Further details can be referred in MMC3 document
 * Section: 5.13 Play MSF
 */

enum PLAYMSF_REQ {
	PLAYMSF_REQ_START_MIN = 3,
	PLAYMSF_REQ_START_SEC = 4,
	PLAYMSF_REQ_START_FRAME = 5,
	PLAYMSF_REQ_END_MIN = 6,
	PLAYMSF_REQ_END_SEC = 7,
	PLAYMSF_REQ_END_FRAME = 8,
	PLAYMSF_REQ_CTRL = 9
};

/******* Play MSF Command end ************/

/******* Pause Resume Command start ************/
/* Further details can be referred in MMC3 document
 * Section: 5.10 Pause Resume
 */

enum PAUSE_RESUME_REQ {
	PAUSE_RESUME_REQ_RESUME = 8
};

/******* Pause Resume Command end ************/

/******* Read Toc Command start ************/
/* Further details can be referred in MMC3 document
 * Section: 5.23 Read Toc
 */

enum TOC_REQ {
	TOC_REQ_TIME = 1,
	TOC_REQ_FORMAT = 2,
	TOC_REQ_TRK_SESSION_NUM = 6,
	TOC_REQ_ALLOC_LEN = 7,
	TOC_REQ_CTRL = 9
};

/******* Read Toc Command end ************/

/******* Get Event Status Command start ************/
/* Further details can be referred in MMC3 document
 * Section: 5.6 Get Event Status
 */

enum GETEVT_REQ {
	GETEVT_REQ_IMMED = 1,
	GETEVT_REQ_NOTY_REQ = 4,
	GETEVT_REQ_ALLOC_LEN = 7,
	GETEVT_REQ_CTRL = 9
};

enum GETEVENT_HDR {
	GETEVT_HDR_DATA_LEN = 0,
	GETEVT_HDR_NEA_NOTY_CLASS = 2,
	GETEVT_HDR_NEA_SUPP_CLASS = 3
};

enum GETEVT_MEDIA_RESP {
	GETEVT_MEDIA_RESP_MEDIA_EVT = 0,
	GETEVT_MEDIA_RESP_MEDIA_STAT = 1
};

enum GETEVT_POWR_RESP {
	GETEVT_POWR_RESP_PWR_EVT = 0,
	GETEVT_POWR_RESP_PWR_STAT = 1
};

/******* Get Event Status Command end ************/

/******* Read Sub Channel Command start ************/
/* Further details can be referred in MMC3 document
 * Section: 5.22 Read Sub Channel
 */

enum READSUBCH_REQ {
	READSUBCH_REQ_TIME = 1,
	READSUBCH_REQ_SUBQ = 2,
	READSUBCH_REQ_SUBCH_LIST = 3,
	READSUBCH_REQ_TRK_NUM = 6,
	READSUBCH_REQ_ALLOC_LEN = 7,
	READSUBCH_REQ_CTRL = 9,
};

enum READSUBCH_HDR {
	READSUBCH_HDR_AUD_STAT = 1,
	READSUBCH_HDR_SUBCH_DATLEN = 2
};

enum READSUBCH_RESP {
	READSUBCH_RESP_SUBCH_CODE = 0,
	READSUBCH_RESP_ADR_CTRL = 1,
	READSUBCH_RESP_TRK_NUM = 2,
	READSUBCH_RESP_INDX_NUM = 3,
	READSUBCH_RESP_ABS_TIME = 4,
	READSUBCH_RESP_RELAT_TIME = 8
};

/******* Read Sub Channel Command end ************/

/******* Read Disc Info Command start ************/
/* Further details can be referred in MMC3 document
 * Section: 5.19 Read Disc Info
 */

enum READ_DISC_REQ {
	READ_DISC_REQ_ALLOC_LEN = 7,
	READ_DISC_REQ_CTRL = 9
};

enum READ_DISC_RESP {
	READ_DISC_RESP_DATA_LEN = 0,
	READ_DISC_RESP_STATUS = 2,
	READ_DISC_RESP_FIRST_TRK_NUM,
	READ_DISC_RESP_SESS_CNT_LSB,
	READ_DISC_RESP_FIRST_TRK_LSB,
	READ_DISC_RESP_LAST_TRK_LSB,
	READ_DISC_RESP_URU_BIT,
	READ_DISC_RESP_CD_TYPE,
	READ_DISC_RESP_SESS_CNT_MSB,
	READ_DISC_RESP_FIRST_TRK_MSB,
	READ_DISC_RESP_LAST_TRK_MSB
};
/******* Read Disc Info Command end ************/


/******* Log Sense Command start ************/
/* Further details can be referred in SPC3 document
 * Section: 7.2.13 LOG SENSE Response
 * Section: 6.6 LOG SENSE Command
 */

enum LOGSENSE_REQ {
	LOGSENSE_REQ_ALLOC_LEN = 7,
	LOGSENSE_REQ_CTRL = 9
};

enum LOGSENSE_RESP {
	LOGSENSE_RESP_PG_CODE = 0,
	LOGSENSE_RESP_PG_LEN = 2,
	LOGSENSE_RESP_TEMP_CODE = 4,
	LOGSENSE_RESP_TEMP_FRMT = 6,
	LOGSENSE_RESP_TEMP_LEN = 7,
	LOGSENSE_RESP_TEMP_VAL = 8,
	LOGSENSE_RESP_REF_TEMP_CODE = 10,
	LOGSENSE_RESP_REF_TEMP_FRMT = 12,
	LOGSENSE_RESP_REF_TEMP_LEN = 13,
	LOGSENSE_RESP_REF_TEMP_VAL = 15
};

/******* Log Sense Command end ************/


/******* Send Diagnostics Command Start ************/
/* Further details can be referred in SPC3 document
 * Section: 6.28 Send Diagnostics command
 */

enum SEND_DIAG_REQ {
	SEND_DIAG_REQ_LIST_LEN = 3,
	/* enumerator assignment for bit-wise operation in test_bit()
		(Parameter_no * 8 bit) + Param_bit_pos(bit0-7) */
	SEND_DIAG_REQ_UNITOFF = (1 * 8) + 0,
	SEND_DIAG_REQ_DEVOFF = (1 * 8) + 1,
	SEND_DIAG_REQ_SELFTEST = (1 * 8) + 2,
	SEND_DIAG_REQ_PAGE_FORMAT = (1 * 8) + 4
};
/******* Send Diagnostics end ************/

/******* Receive Diagnostics Command Start ************/
/* Further details can be referred in SPC3 document
 * Section: 6.18 Receive Diagnostics command
 * Section: 7.1.2 Receive Diagnostics response
 */

enum RCV_DIAG_REQ {
	RCV_DIAG_REQ_PG_CODE = 2,
	RCV_DIAG_REQ_ALLOC_LEN = 3,
	RCV_DIAG_REQ_CTRL = 5
};

enum RCV_DIAG_RESP {
	RCV_DIAG_RESP_PG_CODE = 0,
	RCV_DIAG_RESP_PG_LEN = 2,
	RCV_DIAG_RESP_PG_LIST = 4
};
/******* Receive Diagnostics end ************/
struct track_msf {
	unsigned char min;
	unsigned char sec;
	unsigned char frm;
};

struct masca_track_info {
	struct track_msf track_start;
	unsigned int	track_start_lba;
	unsigned char	adr_ctrl;
	unsigned char	track_number;
};

struct masca_cd_toc {
	struct masca_track_info track_info[MAX_CD_TRKS_INFO];
	unsigned char first_track_number;
	unsigned char last_track_number;
	unsigned char cd_max_min;
	unsigned char cd_max_sec;
	unsigned char last_min;
	unsigned char last_sec;
	unsigned char last_frm;
	unsigned char first_audio_trk_num;
	unsigned char last_audio_trk_num;
	unsigned char first_data_trk_num;
	unsigned char last_data_trk_num;
};

struct get_evt_status {
	char evt_header[4];
	char evt_data[4];
};

struct masca_read_subchannel_cmd_resp {
	unsigned char subchannel_header[4];
	unsigned char subchannel_data[12];
};

extern struct masca_cd_toc cd_toc;

struct masca_cd_text_entry {
	unsigned char track_title[MAX_TEXT_INFO];
	unsigned char track_album[MAX_TEXT_INFO];
	unsigned char track_author[MAX_TEXT_INFO];
	unsigned char length_title;
	unsigned char length_album;
	unsigned char length_author;
	unsigned char track_num;
};

struct masca_cd_text {
	struct masca_cd_text_entry track_text[MAX_CD_TRKS_INFO];
	unsigned char track_number_first;
	unsigned char track_number_last;
};

struct masca_session_info {
	unsigned char first_complete_session;
	unsigned char last_complete_session;
	struct masca_track_info last_sess_trk_info;
};

struct masca_version_info {
	unsigned char vendor_identification;
	unsigned char software_version;
	unsigned char hardware_version;
};

struct masca_adjustment {
	unsigned char focus_gain;
	unsigned char focus_offset;
	unsigned char focus_balance;
	unsigned char tracking_gain;
	unsigned char tracking_offset;
	unsigned char tracking_balance;
	unsigned char rf_gain;
	unsigned char rf_offset;
	unsigned char adjustment_sucess;
};

struct masca_jump_counter {
	unsigned char eeprom_chksum;
	unsigned char jump_counter[MAX_JUMP_CNT_SIZE - DIAG_CHECKSUM_SIZE];
};

struct masca_play_info_msf {
	unsigned char start_min;
	unsigned char start_sec;
	unsigned char start_frame;
	unsigned char end_min;
	unsigned char end_sec;
	unsigned char end_frame;
	unsigned char trk_num_playmsf;
	unsigned char trk_num_last;
};

struct masca_play_info_lba {
	unsigned int	start_sector_address;
	unsigned short	play_lng;
	unsigned char	trk_num_playlba;
};

struct masca_sector_read_info {
	unsigned char	*p_buffer;
	unsigned int	sector_start_address;
	unsigned short	number_of_sectors;
};

struct masca_diag_cmd_params {
	bool		cache_disable;
	unsigned char	write_sticker[DIAG_CMD_WIRTE_STICKER];
	unsigned int	install_date_write;
};

enum masca_spin_speed {
	SPIN_SPEED_NORMAL = 0,
	SPIN_SPEED_HALFMAX,
	SPIN_SPEED_MAX
};

union masca_param_collection {
	struct masca_sector_read_info	block_read_info;
	struct masca_play_info_lba	play_info_lba;
	struct masca_play_info_msf	play_info_msf;
	struct masca_diag_cmd_params	diag_cmd_params;
	enum masca_spin_speed		cd_speed;
};

struct masca_cmd_params {
	enum masca_cmd			command;
	union masca_param_collection	cmd_params;
	int				reply_id;
};

/*!!!!!!!!!!!!!!!!!!!IMPORTANT!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
/*The order of the enums has dependency in masca_scsi_handler.c.   */
/*Refer to err_sen_map[] array and adjust it accordingly.	   */
/*!!!!!!!!!!!!!!!!!!!IMPORTANT!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
enum masca_error {
	MASCA_OK = 0,			/* 0 */
	/* Soft Error */
	MASCA_SE_OVR_TEMP,		/* 1 */
	/* Not Ready */
	MASCA_NR_UNREPORTABLE,		/* 2 */
	MASCA_NR_INPROGRESS_OF_RDY,
	MASCA_NR_OPR_IN_PROGRESS,
	MASCA_NR_MEDIUM_INCOMPATIBLE,
	MASCA_NR_UNKNOWN_FORMAT,
	MASCA_NR_NO_MEDIUM,		/* 7 */
	/* Medium Error */
	MASCA_ME_IDCRC_CDROM,		/* 8 */
	MASCA_ME_READ_ERR_CDROM,
	MASCA_ME_READ_RETRY_EXHAUST,
	MASCA_ME_TOC_ERROR,		/* 11 */
	/* Hardware Error */
	MASCA_HE_COMM_FAIL,		/* 12 */
	MASCA_HE_DIAG_FAIL,
	MASCA_HE_UNSUCCESS_SFT_RST,
	MASCA_HE_LOAD_EJECT_FAIL,
	MASCA_HE_VOLTAGE_FAULT,
	MASCA_HE_SELF_TEST_FAIL,
	MASCA_HE_TIMEOUT_ON_LOGUNIT,	/* 18 */
	/* Illegal Request */
	MASCA_IR_PLY_PROGRESS,		/* 19 */
	MASCA_IR_PARAM_LISTLEN_ERR,
	MASCA_IR_CMD_NOT_SUPP,
	MASCA_IR_LBA_OUT_OF_RANGE,
	MASCA_IR_INVALID_FLD_IN_CDB,
	MASCA_IR_INVALID_FLD_IN_LIST,
	MASCA_IR_PARAM_NOT_SUPP,	/* 25 */
	MASCA_IR_PARAM_VAL_INVALID,
	MASCA_IR_CMD_SEQ_ERR,
	MASCA_IR_NO_MEDIA_REMOVAL,
	MASCA_IR_TRK_END_MSG,
	MASCA_IR_ILLEGAL_TRK_MOD,	/* 30 */
	/* Unit Attention Error codes */
	MASCA_UA_ERR_LOG_OVRFLW,	/* 31 */
	MASCA_UA_POR,
	MASCA_UA_DEV_RST,
	MASCA_UA_PARAM_CNG,
	MASCA_UA_MODE_PARAM_CNG,	/* 35 */
	MASCA_UA_DISK_END,
	MASCA_UA_INQ_DATA_CNG,
	MASCA_UA_MED_REM_REQ,
	MASCA_UA_LOG_CTR_MAX,
	MASCA_UA_LOW_PWR_ON,		/* 40 */
	MASCA_UA_IDLE_TMR,
	MASCA_UA_STDBY_TMR,
	MASCA_UA_IDLE_CMD,
	MASCA_UA_STDBY_CMD,		/* 44 */
	/* Aborted Command */
	MASCA_AC_READ_ERR_CDDA,		/* 45 */
	/* Gen2 Error codes */
	MASCA_UNKNOWN_MSG_CMD,		/* 46 */
	MASCA_CMD_NOT_SUPP,
	MASCA_INVALID_STATE,
	MASCA_PTR_NULL,
	MASCA_INVALID_PARAM,		/* 50 */
	MASCA_NO_RESOURCE,
	MASCA_IO_ERR,
	MASCA_CHECK_CONDITION,
	MASCA_ACCEPTED,
	MASCA_REJECTED,			/* 55 */
	MASCA_PROCESSED,
	MASCA_BUSY,
	MASCA_ABORT,
	MASCA_Q_FULL,
	MASCA_TIMED_OUT,		/* 60 */
	MASCA_NO_MSG,
	MASCA_CHECKSUM_ERROR,
	MASCA_CD_BLOCK_UNREADABLE,
	MASCA_OUT_OF_BOUND		/* 64 */
};

#endif/*MASCA_COMMON_TYPES_H*/
