/*
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Saurabh Arora <saurabh.arora@in.bosch.com>
 *          Ramesh Ramachandran <ramesh.ramachandran@in.bosch.com>
 *          Mahendran Kuppusamy <mahendran.kuppusamy@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#ifndef MASCA_CMD_HNDLR_H
#define MASCA_CMD_HNDLR_H

void masca_cmd_hndlr_init(const struct masca_configuration * const p_config);

void masca_cmd_hndlr_deinit(void);

enum masca_error masca_cmd_hndlr_cmd(
				const struct masca_cmd_params * const p_cmd,
				struct masca_output * const p_output);

extern void masca_cmd_hndlr_cmd_reply(
		const struct masca_drv_response_info * const p_response_info,
		struct masca_output * const p_output);

enum masca_error masca_cmd_hndlr_evt(const unsigned int evt_pattern,
					struct masca_output * const p_output);

enum masca_error masca_cmd_hndlr_abort(const unsigned int req_id);

#endif /* MASCA_CMD_HNDLR_H */
