/*
 * MASCA Block Reader, handles the Data read request(READ(10))
 *
 * Copyright (C) 2013 ADIT Corporation
 * Authors: Dhanasekaran D <dhanasekaran.d@in.bosch.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#ifndef MASCA_BLOCK_READER_I_H
#define MASCA_BLOCK_READER_I_H

#include "masca_helper.h"

/* block reader states */
#define BLKRDR_DEINIT		0x01
#define BLKRDR_ABORT		0x02
#define BLKRDR_IDLE		0x04
#define BLKRDR_BLK_RQ		0x08
#define BLKRDR_PREPARE		0x10
#define BLKRDR_RETRY_FETCH	0x20
#define BLKRDR_READ_DATA	0x40

extern unsigned char drive_speed;
extern enum masca_error
masca_blkrdr_init(const struct masca_configuration * const p_config);

extern void masca_blkrdr_deinit(void);

extern void masca_blkrdr_abort(void);
extern enum masca_error masca_blkrdr_read_blocks(
		const unsigned int sector_address,
		const unsigned int block_count, unsigned char * const p_buffer);

extern void masca_blkrdr_flush(void);

extern void masca_blkrdr_get_play_pos(
		unsigned int * const p_play_pos,
		unsigned char * const p_block_count);

extern void masca_blkrdr_set_cd_bounds(const unsigned int sect_start_addr,
		const unsigned int end_sect_addr);

extern void masca_blkrdr_cache_disable(bool blkrdr_cache_disable);

extern void masca_util_set_blkevent(const unsigned char evt_ptn);
extern void masca_util_clr_blkevent(const unsigned char evt_ptn);
extern unsigned char masca_util_get_blkevent(void);

#endif/*end of MASCA_BLOCK_READER_I_H*/
