/*
 * exchnd_test - Exception handler test module
 */

#define pr_fmt(fmt) "exchnd_test: " fmt

#include <linux/exchnd.h>

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/kthread.h>
#include <linux/sched.h>
#include <linux/rcupdate.h>

struct module *exchnd_ref;
enum exchnd_modules modules[EHM_LAST_ELEMENT] = { EHM_PROCESSOR_REGISTERS,
						  EHM_STACK_DUMP,
						  EHM_BACKTRACE,
						  EHM_NONE };

static struct task_struct *worker_thread;

static pid_t exchnd_test_find_app(void)
{
	pid_t tid = 0;
	struct task_struct *tsk;

	rcu_read_lock();
	/* Search for the first suitable process */
	for_each_process(tsk) {
		if (!tsk->mm)
			continue;

		tid = task_tgid_vnr(tsk);
		break;
	};
	rcu_read_unlock();

	return tid;
}

static int exchnd_test_run(void *data)
{
	int ret = 0;
	pid_t pid = exchnd_test_find_app();

	pr_info("Default list and text on PID %d.\n", pid);

	ret = exchnd_call_external_trigger(exchnd_ref,
				pid,
				NULL,
				NULL);

	if (ret)
		pr_err("External trigger call failed with %d.\n", ret);

	pr_info("Default list on PID 2000 - shall fail if no task.\n");
	ret = exchnd_call_external_trigger(exchnd_ref,
				2000,
				NULL,
				"Default list on PID 2000");

	if (ret)
		pr_err("External trigger call failed with %d.\n", ret);

	pr_info("Basics (regs, stack, backtrace) on PID %d.\n", pid);
	ret = exchnd_call_external_trigger(exchnd_ref,
				pid,
				&modules,
				"External trigger from exchnd_test module");

	if (ret)
		pr_err("External trigger call failed with %d.\n", ret);

	pr_info("Basics (regs, stack, backtrace) me (%d).\n", current->pid);
	ret = exchnd_call_external_trigger(exchnd_ref,
				current->pid,
				&modules,
				"External trigger from exchnd_test module");

	if (ret)
		pr_err("External trigger call failed with %d.\n", ret);
	else
		pr_info("Last test done.\n");

	msleep(1000);
	return 0;
}


static int __init exchnd_test_init(void)
{
	pr_info("Starting external interface tests !\n");

	worker_thread = kthread_create(exchnd_test_run, NULL,
			"exchnd_test_run");

	if (worker_thread == NULL) {
		pr_err("Could not start worker thread\n");
		return -ENOMEM;
	}

	wake_up_process(worker_thread);

	return 0;
}

static void __exit exchnd_test_exit(void)
{
	pr_info("All done, bye !\n");
}

module_init(exchnd_test_init);
module_exit(exchnd_test_exit);

MODULE_AUTHOR("Frederic Berat <fberat@de.adit-jv.com>");
MODULE_DESCRIPTION("Exception handler external tester");
MODULE_LICENSE("GPL v2");
MODULE_VERSION("1.0");
