 /* Neonode Zforce touch device HW check interfaces.
 *
 * Copyright (c) 2014 Robert Bosch Car Multimedia GmbH
 *
 * This source code is provided as a sample only and has not gone
 * through full internal testing. This sample code is provided "as is",
 * with no  warranties for the functionality of the code, nor
 * any warranties concerning side effects when using the code. The
 * intention of this code is reference example for internal evaluation only.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the term of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __ZFORCE_HWCHECK_H
#define __ZFORCE_HWCHECK_H

/*
 * Zforce HW check interface functions
 * */

void zf_hwcheck_handle_response(char *data, int len);
int zf_hwcheck_init(void *zforce_dev);
void zf_hwcheck_deinit(void);

int zforce_ts_hwcheck_send_led_levels_req(void *zforce_dev, int axis);
int zforce_ts_hwcheck_send_low_signals_req(void *zforce_dev, int axis);
int zforce_ts_hwcheck_send_send_openshort_req(void *zforce_dev, int axis);
int zforce_ts_hwcheck_send_status_req(void *zforce_dev);
int zforce_ts_hwcheck_send_bootmode_req(void *zforce_dev);
int zforce_ts_hwcheck_send_bootloader_req(void *zforce_dev,
		u_int8_t *data, int len);

int zforce_ts_hwcheck_set_reset(void *zforce_dev, int reset);

extern int zforce_bootloader;

#endif
