#ifndef _IMX_DRM_H_
#define _IMX_DRM_H_

#include <drm/imx_drm.h>

#define IMX_CRTC_DRIVER  "imx-ipuv3-crtc"
#define IMX_PLANE_DRIVER "imx-ipuv3-plane"
#define IMX_LDB_DRIVER   "imx-ldb"
#define IMX_HDMI_DRIVER  "imx-hdmi"
#define IMX_PD_DRIVER    "imx-parallel-display"

struct imx_drm_crtc;
struct imx_drm_plane;
struct drm_fbdev_cma;

struct imx_drm_crtc_helper_funcs {
	int (*enable_vblank)(struct drm_crtc *crtc);
	void (*disable_vblank)(struct drm_crtc *crtc);
	int (*set_interface_pix_fmt)(struct drm_crtc *crtc, u32 encoder_type,
				     u32 pix_fmt, u32 *pix_map);
	int (*gamma_set)(struct drm_crtc *crtc, bool enable, u32 *m, u32 *b);
	int (*get_ipu_di)(struct drm_crtc *crtc, int *ipu, int *di);
	const struct drm_crtc_helper_funcs *crtc_helper_funcs;
	const struct drm_crtc_funcs *crtc_funcs;
};

int imx_drm_add_crtc(struct drm_crtc *crtc,
		struct imx_drm_crtc **new_crtc,
		const struct imx_drm_crtc_helper_funcs *imx_helper_funcs,
		struct module *owner, void *cookie, int crtc_id);
int imx_drm_remove_crtc(struct imx_drm_crtc *);
int imx_drm_init_drm(struct platform_device *pdev,
		int preferred_bpp);
int imx_drm_exit_drm(void);

int imx_drm_crtc_get_ipu_di(struct drm_crtc *crtc, int *ipu, int *di);
int imx_drm_crtc_get_id(struct drm_crtc *crtc);
int imx_drm_crtc_vblank_get(struct imx_drm_crtc *imx_drm_crtc);
void imx_drm_crtc_vblank_put(struct imx_drm_crtc *imx_drm_crtc);
void imx_drm_crtc_handle_vblank(struct imx_drm_crtc *imx_drm_crtc);
int imx_drm_plane_vblank_get(struct imx_drm_plane *imx_drm_plane);
void imx_drm_plane_vblank_put(struct imx_drm_plane *imx_drm_plane);
void imx_drm_plane_handle_vblank(struct imx_drm_plane *imx_drm_plane);

struct imx_drm_encoder;
int imx_drm_add_encoder(struct drm_encoder *encoder,
		struct imx_drm_encoder **new_enc,
		struct module *owner);
int imx_drm_remove_encoder(struct imx_drm_encoder *);

struct imx_drm_connector;
int imx_drm_add_connector(struct drm_connector *connector,
		struct imx_drm_connector **new_con,
		struct module *owner);
int imx_drm_remove_connector(struct imx_drm_connector *);
void imx_drm_crtc_dpms(int crtc_id, int mode);
struct imx_drm_plane *imx_drm_crtc_find_active_plane(struct imx_drm_crtc *);

struct imx_drm_plane;

struct imx_drm_plane_helper_funcs {
	int (*get_global_alpha)(struct drm_plane *plane,
				struct drm_imx_global_alpha *ga);
	int (*set_global_alpha)(struct drm_plane *plane,
				struct drm_imx_global_alpha *ga);
	int (*get_chromakey)(struct drm_plane *plane,
			     struct drm_imx_chromakey *ck);
	int (*set_chromakey)(struct drm_plane *plane,
			     struct drm_imx_chromakey *ck);
	int (*enable_vblank)(struct drm_plane *plane);
	void (*disable_vblank)(struct drm_plane *plane);
	void (*get_config)(struct drm_plane *plane,
			   int *crtc_x, int *crtc_y,
			   uint32_t *crtc_w, uint32_t *crtc_h,
			   uint32_t *src_x,  uint32_t *src_y,
			   uint32_t *src_w,  uint32_t *src_h);
	const struct drm_plane_funcs *plane_funcs;
};

int imx_drm_add_plane(struct drm_plane *plane,
		struct imx_drm_plane **new_plane,
		const struct imx_drm_plane_helper_funcs *imx_drm_helper_funcs,
		struct module *owner,
		const uint32_t *formats, uint32_t format_count, int plane_id);
int imx_drm_plane_add_possible_crtcs(struct imx_drm_plane *imx_drm_plane,
				     struct device_node *np);
void imx_drm_plane_get_config(struct imx_drm_plane *imx_drm_plane,
			      int *crtc_x, int *crtc_y,
			      uint32_t *crtc_w, uint32_t *crtc_h,
			      uint32_t *src_x,  uint32_t *src_y,
			      uint32_t *src_w,  uint32_t *src_h);
void imx_drm_plane_disable(struct imx_drm_plane *);
int imx_drm_plane_enable(struct imx_drm_plane *);
int imx_drm_remove_plane(struct imx_drm_plane *);

void imx_drm_mode_config_init(struct drm_device *drm);

struct drm_gem_cma_object *imx_drm_fb_get_obj(struct drm_framebuffer *fb);

struct drm_device *imx_drm_device_get(void);
void imx_drm_device_put(void);
int imx_drm_crtc_panel_format(struct drm_crtc *crtc, u32 encoder_type,
			      u32 interface_pix_fmt, u32 *interface_pix_map);
void imx_drm_fb_helper_set(struct drm_fbdev_cma *fbdev_helper);

struct device_node;

int imx_drm_encoder_add_possible_crtcs(struct imx_drm_encoder *imx_drm_encoder,
				       struct device_node *np);
void imx_drm_fb_output_poll_changed(struct drm_device *dev);

int imx_drm_format_to_v4l(uint32_t drm_format, u32 *v4l_format);

#endif /* _IMX_DRM_H_ */
