/*
 * Copyright (c) 2005-2012, Freescale Semiconductor, Inc. All rights reserved.
 *
 */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Module Name:    mfw_gst_v4lsrc.h
 *
 * Description:    Header file of V4L Source (Capture) Plug-in for 
 *                 GStreamer.
 *
 * Portability:    This code is written for Linux OS and Gstreamer
 */

/*
 * Changelog: 
 *  1-Feb-2013:    Enhanced to support different RGB and YUV color formats,
 *                 configurable through plugin properties.
 *
 *  19-Dec-2013:   Added check for V4L2_BUF_FLAG_ERROR buffer flag and signal
 *                 will be emitted if flag is set to notify Gstreamer framework.
 *
 *  9-Jan-2014:    Enhanced to support different picture enhancement parameters
 *                 configurable through plugin properties.
 *
 *  20-Jan-2014:   Added SIGNAL_V4L2_BUF_FLAG_OK signal to recover from error
 *                 state and to notify Gstreamer framework.
 *
 *  13-May-2014:   Added cropping feature to configure left, top, width and
 *                 height values through VIDIOC_S_CROP ioctl call
 */


/*=============================================================================
                                INCLUDE FILES
=============================================================================*/

#ifndef _MFW_GST_V4LSRC_H_
#define _MFW_GST_V4LSRC_H_

/*=============================================================================
                                CONSTANTS
=============================================================================*/

/*=============================================================================
                                ENUMS
=============================================================================*/

/* Enhanced to support diff RGB and YUV color-formats */
enum
{
  PIX_FMT_RGB565,  /* To capture RGB565 color-format image       */
  PIX_FMT_BGR24,   /* To capture BGR24 color-format image        */
  PIX_FMT_RGB24,   /* To capture RGB24 color-format image        */
  PIX_FMT_BGR32,   /* To capture BGR32 color-format image        */
  PIX_FMT_RGB32,   /* To capture RGB32 color-format image        */
  PIX_FMT_YUV422P, /* To capture YUV422P color-format image      */
  PIX_FMT_UYVY,    /* To capture UYVY color-format image         */
  PIX_FMT_YUYV,    /* To capture YUYV color-format image         */
  PIX_FMT_YUV420,  /* To capture YUV420(YU12) color-format image */ 
  PIX_FMT_NV12     /* To capture NV12 color-format image         */
};

/*=============================================================================
                                MACROS
=============================================================================*/
G_BEGIN_DECLS
/* #defines don't like whitespacey bits */
#define MFW_GST_TYPE_V4LSRC (mfw_gst_v4lsrc_get_type())
#define MFW_GST_V4LSRC(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj),MFW_GST_TYPE_V4LSRC,MFWGstV4LSrc))
#define MFW_GST_V4LSRC_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),MFW_GST_TYPE_V4LSRC,MFWGstV4LSrcClass))
#define MFW_GST_IS_V4LSRC(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),MFW_GST_TYPE_V4LSRC))
#define MFW_GST_IS_V4LSRC_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),MFW_GST_TYPE_V4LSRC))
#define MFW_GST_TYPE_V4LSRC_BUFFER (mfw_gst_v4lsrc_buffer_get_type())
#define MFW_GST_IS_V4LSRC_BUFFER(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MFW_GST_TYPE_V4LSRC_BUFFER))
#define MFW_GST_V4LSRC_BUFFER(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST ((obj), MFW_GST_TYPE_V4LSRC_BUFFER, MFWGstV4LSrcBuffer))
#define MFW_GST_V4LSRC_BUFFER_GET_CLASS(obj)  \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), MFW_GST_TYPE_V4LSRC_BUFFER, MFWGstV4LSrcBufferClass))
/*=============================================================================
                  STRUCTURES AND OTHER TYPEDEFS
=============================================================================*/

typedef struct MFW_GST_V4LSRC_INFO_S
{

  GstPushSrc element;
  gint capture_width;           /* width to be captured */
  gint capture_height;          /* height to be captured */
  gint rotate;
  gboolean hflip;
  gboolean vflip;
  gint crop_left;		/* Enhanced to support cropping feature */
  gint crop_top;		/* Enhanced to support cropping feature */
  gint crop_width;		/* Enhanced to support cropping feature */
  gint crop_height;		/* Enhanced to support cropping feature */
  gint fps_n;
  gint fps_d;
  GstBuffer **buffers;
  void **buf_pools;
  GstElementClass *parent_class;
  guint32 offset;
  guint32 buffer_size;
  guint32 count;
  gboolean preview;
  gint preview_width;
  gint preview_height;
  gint preview_top;
  gint preview_left;
  gint fd_v4l;
  gint sensor_width;
  gint sensor_height;
  GstClockTime time_per_frame;
  GstClockTime last_ts;
  v4l2_std_id std_id;
  gint input;
  gboolean bg;
  char *devicename;
#ifdef ENABLE_DRM
  gchar *disp_type;             /* DRM display type (hdmia, hdmib, lvds, ...) */
#endif
  int g_display_lcd;
  int queue_size;               /* v4l request buffer number */
  GList *free_pool;             /* pool for v4l buffers. */
  GMutex *pool_lock;            /* lock for buffer pool operation */
  gboolean start;
  guint pix_fmt;                /* Enhanced to support diff RGB and YUV color-formats */
  gboolean capture_start_flag;  /* Enhanced to support diff RGB and YUV color-formats */
  void *fb_priv;
  gint brightness;              /* Enhanced to support picture enhancement parameters */
  gint contrast;                /* Enhanced to support picture enhancement parameters */
  gint saturation;              /* Enhanced to support picture enhancement parameters */
  gint hue;                     /* Enhanced to support picture enhancement parameters */
  gboolean brightness_set_flag; /* Enhanced to support picture enhancement parameters */
  gboolean contrast_set_flag;   /* Enhanced to support picture enhancement parameters */
  gboolean saturation_set_flag; /* Enhanced to support picture enhancement parameters */
  gboolean hue_set_flag;        /* Enhanced to support picture enhancement parameters */
  GMutex mutex;                 /* Enhanced to support picture enhancement parameters */
  gboolean v4l2_buf_flag_err;   /* Enhanced to support error handling signal */
  gboolean input_flag;
  gboolean stop;
} MFWGstV4LSrc;

typedef struct MFW_GST_V4LSRC_INFO_CLASS_S
{
  GstPushSrcClass parent_class;
  void (*v4l_buf_flag_error) (GstElement *element, GstPad *pad);
  void (*v4l_buf_flag_ok) (GstElement *element, GstPad *pad);
} MFWGstV4LSrcClass;

struct v4l2_mxc_offset
{
  uint32_t u_offset;
  uint32_t v_offset;
};


typedef struct _MFWGstV4LSrcBuffer MFWGstV4LSrcBuffer;
typedef struct _MFWGstV4LSrcBufferClass MFWGstV4LSrcBufferClass;

struct _MFWGstV4LSrcBuffer
{
  GstBuffer buffer;
  struct v4l2_buffer v4l2_buf;
  MFWGstV4LSrc *v4lsrccontext;
  gint num;
};









/*=============================================================================
                  GLOBAL VARIABLE DECLARATIONS
=============================================================================*/

/* None. */

/*=============================================================================
                  FUNCTION PROTOTYPES
=============================================================================*/

extern GType mfw_gst_v4lsrc_get_type (void);

G_END_DECLS
/*===========================================================================*/
#endif /* _MFW_GST_V4LSRC_H_ */
