/*
 * Copyright (c) 2009-2012, Freescale Semiconductor, Inc.
 *
 */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Module Name:    mfw_gst_drm_plane.h
 *
 * Description:    Declaration of DRM Plane FB operations.
 *
 * Portability:    This code is written for Linux OS and Gstreamer
 */

/*
 * Changelog:
 *
 */

/*=============================================================================
                                INCLUDE FILES
=============================================================================*/

#ifndef _MFW_GST_SRC_DRM_PLANE_H_
#define _MFW_GST_SRC_DRM_PLANE_H_

#include <gst/gst.h>
#include "mfw_gst_v4lsrc.h"

gboolean drm_plane_init(MFWGstV4LSrc *v4l);
void drm_plane_release(MFWGstV4LSrc *v4l);
gboolean drm_plane_open(MFWGstV4LSrc *v4l);
gboolean drm_plane_close(MFWGstV4LSrc *v4l);
gboolean drm_plane_setup(MFWGstV4LSrc *v4l,
				struct v4l2_crop *crop);

#endif	/* _MFW_GST_SRC_DRM_PLANE_H_ */
