/*
 * Copyright (C) 2013 Mentor Graphics Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Module Name:    mfw_gst_drm_plane.c
 *
 * Description:    Implementation of DRM Plane FB operations
 *
 * Portability:    This code is written for Linux OS and Gstreamer
 */

#include "mfw_gst_v4lsink.h"
#include "mfw_gst_drm_plane.h"

static gboolean drm_plane_init(MFW_GST_V4LSINK_INFO_T *v4l)
{
	v4l->fb_priv = mfw_gst_drm_plane_init();
	if (!v4l->fb_priv)
		return FALSE;

	return TRUE;
}

static void drm_plane_release(MFW_GST_V4LSINK_INFO_T *v4l)
{
	mfw_gst_drm_plane_release(v4l->fb_priv);
}

static gboolean drm_plane_open(MFW_GST_V4LSINK_INFO_T *v4l)
{
	return mfw_gst_drm_plane_open(v4l->fb_priv,
				      v4l->disp_type,
				      v4l->disp_width + v4l->axis_left,
				      v4l->disp_height + v4l->axis_top);
}

static gboolean drm_plane_close(MFW_GST_V4LSINK_INFO_T *v4l)
{
	return mfw_gst_drm_plane_close(v4l->fb_priv);
}

static gboolean drm_plane_set_global_alpha(MFW_GST_V4LSINK_INFO_T *v4l,
					   gint alphaVal,
					   gboolean enable)
{
	return mfw_gst_drm_plane_set_global_alpha(v4l->fb_priv,
						  alphaVal, enable);
}

static gboolean drm_plane_set_colorkey(MFW_GST_V4LSINK_INFO_T *v4l,
				       gulong *colorSrc,
				       gboolean enable)
{
	return mfw_gst_drm_plane_set_colorkey(v4l->fb_priv,
					      colorSrc, enable);
}


static gboolean drm_plane_get_bounds(MFW_GST_V4LSINK_INFO_T *v4l)
{
	return mfw_gst_drm_plane_get_bounds(v4l->fb_priv,
			&v4l->fullscreen_width,
			&v4l->fullscreen_height);
}

static gboolean drm_plane_setup(MFW_GST_V4LSINK_INFO_T *v4l,
				struct v4l2_crop *crop)
{
	return mfw_gst_drm_plane_setup(v4l->fb_priv,
			TRUE,
			v4l->v4l_id,
			crop);
}

struct mfw_gst_v4lsink_fb_ops mfw_gst_drm_plane_ops = {
	.init                 = drm_plane_init,
	.release              = drm_plane_release,
	.open                 = drm_plane_open,
	.close                = drm_plane_close,
	.set_global_alpha     = drm_plane_set_global_alpha,
	.set_colorkey         = drm_plane_set_colorkey,
	.get_bounds           = drm_plane_get_bounds,
	.setup                = drm_plane_setup,
};
