/*
 * Copyright (C) 2012 Robert Bosch Car Multimedia GmbH
 *
 * Configuration settings for the Bosch i.MX6Q VRNS B1 board.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.         See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __CONFIG_H
#define __CONFIG_H

#define CONFIG_MX6
#define CONFIG_BOARD_JACC2_B2
#define CONFIG_DISPLAY_CPUINFO
#define CONFIG_DISPLAY_BOARDINFO

#include <asm/arch/imx-regs.h>

#define CONFIG_CMDLINE_TAG
#define CONFIG_SETUP_MEMORY_TAGS
#define CONFIG_INITRD_TAG

/* Size of malloc() pool */
#define CONFIG_SYS_MALLOC_LEN		(CONFIG_ENV_SIZE + 2 * 1024 * 1024)

#define CONFIG_ARCH_CPU_INIT
#define CONFIG_BOARD_EARLY_INIT_F
#define CONFIG_MXC_GPIO

#define CONFIG_MXC_UART
#define CONFIG_MXC_UART_BASE		UART4_BASE

/* OCOTP Configs */
#define CONFIG_CMD_IMXOTP
#ifdef CONFIG_CMD_IMXOTP
#define CONFIG_IMX_OTP
#define IMX_OTP_ADDR_MAX		0x7F
#define IMX_OTP_DATA_ERROR_VAL		0xBADABADA
#endif

/* MMC Configs */
#define CONFIG_FSL_ESDHC
#define CONFIG_FSL_USDHC
#define CONFIG_SYS_FSL_ESDHC_ADDR	0
#define CONFIG_SYS_FSL_USDHC_NUM	2

#define CONFIG_MMC
#define CONFIG_CMD_MMC
#define CONFIG_GENERIC_MMC
#define CONFIG_BOUNCE_BUFFER

/* allow to overwrite serial and ethaddr */
#define CONFIG_ENV_OVERWRITE
#define CONFIG_CONS_INDEX		1
#define CONFIG_BAUDRATE			115200
#define CONFIG_SYS_BAUDRATE_TABLE	{9600, 19200, 38400, 57600, 115200}

/* Command definition */
#include <config_cmd_default.h>

#undef CONFIG_CMD_NET
#undef CONFIG_CMD_NFS

/* SPI NOR flash */
#define CONFIG_CMD_SF
#undef CONFIG_CMD_FLASH

/*
 * SPI Configs
 */
#ifdef CONFIG_CMD_SF
#include <asm/imx-common/gpio.h>
#define CONFIG_SPI_FLASH
#define CONFIG_SPI_FLASH_STMICRO
#define CONFIG_SPI_FLASH_WINBOND
#define CONFIG_SPI_FLASH_SPANSION
#define CONFIG_MXC_SPI
#define CONFIG_SF_DEFAULT_BUS	3	/* ECSPI4 */
#define CONFIG_SF_DEFAULT_CS	(0|(IMX_GPIO_NR(3, 20)<<8))
#define CONFIG_SF_DEFAULT_SPEED	15000000
#define CONFIG_SF_DEFAULT_MODE	(SPI_MODE_0)
#endif

#undef CONFIG_CMD_IMLS

#define CONFIG_BOOTDELAY		1

#define CONFIG_TIMER_MX6_HCLK
#define CONFIG_PRINT_STARTTIME
/* #define CONF_SHOW_TIMESTAMPS */
/* #define CONFIG_TIMESTAMP */
/* #define CONFIG_CMD_TIME */

#define CONFIG_LOADADDR			0x10800000
#define CONFIG_SYS_TEXT_BASE		0x17800000

/*
 * The boot ROM code copies U-Boot already into the RAM at
 * address CONFIG_SYS_TEXT_BASE.  To improve the boot time,
 * skip the relocation (i.e. the copy RAM -> RAM).
 *
 * ATTENTION: Please read
 *
 * http://lists.denx.de/pipermail/u-boot/2012-February/117140.html
 *
 * why you normally don't want this!
 */
#define CONFIG_SYS_SKIP_ARM_RELOCATION

#define	CONFIG_EXTRA_ENV_SETTINGS					\
	"kerneladdr=0x12000000\0"					\
	"kernelsize=0x1f00\0"						\
	"dtbaddr=0x11ff0000\0"						\
	"dtbsize=0x40\0"						\
	"console=ttymxc3\0"						\
	"baudrate=115200n8\0"						\
	"fdt_high=0xffffffff\0"						\
	"xtargs=ip=off\0"						\
	"mmcroot=/dev/mmcblk1p1 rootwait rw\0"				\
	"loadkernel=mmc read ${kerneladdr} 0x100 ${kernelsize}\0"	\
	"loaddtb=mmc read ${dtbaddr} 0x0 ${dtbsize}\0"		\
	"mmcargs=setenv bootargs console=${console},${baudrate} "	\
		"root=${mmcroot} nosmp printk.time=1 "	\
		"${xtargs} consoleblank=0 lpj=7905280\0"		\
	"mmcboot=echo Booting from mmc ...; "				\
		"mmc dev 1 1; "						\
		"run mmcargs; "						\
		"run loadkernel; "					\
		"run loaddtb; "						\
		"bootm ${kerneladdr} - ${dtbaddr}\0"			\

#define CONFIG_BOOTCOMMAND						\
	"run mmcboot"

/* Miscellaneous configurable options */
#define CONFIG_SYS_LONGHELP
#define CONFIG_SYS_HUSH_PARSER
#define CONFIG_SYS_PROMPT_HUSH_PS2	"> "
#define CONFIG_SYS_PROMPT		"MX6S JAC C2 B2 U-Boot > "
#define CONFIG_AUTO_COMPLETE
#define CONFIG_SYS_CBSIZE		256

/* Print Buffer Size */
#define CONFIG_SYS_PBSIZE		(CONFIG_SYS_CBSIZE + \
					 sizeof(CONFIG_SYS_PROMPT) + 16)
#define CONFIG_SYS_MAXARGS		16
#define CONFIG_SYS_BARGSIZE		CONFIG_SYS_CBSIZE

#define CONFIG_SYS_MEMTEST_START	0x10000000
#define CONFIG_SYS_MEMTEST_END		0x10010000

#define CONFIG_SYS_LOAD_ADDR		CONFIG_LOADADDR
#define CONFIG_SYS_HZ			1000

#define CONFIG_CMDLINE_EDITING
#define CONFIG_STACKSIZE		(128 * 1024)

#define CONFIG_USE_ARCH_MEMSET
#define CONFIG_USE_ARCH_MEMCPY
#define CONFIG_USE_ARCH_MEMMOVE

/* Physical Memory Map */
#define CONFIG_NR_DRAM_BANKS		1
#define PHYS_SDRAM			MMDC0_ARB_BASE_ADDR
#define PHYS_SDRAM_SIZE			(1024 * 1024 * 1024)

#define CONFIG_SYS_SDRAM_BASE		PHYS_SDRAM
#define CONFIG_SYS_INIT_RAM_ADDR	IRAM_BASE_ADDR
#define CONFIG_SYS_INIT_RAM_SIZE	IRAM_SIZE

#define CONFIG_SYS_INIT_SP_OFFSET	\
	(CONFIG_SYS_INIT_RAM_SIZE - GENERATED_GBL_DATA_SIZE)
#define CONFIG_SYS_INIT_SP_ADDR		\
	(CONFIG_SYS_INIT_RAM_ADDR + CONFIG_SYS_INIT_SP_OFFSET)

/* FLASH and environment organization
 *
 * U-Boot (SD) flash map:
 *	000 - 384k		U-Boot
 *	384 - 512k		SD/SF/NOR U-Boot environment
 */
#define CONFIG_SYS_MONITOR_LEN		(3 * 128 * 1024)
#define CONFIG_SYS_NO_FLASH /* no parallel NOR */

/* Environment settings */
#undef CONFIG_ENV_IS_IN_MMC
#define CONFIG_ENV_IS_IN_SPI_FLASH

#define CONFIG_ENV_OFFSET		CONFIG_SYS_MONITOR_LEN
#define CONFIG_ENV_SECT_SIZE	(128 * 1024)
#define CONFIG_ENV_SIZE			CONFIG_ENV_SECT_SIZE

#ifdef CONFIG_ENV_IS_IN_MMC
#define CONFIG_SYS_MMC_ENV_DEV		0
#endif

#ifdef CONFIG_ENV_IS_IN_SPI_FLASH
#define CONFIG_ENV_SPI_BUS		CONFIG_SF_DEFAULT_BUS
#define CONFIG_ENV_SPI_CS		CONFIG_SF_DEFAULT_CS
#define CONFIG_ENV_SPI_MODE		CONFIG_SF_DEFAULT_MODE
#define CONFIG_ENV_SPI_MAX_HZ	CONFIG_SF_DEFAULT_SPEED
#endif

#define CONFIG_OF_LIBFDT

#ifndef CONFIG_SYS_DCACHE_OFF
#define CONFIG_CMD_CACHE
#endif

#endif	/* __CONFIG_H */
