/*
 * Copyright (C) 2012 Robert Bosch Car Multimedia GmbH
 *
 * Configuration settings for the Bosch i.MX6Q VRNS B2 board.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.         See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __MX6QVRNSB2CONFIG_H
#define __MX6QVRNSB2CONFIG_H

#define CONFIG_BOARD_VRNS_B2_MX6Q

/*
 * This header is only needed to select the DRAM configuration and default
 * environment for iMX6 Dual/Quad version of VRNS B2 board (see boards.cfg)
 * All other iMX6 Quad/Solo differences are considered at run time.
 */

#define CONFIG_SYS_SMP ""
#define PHYS_SDRAM_SIZE (512 * 1024 * 1024)
#define CONFIG_DTB_SRC "dtbsrc=0x080B0000\0"

#include "mx6vrnsb2.h"

#endif
