/*
 * Copyright (C) 2012 Robert Bosch Car Multimedia GmbH
 *
 * Configuration settings for the Bosch i.MX6Q VRNS board.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.         See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __CONFIG_H
#define __CONFIG_H

#define CONFIG_MX6
#define CONFIG_DISPLAY_CPUINFO
#define CONFIG_DISPLAY_BOARDINFO

#include <asm/arch/imx-regs.h>

#define CONFIG_CMDLINE_TAG
#define CONFIG_SETUP_MEMORY_TAGS
#define CONFIG_INITRD_TAG

/* Size of malloc() pool */
#define CONFIG_SYS_MALLOC_LEN		(CONFIG_ENV_SIZE + 2 * 1024 * 1024)

#define CONFIG_ARCH_CPU_INIT
#define CONFIG_BOARD_EARLY_INIT_F
#define CONFIG_MXC_GPIO

#define CONFIG_MXC_UART
#define CONFIG_MXC_UART_BASE		UART4_BASE

/* MMC Configs */
#define CONFIG_FSL_ESDHC
#define CONFIG_FSL_USDHC
#define CONFIG_SYS_FSL_ESDHC_ADDR	0
#define CONFIG_SYS_FSL_USDHC_NUM	2

#define CONFIG_MMC
#define CONFIG_CMD_MMC
#define CONFIG_GENERIC_MMC
#define CONFIG_CMD_PING
#define CONFIG_CMD_DHCP
#define CONFIG_CMD_NET

/* USB Configs */
#define CONFIG_CMD_USB
#define CONFIG_USB_EHCI
#define CONFIG_USB_EHCI_MX6
#define CONFIG_USB_HOST_ETHER
#define CONFIG_USB_ETHER_ASIX
#define CONFIG_MXC_USB_PORT	1
#define CONFIG_MXC_USB_PORTSC	(PORT_PTS_UTMI | PORT_PTS_PTW)
#define CONFIG_MXC_USB_FLAGS	0

/* allow to overwrite serial and ethaddr */
#define CONFIG_ENV_OVERWRITE
#define CONFIG_CONS_INDEX		1
#define CONFIG_BAUDRATE			115200
#define CONFIG_SYS_BAUDRATE_TABLE	{9600, 19200, 38400, 57600, 115200}

/* Command definition */
#include <config_cmd_default.h>

/* select type of flash device */
#define CONFIG_CMD_FLASH			/* for parallel flash */
#undef CONFIG_CMD_SF			/* for serial flash */

/*
 * SPI Configs
 */
#ifdef CONFIG_CMD_SF
	#define CONFIG_FSL_SF		1
	#define CONFIG_SPI_FLASH	1
	#define CONFIG_SPI_FLASH_STMICRO	1
	#define CONFIG_SPI_FLASH_CS	1
	#define CONFIG_IMX_ECSPI
	#define IMX_CSPI_VER_2_3	1

	#define MAX_SPI_BYTES		(64 * 4)
	#define	CONFIG_SF_DEFAULT_SPEED 30000000 /* 30 MHz */
#endif

#undef CONFIG_CMD_IMLS

#define CONFIG_BOOTDELAY		1

#define CONFIG_TIMER_MX6_HCLK
#define CONFIG_PRINT_STARTTIME
/* #define CONF_SHOW_TIMESTAMPS */
/* #define CONFIG_TIMESTAMP */
/* #define CONFIG_CMD_TIME */

#define CONFIG_LOADADDR			0x10800000
#define CONFIG_SYS_TEXT_BASE		0x17800000

/*
 * The boot ROM code copies U-Boot already into the RAM at
 * address CONFIG_SYS_TEXT_BASE.  To improve the boot time,
 * skip the relocation (i.e. the copy RAM -> RAM).
 *
 * ATTENTION: Please read
 *
 * http://lists.denx.de/pipermail/u-boot/2012-February/117140.html
 *
 * why you normally don't want this!
 */
#define CONFIG_SYS_SKIP_ARM_RELOCATION

#define	CONFIG_EXTRA_ENV_SETTINGS					\
	"kerneladdr=0x12000000\0"				       	\
	"kernelsize=0x2800\0"				       		\
	"dtbaddr=0x11ff0000\0"					       	\
	"dtbsize=0x40\0"				       		\
	"console=ttymxc3\0"						\
	"baudrate=115200n8\0"						\
	"fdt_high=0xffffffff\0"						\
	"cpucount=maxcpus=2\0"	       					\
	"xtargs=ip=off\0"						\
	"mmcdev=0\0"							\
	"mmcroot=/dev/mmcblk0p2 rootwait rw\0"				\
	"loadkernel=mmc read ${kerneladdr} 0x800 ${kernelsize}\0"      	\
	"loaddtb=mmc read ${dtbaddr} 0x440 ${dtbsize}\0"	       	\
	"mmcargs=setenv bootargs console=${console},${baudrate} "	\
		"root=${mmcroot} ${cpucount} printk.time=1 "	\
		"${xtargs} consoleblank=0 lpj=7905280 "		\
		"oops=panic panic=1\0"		\
	"mmcboot=echo Booting from mmc ...; "				\
		"run mmcargs; "						\
		"run loadkernel; "					\
		"run loaddtb; "						\
		"bootm ${kerneladdr} - ${dtbaddr}\0"			\


#define CONFIG_BOOTCOMMAND						\
	"mmc dev ${mmcdev};"						\
	"if mmc rescan; then "						\
		"run mmcboot; "						\
	"fi"

/* Miscellaneous configurable options */
#define CONFIG_SYS_LONGHELP
#define CONFIG_SYS_HUSH_PARSER
#define CONFIG_SYS_PROMPT_HUSH_PS2	"> "
#define CONFIG_SYS_PROMPT		"MX6QVRNS U-Boot > "
#define CONFIG_AUTO_COMPLETE
#define CONFIG_SYS_CBSIZE		256

/* Print Buffer Size */
#define CONFIG_SYS_PBSIZE		(CONFIG_SYS_CBSIZE + sizeof(CONFIG_SYS_PROMPT) + 16)
#define CONFIG_SYS_MAXARGS		16
#define CONFIG_SYS_BARGSIZE		CONFIG_SYS_CBSIZE

#define CONFIG_SYS_MEMTEST_START	0x10000000
#define CONFIG_SYS_MEMTEST_END		0x10010000

#define CONFIG_SYS_LOAD_ADDR		CONFIG_LOADADDR
#define CONFIG_SYS_HZ			1000

#define CONFIG_CMDLINE_EDITING
#define CONFIG_STACKSIZE		(128 * 1024)

/* Physical Memory Map */
#define CONFIG_NR_DRAM_BANKS		1
#define PHYS_SDRAM			MMDC0_ARB_BASE_ADDR
#define PHYS_SDRAM_SIZE			(512 * 1024 * 1024)

#define CONFIG_SYS_SDRAM_BASE		PHYS_SDRAM
#define CONFIG_SYS_INIT_RAM_ADDR	IRAM_BASE_ADDR
#define CONFIG_SYS_INIT_RAM_SIZE	IRAM_SIZE

#define CONFIG_SYS_INIT_SP_OFFSET	\
	(CONFIG_SYS_INIT_RAM_SIZE - GENERATED_GBL_DATA_SIZE)
#define CONFIG_SYS_INIT_SP_ADDR		\
	(CONFIG_SYS_INIT_RAM_ADDR + CONFIG_SYS_INIT_SP_OFFSET)

/* FLASH and environment organization */
#ifdef CONFIG_CMD_FLASH
#define CONFIG_SYS_FLASH_CFI			/* Flash memory is CFI compliant */
#define CONFIG_FLASH_CFI_DRIVER			/* Use drivers/cfi_flash.c */
#define CONFIG_SYS_FLASH_BASE		WEIM_ARB_BASE_ADDR	/* Base address mapping */
#define CONFIG_SYS_FLASH_CFI_WIDTH	FLASH_CFI_16BIT
#define CONFIG_SYS_MAX_FLASH_BANKS	1	/* from Datasheet/Schematics */
#define CONFIG_SYS_MAX_FLASH_SECT	512	/* from Datasheet */
#define CONFIG_SYS_MONITOR_BASE		CONFIG_SYS_FLASH_BASE
#define CONFIG_SYS_MONITOR_LEN		(384 * 1024)


/* MTD Command for mtdparts */
#define CONFIG_CMD_MTDPARTS
#define CONFIG_MTD_DEVICE
#define CONFIG_FLASH_CFI_MTD
#define CONFIG_MTD_PARTITIONS
#else /* CONFIG_CMD_FLASH */
#define CONFIG_SYS_NO_FLASH
#endif /* CONFIG_CMD_FLASH */

/* Environment setting */
#ifdef CONFIG_CMD_FLASH
#define CONFIG_ENV_IS_IN_FLASH
#define CONFIG_ENV_SECT_SIZE		(128 * 1024)
#define CONFIG_ENV_ADDR			(CONFIG_SYS_FLASH_BASE + \
					 3 * CONFIG_ENV_SECT_SIZE)
#define CONFIG_ENV_SIZE			CONFIG_ENV_SECT_SIZE
#else /* CONFIG_CMD_FLASH */
#define CONFIG_ENV_OFFSET		(6 * 64 * 1024)
#define CONFIG_ENV_SIZE			(8 * 1024)
#define CONFIG_ENV_IS_IN_MMC
#define CONFIG_SYS_MMC_ENV_DEV		0
#endif /* CONFIG_CMD_FLASH */

#define CONFIG_OF_LIBFDT

#define CONFIG_SYS_DCACHE_OFF

#endif                         /* __CONFIG_H */
