/*
 * (C) Copyright 2013
 * Carsten Resch Bosch CarMultimedia GmbH, Carsten.Resch@de.bosch.com
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef DEFINES_H
#define DEFINES_H

#ifndef TYPES_H
#define TYPES_H

typedef signed char S8;
typedef short S16;
typedef int S32;
typedef unsigned char U8;
typedef unsigned short U16;
typedef unsigned int U32;
typedef unsigned long long U64;
typedef signed long long S64;
typedef float F32;
typedef double F64;
typedef void *VP;
typedef void tVoid;

typedef unsigned long long QWORD;
typedef unsigned long DWORD;
typedef unsigned short WORD;
typedef unsigned char BYTE;
typedef unsigned long BOOL;
typedef S32 INT;

/* DMA Support Defines */

#define RC_OK   0
#define RC_NG (-1)

#define LOCAL       static
#define EXPORT
#define IMPORT      extern

#define TRUE        1		/* True */
#define FALSE       0		/* False */

typedef struct ehw_module {
	U8 name[5];
	U32 base;
	U32 freq;
} hw_module;

typedef struct etest_module {
	U8 *module;
	S32 result;
} test_module;
#endif

#define DEFAULT_EXT_MEMTEST_START	(CONFIG_SYS_SDRAM_BASE)
#define DEFAULT_EXT_MEMTEST_END		(CONFIG_SYS_TEXT_BASE)

#define BOOT_SDCARD		  ( 1 )

#define MAX_SAVED_ERRORS          ((U32)20)
#define MEM_256MB                 ((U32)0x10000000)	/* Size = 256 MByte  */
#define MEM_512MB                 ((U32)0x20000000)	/* Size = 512 MByte  */
#define MEM_1GB                   ((U32)0x40000000)	/* Size = 1024 MByte */

#define NO_DQ_LINES               ((U32)18)	/* 16 DQ + 2DQS */
#define NO_SWEEP_STEPS            ((U32)21)

#define PATTERN_START             ((U32)0x09000000)

#define BUFFER_SIZE_256B          ((U32)0x0000100)
#define BUFFER_SIZE_512B          ((U32)0x0000200)

#define BUFFER_SIZE_1KB           ((U32)0x0000400)
#define BUFFER_SIZE_2KB           ((U32)0x0000800)
#define BUFFER_SIZE_8KB           ((U32)0x0002000)
#define BUFFER_SIZE_10KB          ((U32)0x0002800)
#define BUFFER_SIZE_16KB          ((U32)0x0004000)
#define BUFFER_SIZE_24KB          ((U32)0x0006000)
#define BUFFER_SIZE_32KB          ((U32)0x0008000)

#define BUFFER_SIZE_100KB         ((U32)0x0020000)
#define BUFFER_SIZE_500KB         ((U32)0x0080000)
#define BUFFER_SIZE_1MB           ((U32)0x0100000)
#define BUFFER_SIZE_4MB           ((U32)0x0400000)	/* Size =   4 MByte  */

#define SIZE_16MB_BLOCK           ((U32)0x1000000)	/* 16 MB */

#define NO_DQS                    (4)

#define SWEEP_STEP_WIDTH           4
#define SWEEP_RANGE                0x80
#define SWEEP_SKIP           0
#define VREF_SWEEP

typedef struct {
	volatile U32 *addr_ddr3;
	volatile U32 *addr_comp;
	volatile U32 data_ddr3;
	volatile U32 data_comp;
} Error_Compare_Data;

typedef struct ranctx {
	U32 a;
	U32 b;
	U32 c;
	U32 d;
} ranctx;

typedef enum {
	M_DQ0 = 0,
	M_DQ1,
	M_DQ2,
	M_DQ3,
	M_DQ4,
	M_DQ5,
	M_DQ6,
	M_DQ7,
	M_DQS,
	M_DQ8,
	M_DQ9,
	M_DQ10,
	M_DQ11,
	M_DQ12,
	M_DQ13,
	M_DQ14,
	M_DQ15,
	M_DQS1
} DQ;

typedef enum {
	RES_OK = 0,
	RES_NOT_OK
} RES;

typedef enum {
	GATING_PLUS = 1,
	GATING_MINUS
} GATING_SHIFT;

typedef enum {
	USE_BANK_0 = 0,
	USE_BANK_1
} BANK_ID;

typedef enum {
	DEFAULT_DELAYS = 1,
	CAL_DELAYS
} DELAYS;

typedef enum {
	FORWARD = 1,
	BACKWARD
} DIR_FLAG;

typedef enum {
	NO_OPERATION = 1,
	INVERSION
} OPERATION_FLAG;

typedef enum {
	NO_ERROR_BUF = 1,
	ERROR_BUF
} BUFFER_FLAG;

typedef enum {
	LOW_BYTE = 0,
	HIGH_BYTE = 1
} BYTE_NUMBER;

typedef enum {
	FT_FINISH = 0,
	FT_SWEEP_LOW_RES = 1,
	FT_SWEEP_HIGH_RES = 2,
	FT_EDIT_FT_REG = 3
} FINE_TUNE_STATES;


typedef enum {
	PATTERN_ADDR = 0,
	PATTERN_INVERSE_ADDR = 1,
	PATTERN_ADDR_XOR_CHESS = 2,
	PATTERN_CHESS_FIELD = 3
} ADDRESS_PATTERN_TEST;


#endif
