/*
 * (C) Copyright 2015
 * Carsten Resch Bosch CarMultimedia GmbH, Carsten.Resch@de.bosch.com
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __ASIL_MEM_TEST_H_
#define __ASIL_MEM_TEST_H_

#include <common.h>
#include <asm/arch/imx-regs.h>

#define DEFAULT_ASIL_MEMTEST_START	(MMDC0_ARB_BASE_ADDR)

#define ASIL_TEST_SRAM_BASE             IRAM_BASE_ADDR
/* Partitioning of the SRAM Area for the test */
/* test function              : 0x00901000 - 0x00901800 :  2 KB */
#define ASIL_TEST_FUNC_START            (IRAM_BASE_ADDR + 0x1000)

/* Array for testpattern1     : 0x00902000 - 0x0090201F : 32  B */
#define ASIL_TEST_PATTER1_OFFSET     0x2000
#define ASIL_TEST_PATTER1            (IRAM_BASE_ADDR + \
				      ASIL_TEST_PATTER1_OFFSET)

/* Array for testpattern2     : 0x00902100 - 0x0090211F : 32  B */
#define ASIL_TEST_PATTER2_OFFSET     0x2100
#define ASIL_TEST_PATTER2            (IRAM_BASE_ADDR + \
				      ASIL_TEST_PATTER2_OFFSET)

/* Stackpointer during test   : 0x00902FF0              : 4 KB - 32 B */
#define ASIL_TEST_SP_OFFSET     0x2FF0
#define ASIL_TEST_SP            (IRAM_BASE_ADDR + \
				 ASIL_TEST_SP_OFFSET)

/* backup area for test       : 0x00903000 - 0x00908000 : 20 KB */
#define ASIL_TEST_BACKUP_RAM_OFFSET     0x3000
#define ASIL_TEST_BACKUP_RAM            (IRAM_BASE_ADDR + \
					 ASIL_TEST_BACKUP_RAM_OFFSET)

/* result array               : 0x00910000 - 0x0091FFFF : 64 KB */
#define ERROR_ARRAY_ADDR_OFFSET         (0x10000)
#define ERROR_ARRAY_ADDR                (IRAM_BASE_ADDR + \
					 ERROR_ARRAY_ADDR_OFFSET)
#define ASIL_TEST_MAX_NUM_ERRORS        (10)

/* 3 values are stored per error */
#define ASIL_TEST_ERR_ARR_SIZE          (3 * ASIL_TEST_MAX_NUM_ERRORS * \
					 sizeof(int))

#define ASIL_TEST_PATTERN1              0xAAAAAAAA
#define ASIL_TEST_PATTERN2              0x55555555

#ifndef __ASSEMBLER__

extern int __bss_end__;
extern int do_test_mem_area(int start, int end, int do_backup);
int (*test_func)(int start, int end, int do_backup);

#endif

#endif
