/*
 * Copyright (C) 2012 Robert Bosch Car Multimedia GmbH
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <asm/arch/system.h>
#include <config.h>

#ifdef CONFIG_BOARD_FSL_SABRELITE
static const dcd_config dcd_sabrelite[] = {
	/* {<u32 address>, <u32 value>}, */
	{0x020E02AC, 0x00000001}, /* from U-Boot */
	{0x020E0920, 0x00000003},
	{0x020E0694, 0x0001B0B1},
	{0x020E02A8, 0x00000001},
	{0x020E0690, 0x0001B0B1},
	{0x020E00BC, 0x00000004},
	{0x020E03D0, 0x0001B0B1},
	{0x020E00C0, 0x00000004},
	{0x020E0928, 0x00000001},
	{0x020E03D4, 0x0001B0B1},
	{0x020E009C, 0x00000005},
	{0x020E03B0, 0x000100B1},
	{0x020E0094, 0x00000001},
	{0x020E07F8, 0x00000000},
	{0x020E03A8, 0x000100B1},
	{0x020E0098, 0x00000001},
	{0x020E07FC, 0x00000000},
	{0x020E03AC, 0x000100B1},
	{0x020E0090, 0x00000001},
	{0x020E07F4, 0x00000000},
	{0x020E03A4, 0x000100B1},
	{0x020E02BC, 0x00000000},
	{0x020E06A4, 0x00017059},
	{0x020E02B8, 0x00000010},
	{0x020E06A0, 0x00017059},
	{0x020E02C0, 0x00000000},
	{0x020E06A8, 0x00017059},
	{0x020E02C4, 0x00000000},
	{0x020E06AC, 0x00017059},
	{0x020E02C8, 0x00000000},
	{0x020E06B0, 0x00017059},
	{0x020E02CC, 0x00000000},
	{0x020E06B4, 0x00017059},
	{0x020E02B0, 0x00000005},
	{0x020E02F8, 0x00000000},
	{0x020E06E0, 0x00017059},
	{0x020E02F4, 0x00000010},
	{0x020E06DC, 0x00017059},
	{0x020E031C, 0x00000001},
	{0x020E0704, 0x00017059},
	{0x020E0320, 0x00000001},
	{0x020E0708, 0x00017059},
	{0x020E0324, 0x00000001},
	{0x020E070C, 0x00017059},
	{0x020E0328, 0x00000001},
	{0x020E0710, 0x00017059},
	{0x020E0314, 0x00000005},
	{0x020E01D0, 0x00000001},	/* eth */
	{0x020E0840, 0x00000000},
	{0x020E04E4, 0x0001B0B0},
	{0x020E01F4, 0x00000001},
	{0x020E0508, 0x0001B0B0},
	{0x020E0058, 0x00000001},
	{0x020E036C, 0x0001B0B0},
	{0x020E005C, 0x00000001},
	{0x020E0370, 0x0001B0B0},
	{0x020E0060, 0x00000001},
	{0x020E0374, 0x0001B0B0},
	{0x020E0064, 0x00000001},
	{0x020E0378, 0x0001B0B0},
	{0x020E0068, 0x00000001},
	{0x020E037C, 0x0001B0B0},
	{0x020E0074, 0x00000001},
	{0x020E0388, 0x0001B0B0},
	{0x020E01D4, 0x00000001},
	{0x020E04E8, 0x0001B0B0},
	{0x020E0084, 0x00000005},
	{0x020E0070, 0x00000005},
	{0x020E0078, 0x00000005},
	{0x020E007C, 0x00000005},
	{0x020E0080, 0x00000005},
	{0x020E006C, 0x00000005},
	{0x020E00AC, 0x00000005},
	{0x020E0084, 0x00000001},
	{0x020E0844, 0x00000000},
	{0x020E0398, 0x0001B0B0},
	{0x020E0070, 0x00000001},
	{0x020E0848, 0x00000000},
	{0x020E0384, 0x0001B0B0},
	{0x020E0078, 0x00000001},
	{0x020E084C, 0x00000000},
	{0x020E038C, 0x0001B0B0},
	{0x020E007C, 0x00000001},
	{0x020E0850, 0x00000000},
	{0x020E0390, 0x0001B0B0},
	{0x020E0080, 0x00000001},
	{0x020E0854, 0x00000000},
	{0x020E0394, 0x0001B0B0},
	{0x020E006C, 0x00000001},
	{0x020E0858, 0x00000000},
	{0x020E0380, 0x0001B0B0},
	{0x020E0054, 0x00000003},	/* from kernel */
	{0x020E07B4, 0x00000000},
	{0x020E035C, 0x00000003},
	{0x020E07C4, 0x00000001},
	{0x020E0050, 0x00000003},
	{0x020E07B8, 0x00000000},
	{0x020E004C, 0x00000003},
	{0x020E07C8, 0x00000000},
	{0x020E015C, 0x00000000},
	{0x020E0470, 0x00000010},
	{0x020E0160, 0x00000000},
	{0x020E0474, 0x00000010},
	{0x020E0164, 0x00000000},
	{0x020E0478, 0x00000010},
	{0x020E0168, 0x00000000},
	{0x020E047C, 0x00000010},
	{0x020E0170, 0x00000000},
	{0x020E0484, 0x00000010},
	{0x020E0174, 0x00000000},
	{0x020E0488, 0x00000010},
	{0x020E0178, 0x00000000},
	{0x020E048C, 0x00000010},
	{0x020E017C, 0x00000000},
	{0x020E0490, 0x00000010},
	{0x020E0180, 0x00000000},
	{0x020E0494, 0x00000010},
	{0x020E0184, 0x00000000},
	{0x020E0498, 0x00000010},
	{0x020E0188, 0x00000000},
	{0x020E049C, 0x00000010},
	{0x020E018C, 0x00000000},
	{0x020E04A0, 0x00000010},
	{0x020E0190, 0x00000000},
	{0x020E04A4, 0x00000010},
	{0x020E0194, 0x00000000},
	{0x020E04A8, 0x00000010},
	{0x020E0198, 0x00000000},
	{0x020E04AC, 0x00000010},
	{0x020E019C, 0x00000000},
	{0x020E04B0, 0x00000010},
	{0x020E01A0, 0x00000000},
	{0x020E04B4, 0x00000010},
	{0x020E01A4, 0x00000000},
	{0x020E04B8, 0x00000010},
	{0x020E01A8, 0x00000000},
	{0x020E04BC, 0x00000010},
	{0x020E01AC, 0x00000000},
	{0x020E04C0, 0x00000010},
	{0x020E01B0, 0x00000000},
	{0x020E04C4, 0x00000010},
	{0x020E01B4, 0x00000000},
	{0x020E04C8, 0x00000010},
	{0x020E01B8, 0x00000000},
	{0x020E04CC, 0x00000010},
	{0x020E01BC, 0x00000000},
	{0x020E04D0, 0x00000010},
	{0x020E01C0, 0x00000000},
	{0x020E04D4, 0x00000010},
	{0x020E01C4, 0x00000000},
	{0x020E04D8, 0x00000010},
	{0x020E01C8, 0x00000000},
	{0x020E04DC, 0x00000010},
	{0x020E01CC, 0x00000000},
	{0x020E04E0, 0x00000010},
	{0x020E0348, 0x00000002},
	{0x020E0220, 0x00000000},
	{0x020E05F0, 0x00017059},
	{0x020E00A4, 0x00000016},
	{0x020E0898, 0x00000000},
	{0x020E03B8, 0x0001B8B1},
	{0x020E00C4, 0x00000011},
	{0x020E089C, 0x00000000},
	{0x020E03D8, 0x0001B8B1},
	{0x020E0210, 0x00000014},
	{0x020E08A0, 0x00000001},
	{0x020E05E0, 0x0001B8B1},
	{0x020E0214, 0x00000014},
	{0x020E08A4, 0x00000001},
	{0x020E05E4, 0x0001B8B1},
	{0x020E023C, 0x00000016},
	{0x020E08A8, 0x00000002},
	{0x020E060C, 0x0001B8B1},
	{0x020E0248, 0x00000016},
	{0x020E08AC, 0x00000002},
	{0x020E0618, 0x0001B8B1},
	{0x020E02FC, 0x00000005},
	{0x020E00AC, 0x00000005},
	{0x020E024C, 0x00000005},
	{0x020E00A8, 0x00000005},
	{END_OF_TABLE},
};

const board_config board_data_sabrelite = {
	.name = "MX6Q-Sabre Lite",
	.dcd = dcd_sabrelite,
};
#endif
