/*
 * Copyright (C) 2012 Robert Bosch Car Multimedia GmbH
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <asm/arch/system.h>
#include <config.h>


#ifdef CONFIG_BOARD_FSL_SABREAI_MX6Q

const dcd_config dcd_sabreauto[] = {
	/* {<u32 address>, <u32 value>}, */
	{0x020E01F8, 0x00000004},
	{0x020E05C8, 0x0001B0B1},
	{0x020E01FC, 0x00000004},
	{0x020E0938, 0x00000001},
	{0x020E05CC, 0x0001B0B1},
	{0x020E0350, 0x00000000},
	{0x020E0738, 0x000170F1},
	{0x020E0348, 0x00000010},
	{0x020E0730, 0x000170F1},
	{0x020E0340, 0x00000000},
	{0x020E0728, 0x000170F1},
	{0x020E033C, 0x00000000},
	{0x020E0724, 0x000170F1},
	{0x020E034C, 0x00000000},
	{0x020E0734, 0x000170F1},
	{0x020E0344, 0x00000000},
	{0x020E072C, 0x000170F1},
	{0x020E02BC, 0x00000000},
	{0x020E06A4, 0x000170F1},
	{0x020E02B8, 0x00000010},
	{0x020E06A0, 0x000170F1},
	{0x020E02C0, 0x00000000},
	{0x020E06A8, 0x000170F1},
	{0x020E02C4, 0x00000000},
	{0x020E06AC, 0x000170F1},
	{0x020E02C8, 0x00000000},
	{0x020E06B0, 0x000170F1},
	{0x020E02CC, 0x00000000},
	{0x020E06B4, 0x000170F1},
	{0x020E02B4, 0x00000000},
	{0x020E069C, 0x000170F1},
	{0x020E02B0, 0x00000000},
	{0x020E0698, 0x000170F1},
	{0x020E02AC, 0x00000000},
	{0x020E0694, 0x000170F1},
	{0x020E02A8, 0x00000000},
	{0x020E0690, 0x000170F1},
	{0x020E0250, 0x00000002},
	{0x020E0620, 0x000170F1},
	{0x020E0200, 0x00000001}, /* Kernel */
	{0x020E0840, 0x00000001},
	{0x020E05D0, 0x0001B0B0},
	{0x020E0208, 0x00000004},
	{0x020E05D8, 0x0001B0B0},
	{0x020E0058, 0x00000001},
	{0x020E036C, 0x0001B0B0},
	{0x020E005C, 0x00000001},
	{0x020E0370, 0x0001B0B0},
	{0x020E0060, 0x00000001},
	{0x020E0374, 0x0001B0B0},
	{0x020E0064, 0x00000001},
	{0x020E0378, 0x0001B0B0},
	{0x020E0068, 0x00000001},
	{0x020E037C, 0x0001B0B0},
	{0x020E0074, 0x00000001},
	{0x020E0388, 0x0001B0B0},
	{0x020E01D4, 0x00000001},
	{0x020E04E8, 0x0001B0B0},
	{0x020E0084, 0x00000001},
	{0x020E0844, 0x00000000},
	{0x020E0398, 0x0001B0B0},
	{0x020E0070, 0x00000001},
	{0x020E0848, 0x00000000},
	{0x020E0384, 0x0001B0B0},
	{0x020E0078, 0x00000001},
	{0x020E084C, 0x00000000},
	{0x020E038C, 0x0001B0B0},
	{0x020E007C, 0x00000001},
	{0x020E0850, 0x00000000},
	{0x020E0390, 0x0001B0B0},
	{0x020E0080, 0x00000001},
	{0x020E0854, 0x00000000},
	{0x020E0394, 0x0001B0B0},
	{0x020E006C, 0x00000001},
	{0x020E0858, 0x00000000},
	{0x020E0380, 0x0001B0B0},
	{0x020E0254, 0x00000005},
	{0x020E0220, 0x00000000},
	{0x020E05F0, 0x00017059},
	{0x020E0358, 0x00000005},
	{0x020E035C, 0x00000005},
	{0x020E032C, 0x00000005},
	{0x020E0338, 0x00000005},
	{0x020E01C0, 0x00000005},
	{0x020E0224, 0x00000005},
	{0x020E0260, 0x00000005},
	{0x020E02EC, 0x00000005},
	{0x020E0050, 0x00000005},
	{0x020E01DC, 0x00000002},
	{0x020E0870, 0x00000000},
	{0x020E04F0, 0x0001B030},
	{0x020E01E0, 0x00000002},
	{0x020E0860, 0x00000000},
	{0x020E04F4, 0x0001B030},
	{0x020E01E8, 0x00000002},
	{0x020E0880, 0x00000000},
	{0x020E04FC, 0x0001B030},
	{0x020E023C, 0x00000000},
	{0x020E087C, 0x00000001},
	{0x020E060C, 0x0001B030},
	{0x020E01F0, 0x00000002},
	{0x020E0884, 0x00000000},
	{0x020E0504, 0x0001B030},
	{0x020E01F4, 0x00000002},
	{0x020E0888, 0x00000000},
	{0x020E0508, 0x0001B030},
	{0x020E024C, 0x00000000},
	{0x020E0874, 0x00000000},
	{0x020E061C, 0x0001B030},
	{0x020E02F0, 0x00000002},
	{0x020E0878, 0x00000001},
	{0x020E06D8, 0x0001B030},
	{0x020E01D0, 0x00000002},
	{0x020E086C, 0x00000000},
	{0x020E04E4, 0x0001B030},
	{0x020E0228, 0x00000000},
	{0x020E085C, 0x00000001},
	{0x020E05F8, 0x0001B030},
	{0x020E0354, 0x00000005},
	{0x020E008C, 0x00000016},
	{0x020E08A0, 0x00000000},
	{0x020E03A0, 0x0001B8B1},
	{0x020E0214, 0x00000014},
	{0x020E08A4, 0x00000001},
	{0x020E05E4, 0x0001B8B1},
	{0x020E0054, 0x00000005},
	{0x020E015C, 0x00000000},
	{0x020E0470, 0x00000010},
	{0x020E0160, 0x00000000},
	{0x020E0474, 0x00000010},
	{0x020E0164, 0x00000000},
	{0x020E0478, 0x00000010},
	{0x020E0168, 0x00000000},
	{0x020E047C, 0x00000010},
	{0x020E0170, 0x00000000},
	{0x020E0484, 0x00000010},
	{0x020E0174, 0x00000000},
	{0x020E0488, 0x00000010},
	{0x020E0178, 0x00000000},
	{0x020E048C, 0x00000010},
	{0x020E017C, 0x00000000},
	{0x020E0490, 0x00000010},
	{0x020E0180, 0x00000000},
	{0x020E0494, 0x00000010},
	{0x020E0184, 0x00000000},
	{0x020E0498, 0x00000010},
	{0x020E0188, 0x00000000},
	{0x020E049C, 0x00000010},
	{0x020E018C, 0x00000000},
	{0x020E04A0, 0x00000010},
	{0x020E0190, 0x00000000},
	{0x020E04A4, 0x00000010},
	{0x020E0194, 0x00000000},
	{0x020E04A8, 0x00000010},
	{0x020E0198, 0x00000000},
	{0x020E04AC, 0x00000010},
	{0x020E019C, 0x00000000},
	{0x020E04B0, 0x00000010},
	{0x020E01A0, 0x00000000},
	{0x020E04B4, 0x00000010},
	{0x020E01A4, 0x00000000},
	{0x020E04B8, 0x00000010},
	{0x020E01A8, 0x00000000},
	{0x020E04BC, 0x00000010},
	{0x020E01AC, 0x00000000},
	{0x020E04C0, 0x00000010},
	{0x020E01B0, 0x00000000},
	{0x020E04C4, 0x00000010},
	{0x020E01B4, 0x00000000},
	{0x020E04C8, 0x00000010},
	{0x020E01B8, 0x00000000},
	{0x020E04CC, 0x00000010},
	{0x020E01BC, 0x00000000},
	{0x020E04D0, 0x00000010},
	{0x020E01C4, 0x00000000},
	{0x020E04D8, 0x00000010},
	{0x020E01CC, 0x00000005},
	{0x020E01C8, 0x00000005},
	{0x020E0268, 0x00000000},
	{0x020E026C, 0x00000000},
	{0x020E0270, 0x00000000},
	{0x020E0274, 0x00000000},
	{0x020E0278, 0x00000000},
	{0x020E027C, 0x00000000},
	{0x020E0280, 0x00000000},
	{0x020E0284, 0x00000000},
	{0x020E0288, 0x00000000},
	{0x020E028C, 0x00000000},
	{0x020E0290, 0x00000000},
	{0x020E0294, 0x00000000},
	{0x020E0298, 0x00000000},
	{0x020E029C, 0x00000000},
	{0x020E02A0, 0x00000000},
	{0x020E02A4, 0x00000000},
	{0x020E0264, 0x00000000},
	{0x020E025C, 0x00000000},
	{0x020E0258, 0x00000000},
	{0x020E0320, 0x00000002},
	{0x020E0324, 0x00000002},
	{0x020E0154, 0x00000005},
	{0x020E0468, 0x00000010},
	{0x020E0210, 0x00000006},
	{0x020E0914, 0x00000002},
	{0x020E010C, 0x00000005},
	{0x020E01D8, 0x00000001},
	{0x020E01E4, 0x00000005},
	{0x020E0240, 0x00000004},
	{0x020E0610, 0x0001B0B1},
	{0x020E0244, 0x00000004},
	{0x020E0928, 0x00000003},
	{0x020E0614, 0x0001B0B1},
	{0x020E0334, 0x00000002},
	{0x020E071C, 0x0001B0B1},
	{0x020E0330, 0x00000002},
	{0x020E0924, 0x00000004},
	{0x020E0718, 0x0001B0B1},
	{0x020E02F8, 0x00000002},
	{0x020E06E0, 0x0001B0B1},
	{0x020E02F4, 0x00000002},
	{0x020E0930, 0x00000002},
	{0x020E06DC, 0x0001B0B1},
	{0x020E031C, 0x00000005},
	{0x020E00C4, 0x00000005},
	{0x020E03D8, 0x00000010},
	{0x020E00D0, 0x00000005},
	{0x020E0088, 0x00000006},
	{0x020E088C, 0x00000000},
	{0x020E00B4, 0x00000005},
	{0x020E03C8, 0x00000010},
	{0x020E01EC, 0x00000000},
	{0x020E0900, 0x00000000},
	{0x020E0230, 0x00000007},
	{0x020E0908, 0x00000001},
	{0x020E0600, 0x00000071},
	{0x020E0234, 0x00000007},
	{0x020E0904, 0x00000001},
	{0x020E0604, 0x00000071},
	{0x020E0090, 0x00000001},
	{0x020E07F4, 0x00000000},
	{0x020E03A4, 0x000100B1},
	{0x020E0094, 0x00000001},
	{0x020E07F8, 0x00000000},
	{0x020E03A8, 0x000100B1},
	{0x020E0098, 0x00000001},
	{0x020E07FC, 0x00000000},
	{0x020E03AC, 0x000100B1},
	{0x020E0804, 0x00000000},
	{0x020E03B0, 0x000100B1},
	{0x020E009C, 0x00000005},
	{0x020E022C, 0x00000012},
	{0x020E08A8, 0x00000001},
	{0x020E05FC, 0x0001B8B1},
	{0x020E08AC, 0x00000000},
	{0x020E00D4, 0x00000005},
	{0x020E0248, 0x00000012},
	{0x020E083C, 0x00000001},
	{0x020E0618, 0x0001B0B0},
	{0x020E0218, 0x00000000},
	{0x020E021C, 0x00000000},
	{0x020E07E8, 0x00000000},
	{END_OF_TABLE},
};

const board_config board_data_sabreaiq = {
	.name = "MX6Q-Sabre AI",
	.dcd = dcd_sabreauto,
	.ram_size = 2u * 1024 * 1024 * 1024, /* 2GB DDR3 */
};

#endif /* CONFIG_BOARD_FSL_SABREAI_MX6Q */

#if defined(CONFIG_BOARD_FSL_SABREAI_MX6S) || \
	defined(CONFIG_BOARD_FSL_SABREAI_MX6DL)
const dcd_config dcd_sabreauto_solo[] = {
	/* {<u32 address>, <u32 value>}, */
	{0x020E0244, 0x00000004}, /* UART4 console */
	{0x020E062C, 0x0001B0B1},
	{0x020E0258, 0x00000004},
	{0x020E0914, 0x00000003},
	{0x020E0640, 0x0001B0B1},
	{0x020E02DC, 0x00000000}, /* USDHC1*/
	{0x020E0928, 0x00000001},
	{0x020E06C4, 0x00017059},
	{0x020E02E0, 0x00000010},
	{0x020E06C8, 0x00017059},
	{0x020E02E4, 0x00000000},
	{0x020E06CC, 0x00017059},
	{0x020E02E8, 0x00000000},
	{0x020E06D0, 0x00017059},
	{0x020E02EC, 0x00000000},
	{0x020E06D4, 0x00017059},
	{0x020E02F0, 0x00000000},
	{0x020E06D8, 0x00017059},
	{0x020E030C, 0x00000000}, /* USDHC3 */
	{0x020E0934, 0x00000001},
	{0x020E06F4, 0x00017059},
	{0x020E0310, 0x00000010},
	{0x020E06F8, 0x00017059},
	{0x020E0314, 0x00000000},
	{0x020E06FC, 0x00017059},
	{0x020E0318, 0x00000000},
	{0x020E0700, 0x00017059},
	{0x020E031C, 0x00000000},
	{0x020E0704, 0x00017059},
	{0x020E0320, 0x00000000},
	{0x020E0708, 0x00017059},
	{0x020E0324, 0x00000000},
	{0x020E070C, 0x00017059},
	{0x020E0328, 0x00000000},
	{0x020E0710, 0x00017059},
	{0x020E032C, 0x00000000},
	{0x020E0714, 0x00017059},
	{0x020E0330, 0x00000000},
	{0x020E0718, 0x00017059},
	{0x020E021C, 0x00000002},
	{0x020E05EC, 0x00017059},
	{0x020E0248, 0x00000001}, /* ENET */
	{0x020E0810, 0x00000001},
	{0x020E0630, 0x0001B0B0},
	{0x020E024C, 0x00000004},
	{0x020E0634, 0x0001B0B0},
	{0x020E02D8, 0x00000001},
	{0x020E02C4, 0x00000001},
	{0x020E06AC, 0x0001B0B0},
	{0x020E02C8, 0x00000001},
	{0x020E06B0, 0x0001B0B0},
	{0x020E02CC, 0x00000001},
	{0x020E06B4, 0x0001B0B0},
	{0x020E02D0, 0x00000001},
	{0x020E06B8, 0x0001B0B0},
	{0x020E02D4, 0x00000001},
	{0x020E06BC, 0x0001B0B0},
	{0x020E01F0, 0x00000001},
	{0x020E05C0, 0x0001B0B0},
	{0x020E02C0, 0x00000001},
	{0x020E0814, 0x00000001},
	{0x020E06A8, 0x0001B0B0},
	{0x020E02AC, 0x00000001},
	{0x020E0818, 0x00000001},
	{0x020E0694, 0x0001B0B0},
	{0x020E02B0, 0x00000001},
	{0x020E081C, 0x00000001},
	{0x020E0698, 0x0001B0B0},
	{0x020E02B4, 0x00000001},
	{0x020E0820, 0x00000001},
	{0x020E069C, 0x0001B0B0},
	{0x020E02B8, 0x00000001},
	{0x020E0824, 0x00000001},
	{0x020E06A0, 0x0001B0B0},
	{0x020E02BC, 0x00000001},
	{0x020E0828, 0x00000001},
	{0x020E06A4, 0x0001B0B0},
	{0x020E0220, 0x00000005}, /* KERNEL */
	{0x020E020C, 0x00000000},
	{0x020E05DC, 0x00017059},
	{0x020E02F8, 0x00000005},
	{0x020E0308, 0x00000005},
	{0x020E0350, 0x00000005},
	{0x020E035C, 0x00000005},
	{0x020E00E4, 0x00000005},
	{0x020E0210, 0x00000005},
	{0x020E008C, 0x00000005},
	{0x020E027C, 0x00000005},
	{0x020E0304, 0x00000005},
	{0x020E01E4, 0x00000002},
	{0x020E0840, 0x00000000},
	{0x020E05B4, 0x0001B030},
	{0x020E01FC, 0x00000002},
	{0x020E0830, 0x00000000},
	{0x020E05CC, 0x0001B030},
	{0x020E0200, 0x00000002},
	{0x020E0850, 0x00000000},
	{0x020E05D0, 0x0001B030},
	{0x020E0230, 0x00000000},
	{0x020E084C, 0x00000001},
	{0x020E0600, 0x0001B030},
	{0x020E0204, 0x00000002},
	{0x020E0854, 0x00000000},
	{0x020E05D4, 0x0001B030},
	{0x020E01E8, 0x00000002},
	{0x020E0858, 0x00000000},
	{0x020E05B8, 0x0001B030},
	{0x020E0218, 0x00000000},
	{0x020E0844, 0x00000000},
	{0x020E05E8, 0x0001B030},
	{0x020E0280, 0x00000002},
	{0x020E0848, 0x00000001},
	{0x020E0668, 0x0001B030},
	{0x020E01EC, 0x00000002},
	{0x020E083C, 0x00000000},
	{0x020E0240, 0x00000000},
	{0x020E082C, 0x00000001},
	{0x020E0610, 0x0001B030},
	{0x020E02F4, 0x00000005},
	{0x020E01CC, 0x00000016},
	{0x020E0870, 0x00000000},
	{0x020E059C, 0x0001B8B1},
	{0x020E0264, 0x00000014},
	{0x020E0874, 0x00000001},
	{0x020E064C, 0x0001B8B1},
	{0x020E02FC, 0x00000005},
	{0x020E009C, 0x00000000},
	{0x020E03B0, 0x00000010},
	{0x020E00A0, 0x00000000},
	{0x020E03B4, 0x00000010},
	{0x020E00A4, 0x00000000},
	{0x020E03B8, 0x00000010},
	{0x020E00A8, 0x00000000},
	{0x020E03BC, 0x00000010},
	{0x020E00B0, 0x00000000},
	{0x020E03C4, 0x00000010},
	{0x020E00B4, 0x00000000},
	{0x020E03C8, 0x00000010},
	{0x020E00E0, 0x00000000},
	{0x020E00F4, 0x00000000},
	{0x020E0408, 0x00000010},
	{0x020E00F8, 0x00000000},
	{0x020E040C, 0x00000010},
	{0x020E00FC, 0x00000000},
	{0x020E0410, 0x00000010},
	{0x020E0100, 0x00000000},
	{0x020E0414, 0x00000010},
	{0x020E0104, 0x00000000},
	{0x020E0418, 0x00000010},
	{0x020E0108, 0x00000000},
	{0x020E041C, 0x00000010},
	{0x020E010C, 0x00000000},
	{0x020E0420, 0x00000010},
	{0x020E00B8, 0x00000000},
	{0x020E00BC, 0x00000000},
	{0x020E03D0, 0x00000010},
	{0x020E00C0, 0x00000000},
	{0x020E03D4, 0x00000010},
	{0x020E00C4, 0x00000000},
	{0x020E03D8, 0x00000010},
	{0x020E00C8, 0x00000000},
	{0x020E03DC, 0x00000010},
	{0x020E00CC, 0x00000000},
	{0x020E03E0, 0x00000010},
	{0x020E00D0, 0x00000000},
	{0x020E03E4, 0x00000010},
	{0x020E00D4, 0x00000000},
	{0x020E03E8, 0x00000010},
	{0x020E00D8, 0x00000000},
	{0x020E03EC, 0x00000010},
	{0x020E00DC, 0x00000000},
	{0x020E03F0, 0x00000010},
	{0x020E00E8, 0x00000000},
	{0x020E03FC, 0x00000010},
	{0x020E00F0, 0x00000005},
	{0x020E00EC, 0x00000005},
	{0x020E0074, 0x00000000},
	{0x020E0078, 0x00000000},
	{0x020E007C, 0x00000000},
	{0x020E0080, 0x00000000},
	{0x020E0084, 0x00000000},
	{0x020E0088, 0x00000000},
	{0x020E004C, 0x00000000},
	{0x020E0050, 0x00000000},
	{0x020E0054, 0x00000000},
	{0x020E0058, 0x00000000},
	{0x020E005C, 0x00000000},
	{0x020E0060, 0x00000000},
	{0x020E0064, 0x00000000},
	{0x020E0068, 0x00000000},
	{0x020E006C, 0x00000000},
	{0x020E0070, 0x00000000},
	{0x020E0098, 0x00000000},
	{0x020E0090, 0x00000000},
	{0x020E0094, 0x00000000},
	{0x020E0344, 0x00000002},
	{0x020E0348, 0x00000002},
	{0x020E01E0, 0x00000005},
	{0x020E0250, 0x00000006},
	{0x020E08F0, 0x00000003},
	{0x020E01C4, 0x00000005},
	{0x020E01F4, 0x00000000},
	{0x020E0790, 0x00000000},
	{0x020E01F8, 0x00000005},
	{0x020E0238, 0x00000004},
	{0x020E0608, 0x0001B0B1},
	{0x020E023C, 0x00000004},
	{0x020E0904, 0x00000003},
	{0x020E060C, 0x0001B0B1},
	{0x020E0358, 0x00000002},
	{0x020E0740, 0x0001B0B1},
	{0x020E0354, 0x00000002},
	{0x020E0900, 0x00000004},
	{0x020E073C, 0x0001B0B1},
	{0x020E0338, 0x00000002},
	{0x020E0720, 0x0001B0B1},
	{0x020E033C, 0x00000002},
	{0x020E090C, 0x00000003},
	{0x020E0724, 0x0001B0B1},
	{0x020E0340, 0x00000005},
	{0x020E0174, 0x00000005},
	{0x020E0180, 0x00000005},
	{0x020E0134, 0x00000006},
	{0x020E085C, 0x00000000},
	{0x020E0164, 0x00000005},
	{0x020E0208, 0x00000000},
	{0x020E08DC, 0x00000000},
	{0x020E0234, 0x00000007},
	{0x020E08E4, 0x00000001},
	{0x020E0604, 0x00000071},
	{0x020E0224, 0x00000007},
	{0x020E08E0, 0x00000001},
	{0x020E05F4, 0x00000071},
	{0x020E0144, 0x00000001},
	{0x020E07D8, 0x00000002},
	{0x020E0514, 0x000100B1},
	{0x020E0148, 0x00000001},
	{0x020E07DC, 0x00000002},
	{0x020E0518, 0x000100B1},
	{0x020E014C, 0x00000001},
	{0x020E07E0, 0x00000002},
	{0x020E051C, 0x000100B1},
	{0x020E0150, 0x00000001},
	{0x020E07E8, 0x00000001},
	{0x020E0520, 0x000100B1},
	{0x020E0228, 0x00000012},
	{0x020E0878, 0x00000001},
	{0x020E05F8, 0x0001B8B1},
	{0x020E087C, 0x00000000},
	{0x020E0130, 0x00000005},
	{0x020E0214, 0x00000012},
	{0x020E080C, 0x00000000},
	{0x020E0254, 0x00000000},
	{0x020E0268, 0x00000000},
	{0x020E07CC, 0x00000000},
	{END_OF_TABLE},
};
#endif /* CONFIG_BOARD_FSL_SABREAI_MX6S || CONFIG_BOARD_FSL_SABREAI_MX6DL*/

#ifdef CONFIG_BOARD_FSL_SABREAI_MX6S
const board_config board_data_sabreais = {
	.name = "MX6S-Sabre AI",
	.dcd = dcd_sabreauto_solo,
	.ram_size = 1u * 1024 * 1024 * 1024, /* 1GB DDR3 */
};

#endif /* CONFIG_BOARD_FSL_SABREAI_MX6S */

#ifdef CONFIG_BOARD_FSL_SABREAI_MX6DL
const board_config board_data_sabreaidl = {
	.name = "MX6DL-Sabre AI",
	.dcd = dcd_sabreauto_solo,
	.ram_size = 2u * 1024 * 1024 * 1024, /* 2GB DDR3 */
};
#endif /* CONFIG_BOARD_FSL_SABREAI_MX6S */
