/*
 * Copyright (C) 2014 Robert Bosch Car Multimedia GmbH
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <asm/arch/sys_proto.h>
#include <asm/gpio.h>

#ifdef CONFIG_BOARD_SUZUKISLNC
static const dcd_config dcd_suzukislnc[] = {
	/* {<u32 address>, <u32 value>}, */
	/* iomux */
	{0x020E0790, 0x00000001},
	{0x020E0798, 0x00000001},
	{0x020E07A8, 0x00000001},
	{0x020E07AC, 0x00000001},
	{0x020E0870, 0x00000001},
	{0x020E0874, 0x00000001},
	{0x020E0878, 0x00000002},
	{0x020E087C, 0x00000001},
	{0x020E0074, 0x00000002},
	{0x020E0078, 0x00000002},
	{0x020E007C, 0x00000002},
	{0x020E0084, 0x00000002},
	{0x020E0088, 0x00000002},
	{0x020E004C, 0x00000002},
	{0x020E0054, 0x00000000},
	{0x020E0058, 0x00000000},
	{0x020E005C, 0x00000000},
	{0x020E0060, 0x00000000},
	{0x020E0064, 0x00000000},
	{0x020E0068, 0x00000000},
	{0x020E006C, 0x00000000},
	{0x020E0070, 0x00000000},
	{0x020E008C, 0x00000000},
	{0x020E0090, 0x00000000},
	{0x020E0094, 0x00000000},
	{0x020E0098, 0x00000000},
	{0x020E009C, 0x00000000},
	{0x020E00A4, 0x00000000},
	{0x020E00A8, 0x00000000},
	{0x020E00A0, 0x00000000},
	{0x020E00B0, 0x00000000},
	{0x020E00B4, 0x00000000},
	{0x020E00E0, 0x00000000},
	{0x020E00F4, 0x00000000},
	{0x020E00F8, 0x00000000},
	{0x020E00FC, 0x00000000},
	{0x020E0100, 0x00000000},
	{0x020E0104, 0x00000000},
	{0x020E0108, 0x00000000},
	{0x020E010C, 0x00000000},
	{0x020E00B8, 0x00000000},
	{0x020E00BC, 0x00000000},
	{0x020E00C0, 0x00000000},
	{0x020E00C4, 0x00000000},
	{0x020E00C8, 0x00000000},
	{0x020E00CC, 0x00000000},
	{0x020E00D0, 0x00000000},
	{0x020E00D4, 0x00000000},
	{0x020E00D8, 0x00000000},
	{0x020E00DC, 0x00000000},
	{0x020E00E4, 0x00000000},
	{0x020E00E8, 0x00000000},
	{0x020E00EC, 0x00000000},
	{0x020E00F0, 0x00000000},
	{0x020E0134, 0x00000005},
	{0x020E0138, 0x00000005},
	{0x020E0140, 0x00000005},
	{0x020E0154, 0x00000005},
	{0x020E0158, 0x00000001},
	{0x020E015C, 0x00000001},
	{0x020E0174, 0x00000002},
	{0x020E01D8, 0x00000005},
	{0x020E01E4, 0x00000002},
	{0x020E01E8, 0x00000002},
	{0x020E01FC, 0x00000002},
	{0x020E0210, 0x00000003},
	{0x020E0224, 0x00000005},
	{0x020E022C, 0x00000005},
	{0x020E0230, 0x00000016},
	{0x020E0214, 0x00000016},
	{0x020E0244, 0x00000004},
	{0x020E0248, 0x00000004},
	{0x020E0250, 0x00000014},
	{0x020E0254, 0x00000002},
	{0x020E0258, 0x00000004},
	{0x020E025C, 0x00000004},
	{0x020E0264, 0x00000014},
	{0x020E0268, 0x00000002},
	{0x020E027C, 0x00000002},
	{0x020E02DC, 0x00000000},
	{0x020E02E0, 0x00000000},
	{0x020E02E4, 0x00000000},
	{0x020E02E8, 0x00000000},
	{0x020E02EC, 0x00000000},
	{0x020E02F0, 0x00000000},
	{0x020E02F4, 0x00000005},
	{0x020E02F8, 0x00000005},
	{0x020E02FC, 0x00000003},
	{0x020E0300, 0x00000003},
	{0x020E0304, 0x00000003},
	{0x020E0308, 0x00000003},
	{0x020E030C, 0x00000000},
	{0x020E0310, 0x00000000},
	{0x020E0314, 0x00000000},
	{0x020E0318, 0x00000000},
	{0x020E031C, 0x00000000},
	{0x020E0320, 0x00000000},
	{0x020E0324, 0x00000000},
	{0x020E0328, 0x00000000},
	{0x020E032C, 0x00000000},
	{0x020E0330, 0x00000000},
	{0x020E0334, 0x00000000},
	{0x020E0338, 0x00000000},
	{0x020E033C, 0x00000000},
	{0x020E0340, 0x00000001},
	{0x020E0344, 0x00000001},
	{0x020E0348, 0x00000001},
	{0x020E034C, 0x00000001},
	{0x020E0350, 0x00000002},
	{0x020E0354, 0x00000002},
	{0x020E0358, 0x00000002},
	{0x020E035C, 0x00000002},
	{0x020E03B0, 0x0001B088},
	{0x020E03B8, 0x0001B088},
	{0x020E03BC, 0x0001B088},
	{0x020E03B4, 0x0001B088},
	{0x020E03C4, 0x0001B088},
	{0x020E03C8, 0x0001B088},
	{0x020E03F4, 0x0001B088},
	{0x020E0408, 0x0001B088},
	{0x020E040C, 0x0001B088},
	{0x020E0410, 0x0001B088},
	{0x020E0414, 0x0001B088},
	{0x020E0418, 0x0001B088},
	{0x020E041C, 0x0001B088},
	{0x020E0420, 0x0001B088},
	{0x020E03CC, 0x0001B088},
	{0x020E03D0, 0x0001B088},
	{0x020E03D4, 0x0001B088},
	{0x020E03D8, 0x0001B088},
	{0x020E03DC, 0x0001B088},
	{0x020E03E0, 0x0001B088},
	{0x020E03E4, 0x0001B088},
	{0x020E03E8, 0x0001B088},
	{0x020E03EC, 0x0001B088},
	{0x020E03F0, 0x0001B088},
	{0x020E03F8, 0x0001B088},
	{0x020E03FC, 0x0001B088},
	{0x020E0400, 0x0001B088},
	{0x020E0404, 0x0001B088},
	{0x020E05B4, 0x000130B0},
	{0x020E05B8, 0x000130B0},
	{0x020E05CC, 0x000130B0},
	{0x020E05D0, 0x000130B0},
	{0x020E05E0, 0x0001B0B0},
	{0x020E0608, 0x000130B0},
	{0x020E0664, 0x000130B0},
	{0x020E066C, 0x000130B0},
	{0x020E06F4, 0x0001B0A0},
	{0x020E06F8, 0x0001B090},
	{0x020E06FC, 0x0001B090},
	{0x020E0700, 0x0001B090},
	{0x020E0704, 0x0001B090},
	{0x020E0708, 0x0001B090},
	{0x020E070C, 0x0001B090},
	{0x020E0710, 0x0001B090},
	{0x020E0714, 0x0001B090},
	{0x020E0718, 0x0001B090},
	{0x020E071C, 0x0001B090},
	{0x020E0900, 0x00000004},
	{0x020E0904, 0x00000006},
	{0x020E0914, 0x00000003},
	{0x020E091C, 0x00000003},
	{0x020E0920, 0x00000001},
	{0x020E0928, 0x00000001},
	{0x020E0934, 0x00000001},
	{0x020E0938, 0x00000001},
	/*GPIO settings*/
	{0x0209C000, 0x20000000},
	{0x0209C004, 0x30000E00},
	{0x020A0000, 0x03000024},
	{0x020A0004, 0x430000BD},
	{0x020A4000, 0x00100000},
	{0x020A4004, 0x00100000},
	{0x020A8000, 0x00100400},
	{0x020A8004, 0x00100400},
	{0x020AC000, 0x22000000},
	{0x020AC004, 0x22000000},
	{0x020B0000, 0x00000000},
	{0x020B0004, 0x00000800},
	{0x020B4000, 0x00000000},
	{0x020B4004, 0x00000000},
	{END_OF_TABLE},
};

static const env_entry board_env_suzukislnc[] = {
	{"cpucount", "nosmp"},
	{"console", "ttymxc3"},
	{0, 0}
};

static const env_entry board_env_suzukislnc_dl[] = {
	{"cpucount", "maxcpus=2"},
	{"console", "ttymxc3"},
	{0, 0}
};

static const sf_spi sf_spi_suzukislnc = {
	.bus = 3,
	.cs = (0|(IMX_GPIO_NR(3, 20)<<8)),
};

static const struct sw_opt_gpio sw_opt_gpio_suzukislnc = {
	.sw_opt = { IMX_GPIO_NR(1,  8), IMX_GPIO_NR(4, 5) },
};

#define SUZUKISLN_C_GPIO_SD_MPWR		IMX_GPIO_NR(4, 20)

static void board_init_suzukislnc(void)
{
	/* switch on eMMC/SD power */
	gpio_direction_output(SUZUKISLN_C_GPIO_SD_MPWR, 1);
}

const board_config board_data_suzukislnc = {
	.name = "MX6S-Suzuki-SLN-C",
	.dcd = dcd_suzukislnc,
	.env = board_env_suzukislnc,
	.ram_size = 1u * 1024 * 1024 * 1024,
	.board_init = board_init_suzukislnc,
	.sf = &sf_spi_suzukislnc,
	.uart = UART4_BASE,
	.env_dev = ENV_GEN3_DEV_SPI_FLASH,
	.sw_opt = &sw_opt_gpio_suzukislnc,
	.n_single_rootfs = 1,
};

const board_config board_data_suzukislnc_dl = {
	.name = "MX6DL-Suzuki-SLN-C",
	.dcd = dcd_suzukislnc,
	.env = board_env_suzukislnc_dl,
	.ram_size = 1u * 1024 * 1024 * 1024,
	.board_init = board_init_suzukislnc,
	.sf = &sf_spi_suzukislnc,
	.uart = UART4_BASE,
	.env_dev = ENV_GEN3_DEV_SPI_FLASH,
	.sw_opt = &sw_opt_gpio_suzukislnc,
	.n_single_rootfs = 1,
};
#endif
