/*
 * Copyright (C) 2012 Robert Bosch Car Multimedia GmbH
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <asm/arch/system.h>
#include <asm/arch/clock.h>
#include <config.h>

#ifdef CONFIG_BOARD_ICAMA1
static const dcd_config dcd_icama1_solo[] = {
	/* {<u32 address>, <u32 value>}, */
	{0x020E004C, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_DAT10 */
	{0x020E0050, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_DAT11 */
	{0x020E0054, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_DAT12 */
	{0x020E0058, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_DAT13 */
	{0x020E005C, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_DAT14 */
	{0x020E0060, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_DAT15 */
	{0x020E0064, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_DAT16 */
	{0x020E0068, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_DAT17 */
	{0x020E006C, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_DAT18 */
	{0x020E0070, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_DAT19 */
	{0x020E0074, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_DAT4 */
	{0x020E0078, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_DAT5 */
	{0x020E007C, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_DAT6 */
	{0x020E0080, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_DAT7 */
	{0x020E0084, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_DAT8 */
	{0x020E0088, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_DAT9 */
	{0x020E008C, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA_EN */
	{0x020E0090, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_MCLK */
	{0x020E0094, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_PIXCLK */
	{0x020E0098, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_CSI0_VSYNC */
	{0x020E009C, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DI0_DISP_CLK */
	{0x020E00A0, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DI0_PIN15 */
	{0x020E00A4, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DI0_PIN2 */
	{0x020E00A8, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DI0_PIN3 */
	{0x020E00AC, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DI0_PIN4 */
	{0x020E00B0, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DISP0_DAT0 */
	{0x020E00B4, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DISP0_DAT1 */
	{0x020E00B8, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DISP0_DAT10 */
	{0x020E00BC, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DISP0_DAT11 */
	{0x020E00C0, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DISP0_DAT12 */
	{0x020E00C4, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DISP0_DAT13 */
	{0x020E00C8, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DISP0_DAT14 */
	{0x020E00CC, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DISP0_DAT15 */
	{0x020E00E0, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DISP0_DAT2 */
	{0x020E00F4, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DISP0_DAT3 */
	{0x020E00F8, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DISP0_DAT4 */
	{0x020E00FC, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DISP0_DAT5 */
	{0x020E0100, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DISP0_DAT6 */
	{0x020E0104, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DISP0_DAT7 */
	{0x020E0108, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DISP0_DAT8 */
	{0x020E010C, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_DISP0_DAT9 */
	{0x020E0110, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_A16 */
	{0x020E0114, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_A17 */
	{0x020E0118, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_A18 */
	{0x020E011C, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_A19 */
	{0x020E0120, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_A20 */
	{0x020E0124, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_A21 */
	{0x020E0128, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_A22 */
	{0x020E012C, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_A23 */
	{0x020E0130, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_A24 */
	{0x020E0134, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_A25 */
	{0x020E013C, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_CS0 */
	{0x020E0140, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_CS1 */
	{0x020E0144, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_D16 */
	{0x020E0148, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_D17 */
	{0x020E014C, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_D18 */
	{0x020E0150, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_D19 */
	{0x020E0154, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_D20 */
	{0x020E0158, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_D21 */
	{0x020E015C, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_D22 */
	{0x020E0160, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_D23 */
	{0x020E0164, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_D24 */
	{0x020E0168, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_D25 */
	{0x020E016C, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_D26 */
	{0x020E0170, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_D27 */
	{0x020E0174, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_D28 */
	{0x020E0178, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_D29 */
	{0x020E017C, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_D30 */
	{0x020E0180, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_D31 */
	{0x020E0184, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_DA0 */
	{0x020E0188, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_DA1 */
	{0x020E018C, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_DA10 */
	{0x020E0190, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_DA11 */
	{0x020E0194, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_DA12 */
	{0x020E0198, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_DA13 */
	{0x020E019C, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_DA14 */
	{0x020E01A0, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_DA15 */
	{0x020E01A4, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_DA2 */
	{0x020E01A8, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_DA3 */
	{0x020E01AC, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_DA4 */
	{0x020E01B0, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_DA5 */
	{0x020E01B4, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_DA6 */
	{0x020E01B8, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_DA7 */
	{0x020E01BC, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_DA8 */
	{0x020E01C0, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_DA9 */
	{0x020E01D8, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_OE */
	{0x020E01DC, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_RW */
	{0x020E01E0, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_EIM_WAIT */
	{0x020E01F0, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_ENET_REF_CLK */
	{0x020E0200, 0x00000009}, /* IOMUXC_SW_MUX_CTL_PAD_ENET_TX_EN */
	{0x020E0208, 0x00000009}, /* IOMUXC_SW_MUX_CTL_PAD_ENET_TXD1 */
	{0x020E020C, 0x00000005}, /* IOMUXC_SW_MUX_CTL_PAD_GPIO_0 */
	{0x020E0210, 0x00000006}, /* IOMUXC_SW_MUX_CTL_PAD_GPIO_1 */
	{0x020E0218, 0x00000005}, /* IOMUXC_SW_MUX_CTL_PAD_GPIO_17 */
	{0x020E0224, 0x00000005}, /* IOMUXC_SW_MUX_CTL_PAD_GPIO_2 */
	{0x020E0228, 0x00000005}, /* IOMUXC_SW_MUX_CTL_PAD_GPIO_3 */
	{0x020E022C, 0x00000005}, /* IOMUXC_SW_MUX_CTL_PAD_GPIO_4 */
	{0x020E0230, 0x00000005}, /* IOMUXC_SW_MUX_CTL_PAD_GPIO_5 */
	{0x020E0238, 0x00000003}, /* IOMUXC_SW_MUX_CTL_PAD_GPIO_7 */
	{0x020E023C, 0x00000003}, /* IOMUXC_SW_MUX_CTL_PAD_GPIO_8 */
	{0x020E0250, 0x00000004}, /* IOMUXC_SW_MUX_CTL_PAD_KEY_COL3 */
	{0x020E0254, 0x00000005}, /* IOMUXC_SW_MUX_CTL_PAD_KEY_COL4 */
	{0x020E0264, 0x00000004}, /* IOMUXC_SW_MUX_CTL_PAD_KEY_ROW3 */
	{0x020E0268, 0x00000005}, /* IOMUXC_SW_MUX_CTL_PAD_KEY_ROW4 */
	{0x020E0284, 0x00000005}, /* IOMUXC_SW_MUX_CTL_PAD_NANDF_D0 */
	{0x020E0288, 0x00000005}, /* IOMUXC_SW_MUX_CTL_PAD_NANDF_D1 */
	{0x020E02AC, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_RGMII_RD0 */
	{0x020E02B0, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_RGMII_RD1 */
	{0x020E02B4, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_RGMII_RD2 */
	{0x020E02B8, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_RGMII_RD3 */
	{0x020E02BC, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_RGMII_RX_CTL */
	{0x020E02C0, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_RGMII_RXC */
	{0x020E02C4, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_RGMII_TD0 */
	{0x020E02C8, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_RGMII_TD1 */
	{0x020E02CC, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_RGMII_TD2 */
	{0x020E02D0, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_RGMII_TD3 */
	{0x020E02D4, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_RGMII_TX_CTL */
	{0x020E02D8, 0x00000001}, /* IOMUXC_SW_MUX_CTL_PAD_RGMII_TXC */
	{0x020E02DC, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD1_CLK */
	{0x020E02E0, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD1_CMD */
	{0x020E02E4, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD1_DAT0 */
	{0x020E02E8, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD1_DAT1 */
	{0x020E02EC, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD1_DAT2 */
	{0x020E02F0, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD1_DAT3 */
	{0x020E02F4, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD2_CLK */
	{0x020E02F8, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD2_CMD */
	{0x020E02FC, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD2_DAT0 */
	{0x020E0300, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD2_DAT1 */
	{0x020E0304, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD2_DAT2 */
	{0x020E0308, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD2_DAT3 */
	{0x020E030C, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD3_CLK */
	{0x020E0310, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD3_CMD */
	{0x020E0314, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD3_DAT0 */
	{0x020E0318, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD3_DAT1 */
	{0x020E031C, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD3_DAT2 */
	{0x020E0320, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD3_DAT3 */
	{0x020E0324, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD3_DAT4 */
	{0x020E0328, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD3_DAT5 */
	{0x020E032C, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD3_DAT6 */
	{0x020E0330, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD3_DAT7 */
	{0x020E0334, 0x00000000}, /* IOMUXC_SW_MUX_CTL_PAD_SD3_RST */
	{0x020E0338, 0x00000002}, /* IOMUXC_SW_MUX_CTL_PAD_SD4_CLK */
	{0x020E033C, 0x00000002}, /* IOMUXC_SW_MUX_CTL_PAD_SD4_CMD */
	{0x020E0350, 0x00000002}, /* IOMUXC_SW_MUX_CTL_PAD_SD4_DAT4 */
	{0x020E035C, 0x00000002}, /* IOMUXC_SW_MUX_CTL_PAD_SD4_DAT7 */
	{0x020E0360, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_DAT10 */
	{0x020E0364, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_DAT11 */
	{0x020E0368, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_DAT12 */
	{0x020E036C, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_DAT13 */
	{0x020E0370, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_DAT14 */
	{0x020E0374, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_DAT15 */
	{0x020E0378, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_DAT16 */
	{0x020E037C, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_DAT17 */
	{0x020E0380, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_DAT18 */
	{0x020E0384, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_DAT19 */
	{0x020E0388, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_DAT4 */
	{0x020E038C, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_DAT5 */
	{0x020E0390, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_DAT6 */
	{0x020E0394, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_DAT7 */
	{0x020E0398, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_DAT8 */
	{0x020E039C, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_DAT9 */
	{0x020E03A0, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA_EN */
	{0x020E03A4, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_MCLK */
	{0x020E03A8, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_PIXCLK */
	{0x020E03AC, 0x0001B0F1}, /* IOMUXC_SW_PAD_CTL_PAD_CSI0_VSYNC */
	{0x020E03B0, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DI0_DISP_CLK */
	{0x020E03B4, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15 */
	{0x020E03B8, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DI0_PIN2 */
	{0x020E03BC, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DI0_PIN3 */
	{0x020E03C0, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DI0_PIN4 */
	{0x020E03C4, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DISP0_DAT0 */
	{0x020E03C8, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DISP0_DAT1 */
	{0x020E03CC, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DISP0_DAT10 */
	{0x020E03D0, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DISP0_DAT11 */
	{0x020E03D4, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DISP0_DAT12 */
	{0x020E03D8, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DISP0_DAT13 */
	{0x020E03DC, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DISP0_DAT14 */
	{0x020E03E0, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DISP0_DAT15 */
	{0x020E03F4, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DISP0_DAT2 */
	{0x020E0408, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DISP0_DAT3 */
	{0x020E040C, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DISP0_DAT4 */
	{0x020E0410, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DISP0_DAT5 */
	{0x020E0414, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DISP0_DAT6 */
	{0x020E0418, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DISP0_DAT7 */
	{0x020E041C, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DISP0_DAT8 */
	{0x020E0420, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_DISP0_DAT9 */
	{0x020E04E0, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_A16 */
	{0x020E04E4, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_A17 */
	{0x020E04E8, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_A18 */
	{0x020E04EC, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_A19 */
	{0x020E04F0, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_A20 */
	{0x020E04F4, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_A21 */
	{0x020E04F8, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_A22 */
	{0x020E04FC, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_A23 */
	{0x020E0500, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_A24 */
	{0x020E0504, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_A25 */
	{0x020E050C, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_CS0 */
	{0x020E0510, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_CS1 */
	{0x020E0514, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_D16 */
	{0x020E0518, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_D17 */
	{0x020E051C, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_D18 */
	{0x020E0520, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_D19 */
	{0x020E0524, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_D20 */
	{0x020E0528, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_D21 */
	{0x020E052C, 0x000130B0}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_D22 */
	{0x020E0530, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_D23 */
	{0x020E0534, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_D24 */
	{0x020E0538, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_D25 */
	{0x020E053C, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_D26 */
	{0x020E0540, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_D27 */
	{0x020E0544, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_D28 */
	{0x020E0548, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_D29 */
	{0x020E054C, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_D30 */
	{0x020E0550, 0x000130B0}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_D31 */
	{0x020E0554, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_DA0 */
	{0x020E0558, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_DA1 */
	{0x020E055C, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_DA10 */
	{0x020E0560, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_DA11 */
	{0x020E0564, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_DA12 */
	{0x020E0568, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_DA13 */
	{0x020E056C, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_DA14 */
	{0x020E0570, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_DA15 */
	{0x020E0574, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_DA2 */
	{0x020E0578, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_DA3 */
	{0x020E057C, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_DA4 */
	{0x020E0580, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_DA5 */
	{0x020E0584, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_DA6 */
	{0x020E0588, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_DA7 */
	{0x020E058C, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_DA8 */
	{0x020E0590, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_DA9 */
	{0x020E05A8, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_OE */
	{0x020E05AC, 0x0000B0B1}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_RW */
	{0x020E05B0, 0x0000B060}, /* IOMUXC_SW_PAD_CTL_PAD_EIM_WAIT */
	{0x020E05C0, 0x000130F1}, /* IOMUXC_SW_PAD_CTL_PAD_ENET_REF_CLK */
	{0x020E05D0, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN */
	{0x020E05D8, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_ENET_TXD1 */
	{0x020E05DC, 0x000120B0}, /* IOMUXC_SW_PAD_CTL_PAD_GPIO_0 */
	{0x020E05E0, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_GPIO_1 */
	{0x020E05E8, 0x000120B0}, /* IOMUXC_SW_PAD_CTL_PAD_GPIO_17 */
	{0x020E05F4, 0x000120B0}, /* IOMUXC_SW_PAD_CTL_PAD_GPIO_2 */
	{0x020E05F8, 0x000120B0}, /* IOMUXC_SW_PAD_CTL_PAD_GPIO_3 */
	{0x020E05FC, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_GPIO_4 */
	{0x020E0600, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_GPIO_5 */
	{0x020E0608, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_GPIO_7 */
	{0x020E060C, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_GPIO_8 */
	{0x020E0638, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_KEY_COL3 */
	{0x020E063C, 0x000120B0}, /* IOMUXC_SW_PAD_CTL_PAD_KEY_COL4 */
	{0x020E064C, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_KEY_ROW3 */
	{0x020E0650, 0x000120B0}, /* IOMUXC_SW_PAD_CTL_PAD_KEY_ROW4 */
	{0x020E066C, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_NANDF_D0 */
	{0x020E0670, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_NANDF_D1 */
	{0x020E0694, 0x0001B038}, /* IOMUXC_SW_PAD_CTL_PAD_RGMII_RD0 */
	{0x020E0698, 0x0001B038}, /* IOMUXC_SW_PAD_CTL_PAD_RGMII_RD1 */
	{0x020E069C, 0x0001B038}, /* IOMUXC_SW_PAD_CTL_PAD_RGMII_RD2 */
	{0x020E06A0, 0x0001B038}, /* IOMUXC_SW_PAD_CTL_PAD_RGMII_RD3 */
	{0x020E06A4, 0x00013038}, /* IOMUXC_SW_PAD_CTL_PAD_RGMII_RX_CTL */
	{0x020E06A8, 0x00013038}, /* IOMUXC_SW_PAD_CTL_PAD_RGMII_RXC */
	{0x020E06AC, 0x0001B038}, /* IOMUXC_SW_PAD_CTL_PAD_RGMII_TD0 */
	{0x020E06B0, 0x0001B038}, /* IOMUXC_SW_PAD_CTL_PAD_RGMII_TD1 */
	{0x020E06B4, 0x0001B038}, /* IOMUXC_SW_PAD_CTL_PAD_RGMII_TD2 */
	{0x020E06B8, 0x0001B038}, /* IOMUXC_SW_PAD_CTL_PAD_RGMII_TD3 */
	{0x020E06BC, 0x00013038}, /* IOMUXC_SW_PAD_CTL_PAD_RGMII_TX_CTL */
	{0x020E06C0, 0x00013038}, /* IOMUXC_SW_PAD_CTL_PAD_RGMII_TXC */
	{0x020E06C4, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD1_CLK */
	{0x020E06C8, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD1_CMD */
	{0x020E06CC, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD1_DAT0 */
	{0x020E06D0, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD1_DAT1 */
	{0x020E06D4, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD1_DAT2 */
	{0x020E06D8, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD1_DAT3 */
	{0x020E06DC, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD2_CLK */
	{0x020E06E0, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD2_CMD */
	{0x020E06E4, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD2_DAT0 */
	{0x020E06E8, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD2_DAT1 */
	{0x020E06EC, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD2_DAT2 */
	{0x020E06F0, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD2_DAT3 */
	{0x020E06F4, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD3_CLK */
	{0x020E06F8, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD3_CMD */
	{0x020E06FC, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD3_DAT0 */
	{0x020E0700, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD3_DAT1 */
	{0x020E0704, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD3_DAT2 */
	{0x020E0708, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD3_DAT3 */
	{0x020E070C, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD3_DAT4 */
	{0x020E0710, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD3_DAT5 */
	{0x020E0714, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD3_DAT6 */
	{0x020E0718, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD3_DAT7 */
	{0x020E071C, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD3_RST */
	{0x020E0720, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD4_CLK */
	{0x020E0724, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD4_CMD */
	{0x020E0738, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD4_DAT4 */
	{0x020E0744, 0x0001B0B0}, /* IOMUXC_SW_PAD_CTL_PAD_SD4_DAT7 */
	{0x020E0768, 0x000C0000}, /* IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII */
	{0x020E0788, 0x00000000}, /* IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM */
	{0x020E07C8, 0x00000000}, /* IOMUXC_CAN1_IPP_IND_CANRX_SELECT_INPUT */
	{0x020E0814, 0x00000001}, /* IOMUXC_ENET_IPP_IND_MAC0_RXCLK_SELECT_INPUT */
	{0x020E0818, 0x00000001}, /* IOMUXC_ENET_IPP_IND_MAC0_RXDATA_0_SELECT_INPUT */
	{0x020E081C, 0x00000001}, /* IOMUXC_ENET_IPP_IND_MAC0_RXDATA_1_SELECT_INPUT */
	{0x020E0820, 0x00000001}, /* IOMUXC_ENET_IPP_IND_MAC0_RXDATA_2_SELECT_INPUT */
	{0x020E0824, 0x00000001}, /* IOMUXC_ENET_IPP_IND_MAC0_RXDATA_3_SELECT_INPUT */
	{0x020E0828, 0x00000001}, /* IOMUXC_ENET_IPP_IND_MAC0_RXEN_SELECT_INPUT */
	{0x020E0870, 0x00000000}, /* IOMUXC_I2C2_IPP_SCL_IN_SELECT_INPUT */
	{0x020E0874, 0x00000000}, /* IOMUXC_I2C2_IPP_SDA_IN_SELECT_INPUT */
	{0x020E0880, 0x00000000}, /* IOMUXC_I2C4_IPP_SCL_IN_SELECT_INPUT */
	{0x020E0884, 0x00000000}, /* IOMUXC_I2C4_IPP_SDA_IN_SELECT_INPUT */
	{0x020E08D8, 0x00000000}, /* IOMUXC_LCDIF_LCDIF_BUSY_SELECT_INPUT */
	{0x020E0904, 0x00000006}, /* IOMUXC_UART2_IPP_UART_RXD_MUX_SELECT_INPUT */
	{0x020E090C, 0x00000002}, /* IOMUXC_UART3_IPP_UART_RXD_MUX_SELECT_INPUT */
	{0x020E0928, 0x00000001}, /* IOMUXC_USDHC1_IPP_CARD_CLK_IN_SELECT_INPUT */
	{0x020E0930, 0x00000001}, /* IOMUXC_USDHC2_IPP_CARD_CLK_IN_SELECT_INPUT */
	{0x020E0934, 0x00000001}, /* IOMUXC_USDHC3_IPP_CARD_CLK_IN_SELECT_INPUT */
	/* NOR/WEIM controller settings */
	{0x020C401C, 0x21900000},	/* CSCMR1[30-29]: 01 -> Select PLL3 480MHz, CSCMR1[25-23]: 011 -> divide by 4 => 120MHz EIM clock */
	{0x021B8000, 0x10020281},	/* EIM_CS0GCR1, 16 words per read page */
	{0x021B8004, 0x00000001},
	{0x021B8008, 0x0E020000},	/* 14 cycles wait when reading a new page */
	{0x021B800C, 0x00008000},	/* 2 cycles wait inside the read page */
	{0x021B8010, 0x0804a240},
	{0x021B8014, 0x00000000},
	{0x021B8090, 0x00000120},	/* WEIM_WCR */
	{0x020E0004, 0x48400005},	/* IOMUXC_IOMUXC_GPR1: CS0 = 128 MB */
	{END_OF_TABLE},
};

static const env_entry board_env_icama1[] = {
		 {"dnl_script_addr", "0x17700000"},
		 {"cpucount", "nosmp"},
		 {"ipaddr", "160.48.199.117"},
		 {"serverip", "160.48.199.6"},
		 {"console", "ttymxc1"},
		 {"set_ethaddr", "setenv ethaddr aa:bb:cc:dd:ee:ff; "
			"echo No MAC Addr in fuse. Using $ethaddr"},
		 {"check_ethaddr", "if printenv ethaddr; "
			"then echo Using MAC from fuse $ethaddr; "
			"else run set_ethaddr;fi"},
		 {"icam_dnl", "run check_ethaddr; "
			"echo Starting iCAM Download ...; "
			"tftp ${dnl_script_addr} icam_dnl.scr;"
			"source ${dnl_script_addr}; "},
		 {"gen3boot", "run icam_dnl;"},
		 {0, 0}
};

static void board_init_icama1(void)
{
	enable_enet_clk(1);
	return;
}

const board_config board_data_icama1 = {
	.name = "MX6S-iCAM-A1",
	.dcd = dcd_icama1_solo,
	/*
	 * Below definitions are used only with the generic mx6gen3 target.
	 * The mx6sjacc2a build will use the hard coded defines from
	 * include/configs/mx6sjacc2a.h, instead.
	 */
	.env = board_env_icama1,
	.ram_size = 1u * 512 * 1024 * 1024,
	.board_init = board_init_icama1,
	.uart = UART2_BASE,
	.env_dev = ENV_GEN3_DEV_FLASH,
	.n_use_fixed_phy = 1,
	.n_keep_env_in_recovery_mode = 1,
};
#endif
