/*
 * Copyright (C) 2013 Robert Bosch Car Multimedia GmbH
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <asm/arch/system.h>
#include <config.h>
#include <asm/imx-common/gpio.h>

#ifdef CONFIG_BOARD_MY16_B1B3_MX6DL
static const dcd_config dcd_my16b1b3_dl[] = {
	/* {<u32 address>, <u32 value>}, */
	{0x020E004C, 0x00000003},
	{0x020E0050, 0x00000003},
	{0x020E0054, 0x00000000},
	{0x020E0058, 0x00000000},
	{0x020E005C, 0x00000000},
	{0x020E0060, 0x00000000},
	{0x020E0064, 0x00000000},
	{0x020E0068, 0x00000000},
	{0x020E006C, 0x00000000},
	{0x020E0070, 0x00000000},
	{0x020E0074, 0x00000004},
	{0x020E0078, 0x00000004},
	{0x020E007C, 0x00000004},
	{0x020E0080, 0x00000004},
	{0x020E0084, 0x00000014},
	{0x020E0088, 0x00000014},
	{0x020E008C, 0x00000000},
	{0x020E0090, 0x00000000},
	{0x020E0094, 0x00000000},
	{0x020E0098, 0x00000000},
	{0x020E00A0, 0x00000002},
	{0x020E00A8, 0x00000002},
	{0x020E00AC, 0x00000002},
	{0x020E00B0, 0x00000002},
	{0x020E00B4, 0x00000002},
	{0x020E00D0, 0x00000002},
	{0x020E00D4, 0x00000002},
	{0x020E00DC, 0x00000002},
	{0x020E00E0, 0x00000002},
	{0x020E0108, 0x00000002},
	{0x020E0144, 0x00000000},
	{0x020E0148, 0x00000000},
	{0x020E014C, 0x00000000},
	{0x020E0150, 0x00000000},
	{0x020E0154, 0x00000000},
	{0x020E0158, 0x00000000},
	{0x020E015C, 0x00000000},
	{0x020E0160, 0x00000000},
	{0x020E0164, 0x00000000},
	{0x020E0168, 0x00000000},
	{0x020E016C, 0x00000000},
	{0x020E0170, 0x00000000},
	{0x020E0174, 0x00000000},
	{0x020E0178, 0x00000000},
	{0x020E017C, 0x00000000},
	{0x020E0180, 0x00000000},
	{0x020E01C4, 0x00000005},
	{0x020E01C8, 0x00000005},
	{0x020E01D4, 0x00000005},
	{0x020E01E8, 0x00000000},
	{0x020E01EC, 0x00000001},
	{0x020E01F0, 0x00000001},
	{0x020E01FC, 0x00000000},
	{0x020E0208, 0x00000000},
	{0x020E020C, 0x00000006},
	{0x020E0210, 0x00000003},
	{0x020E0214, 0x00000016},
	{0x020E0228, 0x00000006},
	{0x020E022C, 0x00000005},
	{0x020E0230, 0x00000016},
	{0x020E0240, 0x00000007},
	{0x020E0244, 0x00000004},
	{0x020E0248, 0x00000004},
	{0x020E024C, 0x00000004},
	{0x020E0250, 0x00000014},
	{0x020E0254, 0x00000002},
	{0x020E0258, 0x00000004},
	{0x020E025C, 0x00000004},
	{0x020E0264, 0x00000014},
	{0x020E0268, 0x00000002},
	{0x020E02AC, 0x00000001},
	{0x020E02B0, 0x00000001},
	{0x020E02B4, 0x00000001},
	{0x020E02B8, 0x00000001},
	{0x020E02BC, 0x00000001},
	{0x020E02C0, 0x00000001},
	{0x020E02C4, 0x00000001},
	{0x020E02C8, 0x00000001},
	{0x020E02CC, 0x00000001},
	{0x020E02D0, 0x00000001},
	{0x020E02D4, 0x00000001},
	{0x020E02D8, 0x00000001},
	{0x020E02FC, 0x00000003},
	{0x020E0300, 0x00000003},
	{0x020E0304, 0x00000003},
	{0x020E0308, 0x00000003},
	{0x020E030C, 0x00000000},
	{0x020E0310, 0x00000000},
	{0x020E0314, 0x00000000},
	{0x020E0318, 0x00000000},
	{0x020E031C, 0x00000000},
	{0x020E0320, 0x00000000},
	{0x020E0324, 0x00000000},
	{0x020E0328, 0x00000000},
	{0x020E032C, 0x00000000},
	{0x020E0330, 0x00000000},
	{0x020E0334, 0x00000000},
	{0x020E0338, 0x00000000},
	{0x020E033C, 0x00000000},
	{0x020E0340, 0x00000001},
	{0x020E0344, 0x00000001},
	{0x020E0348, 0x00000001},
	{0x020E034C, 0x00000001},
	{0x020E0350, 0x00000002},
	{0x020E0354, 0x00000002},
	{0x020E0358, 0x00000002},
	{0x020E035C, 0x00000002},
	{0x020E0398, 0x0001B098},
	{0x020E039C, 0x0001B098},
	{0x020E041C, 0x0001B098},
	{0x020E04E0, 0x0000A0A1},
	{0x020E04E4, 0x0000A0A1},
	{0x020E04E8, 0x0000A0A1},
	{0x020E04EC, 0x0000A0A1},
	{0x020E04F0, 0x0000A0A1},
	{0x020E04F4, 0x0000A0A1},
	{0x020E04F8, 0x0000A0A1},
	{0x020E04FC, 0x0000A0A1},
	{0x020E0500, 0x0000A0A1},
	{0x020E0504, 0x000030A1},
	{0x020E050C, 0x000070A1},
	{0x020E0510, 0x000070A1},
	{0x020E0514, 0x000130A1},
	{0x020E0518, 0x000130A1},
	{0x020E051C, 0x000130A1},
	{0x020E0520, 0x000130A1},
	{0x020E0524, 0x000130A1},
	{0x020E0528, 0x000130A1},
	{0x020E052C, 0x000130A1},
	{0x020E0530, 0x000130A1},
	{0x020E0534, 0x000130A1},
	{0x020E0538, 0x000130A1},
	{0x020E053C, 0x000130A1},
	{0x020E0540, 0x000130A1},
	{0x020E0544, 0x000130A1},
	{0x020E0548, 0x000130A1},
	{0x020E054C, 0x000130A1},
	{0x020E0550, 0x000130A1},
	{0x020E0554, 0x0000A0A1},
	{0x020E0558, 0x0000A0A1},
	{0x020E055C, 0x0000A0A1},
	{0x020E0560, 0x0000A0A1},
	{0x020E0564, 0x0000A0A1},
	{0x020E0568, 0x0000A0A1},
	{0x020E056C, 0x0000A0A1},
	{0x020E0570, 0x0000A0A1},
	{0x020E0574, 0x0000A0A1},
	{0x020E0578, 0x0000A0A1},
	{0x020E057C, 0x0000A0A1},
	{0x020E0580, 0x0000A0A1},
	{0x020E0584, 0x0000A0A1},
	{0x020E0588, 0x0000A0A1},
	{0x020E058C, 0x0000A0A1},
	{0x020E0590, 0x0000A0A1},
	{0x020E05A8, 0x0000B0A1},
	{0x020E05AC, 0x0000A0A1},
	{0x020E05B0, 0x0000A060},
	{0x020E05DC, 0x000170B0},
	{0x020E05E0, 0x0001B0B0},
	{0x020E05E4, 0x0001B098},
	{0x020E05FC, 0x0001B0B0},
	{0x020E0600, 0x0001B098},
	{0x020E0604, 0x000130B0},
	{0x020E062C, 0x0001B060},
	{0x020E0640, 0x0001B060},
	{0x020E0694, 0x0001B028},
	{0x020E0698, 0x0001B028},
	{0x020E069C, 0x0001B028},
	{0x020E06A0, 0x0001B028},
	{0x020E06A4, 0x00013028},
	{0x020E06A8, 0x00013028},
	{0x020E06AC, 0x0001B028},
	{0x020E06B0, 0x0001B028},
	{0x020E06B4, 0x0001B028},
	{0x020E06B8, 0x0001B028},
	{0x020E06BC, 0x00013028},
	{0x020E06C0, 0x00013028},
	{0x020E06EC, 0x0001B098},
	{0x020E06F0, 0x0001B0A0},
	{0x020E06F4, 0x0001A0A1},
	{0x020E06F8, 0x0001A0A1},
	{0x020E06FC, 0x0001A0A1},
	{0x020E0700, 0x0001A0A1},
	{0x020E0704, 0x0001A0A1},
	{0x020E0708, 0x0001A0A1},
	{0x020E070C, 0x0001A0A1},
	{0x020E0710, 0x0001A0A1},
	{0x020E0714, 0x0001A0A1},
	{0x020E0718, 0x0001A0A1},
	{0x020E071C, 0x0001A0A1},
	{0x020E0720, 0x0001B090},
	{0x020E0724, 0x0001B090},
	{0x020E0728, 0x0001B090},
	{0x020E072C, 0x0001B090},
	{0x020E0730, 0x0001B090},
	{0x020E0734, 0x0001B090},
	{0x020E0738, 0x0001B098},
	{0x020E073C, 0x0001B098},
	{0x020E0740, 0x0001B098},
	{0x020E0744, 0x0001B098},
	{0x020E0790, 0x00000001},
	{0x020E0798, 0x00000001},
	{0x020E07A8, 0x00000001},
	{0x020E07AC, 0x00000001},
	{0x020E07F8, 0x00000001},
	{0x020E0814, 0x00000001},
	{0x020E0818, 0x00000001},
	{0x020E081C, 0x00000001},
	{0x020E0820, 0x00000001},
	{0x020E0824, 0x00000001},
	{0x020E0870, 0x00000001},
	{0x020E0874, 0x00000001},
	{0x020E0878, 0x00000002},
	{0x020E087C, 0x00000001},
	{0x020E08FC, 0x00000001},
	{0x020E0900, 0x00000004},
	{0x020E0904, 0x00000006},
	{0x020E0914, 0x00000003},
	{0x020E091C, 0x00000003},
	{0x020E0920, 0x00000001},
	{0x020E0924, 0x00000001},
	{0x020E0934, 0x00000001},
	{0x020E0938, 0x00000001},
	/*gpio settings*/
	{0x0209C000, 0x18180800},
	{0x0209C004, 0x19180900},
	{0x020A0000, 0x50000021},
	{0x020A0004, 0x780000B7},
	{0x020A4000, 0x00000000},
	{0x020A4004, 0x00000000},
	{0x020A8000, 0x18050020},
	{0x020A8004, 0x1F050020},
	{0x020AC000, 0x00001000},
	{0x020AC004, 0x000013C0},
	{0x020B0000, 0x00000100},
	{0x020B0004, 0x00008100},
	{0x020B4000, 0x00000000},
	{0x020B4004, 0x00001000},
	/* NOR/WEIM controller settings (TODO: timing!!!) */
	{0x020C401C, 0x21900000}, /* CSCMR1[30-29]: 01 -> Select PLL3 480MHz, CSCMR1[25-23]: 011 -> divide by 4 => 120MHz EIM clock */
	{0x021B8000, 0x10020281}, /* EIM_CS0CGR1, 16 words per read page */
	{0x021B8004, 0x00000001},
	{0x021B8008, 0x0D002000}, /* 13 cycles wait when reading a new page */
	{0x021B800C, 0x00008000}, /* 2 cycles wait inside the read page */
	{0x021B8010, 0x10000440},
	{0x021B8014, 0x00000000},
	{0x021B8090, 0x00000000}, /* WEIM_WCR */
	{0x020E0004, 0x48400005}, /* IOMUXC_IOMUXC_GPR1: CS0 = 128 MB */
	{END_OF_TABLE},
};

static const env_entry board_env_my16b1b3[] = {
		 {"cpucount", "maxcpus=2"},
		 {"console", "ttymxc3"},
		 {"gen3boot", "echo Booting from parallel NOR ...; " \
				 "run kernelargs;" \
				 "run loaddtb; " \
				 "bootm ${kerneladdr} - ${dtbaddr}"},
		 {0, 0}
};

static const struct sw_opt_gpio sw_opt_gpio_my16b1b3 = {
	.sw_opt = { IMX_GPIO_NR(6, 10), IMX_GPIO_NR(6, 11) },
};

const board_config board_data_my16b1b3_dl = {
	.name = "MX6DL-MY16-B1/B3",
	.dcd = dcd_my16b1b3_dl,
	/*
	 * Below definitions are used only with the generic mx6gen3 target.
	 */
	 .env = board_env_my16b1b3,
	 .ram_size = 1u * 1024 * 1024 * 1024,
	 .uart = UART4_BASE,
	 .env_dev = ENV_GEN3_DEV_FLASH,
	 .sw_opt = &sw_opt_gpio_my16b1b3,
};
#endif
