/*
 * Copyright (C) 2013 Robert Bosch Car Multimedia GmbH
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <asm/arch/sys_proto.h>
#include <asm/gpio.h>
#include <asm/io.h>

#ifdef CONFIG_CMD_MMC
#include <mmc.h>
#include <fsl_esdhc.h>
#include <asm/arch/clock.h>
#endif

DECLARE_GLOBAL_DATA_PTR;

int dram_init(void)
{
	gd->ram_size = get_ram_size((void *)PHYS_SDRAM, PHYS_SDRAM_SIZE);

	return 0;
}

#ifdef CONFIG_USB_EHCI_MX6
int board_ehci_hcd_init(int port)
{
	return 0;
}
#endif

#define ICAM_A1_GPIO_NOR0_RESET IMX_GPIO_NR(2, 0)
#define ICAM_A1_GPIO_SD_CD IMX_GPIO_NR(1, 1)

static void setup_misc_iomux(void)
{
	gpio_direction_output(ICAM_A1_GPIO_NOR0_RESET, 1);
	gpio_direction_input(ICAM_A1_GPIO_SD_CD);
}

#ifdef CONFIG_CMD_MMC
enum icam_mmc_t {
	ICAM_MMC_EMMC = USDHC3_BASE_ADDR,
	ICAM_MMC_SD_DEBUG = USDHC2_BASE_ADDR,
};

struct fsl_esdhc_cfg usdhc_cfg[] = {
	{ICAM_MMC_SD_DEBUG},
	{ICAM_MMC_EMMC},	/* eMMC iCAM */
};

int board_mmc_getcd(struct mmc *mmc)
{
	/* no card detect; always on */
	return 1;
}

int usdhc_gpio_init(bd_t *bis)
{
	s32 status = 0;
	u32 index = 0;

	usdhc_cfg[0].sdhc_clk = mxc_get_clock(MXC_ESDHC2_CLK);
	usdhc_cfg[1].sdhc_clk = mxc_get_clock(MXC_ESDHC3_CLK);

	for (index = 0; index < ARRAY_SIZE(usdhc_cfg);
		++index) {
		status |= fsl_esdhc_initialize(bis, &usdhc_cfg[index]);
	}

	return status;
}

int board_mmc_init(bd_t *bis)
{
	if (!usdhc_gpio_init(bis))
		return 0;
	else
		return -1;
}
#endif

int board_early_init_f(void)
{
	dcd_config *dcd = (dcd_config *)((ocram *)IRAM_BASE_ADDR)->board->dcd;

	dcd_init(dcd);

	return 0;
}

void board_eth_use_fixed_phy(int *use_fixed_phy)
{
	*use_fixed_phy = 1;
}

int board_init(void)
{
	setup_misc_iomux();

	/* address of boot parameters */
	gd->bd->bi_boot_params = PHYS_SDRAM + 0x100;

	return 0;
}

int checkboard(void)
{
	ocram *config = (ocram *)IRAM_BASE_ADDR;

	printf("Board: %s\n", config->board->name);

	printf("Board ID: 0x%04x (#%d)\n", config->boardid, config->idcount);

	return 0;
}
