/*
 * Copyright (C) 2013 Robert Bosch Car Multimedia GmbH
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef BOOT_OPT_H_
#define BOOT_OPT_H_

enum enBootOpt {
	EN_RECOVERY_DOWNLOAD	= 0,
	EN_DEVELOPER_BOOT	= 1,
	EN_NORMAL_BOOT		= 2,
	EN_BOOTOPT_INVALID	= -1,
};

enum sw_opt_type {
	SW_OPT_NORMAL	= 0x3,
	SW_OPT_DOWNLOAD	= 0x2,
	SW_OPT_TEST	= 0x1,
	SW_OPT_UNDEF	= 0x0,
};

void get_sw_opt(enum sw_opt_type *);
void evaluate_boot_option(enum enBootOpt *, int *);
void evaluate_reset_counter(enum enBootOpt *, int *);
void print_boot_config(enum enBootOpt, int);
int start_ram_test(void);

#endif /* BOOT_OPT_H_ */
