/*
 * (C) Copyright 2012, Robert Bosch Car Multimedia GmbH
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef _SYSTEM_H_
#define _SYSTEM_H_

#define END_OF_TABLE	0

#ifndef __ASSEMBLY__

typedef struct {
	unsigned int address;
	unsigned int value;
} dcd_config;

typedef struct {
	const char *name;
	const char *value;
} env_entry;

typedef struct {
	unsigned int bus;
	unsigned int cs;
} sf_spi;

enum env_type {
	ENV_GEN3_DEV_INVALID = 0,
	ENV_GEN3_DEV_FLASH,	/* env in parallel NOR */
	ENV_GEN3_DEV_SPI_FLASH,	/* env in serial SPI NOR */
	ENV_GEN3_DEV_MMC,
};

struct sw_opt_gpio {
	unsigned int sw_opt[2];
};

typedef struct {
	const char *name;
	const dcd_config *dcd;
	const env_entry *env;
	const unsigned int ram_size;
	void (*board_init)(void);
	void (*board_usb_otg_init)(void);
	const sf_spi *sf;
	const struct sw_opt_gpio *sw_opt;
	const unsigned int uart;
	enum env_type env_dev;
	const int n_use_fixed_phy;
	const int n_keep_env_in_recovery_mode;
	const int n_single_rootfs;
} board_config;

typedef struct {
	unsigned short boardid;
	unsigned short idcount;
	board_config * board;
} ocram;

#endif /* _ASSEMBLY__ */

#endif /* _SYSTEM_H_ */
