/*
 * (C) Copyright 2009
 * Stefano Babic, DENX Software Engineering, sbabic@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef _SYS_PROTO_H_
#define _SYS_PROTO_H_

#include <asm/arch/system.h>

#define MXC_CPU_MX51		0x51
#define MXC_CPU_MX53		0x53
#define MXC_CPU_MX6SL		0x60
#define MXC_CPU_MX6DL		0x61
#define MXC_CPU_MX6SOLO		0x62
#define MXC_CPU_MX6Q		0x63
#define MXC_CPU_MX6D		0x64

#define soc_rev() (get_cpu_rev() & 0xFF)
#define is_soc_rev(rev)        (soc_rev() - rev)

u32 get_cpu_rev(void);

/* returns MXC_CPU_ value */
#define cpu_type(rev) (((rev) >> 12)&0xff)

/* use with MXC_CPU_ constants */
#define is_cpu_type(cpu) (cpu_type(get_cpu_rev()) == cpu)

const char *get_imx_type(u32 imxtype);
unsigned imx_ddr_size(void);
int read_cpu_temperature(void);

unsigned int get_boot_mode(void);

/*
 * Initializes on-chip ethernet controllers.
 * to override, implement board_eth_init()
 */

int fecmxc_initialize(bd_t *bis);
u32 get_ahb_clk(void);
u32 get_periph_clk(void);

/* OTP related functionality */
int imx_otp_read_one_u32(u32, u32 *);
int imx_otp_blow_one_u32(u32, u32, u32 *);
void enable_otp_clk(unsigned char);
void dcd_init(const dcd_config *);

#ifdef CONFIG_ENV_IS_DYNAMIC
unsigned long board_flash_init(void);
int env_flash_init(void);
int env_flash_saveenv(void);
void env_flash_relocate_spec(void);
int env_spi_flash_init(void);
int env_spi_flash_saveenv(void);
void env_spi_flash_relocate_spec(void);
int env_mmc_init(void);
int env_mmc_saveenv(void);
void env_mmc_relocate_spec(void);
#endif

#endif
