/*
 * PWM DEMO DRIVER
 *
 * Copyright (C) 2013 Mentor Graphics Inc.
 *
 * This file is licensed under the terms of the GNU General Public
 * License version 2. This program is licensed "as is" without any
 * warranty of any kind, whether express or implied.
 */
#ifndef _LINUX_PWM_DEMO_H
#define _LINUX_PWM_DEMO_H

#include <linux/device.h>
#include <linux/mutex.h>

struct pwm_demo_device;

struct pwm_demo_ops {
	int (*update_status)(struct pwm_demo_device *);
};

struct pwm_demo_properties {
	unsigned int max_period;
	unsigned int period;
	unsigned int duty;
	unsigned int polarity;
	unsigned int active;
};

struct pwm_demo_device {
	struct pwm_demo_properties props;
	struct mutex update_lock;
	struct mutex ops_lock;
	const struct pwm_demo_ops *ops;
	struct device dev;
};

static inline void pwm_demo_update_status(struct pwm_demo_device *dd)
{
	mutex_lock(&dd->update_lock);
	if (dd->ops && dd->ops->update_status)
		dd->ops->update_status(dd);
	mutex_unlock(&dd->update_lock);
}

extern struct pwm_demo_device *pwm_demo_device_register(const char *name,
	struct device *dev, void *devdata, const struct pwm_demo_ops *ops,
	const struct pwm_demo_properties *props);
extern void pwm_demo_device_unregister(struct pwm_demo_device *dd);

#define to_pwm_demo_device(obj) container_of(obj, struct pwm_demo_device, dev)

static inline void *pwm_demo_get_data(struct pwm_demo_device *dd)
{
	return dev_get_drvdata(&dd->dev);
}

#endif
