/*
 *  Profiling infrastructure declarations.
 *
 *  This file is based on gcc-internal definitions. Data structures are
 *  defined to be compatible with gcc counterparts. For a better
 *  understanding, refer to gcc source: gcc/gcov-io.h.
 *
 *    Copyright Mentor Graphics Corp. 2013
 *    Author(s): Jiada Wang <jiada_wang@mentor.com>
 *
 *    Uses gcc-internal data definitions.
 */

#ifndef GCOV_4_7_H
#define GCOV_4_7_H GCOV_4_7_H

#include <linux/types.h>
#include "gcov.h"

#define GCOV_COUNTERS		8

/**
 * struct gcov_ctr_info - profiling data per counter type
 * @num: number of counter values for this type
 * @values: array of counter values for this type
 *
 * This data is generated by gcc during compilation and doesn't change
 * at run-time with the exception of the values array.
 */
struct gcov_ctr_info {
	unsigned int	num;
	gcov_type	*values;
};

/**
 * struct gcov_fn_info - profiling meta data per function
 * @key: comdat key
 * @ident: object file-unique function identifier
 * @lineno_checksum: function lineo_checksum
 * @cfg_checksum: function cfg checksum
 * @ctrs: instrumented counters
 *
 * This data is generated by gcc during compilation and doesn't change
 * at run-time.
 */
struct gcov_fn_info {
	const struct gcov_info_47 *key;
	unsigned int ident;
	unsigned int lineno_checksum;
	unsigned int cfg_checksum;
	struct gcov_ctr_info ctrs[0];
};

/**
 * struct gcov_info_47 - profiling data per object file for gcc 4.7 and later
 * @version: gcov version magic indicating the gcc version used for compilation
 * @next: list head for a singly-linked list
 * @stamp: time stamp
 * @filename: name of the associated gcov data file
 * @merge: merge functions (null for unused)
 * @n_functions: number of instrumented functions
 * @functions: pointer to pointers to function information
 *
 * This data is generated by gcc during compilation and doesn't change
 * at run-time with the exception of the next pointer.
 */
struct gcov_info_47 {
	unsigned int                    version;
	struct gcov_info                *next;
	unsigned int                    stamp;
	const char                      *filename;
	void                            (*merge[GCOV_COUNTERS])
					(gcov_type *, unsigned int);
	unsigned int			n_functions;
	struct gcov_fn_info		**functions;
};

#endif /* GCOV_4_7_H */
