/*
 * Copyright (C) 2013 Mentor Graphics, Inc. All Rights Reserved.
 * Copyright 2008-2012 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */

#ifndef _UAPI__MXC_ASRC_H__
#define _UAPI__MXC_ASRC_H__

#include <linux/mxc_asrc_core.h>

#define ASRC_IOC_MAGIC	'C'

#define ASRC_REQ_PAIR			_IOW(ASRC_IOC_MAGIC, 0, \
		struct asrc_req)
#define ASRC_SECTION_PREPARE	_IO(ASRC_IOC_MAGIC, 1)
#define ASRC_CONFIG_BUFFER		_IOW(ASRC_IOC_MAGIC, 2, \
		struct section_buffer_config)
#define ASRC_SET_FILTER			_IOW(ASRC_IOC_MAGIC, 3, \
		enum filter_settings)
#define ASRC_SET_PERIOD			_IOW(ASRC_IOC_MAGIC, 4, \
		unsigned char)
#define ASRC_GET_CAPABILITY		_IOR(ASRC_IOC_MAGIC, 5, \
		struct asrc_section_capabilities)
#define ASRC_GET_BUF_CAPABILITY	_IOR(ASRC_IOC_MAGIC, 6, \
		struct buffer_capabilities)
#define ASRC_START_CONV			_IO(ASRC_IOC_MAGIC, 7)
#define ASRC_STOP_CONV			_IO(ASRC_IOC_MAGIC, 8)
#define ASRC_SETUP_SECTION		_IOW(ASRC_IOC_MAGIC, 9, \
		struct section_config)
#define ASRC_SYNC				_IOWR(ASRC_IOC_MAGIC, 10, \
		struct section_sync)
#define ASRC_INIT_SECTION		_IO(ASRC_IOC_MAGIC, 11)
#define ASRC_SET_CLK_REFERENCE	_IOW(ASRC_IOC_MAGIC, 12, \
		char *)
#define ASRC_FREE_BUFFER		_IO(ASRC_IOC_MAGIC, 13)
#define ASRC_RELEASE_PAIR		_IO(ASRC_IOC_MAGIC, 14)
#define ASRC_SECTION_XRUN		_IO(ASRC_IOC_MAGIC, 15)

struct section_buffer_config {
	unsigned long buffer_bytes;
	unsigned int periods;
};

struct section_sync {
	unsigned int appl_pos; /* provide */
	unsigned int avail_min; /* provide */
	unsigned int stop_threshold; /* provide */
	unsigned int boundary; /* provide */
	unsigned int hw_pos; /* returned */
	unsigned int state; /* returned */
};

#endif /* _UAPI__MXC_ASRC_H__ */
