/*
 * Copyright (C) 2013 Mentor Graphics, Inc. All Rights Reserved.
 * Copyright 2008-2012 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */

#ifndef __MXC_ASRC_CORE_REG_H__
#define __MXC_ASRC_CORE_REG_H__

#define ASRC_ASRCTR_REG		0x00
#define ASRC_ASRIER_REG		0x04
#define ASRC_ASRCNCR_REG	0x0C
#define ASRC_ASRCFG_REG		0x10
#define ASRC_ASRCSR_REG		0x14
#define ASRC_ASRCDR1_REG	0x18
#define ASRC_ASRCDR2_REG	0x1C
#define ASRC_ASRCDR_REG(p) \
	(p == ASRC_PAIR_C ? ASRC_ASRCDR2_REG : ASRC_ASRCDR1_REG)
#define ASRC_ASRCDR_MASK(p) \
	(p == ASRC_PAIR_A ? 0xfc0fc0 : p == ASRC_PAIR_B ? 0x03f03f : 0)
#define ASRC_ASRSTR_REG		0x20
#define ASRC_ASRRA_REG		0x24
#define ASRC_ASRRB_REG		0x28
#define ASRC_ASRRC_REG		0x2C
#define ASRC_ASRPM1_REG		0x40
#define ASRC_ASRPM2_REG		0x44
#define ASRC_ASRPM3_REG		0x48
#define ASRC_ASRPM4_REG		0x4C
#define ASRC_ASRPM5_REG		0x50
#define ASRC_ASRTFR1		0x54
#define ASRC_ASRCCR_REG		0x5C
#define ASRC_ASRDIA_REG		0x60
#define ASRC_ASRDOA_REG		0x64
#define ASRC_ASRDIB_REG		0x68
#define ASRC_ASRDOB_REG		0x6C
#define ASRC_ASRDIC_REG		0x70
#define ASRC_ASRDOC_REG		0x74
#define ASRC_ASRIDRHA_REG	0x80
#define ASRC_ASRIDRLA_REG	0x84
#define ASRC_ASRIDRHB_REG	0x88
#define ASRC_ASRIDRLB_REG	0x8C
#define ASRC_ASRIDRHC_REG	0x90
#define ASRC_ASRIDRLC_REG	0x94
#define ASRC_ASR76K_REG		0x98
#define ASRC_ASR56K_REG		0x9C
#define ASRC_ASRMCRA_REG	0xA0
#define ASRC_ASRFSTA_REG	0xA4
#define ASRC_ASRMCRB_REG	0xA8
#define ASRC_ASRFSTB_REG	0xAC
#define ASRC_ASRMCRC_REG	0xB0
#define ASRC_ASRFSTC_REG	0xB4
#define ASRC_ASRMCR1A_REG	0xC0
#define ASRC_ASRMCR1B_REG	0xC4
#define ASRC_ASRMCR1C_REG	0xC8
#define ASRC_ASRMCR_REG(p)	(0xA0 + 8 * p)
#define ASRC_ASRFST_REG(p)	(0xA4 + 8 * p)
#define ASRC_ASRMCR1_REG(p)	(0xC0 + 4 * p)

#define ASRIER_AFPWE_EN	0x00000080	/* FP in Wait State Interrupt Enable */
#define ASRIER_AOLIE_EN	0x00000040	/* Overload Interrupt Enable */
#define ASRIER_ADOEC_EN	0x00000020	/* Data Output C Interrupt Enable */
#define ASRIER_ADOEB_EN	0x00000010	/* Data Output B Interrupt Enable */
#define ASRIER_ADOEA_EN	0x00000008	/* Data Output A Interrupt Enable */
#define ASRIER_ADIEC_EN	0x00000004	/* Data Input C Interrupt Enable */
#define ASRIER_ADIEB_EN	0x00000002	/* Data Input B Interrupt Enable */
#define ASRIER_ADIEA_EN	0x00000001	/* Data Input A Interrupt Enable */

#define ASRCFG_MOD_UP		0x0
#define ASRCFG_MOD_DIRECT	0x1
#define ASRCFG_MOD_DOWN		0x2
#define ASRCFG_MOD_PASSTHRU	0x3

#define GET_PER_ADDR(ba, d, idx) ((u32)ba + \
		((d == SECTION_INPUT) ? ASRC_ASRDIA_REG : ASRC_ASRDOA_REG) +\
				(idx << 3))

/*
 * Convenience masks for the CSR register
 */
#define CSR_AOCS_SET(p, x) ((x & 0xF) << (12 + 4 * p))
#define CSR_AOCS_GET(p, x) ((x >> (12 + 4 * p)) & 0xF)
#define CSR_AICS_SET(p, x) ((x & 0xF) << (0 + 4 * p))
#define CSR_AICS_GET(p, x) ((x >> (0 + 4 * p)) & 0xF)

/*
 * Convenience masks for the CCR register
 */
#define CCR_ACOC_SHIFT	20
#define CCR_ACOC_MASK	0x00F00000
#define CCR_ACOC_GET(x)	\
	(((x) & CCR_ACOC_MASK) >> CCR_ACOC_SHIFT)

#define CCR_ACOB_SHIFT	16
#define CCR_ACOB_MASK	0x000F0000
#define CCR_ACOB_GET(x)	\
	(((x) & CCR_ACOB_MASK) >> CCR_ACOB_SHIFT)

#define CCR_ACOA_SHIFT	12
#define CCR_ACOA_MASK	0x0000F000
#define CCR_ACOA_GET(x)	\
	(((x) & CCR_ACOA_MASK) >> CCR_ACOA_SHIFT)

#define CCR_ACIC_SHIFT	8
#define CCR_ACIC_MASK	0x00000F00
#define CCR_ACIC_GET(x)	\
	(((x) & CCR_ACIC_MASK) >> CCR_ACIC_SHIFT)

#define CCR_ACIB_SHIFT	4
#define CCR_ACIB_MASK	0x000000F0
#define CCR_ACIB_GET(x)	\
	(((x) & CCR_ACIB_MASK) >> CCR_ACIB_SHIFT)

#define CCR_ACIA_SHIFT	0
#define CCR_ACIA_MASK	0x0000000F
#define CCR_ACIA_GET(x)	\
	(((x) & CCR_ACIA_MASK) >> CCR_ACIA_SHIFT)

#define CDR_AICDA	3	/* Input Clock Prescaler A Offset */
#define CDR_AICDB	9	/* Input Clock Prescaler B Offset */
#define CDR_AOCDA	15	/* Output Clock Prescaler A Offset */
#define CDR_AOCDB	21	/* Output Clock Prescaler B Offset */
#define CDR_AICDC	3	/* Input Clock Prescaler C Offset */
#define CDR_AOCDC	9	/* Output Clock Divider C Offset */

/* Input Clock Divider Offset */
#define CDR_AICP(p)	(p == ASRC_PAIR_A ? 0 : p == ASRC_PAIR_B ? 6 : 0)
/* Output Clock Divider A Offset */
#define CDR_AOCP(p)	(p == ASRC_PAIR_A ? 12 : p == ASRC_PAIR_B ? 18 : 6)

#define MCRX_EXTTHRSH_OFFSET		22
#define MCRX_EXTTHRSH_WIDTH		1
#define MCRX_BUFSTALL_OFFSET		21
#define MCRX_BUFSTALL_WIDTH		1
#define MCRX_ZEROBUFF_OFFSET		23
#define MCRX_ZEROBUFF_WIDTH		1
#define MCRX_OUTFIFO_THRESH_OFFSET	12
#define MCRX_OUTFIFO_THRESH_WIDTH	6
#define MCRX_INFIFO_THRESH_OFFSET	0
#define MCRX_INFIFO_THRESH_WIDTH	6
#define FSTX_OUTFIFO_FILL_OFFSET	12
#define FSTX_OUTFIFO_FILL_WIDTH		6
#define FSTX_INFIFO_FILL_OFFSET		0
#define FSTX_INFIFO_FILL_WIDTH		6
#define MCR1X_INFIFO_ALIGN_OFFSET	8
#define MCR1X_INFIFO_ALIGN_WIDTH	1
#define MCR1X_OUTFIFO_ALIGN_OFFSET	2
#define MCR1X_OUTFIFO_ALIGN_WIDTH	1
#define MCR1X_INFIFO_DATA_SIZE_OFFSET	9
#define MCR1X_INFIFO_DATA_SIZE_WIDTH	3
#define MCR1X_OUTFIFO_DATA_SIZE_OFFSET	0
#define MCR1X_OUTFIFO_DATA_SIZE_WIDTH	1
#define MCR1X_OUTFIFO_SIGN_OFFSET	1
#define MCR1X_OUTFIFO_SIGN_WIDTH	1

#define IMX_ASRC_CLK_NUM 0xe
#define IMX_ASRC_PAIR_NUM 3
#define ASRC_RATIO_DECIMAL_DEPTH 26

/* ASRIER bitflag of interrupts to enable */
#define ASRIER_FLAGS (ASRIER_AOLIE_EN)

/* Convenience macros */
#define CCR_MASK(x) \
		((0xFFFFFFFF >> (32-(x##_WIDTH))))
#define CCR_GET(x, y) \
	(((x) >> (y##_OFFSET)) & CCR_MASK(y))
#define CCR_SET(x, y) \
	(((x) & CCR_MASK(y)) << (y##_OFFSET))

#endif				/* __MXC_ASRC_CORE_REG_H__ */
