/*
 * linux/inc.h
 *
 * Definitions for Inter Node Communication network layer
 *
 *   Copyright (c) 2012 Robert Bosch GmbH, Hildesheim
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#ifndef INC_H
#define INC_H

#include <linux/types.h>
#include <linux/socket.h>
#include <linux/if_ether.h>

#ifdef __KERNEL__

struct inc_hdr {
	uint8_t src_node;
	uint8_t dest_node;
	uint8_t src_lun;
	uint8_t dest_lun;
};

enum inc_state {
	INC_CHANNEL_XOFF = 0xf0,
	INC_CHANNEL_XON = 0xf1,
	INC_CHANNEL_BROKEN = 0xfe
};

/* particular protocols of the protocol family PF_INC */
#define INC_PROTO_DEFAULT	0 /*default*/
#define INC_PROTO_SSI32		1 /* sychronuos serial interface */
#define INC_NPROTO		2

#define SOL_INC SOL_TCP

#define INC_DT_NODE_PATH	"/board-configuration/inc"

#endif /*__KERNEL__*/

#endif /* INC_H */
