/*
 * adc_inc_ioctl.h
 *
 * ioctl defination for adc-inc driver
 *
 *   Copyright (c) 2013 Robert Bosch GmbH, Hildesheim
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef ADC_INC_IOCTL_H
#define ADC_INC_IOCTL_H

#include <linux/bosch_ioctl.h>
#include <stdbool.h>

enum devadc_comparision {
	devadc_threshold_lt = 0,
	devadc_threshold_gt,
};

struct dev_threshold {
	u_int16_t u16threshold;
	enum devadc_comparision encomparision;
	bool benable;
};

struct dev_resolution {
	u_int8_t adc_resolution;
};

#define PE_DEVADC_IOCSET_THRESHOLD _IOW(BOSCH_MAGIC_ADC_INC, 1\
							, struct dev_threshold)
#define PE_DEVADC_IOCGET_CONFIG    _IOR(BOSCH_MAGIC_ADC_INC, 2\
							, struct dev_resolution)

#endif /* ADC_INC_IOCTL_H_ */
