/*
 * Copyright 2013 Mentor Graphics, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef __DTS_IMX6DQ_SYSCLK_SSI_H
#define __DTS_IMX6DQ_SYSCLK_SSI_H

/* SSI System Clock Directions */
#define SYSCLK_SSI_DIR_IN		0
#define SYSCLK_SSI_DIR_OUT		1

/* SSI System Clock IDs */
#define SYSCLK_SSI_FSYS			0

/* SSI System Clock Dividers
In synchronous mode only tx dividers are needed
In asynchronous mode tx and rx dividers are needed
we are distinguishing between rx and tx internally */
#define SYSCLK_SSI_DIV_DIV2		0
#define SYSCLK_SSI_DIV_PSR		1
#define SYSCLK_SSI_DIV_PM		2

#define SYSCLK_SSI_DIV_DIV2_DIVBY_1	0
#define SYSCLK_SSI_DIV_DIV2_DIVBY_2	1
#define SYSCLK_SSI_DIV_PSR_DIVBY_1	0
#define SYSCLK_SSI_DIV_PSR_DIVBY_8	1
#define SYSCLK_SSI_DIV_PM_DIVBY(X)	(X-1)

#define SYSCLK_SSI_DIV_PM_MIN		0
#define SYSCLK_SSI_DIV_PM_MAX		255

#endif /* __DTS_IMX6DQ_SYSCLK_SSI_H */
