/*
 * Freescale i.MX drm driver
 *
 * Copyright (C) 2013 Mentor Graphics
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef _INCLUDE_DRM_IMX_DRM_H_
#define _INCLUDE_DRM_IMX_DRM_H_

#include <uapi/drm/drm.h>

struct drm_imx_get_phys {
	uint32_t handle;
	uint32_t paddr;
};

struct drm_imx_global_alpha {
	bool     enable;
	uint32_t plane_id;
	uint8_t  value;
};

struct drm_imx_chromakey {
	bool     enable;
	uint32_t plane_id;
	uint32_t key;
};

#define DRM_IMX_GAMMA_SIZE         16
struct drm_imx_gamma {
	bool     enable;
	uint32_t crtc_id;
	uint32_t m[DRM_IMX_GAMMA_SIZE];
	uint32_t b[DRM_IMX_GAMMA_SIZE];
};

#define DRM_IMX_GET_PHYS           0x00
#define DRM_IMX_GET_GLOBAL_ALPHA   0x01
#define DRM_IMX_SET_GLOBAL_ALPHA   0x02
#define DRM_IMX_GET_CHROMAKEY      0x03
#define DRM_IMX_SET_CHROMAKEY      0x04
#define DRM_IMX_SET_GAMMA          0x05

#define DRM_IOCTL_IMX_GET_PHYS						\
	DRM_IOWR(DRM_COMMAND_BASE + DRM_IMX_GET_PHYS,        struct drm_imx_get_phys)
#define DRM_IOCTL_IMX_GET_GLOBAL_ALPHA					\
	DRM_IOR(DRM_COMMAND_BASE + DRM_IMX_GET_GLOBAL_ALPHA, struct drm_imx_global_alpha)
#define DRM_IOCTL_IMX_SET_GLOBAL_ALPHA					\
	DRM_IOW(DRM_COMMAND_BASE + DRM_IMX_SET_GLOBAL_ALPHA, struct drm_imx_global_alpha)
#define DRM_IOCTL_IMX_GET_CHROMAKEY					\
	DRM_IOR(DRM_COMMAND_BASE + DRM_IMX_GET_CHROMAKEY,    struct drm_imx_chromakey)
#define DRM_IOCTL_IMX_SET_CHROMAKEY					\
	DRM_IOW(DRM_COMMAND_BASE + DRM_IMX_SET_CHROMAKEY,    struct drm_imx_chromakey)
#define DRM_IOCTL_IMX_SET_GAMMA						\
	DRM_IOW(DRM_COMMAND_BASE + DRM_IMX_SET_GAMMA,        struct drm_imx_gamma)


#endif /* _INCLUDE_DRM_IMX_DRM_H_ */
