
#ifndef __SSI32_PROT_INCLUDE__
#define __SSI32_PROT_INCLUDE__

#include <linux/inc.h>

struct ssi32_device;
struct ssi32_slavedev;


struct ssi32_dcfg {
	int bus;		/*bus nr*/
	int node;		/*node nr*/
	char mac;		/*mac*/
	__be32 addr;		/*IP addr*/
	char *ifname;		/*interface name*/
	int blocksize;		/*SSI32 blocksize*/
	int mbhdlen;		/*optional multiblock header*/
	int flowcontrol;	/*enable flowcontrol on local node*/
	int rxonly;		/*half duplex, only rx*/
	unsigned int tssr;	/*timeout t_SSR [ns]*/
	unsigned int tcd1;	/*timeout t_CD1 [ns]*/
	unsigned int tcd2;	/*timeout t_CD2 [ns]*/
	unsigned int tesr;	/*timeout t_ESR [ns]*/
	unsigned int tmri;	/*timeout t_MRI [ms]*/
	unsigned int mnr;	/*number of repeat attempts MNR*/
};

int ssi32m_register_slave_device(struct ssi32_device *ssidev,
		struct ssi32_dcfg *cfg, struct ssi32_slavedev **slaveout);
int ssi32m_unregister_slave_device(struct ssi32_slavedev *slave);
void ssi32m_configure(struct ssi32_slavedev *slave, __be32 addr);
void ssi32m_slave_srq(struct ssi32_slavedev *slave, int high);
int ssi32m_tx(void *port_handle, struct sk_buff *skb, struct inc_hdr *hdr);
void ssi32m_spi_complete(struct ssi32_slavedev *slave);
int ssi32_slave_start(struct ssi32_slavedev *slave);
void ssi32_slave_stop(struct ssi32_slavedev *slave);
void ssi32_master_start(void *port_handle);
void ssi32_master_stop(void *port_handle);
void ssi32m_dump(struct ssi32_slavedev *slave, int idx,
		char *title, char *buf, int len);

#endif /*__SSI32_PROT_INCLUDE__*/
