/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2014
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

/* Note: this is an auto-generated file. */

#include "csr_synergy.h"

#include "csr_pmem.h"
#include "csr_msgconv.h"
#include "csr_unicode.h"


#include "csr_wifi_sme_prim.h"
#include "csr_wifi_sme_serialize.h"

void CsrWifiSmePfree(void *ptr)
{
    CsrPmemFree(ptr);
}

CsrSize CsrWifiSmeBlacklistReqSizeof(void *msg)
{
    CsrWifiSmeBlacklistReq *primitive = (CsrWifiSmeBlacklistReq *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 13) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 1; /* CsrWifiSmeListAction primitive->action */
    bufferSize += 1; /* CsrUint8 primitive->setAddressCount */
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->setAddressCount; i1++)
        {
            bufferSize += 6; /* CsrUint8 primitive->setAddresses[i1].a[6] */
        }
    }
    return bufferSize;
}

CsrUint8 *CsrWifiSmeBlacklistReqSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeBlacklistReq *primitive = (CsrWifiSmeBlacklistReq *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->action);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->setAddressCount);
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->setAddressCount; i1++)
        {
            CsrMemCpySer(ptr, len, (const void *) primitive->setAddresses[i1].a, ((CsrUint16) (6)));
        }
    }
    return ptr;
}

void *CsrWifiSmeBlacklistReqDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeBlacklistReq *primitive = (CsrWifiSmeBlacklistReq *) CsrPmemAlloc(sizeof(CsrWifiSmeBlacklistReq));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->action, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->setAddressCount, buffer, &offset);
    primitive->setAddresses = NULL;
    if (primitive->setAddressCount)
    {
        primitive->setAddresses = (CsrWifiMacAddress *) CsrPmemAlloc(sizeof(CsrWifiMacAddress) * primitive->setAddressCount);
    }
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->setAddressCount; i1++)
        {
            CsrMemCpyDes(primitive->setAddresses[i1].a, buffer, &offset, ((CsrUint16) (6)));
        }
    }

    return primitive;
}

void CsrWifiSmeBlacklistReqSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeBlacklistReq *primitive = (CsrWifiSmeBlacklistReq *) voidPrimitivePointer;
    CsrPmemFree(primitive->setAddresses);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeConnectReqSizeof(void *msg)
{
    CsrWifiSmeConnectReq *primitive = (CsrWifiSmeConnectReq *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 60) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 32; /* CsrUint8 primitive->connectionConfig.ssid.ssid[32] */
    bufferSize += 1; /* CsrUint8 primitive->connectionConfig.ssid.length */
    bufferSize += 6; /* CsrUint8 primitive->connectionConfig.bssid.a[6] */
    bufferSize += 1; /* CsrWifiSmeBssType primitive->connectionConfig.bssType */
    bufferSize += 1; /* CsrWifiSme80211PrivacyMode primitive->connectionConfig.privacyMode */
    bufferSize += 2; /* CsrWifiSmeAuthModeMask primitive->connectionConfig.authModeMask */
    bufferSize += 2; /* CsrWifiSmeEncryptionMask primitive->connectionConfig.encryptionModeMask */
    bufferSize += 4; /* CsrUint32 primitive->connectionConfig.mlmeAssociateReqInformationElementsLength */
    bufferSize += primitive->connectionConfig.mlmeAssociateReqInformationElementsLength; /* CsrUint8 primitive->connectionConfig.mlmeAssociateReqInformationElements */
    bufferSize += 4; /* CsrUint32 primitive->connectionConfig.mibValuesLength */
    bufferSize += primitive->connectionConfig.mibValuesLength; /* CsrUint8 primitive->connectionConfig.mibValues */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeConnectReqSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeConnectReq *primitive = (CsrWifiSmeConnectReq *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrMemCpySer(ptr, len, (const void *) primitive->connectionConfig.ssid.ssid, ((CsrUint16) (32)));
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->connectionConfig.ssid.length);
    CsrMemCpySer(ptr, len, (const void *) primitive->connectionConfig.bssid.a, ((CsrUint16) (6)));
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->connectionConfig.bssType);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->connectionConfig.privacyMode);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionConfig.authModeMask);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionConfig.encryptionModeMask);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->connectionConfig.mlmeAssociateReqInformationElementsLength);
    if (primitive->connectionConfig.mlmeAssociateReqInformationElementsLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->connectionConfig.mlmeAssociateReqInformationElements, ((CsrUint16) (primitive->connectionConfig.mlmeAssociateReqInformationElementsLength)));
    }
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->connectionConfig.mibValuesLength);
    if (primitive->connectionConfig.mibValuesLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->connectionConfig.mibValues, ((CsrUint16) (primitive->connectionConfig.mibValuesLength)));
    }
    return ptr;
}

void *CsrWifiSmeConnectReqDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeConnectReq *primitive = (CsrWifiSmeConnectReq *) CsrPmemAlloc(sizeof(CsrWifiSmeConnectReq));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrMemCpyDes(primitive->connectionConfig.ssid.ssid, buffer, &offset, ((CsrUint16) (32)));
    CsrUint8Des((CsrUint8 *) &primitive->connectionConfig.ssid.length, buffer, &offset);
    CsrMemCpyDes(primitive->connectionConfig.bssid.a, buffer, &offset, ((CsrUint16) (6)));
    CsrUint8Des((CsrUint8 *) &primitive->connectionConfig.bssType, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->connectionConfig.privacyMode, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionConfig.authModeMask, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionConfig.encryptionModeMask, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->connectionConfig.mlmeAssociateReqInformationElementsLength, buffer, &offset);
    if (primitive->connectionConfig.mlmeAssociateReqInformationElementsLength)
    {
        primitive->connectionConfig.mlmeAssociateReqInformationElements = (CsrUint8 *) CsrPmemAlloc(primitive->connectionConfig.mlmeAssociateReqInformationElementsLength);
        CsrMemCpyDes(primitive->connectionConfig.mlmeAssociateReqInformationElements, buffer, &offset, ((CsrUint16) (primitive->connectionConfig.mlmeAssociateReqInformationElementsLength)));
    }
    else
    {
        primitive->connectionConfig.mlmeAssociateReqInformationElements = NULL;
    }
    CsrUint32Des((CsrUint32 *) &primitive->connectionConfig.mibValuesLength, buffer, &offset);
    if (primitive->connectionConfig.mibValuesLength)
    {
        primitive->connectionConfig.mibValues = (CsrUint8 *) CsrPmemAlloc(primitive->connectionConfig.mibValuesLength);
        CsrMemCpyDes(primitive->connectionConfig.mibValues, buffer, &offset, ((CsrUint16) (primitive->connectionConfig.mibValuesLength)));
    }
    else
    {
        primitive->connectionConfig.mibValues = NULL;
    }

    return primitive;
}

void CsrWifiSmeConnectReqSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeConnectReq *primitive = (CsrWifiSmeConnectReq *) voidPrimitivePointer;
    CsrPmemFree(primitive->connectionConfig.mlmeAssociateReqInformationElements);
    CsrPmemFree(primitive->connectionConfig.mibValues);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeKeyReqSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 65) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 1; /* CsrWifiSmeListAction primitive->action */
    bufferSize += 1; /* CsrWifiSmeKeyType primitive->key.keyType */
    bufferSize += 1; /* CsrUint8 primitive->key.keyIndex */
    bufferSize += 1; /* CsrBool primitive->key.wepTxKey */
    {
        CsrUint16 i2;
        for (i2 = 0; i2 < 8; i2++)
        {
            bufferSize += 2; /* CsrUint16 primitive->key.keyRsc[8] */
        }
    }
    bufferSize += 1; /* CsrBool primitive->key.authenticator */
    bufferSize += 6; /* CsrUint8 primitive->key.address.a[6] */
    bufferSize += 1; /* CsrUint8 primitive->key.keyLength */
    bufferSize += 32; /* CsrUint8 primitive->key.key[32] */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeKeyReqSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeKeyReq *primitive = (CsrWifiSmeKeyReq *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->action);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->key.keyType);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->key.keyIndex);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->key.wepTxKey);
    {
        CsrUint16 i2;
        for (i2 = 0; i2 < 8; i2++)
        {
            CsrUint16Ser(ptr, len, (CsrUint16) primitive->key.keyRsc[i2]);
        }
    }
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->key.authenticator);
    CsrMemCpySer(ptr, len, (const void *) primitive->key.address.a, ((CsrUint16) (6)));
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->key.keyLength);
    CsrMemCpySer(ptr, len, (const void *) primitive->key.key, ((CsrUint16) (32)));
    return ptr;
}

void *CsrWifiSmeKeyReqDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeKeyReq *primitive = (CsrWifiSmeKeyReq *) CsrPmemAlloc(sizeof(CsrWifiSmeKeyReq));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->action, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->key.keyType, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->key.keyIndex, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->key.wepTxKey, buffer, &offset);
    {
        CsrUint16 i2;
        for (i2 = 0; i2 < 8; i2++)
        {
            CsrUint16Des((CsrUint16 *) &primitive->key.keyRsc[i2], buffer, &offset);
        }
    }
    CsrUint8Des((CsrUint8 *) &primitive->key.authenticator, buffer, &offset);
    CsrMemCpyDes(primitive->key.address.a, buffer, &offset, ((CsrUint16) (6)));
    CsrUint8Des((CsrUint8 *) &primitive->key.keyLength, buffer, &offset);
    CsrMemCpyDes(primitive->key.key, buffer, &offset, ((CsrUint16) (32)));

    return primitive;
}

CsrSize CsrWifiSmeGetReqSizeof(void *msg)
{
    CsrWifiSmeGetReq *primitive = (CsrWifiSmeGetReq *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 10) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 4; /* CsrUint32 primitive->valuesLength */
    bufferSize += primitive->valuesLength; /* CsrUint8 primitive->values */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeGetReqSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeGetReq *primitive = (CsrWifiSmeGetReq *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->valuesLength);
    if (primitive->valuesLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->values, ((CsrUint16) (primitive->valuesLength)));
    }
    return ptr;
}

void *CsrWifiSmeGetReqDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeGetReq *primitive = (CsrWifiSmeGetReq *) CsrPmemAlloc(sizeof(CsrWifiSmeGetReq));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->valuesLength, buffer, &offset);
    if (primitive->valuesLength)
    {
        primitive->values = (CsrUint8 *) CsrPmemAlloc(primitive->valuesLength);
        CsrMemCpyDes(primitive->values, buffer, &offset, ((CsrUint16) (primitive->valuesLength)));
    }
    else
    {
        primitive->values = NULL;
    }

    return primitive;
}

void CsrWifiSmeGetReqSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeGetReq *primitive = (CsrWifiSmeGetReq *) voidPrimitivePointer;
    CsrPmemFree(primitive->values);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeSetReqSizeof(void *msg)
{
    CsrWifiSmeSetReq *primitive = (CsrWifiSmeSetReq *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 11) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 1; /* CsrBool primitive->resetMib */
    bufferSize += 4; /* CsrUint32 primitive->valuesLength */
    bufferSize += primitive->valuesLength; /* CsrUint8 primitive->values */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeSetReqSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeSetReq *primitive = (CsrWifiSmeSetReq *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->resetMib);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->valuesLength);
    if (primitive->valuesLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->values, ((CsrUint16) (primitive->valuesLength)));
    }
    return ptr;
}

void *CsrWifiSmeSetReqDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeSetReq *primitive = (CsrWifiSmeSetReq *) CsrPmemAlloc(sizeof(CsrWifiSmeSetReq));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->resetMib, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->valuesLength, buffer, &offset);
    if (primitive->valuesLength)
    {
        primitive->values = (CsrUint8 *) CsrPmemAlloc(primitive->valuesLength);
        CsrMemCpyDes(primitive->values, buffer, &offset, ((CsrUint16) (primitive->valuesLength)));
    }
    else
    {
        primitive->values = NULL;
    }

    return primitive;
}

void CsrWifiSmeSetReqSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeSetReq *primitive = (CsrWifiSmeSetReq *) voidPrimitivePointer;
    CsrPmemFree(primitive->values);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeMulticastAddressReqSizeof(void *msg)
{
    CsrWifiSmeMulticastAddressReq *primitive = (CsrWifiSmeMulticastAddressReq *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 13) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 1; /* CsrWifiSmeListAction primitive->action */
    bufferSize += 1; /* CsrUint8 primitive->setAddressesCount */
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->setAddressesCount; i1++)
        {
            bufferSize += 6; /* CsrUint8 primitive->setAddresses[i1].a[6] */
        }
    }
    return bufferSize;
}

CsrUint8 *CsrWifiSmeMulticastAddressReqSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeMulticastAddressReq *primitive = (CsrWifiSmeMulticastAddressReq *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->action);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->setAddressesCount);
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->setAddressesCount; i1++)
        {
            CsrMemCpySer(ptr, len, (const void *) primitive->setAddresses[i1].a, ((CsrUint16) (6)));
        }
    }
    return ptr;
}

void *CsrWifiSmeMulticastAddressReqDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeMulticastAddressReq *primitive = (CsrWifiSmeMulticastAddressReq *) CsrPmemAlloc(sizeof(CsrWifiSmeMulticastAddressReq));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->action, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->setAddressesCount, buffer, &offset);
    primitive->setAddresses = NULL;
    if (primitive->setAddressesCount)
    {
        primitive->setAddresses = (CsrWifiMacAddress *) CsrPmemAlloc(sizeof(CsrWifiMacAddress) * primitive->setAddressesCount);
    }
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->setAddressesCount; i1++)
        {
            CsrMemCpyDes(primitive->setAddresses[i1].a, buffer, &offset, ((CsrUint16) (6)));
        }
    }

    return primitive;
}

void CsrWifiSmeMulticastAddressReqSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeMulticastAddressReq *primitive = (CsrWifiSmeMulticastAddressReq *) voidPrimitivePointer;
    CsrPmemFree(primitive->setAddresses);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmePmkidReqSizeof(void *msg)
{
    CsrWifiSmePmkidReq *primitive = (CsrWifiSmePmkidReq *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 29) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 1; /* CsrWifiSmeListAction primitive->action */
    bufferSize += 1; /* CsrUint8 primitive->setPmkidsCount */
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->setPmkidsCount; i1++)
        {
            bufferSize += 6; /* CsrUint8 primitive->setPmkids[i1].bssid.a[6] */
            bufferSize += 16; /* CsrUint8 primitive->setPmkids[i1].pmkid[16] */
        }
    }
    return bufferSize;
}

CsrUint8 *CsrWifiSmePmkidReqSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmePmkidReq *primitive = (CsrWifiSmePmkidReq *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->action);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->setPmkidsCount);
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->setPmkidsCount; i1++)
        {
            CsrMemCpySer(ptr, len, (const void *) primitive->setPmkids[i1].bssid.a, ((CsrUint16) (6)));
            CsrMemCpySer(ptr, len, (const void *) primitive->setPmkids[i1].pmkid, ((CsrUint16) (16)));
        }
    }
    return ptr;
}

void *CsrWifiSmePmkidReqDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmePmkidReq *primitive = (CsrWifiSmePmkidReq *) CsrPmemAlloc(sizeof(CsrWifiSmePmkidReq));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->action, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->setPmkidsCount, buffer, &offset);
    primitive->setPmkids = NULL;
    if (primitive->setPmkidsCount)
    {
        primitive->setPmkids = (CsrWifiSmePmkid *) CsrPmemAlloc(sizeof(CsrWifiSmePmkid) * primitive->setPmkidsCount);
    }
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->setPmkidsCount; i1++)
        {
            CsrMemCpyDes(primitive->setPmkids[i1].bssid.a, buffer, &offset, ((CsrUint16) (6)));
            CsrMemCpyDes(primitive->setPmkids[i1].pmkid, buffer, &offset, ((CsrUint16) (16)));
        }
    }

    return primitive;
}

void CsrWifiSmePmkidReqSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmePmkidReq *primitive = (CsrWifiSmePmkidReq *) voidPrimitivePointer;
    CsrPmemFree(primitive->setPmkids);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeScanFullReqSizeof(void *msg)
{
    CsrWifiSmeScanFullReq *primitive = (CsrWifiSmeScanFullReq *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 54) */
    bufferSize += 1; /* CsrUint8 primitive->ssidCount */
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->ssidCount; i1++)
        {
            bufferSize += 32; /* CsrUint8 primitive->ssid[i1].ssid[32] */
            bufferSize += 1; /* CsrUint8 primitive->ssid[i1].length */
        }
    }
    bufferSize += 6; /* CsrUint8 primitive->bssid.a[6] */
    bufferSize += 1; /* CsrBool primitive->forceScan */
    bufferSize += 1; /* CsrWifiSmeBssType primitive->bssType */
    bufferSize += 2; /* CsrUint16 primitive->channelInfoListCount */
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->channelInfoListCount; i1++)
        {
            bufferSize += 2; /* CsrUint16 primitive->channelInfoList */
        }
    }
    bufferSize += 4; /* CsrUint32 primitive->probeIeLength */
    bufferSize += primitive->probeIeLength; /* CsrUint8 primitive->probeIe */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeScanFullReqSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeScanFullReq *primitive = (CsrWifiSmeScanFullReq *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->ssidCount);
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->ssidCount; i1++)
        {
            CsrMemCpySer(ptr, len, (const void *) primitive->ssid[i1].ssid, ((CsrUint16) (32)));
            CsrUint8Ser(ptr, len, (CsrUint8) primitive->ssid[i1].length);
        }
    }
    CsrMemCpySer(ptr, len, (const void *) primitive->bssid.a, ((CsrUint16) (6)));
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->forceScan);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->bssType);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->channelInfoListCount);
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->channelInfoListCount; i1++)
        {
            CsrUint16Ser(ptr, len, (CsrUint16) primitive->channelInfoList[i1]);
        }
    }
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->probeIeLength);
    if (primitive->probeIeLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->probeIe, ((CsrUint16) (primitive->probeIeLength)));
    }
    return ptr;
}

void *CsrWifiSmeScanFullReqDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeScanFullReq *primitive = (CsrWifiSmeScanFullReq *) CsrPmemAlloc(sizeof(CsrWifiSmeScanFullReq));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->ssidCount, buffer, &offset);
    primitive->ssid = NULL;
    if (primitive->ssidCount)
    {
        primitive->ssid = (CsrWifiSsid *) CsrPmemAlloc(sizeof(CsrWifiSsid) * primitive->ssidCount);
    }
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->ssidCount; i1++)
        {
            CsrMemCpyDes(primitive->ssid[i1].ssid, buffer, &offset, ((CsrUint16) (32)));
            CsrUint8Des((CsrUint8 *) &primitive->ssid[i1].length, buffer, &offset);
        }
    }
    CsrMemCpyDes(primitive->bssid.a, buffer, &offset, ((CsrUint16) (6)));
    CsrUint8Des((CsrUint8 *) &primitive->forceScan, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->bssType, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->channelInfoListCount, buffer, &offset);
    primitive->channelInfoList = NULL;
    if (primitive->channelInfoListCount)
    {
        primitive->channelInfoList = (CsrUint16 *) CsrPmemAlloc(sizeof(CsrUint16) * primitive->channelInfoListCount);
    }
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->channelInfoListCount; i1++)
        {
            CsrUint16Des((CsrUint16 *) &primitive->channelInfoList[i1], buffer, &offset);
        }
    }
    CsrUint32Des((CsrUint32 *) &primitive->probeIeLength, buffer, &offset);
    if (primitive->probeIeLength)
    {
        primitive->probeIe = (CsrUint8 *) CsrPmemAlloc(primitive->probeIeLength);
        CsrMemCpyDes(primitive->probeIe, buffer, &offset, ((CsrUint16) (primitive->probeIeLength)));
    }
    else
    {
        primitive->probeIe = NULL;
    }

    return primitive;
}

void CsrWifiSmeScanFullReqSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeScanFullReq *primitive = (CsrWifiSmeScanFullReq *) voidPrimitivePointer;
    CsrPmemFree(primitive->ssid);
    CsrPmemFree(primitive->channelInfoList);
    CsrPmemFree(primitive->probeIe);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeTspecReqSizeof(void *msg)
{
    CsrWifiSmeTspecReq *primitive = (CsrWifiSmeTspecReq *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 22) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 1; /* CsrWifiSmeListAction primitive->action */
    bufferSize += 4; /* CsrUint32 primitive->transactionId */
    bufferSize += 1; /* CsrBool primitive->strict */
    bufferSize += 1; /* CsrWifiSmeTspecCtrlMask primitive->ctrlMask */
    bufferSize += 4; /* CsrUint32 primitive->tspecLength */
    bufferSize += primitive->tspecLength; /* CsrUint8 primitive->tspec */
    bufferSize += 4; /* CsrUint32 primitive->tclasLength */
    bufferSize += primitive->tclasLength; /* CsrUint8 primitive->tclas */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeTspecReqSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeTspecReq *primitive = (CsrWifiSmeTspecReq *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->action);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->transactionId);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->strict);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->ctrlMask);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->tspecLength);
    if (primitive->tspecLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->tspec, ((CsrUint16) (primitive->tspecLength)));
    }
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->tclasLength);
    if (primitive->tclasLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->tclas, ((CsrUint16) (primitive->tclasLength)));
    }
    return ptr;
}

void *CsrWifiSmeTspecReqDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeTspecReq *primitive = (CsrWifiSmeTspecReq *) CsrPmemAlloc(sizeof(CsrWifiSmeTspecReq));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->action, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->transactionId, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->strict, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->ctrlMask, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->tspecLength, buffer, &offset);
    if (primitive->tspecLength)
    {
        primitive->tspec = (CsrUint8 *) CsrPmemAlloc(primitive->tspecLength);
        CsrMemCpyDes(primitive->tspec, buffer, &offset, ((CsrUint16) (primitive->tspecLength)));
    }
    else
    {
        primitive->tspec = NULL;
    }
    CsrUint32Des((CsrUint32 *) &primitive->tclasLength, buffer, &offset);
    if (primitive->tclasLength)
    {
        primitive->tclas = (CsrUint8 *) CsrPmemAlloc(primitive->tclasLength);
        CsrMemCpyDes(primitive->tclas, buffer, &offset, ((CsrUint16) (primitive->tclasLength)));
    }
    else
    {
        primitive->tclas = NULL;
    }

    return primitive;
}

void CsrWifiSmeTspecReqSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeTspecReq *primitive = (CsrWifiSmeTspecReq *) voidPrimitivePointer;
    CsrPmemFree(primitive->tspec);
    CsrPmemFree(primitive->tclas);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeWifiFlightmodeReqSizeof(void *msg)
{
    CsrWifiSmeWifiFlightmodeReq *primitive = (CsrWifiSmeWifiFlightmodeReq *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 10) */
    bufferSize += 2; /* CsrUint16 primitive->mibFilesCount */
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->mibFilesCount; i1++)
        {
            bufferSize += 4; /* CsrUint32 primitive->mibFiles[i1].dataLength */
            bufferSize += primitive->mibFiles[i1].dataLength; /* CsrUint8 primitive->mibFiles[i1].data */
        }
    }
    return bufferSize;
}

CsrUint8 *CsrWifiSmeWifiFlightmodeReqSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeWifiFlightmodeReq *primitive = (CsrWifiSmeWifiFlightmodeReq *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->mibFilesCount);
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->mibFilesCount; i1++)
        {
            CsrUint32Ser(ptr, len, (CsrUint32) primitive->mibFiles[i1].dataLength);
            if (primitive->mibFiles[i1].dataLength)
            {
                CsrMemCpySer(ptr, len, (const void *) primitive->mibFiles[i1].data, ((CsrUint16) (primitive->mibFiles[i1].dataLength)));
            }
        }
    }
    return ptr;
}

void *CsrWifiSmeWifiFlightmodeReqDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeWifiFlightmodeReq *primitive = (CsrWifiSmeWifiFlightmodeReq *) CsrPmemAlloc(sizeof(CsrWifiSmeWifiFlightmodeReq));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->mibFilesCount, buffer, &offset);
    primitive->mibFiles = NULL;
    if (primitive->mibFilesCount)
    {
        primitive->mibFiles = (CsrWifiDataBlock *) CsrPmemAlloc(sizeof(CsrWifiDataBlock) * primitive->mibFilesCount);
    }
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->mibFilesCount; i1++)
        {
            CsrUint32Des((CsrUint32 *) &primitive->mibFiles[i1].dataLength, buffer, &offset);
            if (primitive->mibFiles[i1].dataLength)
            {
                primitive->mibFiles[i1].data = (CsrUint8 *) CsrPmemAlloc(primitive->mibFiles[i1].dataLength);
                CsrMemCpyDes(primitive->mibFiles[i1].data, buffer, &offset, ((CsrUint16) (primitive->mibFiles[i1].dataLength)));
            }
            else
            {
                primitive->mibFiles[i1].data = NULL;
            }
        }
    }

    return primitive;
}

void CsrWifiSmeWifiFlightmodeReqSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeWifiFlightmodeReq *primitive = (CsrWifiSmeWifiFlightmodeReq *) voidPrimitivePointer;
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->mibFilesCount; i1++)
        {
            CsrPmemFree(primitive->mibFiles[i1].data);
        }
    }
    CsrPmemFree(primitive->mibFiles);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeWifiOnReqSizeof(void *msg)
{
    CsrWifiSmeWifiOnReq *primitive = (CsrWifiSmeWifiOnReq *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 16) */
    bufferSize += 6; /* CsrUint8 primitive->address.a[6] */
    bufferSize += 2; /* CsrUint16 primitive->mibFilesCount */
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->mibFilesCount; i1++)
        {
            bufferSize += 4; /* CsrUint32 primitive->mibFiles[i1].dataLength */
            bufferSize += primitive->mibFiles[i1].dataLength; /* CsrUint8 primitive->mibFiles[i1].data */
        }
    }
    return bufferSize;
}

CsrUint8 *CsrWifiSmeWifiOnReqSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeWifiOnReq *primitive = (CsrWifiSmeWifiOnReq *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrMemCpySer(ptr, len, (const void *) primitive->address.a, ((CsrUint16) (6)));
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->mibFilesCount);
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->mibFilesCount; i1++)
        {
            CsrUint32Ser(ptr, len, (CsrUint32) primitive->mibFiles[i1].dataLength);
            if (primitive->mibFiles[i1].dataLength)
            {
                CsrMemCpySer(ptr, len, (const void *) primitive->mibFiles[i1].data, ((CsrUint16) (primitive->mibFiles[i1].dataLength)));
            }
        }
    }
    return ptr;
}

void *CsrWifiSmeWifiOnReqDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeWifiOnReq *primitive = (CsrWifiSmeWifiOnReq *) CsrPmemAlloc(sizeof(CsrWifiSmeWifiOnReq));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrMemCpyDes(primitive->address.a, buffer, &offset, ((CsrUint16) (6)));
    CsrUint16Des((CsrUint16 *) &primitive->mibFilesCount, buffer, &offset);
    primitive->mibFiles = NULL;
    if (primitive->mibFilesCount)
    {
        primitive->mibFiles = (CsrWifiDataBlock *) CsrPmemAlloc(sizeof(CsrWifiDataBlock) * primitive->mibFilesCount);
    }
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->mibFilesCount; i1++)
        {
            CsrUint32Des((CsrUint32 *) &primitive->mibFiles[i1].dataLength, buffer, &offset);
            if (primitive->mibFiles[i1].dataLength)
            {
                primitive->mibFiles[i1].data = (CsrUint8 *) CsrPmemAlloc(primitive->mibFiles[i1].dataLength);
                CsrMemCpyDes(primitive->mibFiles[i1].data, buffer, &offset, ((CsrUint16) (primitive->mibFiles[i1].dataLength)));
            }
            else
            {
                primitive->mibFiles[i1].data = NULL;
            }
        }
    }

    return primitive;
}

void CsrWifiSmeWifiOnReqSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeWifiOnReq *primitive = (CsrWifiSmeWifiOnReq *) voidPrimitivePointer;
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->mibFilesCount; i1++)
        {
            CsrPmemFree(primitive->mibFiles[i1].data);
        }
    }
    CsrPmemFree(primitive->mibFiles);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeCloakedSsidsSetReqSizeof(void *msg)
{
    CsrWifiSmeCloakedSsidsSetReq *primitive = (CsrWifiSmeCloakedSsidsSetReq *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 37) */
    bufferSize += 1; /* CsrUint8 primitive->cloakedSsids.cloakedSsidsCount */
    {
        CsrUint16 i2;
        for (i2 = 0; i2 < primitive->cloakedSsids.cloakedSsidsCount; i2++)
        {
            bufferSize += 32; /* CsrUint8 primitive->cloakedSsids.cloakedSsids[i2].ssid[32] */
            bufferSize += 1; /* CsrUint8 primitive->cloakedSsids.cloakedSsids[i2].length */
        }
    }
    return bufferSize;
}

CsrUint8 *CsrWifiSmeCloakedSsidsSetReqSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeCloakedSsidsSetReq *primitive = (CsrWifiSmeCloakedSsidsSetReq *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->cloakedSsids.cloakedSsidsCount);
    {
        CsrUint16 i2;
        for (i2 = 0; i2 < primitive->cloakedSsids.cloakedSsidsCount; i2++)
        {
            CsrMemCpySer(ptr, len, (const void *) primitive->cloakedSsids.cloakedSsids[i2].ssid, ((CsrUint16) (32)));
            CsrUint8Ser(ptr, len, (CsrUint8) primitive->cloakedSsids.cloakedSsids[i2].length);
        }
    }
    return ptr;
}

void *CsrWifiSmeCloakedSsidsSetReqDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeCloakedSsidsSetReq *primitive = (CsrWifiSmeCloakedSsidsSetReq *) CsrPmemAlloc(sizeof(CsrWifiSmeCloakedSsidsSetReq));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->cloakedSsids.cloakedSsidsCount, buffer, &offset);
    primitive->cloakedSsids.cloakedSsids = NULL;
    if (primitive->cloakedSsids.cloakedSsidsCount)
    {
        primitive->cloakedSsids.cloakedSsids = (CsrWifiSsid *) CsrPmemAlloc(sizeof(CsrWifiSsid) * primitive->cloakedSsids.cloakedSsidsCount);
    }
    {
        CsrUint16 i2;
        for (i2 = 0; i2 < primitive->cloakedSsids.cloakedSsidsCount; i2++)
        {
            CsrMemCpyDes(primitive->cloakedSsids.cloakedSsids[i2].ssid, buffer, &offset, ((CsrUint16) (32)));
            CsrUint8Des((CsrUint8 *) &primitive->cloakedSsids.cloakedSsids[i2].length, buffer, &offset);
        }
    }

    return primitive;
}

void CsrWifiSmeCloakedSsidsSetReqSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeCloakedSsidsSetReq *primitive = (CsrWifiSmeCloakedSsidsSetReq *) voidPrimitivePointer;
    CsrPmemFree(primitive->cloakedSsids.cloakedSsids);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeInterfaceAddReqSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 9) */
    bufferSize += 6; /* CsrUint8 primitive->address.a[6] */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeInterfaceAddReqSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeInterfaceAddReq *primitive = (CsrWifiSmeInterfaceAddReq *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrMemCpySer(ptr, len, (const void *) primitive->address.a, ((CsrUint16) (6)));
    return ptr;
}

void *CsrWifiSmeInterfaceAddReqDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeInterfaceAddReq *primitive = (CsrWifiSmeInterfaceAddReq *) CsrPmemAlloc(sizeof(CsrWifiSmeInterfaceAddReq));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrMemCpyDes(primitive->address.a, buffer, &offset, ((CsrUint16) (6)));

    return primitive;
}

CsrSize CsrWifiSmeAssociationCompleteIndSizeof(void *msg)
{
    CsrWifiSmeAssociationCompleteInd *primitive = (CsrWifiSmeAssociationCompleteInd *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 110) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 2; /* CsrResult primitive->status */
    bufferSize += 32; /* CsrUint8 primitive->connectionInfo.ssid.ssid[32] */
    bufferSize += 1; /* CsrUint8 primitive->connectionInfo.ssid.length */
    bufferSize += 6; /* CsrUint8 primitive->connectionInfo.bssid.a[6] */
    bufferSize += 2; /* CsrUint16 primitive->connectionInfo.channelInfo */
    bufferSize += 2; /* CsrUint16 primitive->connectionInfo.channelFrequency */
    bufferSize += 2; /* CsrWifiSmeAuthMode primitive->connectionInfo.authMode */
    bufferSize += 2; /* CsrWifiSmeEncryption primitive->connectionInfo.pairwiseCipher */
    bufferSize += 2; /* CsrWifiSmeEncryption primitive->connectionInfo.groupCipher */
    bufferSize += 2; /* CsrUint16 primitive->connectionInfo.atimWindowTu */
    bufferSize += 2; /* CsrUint16 primitive->connectionInfo.beaconPeriodTu */
    bufferSize += 1; /* CsrBool primitive->connectionInfo.reassociation */
    bufferSize += 1; /* CsrBool primitive->connectionInfo.wmmAssociation */
    bufferSize += 4; /* CsrUint32 primitive->connectionInfo.beaconFrameLength */
    bufferSize += primitive->connectionInfo.beaconFrameLength; /* CsrUint8 primitive->connectionInfo.beaconFrame */
    bufferSize += 4; /* CsrUint32 primitive->connectionInfo.associationReqFrameLength */
    bufferSize += primitive->connectionInfo.associationReqFrameLength; /* CsrUint8 primitive->connectionInfo.associationReqFrame */
    bufferSize += 4; /* CsrUint32 primitive->connectionInfo.associationRspFrameLength */
    bufferSize += primitive->connectionInfo.associationRspFrameLength; /* CsrUint8 primitive->connectionInfo.associationRspFrame */
    bufferSize += 4; /* CsrUint32 primitive->connectionInfo.assocScanInfoElementsLength */
    bufferSize += primitive->connectionInfo.assocScanInfoElementsLength; /* CsrUint8 primitive->connectionInfo.assocScanInfoElements */
    bufferSize += 2; /* CsrUint16 primitive->connectionInfo.assocReqCapabilities */
    bufferSize += 2; /* CsrUint16 primitive->connectionInfo.assocReqListenIntervalTu */
    bufferSize += 6; /* CsrUint8 primitive->connectionInfo.assocReqApAddress.a[6] */
    bufferSize += 4; /* CsrUint32 primitive->connectionInfo.assocReqInfoElementsLength */
    bufferSize += primitive->connectionInfo.assocReqInfoElementsLength; /* CsrUint8 primitive->connectionInfo.assocReqInfoElements */
    bufferSize += 2; /* CsrWifiSmeIEEE80211Result primitive->connectionInfo.assocRspResult */
    bufferSize += 2; /* CsrUint16 primitive->connectionInfo.assocRspCapabilityInfo */
    bufferSize += 2; /* CsrUint16 primitive->connectionInfo.assocRspAssociationId */
    bufferSize += 4; /* CsrUint32 primitive->connectionInfo.assocRspInfoElementsLength */
    bufferSize += primitive->connectionInfo.assocRspInfoElementsLength; /* CsrUint8 primitive->connectionInfo.assocRspInfoElements */
    bufferSize += 2; /* CsrWifiSmeIEEE80211Reason primitive->deauthReason */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeAssociationCompleteIndSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeAssociationCompleteInd *primitive = (CsrWifiSmeAssociationCompleteInd *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->status);
    CsrMemCpySer(ptr, len, (const void *) primitive->connectionInfo.ssid.ssid, ((CsrUint16) (32)));
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->connectionInfo.ssid.length);
    CsrMemCpySer(ptr, len, (const void *) primitive->connectionInfo.bssid.a, ((CsrUint16) (6)));
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.channelInfo);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.channelFrequency);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.authMode);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.pairwiseCipher);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.groupCipher);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.atimWindowTu);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.beaconPeriodTu);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->connectionInfo.reassociation);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->connectionInfo.wmmAssociation);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->connectionInfo.beaconFrameLength);
    if (primitive->connectionInfo.beaconFrameLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->connectionInfo.beaconFrame, ((CsrUint16) (primitive->connectionInfo.beaconFrameLength)));
    }
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->connectionInfo.associationReqFrameLength);
    if (primitive->connectionInfo.associationReqFrameLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->connectionInfo.associationReqFrame, ((CsrUint16) (primitive->connectionInfo.associationReqFrameLength)));
    }
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->connectionInfo.associationRspFrameLength);
    if (primitive->connectionInfo.associationRspFrameLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->connectionInfo.associationRspFrame, ((CsrUint16) (primitive->connectionInfo.associationRspFrameLength)));
    }
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->connectionInfo.assocScanInfoElementsLength);
    if (primitive->connectionInfo.assocScanInfoElementsLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->connectionInfo.assocScanInfoElements, ((CsrUint16) (primitive->connectionInfo.assocScanInfoElementsLength)));
    }
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.assocReqCapabilities);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.assocReqListenIntervalTu);
    CsrMemCpySer(ptr, len, (const void *) primitive->connectionInfo.assocReqApAddress.a, ((CsrUint16) (6)));
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->connectionInfo.assocReqInfoElementsLength);
    if (primitive->connectionInfo.assocReqInfoElementsLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->connectionInfo.assocReqInfoElements, ((CsrUint16) (primitive->connectionInfo.assocReqInfoElementsLength)));
    }
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.assocRspResult);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.assocRspCapabilityInfo);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.assocRspAssociationId);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->connectionInfo.assocRspInfoElementsLength);
    if (primitive->connectionInfo.assocRspInfoElementsLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->connectionInfo.assocRspInfoElements, ((CsrUint16) (primitive->connectionInfo.assocRspInfoElementsLength)));
    }
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->deauthReason);
    return ptr;
}

void *CsrWifiSmeAssociationCompleteIndDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeAssociationCompleteInd *primitive = (CsrWifiSmeAssociationCompleteInd *) CsrPmemAlloc(sizeof(CsrWifiSmeAssociationCompleteInd));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->status, buffer, &offset);
    CsrMemCpyDes(primitive->connectionInfo.ssid.ssid, buffer, &offset, ((CsrUint16) (32)));
    CsrUint8Des((CsrUint8 *) &primitive->connectionInfo.ssid.length, buffer, &offset);
    CsrMemCpyDes(primitive->connectionInfo.bssid.a, buffer, &offset, ((CsrUint16) (6)));
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.channelInfo, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.channelFrequency, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.authMode, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.pairwiseCipher, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.groupCipher, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.atimWindowTu, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.beaconPeriodTu, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->connectionInfo.reassociation, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->connectionInfo.wmmAssociation, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->connectionInfo.beaconFrameLength, buffer, &offset);
    if (primitive->connectionInfo.beaconFrameLength)
    {
        primitive->connectionInfo.beaconFrame = (CsrUint8 *) CsrPmemAlloc(primitive->connectionInfo.beaconFrameLength);
        CsrMemCpyDes(primitive->connectionInfo.beaconFrame, buffer, &offset, ((CsrUint16) (primitive->connectionInfo.beaconFrameLength)));
    }
    else
    {
        primitive->connectionInfo.beaconFrame = NULL;
    }
    CsrUint32Des((CsrUint32 *) &primitive->connectionInfo.associationReqFrameLength, buffer, &offset);
    if (primitive->connectionInfo.associationReqFrameLength)
    {
        primitive->connectionInfo.associationReqFrame = (CsrUint8 *) CsrPmemAlloc(primitive->connectionInfo.associationReqFrameLength);
        CsrMemCpyDes(primitive->connectionInfo.associationReqFrame, buffer, &offset, ((CsrUint16) (primitive->connectionInfo.associationReqFrameLength)));
    }
    else
    {
        primitive->connectionInfo.associationReqFrame = NULL;
    }
    CsrUint32Des((CsrUint32 *) &primitive->connectionInfo.associationRspFrameLength, buffer, &offset);
    if (primitive->connectionInfo.associationRspFrameLength)
    {
        primitive->connectionInfo.associationRspFrame = (CsrUint8 *) CsrPmemAlloc(primitive->connectionInfo.associationRspFrameLength);
        CsrMemCpyDes(primitive->connectionInfo.associationRspFrame, buffer, &offset, ((CsrUint16) (primitive->connectionInfo.associationRspFrameLength)));
    }
    else
    {
        primitive->connectionInfo.associationRspFrame = NULL;
    }
    CsrUint32Des((CsrUint32 *) &primitive->connectionInfo.assocScanInfoElementsLength, buffer, &offset);
    if (primitive->connectionInfo.assocScanInfoElementsLength)
    {
        primitive->connectionInfo.assocScanInfoElements = (CsrUint8 *) CsrPmemAlloc(primitive->connectionInfo.assocScanInfoElementsLength);
        CsrMemCpyDes(primitive->connectionInfo.assocScanInfoElements, buffer, &offset, ((CsrUint16) (primitive->connectionInfo.assocScanInfoElementsLength)));
    }
    else
    {
        primitive->connectionInfo.assocScanInfoElements = NULL;
    }
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.assocReqCapabilities, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.assocReqListenIntervalTu, buffer, &offset);
    CsrMemCpyDes(primitive->connectionInfo.assocReqApAddress.a, buffer, &offset, ((CsrUint16) (6)));
    CsrUint32Des((CsrUint32 *) &primitive->connectionInfo.assocReqInfoElementsLength, buffer, &offset);
    if (primitive->connectionInfo.assocReqInfoElementsLength)
    {
        primitive->connectionInfo.assocReqInfoElements = (CsrUint8 *) CsrPmemAlloc(primitive->connectionInfo.assocReqInfoElementsLength);
        CsrMemCpyDes(primitive->connectionInfo.assocReqInfoElements, buffer, &offset, ((CsrUint16) (primitive->connectionInfo.assocReqInfoElementsLength)));
    }
    else
    {
        primitive->connectionInfo.assocReqInfoElements = NULL;
    }
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.assocRspResult, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.assocRspCapabilityInfo, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.assocRspAssociationId, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->connectionInfo.assocRspInfoElementsLength, buffer, &offset);
    if (primitive->connectionInfo.assocRspInfoElementsLength)
    {
        primitive->connectionInfo.assocRspInfoElements = (CsrUint8 *) CsrPmemAlloc(primitive->connectionInfo.assocRspInfoElementsLength);
        CsrMemCpyDes(primitive->connectionInfo.assocRspInfoElements, buffer, &offset, ((CsrUint16) (primitive->connectionInfo.assocRspInfoElementsLength)));
    }
    else
    {
        primitive->connectionInfo.assocRspInfoElements = NULL;
    }
    CsrUint16Des((CsrUint16 *) &primitive->deauthReason, buffer, &offset);

    return primitive;
}

void CsrWifiSmeAssociationCompleteIndSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeAssociationCompleteInd *primitive = (CsrWifiSmeAssociationCompleteInd *) voidPrimitivePointer;
    CsrPmemFree(primitive->connectionInfo.beaconFrame);
    CsrPmemFree(primitive->connectionInfo.associationReqFrame);
    CsrPmemFree(primitive->connectionInfo.associationRspFrame);
    CsrPmemFree(primitive->connectionInfo.assocScanInfoElements);
    CsrPmemFree(primitive->connectionInfo.assocReqInfoElements);
    CsrPmemFree(primitive->connectionInfo.assocRspInfoElements);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeAssociationStartIndSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 44) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 6; /* CsrUint8 primitive->address.a[6] */
    bufferSize += 32; /* CsrUint8 primitive->ssid.ssid[32] */
    bufferSize += 1; /* CsrUint8 primitive->ssid.length */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeAssociationStartIndSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeAssociationStartInd *primitive = (CsrWifiSmeAssociationStartInd *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrMemCpySer(ptr, len, (const void *) primitive->address.a, ((CsrUint16) (6)));
    CsrMemCpySer(ptr, len, (const void *) primitive->ssid.ssid, ((CsrUint16) (32)));
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->ssid.length);
    return ptr;
}

void *CsrWifiSmeAssociationStartIndDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeAssociationStartInd *primitive = (CsrWifiSmeAssociationStartInd *) CsrPmemAlloc(sizeof(CsrWifiSmeAssociationStartInd));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrMemCpyDes(primitive->address.a, buffer, &offset, ((CsrUint16) (6)));
    CsrMemCpyDes(primitive->ssid.ssid, buffer, &offset, ((CsrUint16) (32)));
    CsrUint8Des((CsrUint8 *) &primitive->ssid.length, buffer, &offset);

    return primitive;
}

CsrSize CsrWifiSmeBlacklistCfmSizeof(void *msg)
{
    CsrWifiSmeBlacklistCfm *primitive = (CsrWifiSmeBlacklistCfm *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 15) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 2; /* CsrResult primitive->status */
    bufferSize += 1; /* CsrWifiSmeListAction primitive->action */
    bufferSize += 1; /* CsrUint8 primitive->getAddressCount */
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->getAddressCount; i1++)
        {
            bufferSize += 6; /* CsrUint8 primitive->getAddresses[i1].a[6] */
        }
    }
    return bufferSize;
}

CsrUint8 *CsrWifiSmeBlacklistCfmSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeBlacklistCfm *primitive = (CsrWifiSmeBlacklistCfm *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->status);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->action);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->getAddressCount);
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->getAddressCount; i1++)
        {
            CsrMemCpySer(ptr, len, (const void *) primitive->getAddresses[i1].a, ((CsrUint16) (6)));
        }
    }
    return ptr;
}

void *CsrWifiSmeBlacklistCfmDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeBlacklistCfm *primitive = (CsrWifiSmeBlacklistCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeBlacklistCfm));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->status, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->action, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->getAddressCount, buffer, &offset);
    primitive->getAddresses = NULL;
    if (primitive->getAddressCount)
    {
        primitive->getAddresses = (CsrWifiMacAddress *) CsrPmemAlloc(sizeof(CsrWifiMacAddress) * primitive->getAddressCount);
    }
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->getAddressCount; i1++)
        {
            CsrMemCpyDes(primitive->getAddresses[i1].a, buffer, &offset, ((CsrUint16) (6)));
        }
    }

    return primitive;
}

void CsrWifiSmeBlacklistCfmSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeBlacklistCfm *primitive = (CsrWifiSmeBlacklistCfm *) voidPrimitivePointer;
    CsrPmemFree(primitive->getAddresses);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeCalibrationDataGetCfmSizeof(void *msg)
{
    CsrWifiSmeCalibrationDataGetCfm *primitive = (CsrWifiSmeCalibrationDataGetCfm *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 10) */
    bufferSize += 2; /* CsrResult primitive->status */
    bufferSize += 4; /* CsrUint32 primitive->calibrationDataLength */
    bufferSize += primitive->calibrationDataLength; /* CsrUint8 primitive->calibrationData */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeCalibrationDataGetCfmSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeCalibrationDataGetCfm *primitive = (CsrWifiSmeCalibrationDataGetCfm *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->status);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->calibrationDataLength);
    if (primitive->calibrationDataLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->calibrationData, ((CsrUint16) (primitive->calibrationDataLength)));
    }
    return ptr;
}

void *CsrWifiSmeCalibrationDataGetCfmDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeCalibrationDataGetCfm *primitive = (CsrWifiSmeCalibrationDataGetCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeCalibrationDataGetCfm));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->status, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->calibrationDataLength, buffer, &offset);
    if (primitive->calibrationDataLength)
    {
        primitive->calibrationData = (CsrUint8 *) CsrPmemAlloc(primitive->calibrationDataLength);
        CsrMemCpyDes(primitive->calibrationData, buffer, &offset, ((CsrUint16) (primitive->calibrationDataLength)));
    }
    else
    {
        primitive->calibrationData = NULL;
    }

    return primitive;
}

void CsrWifiSmeCalibrationDataGetCfmSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeCalibrationDataGetCfm *primitive = (CsrWifiSmeCalibrationDataGetCfm *) voidPrimitivePointer;
    CsrPmemFree(primitive->calibrationData);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeConnectCfmSizeof(void *msg)
{
    CsrWifiSmeConnectCfm *primitive = (CsrWifiSmeConnectCfm *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 12) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 2; /* CsrResult primitive->status */
    bufferSize += 4; /* CsrUint32 primitive->errorValuesLength */
    bufferSize += primitive->errorValuesLength; /* CsrUint8 primitive->errorValues */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeConnectCfmSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeConnectCfm *primitive = (CsrWifiSmeConnectCfm *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->status);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->errorValuesLength);
    if (primitive->errorValuesLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->errorValues, ((CsrUint16) (primitive->errorValuesLength)));
    }
    return ptr;
}

void *CsrWifiSmeConnectCfmDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeConnectCfm *primitive = (CsrWifiSmeConnectCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeConnectCfm));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->status, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->errorValuesLength, buffer, &offset);
    if (primitive->errorValuesLength)
    {
        primitive->errorValues = (CsrUint8 *) CsrPmemAlloc(primitive->errorValuesLength);
        CsrMemCpyDes(primitive->errorValues, buffer, &offset, ((CsrUint16) (primitive->errorValuesLength)));
    }
    else
    {
        primitive->errorValues = NULL;
    }

    return primitive;
}

void CsrWifiSmeConnectCfmSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeConnectCfm *primitive = (CsrWifiSmeConnectCfm *) voidPrimitivePointer;
    CsrPmemFree(primitive->errorValues);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeConnectionQualityIndSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 9) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 2; /* CsrInt16 primitive->linkQuality.unifiRssi */
    bufferSize += 2; /* CsrInt16 primitive->linkQuality.unifiSnr */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeConnectionQualityIndSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeConnectionQualityInd *primitive = (CsrWifiSmeConnectionQualityInd *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->linkQuality.unifiRssi);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->linkQuality.unifiSnr);
    return ptr;
}

void *CsrWifiSmeConnectionQualityIndDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeConnectionQualityInd *primitive = (CsrWifiSmeConnectionQualityInd *) CsrPmemAlloc(sizeof(CsrWifiSmeConnectionQualityInd));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->linkQuality.unifiRssi, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->linkQuality.unifiSnr, buffer, &offset);

    return primitive;
}

CsrSize CsrWifiSmeDisconnectCfmSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 7) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 2; /* CsrResult primitive->status */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeDisconnectCfmSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeDisconnectCfm *primitive = (CsrWifiSmeDisconnectCfm *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->status);
    return ptr;
}

void *CsrWifiSmeDisconnectCfmDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeDisconnectCfm *primitive = (CsrWifiSmeDisconnectCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeDisconnectCfm));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->status, buffer, &offset);

    return primitive;
}

CsrSize CsrWifiSmeIbssStationIndSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 12) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 6; /* CsrUint8 primitive->address.a[6] */
    bufferSize += 1; /* CsrBool primitive->isconnected */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeIbssStationIndSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeIbssStationInd *primitive = (CsrWifiSmeIbssStationInd *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrMemCpySer(ptr, len, (const void *) primitive->address.a, ((CsrUint16) (6)));
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->isconnected);
    return ptr;
}

void *CsrWifiSmeIbssStationIndDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeIbssStationInd *primitive = (CsrWifiSmeIbssStationInd *) CsrPmemAlloc(sizeof(CsrWifiSmeIbssStationInd));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrMemCpyDes(primitive->address.a, buffer, &offset, ((CsrUint16) (6)));
    CsrUint8Des((CsrUint8 *) &primitive->isconnected, buffer, &offset);

    return primitive;
}

CsrSize CsrWifiSmeKeyCfmSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 15) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 2; /* CsrResult primitive->status */
    bufferSize += 1; /* CsrWifiSmeListAction primitive->action */
    bufferSize += 1; /* CsrWifiSmeKeyType primitive->keyType */
    bufferSize += 6; /* CsrUint8 primitive->peerMacAddress.a[6] */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeKeyCfmSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeKeyCfm *primitive = (CsrWifiSmeKeyCfm *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->status);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->action);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->keyType);
    CsrMemCpySer(ptr, len, (const void *) primitive->peerMacAddress.a, ((CsrUint16) (6)));
    return ptr;
}

void *CsrWifiSmeKeyCfmDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeKeyCfm *primitive = (CsrWifiSmeKeyCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeKeyCfm));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->status, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->action, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->keyType, buffer, &offset);
    CsrMemCpyDes(primitive->peerMacAddress.a, buffer, &offset, ((CsrUint16) (6)));

    return primitive;
}

CsrSize CsrWifiSmeMediaStatusIndSizeof(void *msg)
{
    CsrWifiSmeMediaStatusInd *primitive = (CsrWifiSmeMediaStatusInd *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 111) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 1; /* CsrWifiSmeMediaStatus primitive->mediaStatus */
    bufferSize += 32; /* CsrUint8 primitive->connectionInfo.ssid.ssid[32] */
    bufferSize += 1; /* CsrUint8 primitive->connectionInfo.ssid.length */
    bufferSize += 6; /* CsrUint8 primitive->connectionInfo.bssid.a[6] */
    bufferSize += 2; /* CsrUint16 primitive->connectionInfo.channelInfo */
    bufferSize += 2; /* CsrUint16 primitive->connectionInfo.channelFrequency */
    bufferSize += 2; /* CsrWifiSmeAuthMode primitive->connectionInfo.authMode */
    bufferSize += 2; /* CsrWifiSmeEncryption primitive->connectionInfo.pairwiseCipher */
    bufferSize += 2; /* CsrWifiSmeEncryption primitive->connectionInfo.groupCipher */
    bufferSize += 2; /* CsrUint16 primitive->connectionInfo.atimWindowTu */
    bufferSize += 2; /* CsrUint16 primitive->connectionInfo.beaconPeriodTu */
    bufferSize += 1; /* CsrBool primitive->connectionInfo.reassociation */
    bufferSize += 1; /* CsrBool primitive->connectionInfo.wmmAssociation */
    bufferSize += 4; /* CsrUint32 primitive->connectionInfo.beaconFrameLength */
    bufferSize += primitive->connectionInfo.beaconFrameLength; /* CsrUint8 primitive->connectionInfo.beaconFrame */
    bufferSize += 4; /* CsrUint32 primitive->connectionInfo.associationReqFrameLength */
    bufferSize += primitive->connectionInfo.associationReqFrameLength; /* CsrUint8 primitive->connectionInfo.associationReqFrame */
    bufferSize += 4; /* CsrUint32 primitive->connectionInfo.associationRspFrameLength */
    bufferSize += primitive->connectionInfo.associationRspFrameLength; /* CsrUint8 primitive->connectionInfo.associationRspFrame */
    bufferSize += 4; /* CsrUint32 primitive->connectionInfo.assocScanInfoElementsLength */
    bufferSize += primitive->connectionInfo.assocScanInfoElementsLength; /* CsrUint8 primitive->connectionInfo.assocScanInfoElements */
    bufferSize += 2; /* CsrUint16 primitive->connectionInfo.assocReqCapabilities */
    bufferSize += 2; /* CsrUint16 primitive->connectionInfo.assocReqListenIntervalTu */
    bufferSize += 6; /* CsrUint8 primitive->connectionInfo.assocReqApAddress.a[6] */
    bufferSize += 4; /* CsrUint32 primitive->connectionInfo.assocReqInfoElementsLength */
    bufferSize += primitive->connectionInfo.assocReqInfoElementsLength; /* CsrUint8 primitive->connectionInfo.assocReqInfoElements */
    bufferSize += 2; /* CsrWifiSmeIEEE80211Result primitive->connectionInfo.assocRspResult */
    bufferSize += 2; /* CsrUint16 primitive->connectionInfo.assocRspCapabilityInfo */
    bufferSize += 2; /* CsrUint16 primitive->connectionInfo.assocRspAssociationId */
    bufferSize += 4; /* CsrUint32 primitive->connectionInfo.assocRspInfoElementsLength */
    bufferSize += primitive->connectionInfo.assocRspInfoElementsLength; /* CsrUint8 primitive->connectionInfo.assocRspInfoElements */
    bufferSize += 2; /* CsrWifiSmeIEEE80211Reason primitive->disassocReason */
    bufferSize += 2; /* CsrWifiSmeIEEE80211Reason primitive->deauthReason */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeMediaStatusIndSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeMediaStatusInd *primitive = (CsrWifiSmeMediaStatusInd *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->mediaStatus);
    CsrMemCpySer(ptr, len, (const void *) primitive->connectionInfo.ssid.ssid, ((CsrUint16) (32)));
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->connectionInfo.ssid.length);
    CsrMemCpySer(ptr, len, (const void *) primitive->connectionInfo.bssid.a, ((CsrUint16) (6)));
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.channelInfo);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.channelFrequency);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.authMode);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.pairwiseCipher);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.groupCipher);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.atimWindowTu);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.beaconPeriodTu);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->connectionInfo.reassociation);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->connectionInfo.wmmAssociation);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->connectionInfo.beaconFrameLength);
    if (primitive->connectionInfo.beaconFrameLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->connectionInfo.beaconFrame, ((CsrUint16) (primitive->connectionInfo.beaconFrameLength)));
    }
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->connectionInfo.associationReqFrameLength);
    if (primitive->connectionInfo.associationReqFrameLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->connectionInfo.associationReqFrame, ((CsrUint16) (primitive->connectionInfo.associationReqFrameLength)));
    }
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->connectionInfo.associationRspFrameLength);
    if (primitive->connectionInfo.associationRspFrameLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->connectionInfo.associationRspFrame, ((CsrUint16) (primitive->connectionInfo.associationRspFrameLength)));
    }
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->connectionInfo.assocScanInfoElementsLength);
    if (primitive->connectionInfo.assocScanInfoElementsLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->connectionInfo.assocScanInfoElements, ((CsrUint16) (primitive->connectionInfo.assocScanInfoElementsLength)));
    }
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.assocReqCapabilities);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.assocReqListenIntervalTu);
    CsrMemCpySer(ptr, len, (const void *) primitive->connectionInfo.assocReqApAddress.a, ((CsrUint16) (6)));
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->connectionInfo.assocReqInfoElementsLength);
    if (primitive->connectionInfo.assocReqInfoElementsLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->connectionInfo.assocReqInfoElements, ((CsrUint16) (primitive->connectionInfo.assocReqInfoElementsLength)));
    }
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.assocRspResult);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.assocRspCapabilityInfo);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->connectionInfo.assocRspAssociationId);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->connectionInfo.assocRspInfoElementsLength);
    if (primitive->connectionInfo.assocRspInfoElementsLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->connectionInfo.assocRspInfoElements, ((CsrUint16) (primitive->connectionInfo.assocRspInfoElementsLength)));
    }
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->disassocReason);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->deauthReason);
    return ptr;
}

void *CsrWifiSmeMediaStatusIndDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeMediaStatusInd *primitive = (CsrWifiSmeMediaStatusInd *) CsrPmemAlloc(sizeof(CsrWifiSmeMediaStatusInd));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->mediaStatus, buffer, &offset);
    CsrMemCpyDes(primitive->connectionInfo.ssid.ssid, buffer, &offset, ((CsrUint16) (32)));
    CsrUint8Des((CsrUint8 *) &primitive->connectionInfo.ssid.length, buffer, &offset);
    CsrMemCpyDes(primitive->connectionInfo.bssid.a, buffer, &offset, ((CsrUint16) (6)));
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.channelInfo, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.channelFrequency, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.authMode, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.pairwiseCipher, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.groupCipher, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.atimWindowTu, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.beaconPeriodTu, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->connectionInfo.reassociation, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->connectionInfo.wmmAssociation, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->connectionInfo.beaconFrameLength, buffer, &offset);
    if (primitive->connectionInfo.beaconFrameLength)
    {
        primitive->connectionInfo.beaconFrame = (CsrUint8 *) CsrPmemAlloc(primitive->connectionInfo.beaconFrameLength);
        CsrMemCpyDes(primitive->connectionInfo.beaconFrame, buffer, &offset, ((CsrUint16) (primitive->connectionInfo.beaconFrameLength)));
    }
    else
    {
        primitive->connectionInfo.beaconFrame = NULL;
    }
    CsrUint32Des((CsrUint32 *) &primitive->connectionInfo.associationReqFrameLength, buffer, &offset);
    if (primitive->connectionInfo.associationReqFrameLength)
    {
        primitive->connectionInfo.associationReqFrame = (CsrUint8 *) CsrPmemAlloc(primitive->connectionInfo.associationReqFrameLength);
        CsrMemCpyDes(primitive->connectionInfo.associationReqFrame, buffer, &offset, ((CsrUint16) (primitive->connectionInfo.associationReqFrameLength)));
    }
    else
    {
        primitive->connectionInfo.associationReqFrame = NULL;
    }
    CsrUint32Des((CsrUint32 *) &primitive->connectionInfo.associationRspFrameLength, buffer, &offset);
    if (primitive->connectionInfo.associationRspFrameLength)
    {
        primitive->connectionInfo.associationRspFrame = (CsrUint8 *) CsrPmemAlloc(primitive->connectionInfo.associationRspFrameLength);
        CsrMemCpyDes(primitive->connectionInfo.associationRspFrame, buffer, &offset, ((CsrUint16) (primitive->connectionInfo.associationRspFrameLength)));
    }
    else
    {
        primitive->connectionInfo.associationRspFrame = NULL;
    }
    CsrUint32Des((CsrUint32 *) &primitive->connectionInfo.assocScanInfoElementsLength, buffer, &offset);
    if (primitive->connectionInfo.assocScanInfoElementsLength)
    {
        primitive->connectionInfo.assocScanInfoElements = (CsrUint8 *) CsrPmemAlloc(primitive->connectionInfo.assocScanInfoElementsLength);
        CsrMemCpyDes(primitive->connectionInfo.assocScanInfoElements, buffer, &offset, ((CsrUint16) (primitive->connectionInfo.assocScanInfoElementsLength)));
    }
    else
    {
        primitive->connectionInfo.assocScanInfoElements = NULL;
    }
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.assocReqCapabilities, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.assocReqListenIntervalTu, buffer, &offset);
    CsrMemCpyDes(primitive->connectionInfo.assocReqApAddress.a, buffer, &offset, ((CsrUint16) (6)));
    CsrUint32Des((CsrUint32 *) &primitive->connectionInfo.assocReqInfoElementsLength, buffer, &offset);
    if (primitive->connectionInfo.assocReqInfoElementsLength)
    {
        primitive->connectionInfo.assocReqInfoElements = (CsrUint8 *) CsrPmemAlloc(primitive->connectionInfo.assocReqInfoElementsLength);
        CsrMemCpyDes(primitive->connectionInfo.assocReqInfoElements, buffer, &offset, ((CsrUint16) (primitive->connectionInfo.assocReqInfoElementsLength)));
    }
    else
    {
        primitive->connectionInfo.assocReqInfoElements = NULL;
    }
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.assocRspResult, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.assocRspCapabilityInfo, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->connectionInfo.assocRspAssociationId, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->connectionInfo.assocRspInfoElementsLength, buffer, &offset);
    if (primitive->connectionInfo.assocRspInfoElementsLength)
    {
        primitive->connectionInfo.assocRspInfoElements = (CsrUint8 *) CsrPmemAlloc(primitive->connectionInfo.assocRspInfoElementsLength);
        CsrMemCpyDes(primitive->connectionInfo.assocRspInfoElements, buffer, &offset, ((CsrUint16) (primitive->connectionInfo.assocRspInfoElementsLength)));
    }
    else
    {
        primitive->connectionInfo.assocRspInfoElements = NULL;
    }
    CsrUint16Des((CsrUint16 *) &primitive->disassocReason, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->deauthReason, buffer, &offset);

    return primitive;
}

void CsrWifiSmeMediaStatusIndSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeMediaStatusInd *primitive = (CsrWifiSmeMediaStatusInd *) voidPrimitivePointer;
    CsrPmemFree(primitive->connectionInfo.beaconFrame);
    CsrPmemFree(primitive->connectionInfo.associationReqFrame);
    CsrPmemFree(primitive->connectionInfo.associationRspFrame);
    CsrPmemFree(primitive->connectionInfo.assocScanInfoElements);
    CsrPmemFree(primitive->connectionInfo.assocReqInfoElements);
    CsrPmemFree(primitive->connectionInfo.assocRspInfoElements);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeGetCfmSizeof(void *msg)
{
    CsrWifiSmeGetCfm *primitive = (CsrWifiSmeGetCfm *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 15) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 4; /* CsrUint32 primitive->valuesLength */
    bufferSize += primitive->valuesLength; /* CsrUint8 primitive->values */
    bufferSize += 4; /* CsrUint32 primitive->errorValuesLength */
    bufferSize += primitive->errorValuesLength; /* CsrUint8 primitive->errorValues */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeGetCfmSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeGetCfm *primitive = (CsrWifiSmeGetCfm *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->valuesLength);
    if (primitive->valuesLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->values, ((CsrUint16) (primitive->valuesLength)));
    }
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->errorValuesLength);
    if (primitive->errorValuesLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->errorValues, ((CsrUint16) (primitive->errorValuesLength)));
    }
    return ptr;
}

void *CsrWifiSmeGetCfmDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeGetCfm *primitive = (CsrWifiSmeGetCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeGetCfm));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->valuesLength, buffer, &offset);
    if (primitive->valuesLength)
    {
        primitive->values = (CsrUint8 *) CsrPmemAlloc(primitive->valuesLength);
        CsrMemCpyDes(primitive->values, buffer, &offset, ((CsrUint16) (primitive->valuesLength)));
    }
    else
    {
        primitive->values = NULL;
    }
    CsrUint32Des((CsrUint32 *) &primitive->errorValuesLength, buffer, &offset);
    if (primitive->errorValuesLength)
    {
        primitive->errorValues = (CsrUint8 *) CsrPmemAlloc(primitive->errorValuesLength);
        CsrMemCpyDes(primitive->errorValues, buffer, &offset, ((CsrUint16) (primitive->errorValuesLength)));
    }
    else
    {
        primitive->errorValues = NULL;
    }

    return primitive;
}

void CsrWifiSmeGetCfmSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeGetCfm *primitive = (CsrWifiSmeGetCfm *) voidPrimitivePointer;
    CsrPmemFree(primitive->values);
    CsrPmemFree(primitive->errorValues);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeSetCfmSizeof(void *msg)
{
    CsrWifiSmeSetCfm *primitive = (CsrWifiSmeSetCfm *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 11) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 1; /* CsrBool primitive->mibReset */
    bufferSize += 4; /* CsrUint32 primitive->errorValuesLength */
    bufferSize += primitive->errorValuesLength; /* CsrUint8 primitive->errorValues */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeSetCfmSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeSetCfm *primitive = (CsrWifiSmeSetCfm *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->mibReset);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->errorValuesLength);
    if (primitive->errorValuesLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->errorValues, ((CsrUint16) (primitive->errorValuesLength)));
    }
    return ptr;
}

void *CsrWifiSmeSetCfmDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeSetCfm *primitive = (CsrWifiSmeSetCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeSetCfm));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->mibReset, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->errorValuesLength, buffer, &offset);
    if (primitive->errorValuesLength)
    {
        primitive->errorValues = (CsrUint8 *) CsrPmemAlloc(primitive->errorValuesLength);
        CsrMemCpyDes(primitive->errorValues, buffer, &offset, ((CsrUint16) (primitive->errorValuesLength)));
    }
    else
    {
        primitive->errorValues = NULL;
    }

    return primitive;
}

void CsrWifiSmeSetCfmSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeSetCfm *primitive = (CsrWifiSmeSetCfm *) voidPrimitivePointer;
    CsrPmemFree(primitive->errorValues);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeMicFailureIndSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 15) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 1; /* CsrBool primitive->secondFailure */
    bufferSize += 2; /* CsrUint16 primitive->count */
    bufferSize += 6; /* CsrUint8 primitive->address.a[6] */
    bufferSize += 1; /* CsrWifiSmeKeyType primitive->keyType */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeMicFailureIndSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeMicFailureInd *primitive = (CsrWifiSmeMicFailureInd *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->secondFailure);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->count);
    CsrMemCpySer(ptr, len, (const void *) primitive->address.a, ((CsrUint16) (6)));
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->keyType);
    return ptr;
}

void *CsrWifiSmeMicFailureIndDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeMicFailureInd *primitive = (CsrWifiSmeMicFailureInd *) CsrPmemAlloc(sizeof(CsrWifiSmeMicFailureInd));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->secondFailure, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->count, buffer, &offset);
    CsrMemCpyDes(primitive->address.a, buffer, &offset, ((CsrUint16) (6)));
    CsrUint8Des((CsrUint8 *) &primitive->keyType, buffer, &offset);

    return primitive;
}

CsrSize CsrWifiSmeMulticastAddressCfmSizeof(void *msg)
{
    CsrWifiSmeMulticastAddressCfm *primitive = (CsrWifiSmeMulticastAddressCfm *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 15) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 2; /* CsrResult primitive->status */
    bufferSize += 1; /* CsrWifiSmeListAction primitive->action */
    bufferSize += 1; /* CsrUint8 primitive->getAddressesCount */
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->getAddressesCount; i1++)
        {
            bufferSize += 6; /* CsrUint8 primitive->getAddresses[i1].a[6] */
        }
    }
    return bufferSize;
}

CsrUint8 *CsrWifiSmeMulticastAddressCfmSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeMulticastAddressCfm *primitive = (CsrWifiSmeMulticastAddressCfm *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->status);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->action);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->getAddressesCount);
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->getAddressesCount; i1++)
        {
            CsrMemCpySer(ptr, len, (const void *) primitive->getAddresses[i1].a, ((CsrUint16) (6)));
        }
    }
    return ptr;
}

void *CsrWifiSmeMulticastAddressCfmDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeMulticastAddressCfm *primitive = (CsrWifiSmeMulticastAddressCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeMulticastAddressCfm));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->status, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->action, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->getAddressesCount, buffer, &offset);
    primitive->getAddresses = NULL;
    if (primitive->getAddressesCount)
    {
        primitive->getAddresses = (CsrWifiMacAddress *) CsrPmemAlloc(sizeof(CsrWifiMacAddress) * primitive->getAddressesCount);
    }
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->getAddressesCount; i1++)
        {
            CsrMemCpyDes(primitive->getAddresses[i1].a, buffer, &offset, ((CsrUint16) (6)));
        }
    }

    return primitive;
}

void CsrWifiSmeMulticastAddressCfmSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeMulticastAddressCfm *primitive = (CsrWifiSmeMulticastAddressCfm *) voidPrimitivePointer;
    CsrPmemFree(primitive->getAddresses);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmePmkidCandidateListIndSizeof(void *msg)
{
    CsrWifiSmePmkidCandidateListInd *primitive = (CsrWifiSmePmkidCandidateListInd *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 13) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 1; /* CsrUint8 primitive->pmkidCandidatesCount */
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->pmkidCandidatesCount; i1++)
        {
            bufferSize += 6; /* CsrUint8 primitive->pmkidCandidates[i1].bssid.a[6] */
            bufferSize += 1; /* CsrBool primitive->pmkidCandidates[i1].preAuthAllowed */
        }
    }
    return bufferSize;
}

CsrUint8 *CsrWifiSmePmkidCandidateListIndSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmePmkidCandidateListInd *primitive = (CsrWifiSmePmkidCandidateListInd *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->pmkidCandidatesCount);
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->pmkidCandidatesCount; i1++)
        {
            CsrMemCpySer(ptr, len, (const void *) primitive->pmkidCandidates[i1].bssid.a, ((CsrUint16) (6)));
            CsrUint8Ser(ptr, len, (CsrUint8) primitive->pmkidCandidates[i1].preAuthAllowed);
        }
    }
    return ptr;
}

void *CsrWifiSmePmkidCandidateListIndDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmePmkidCandidateListInd *primitive = (CsrWifiSmePmkidCandidateListInd *) CsrPmemAlloc(sizeof(CsrWifiSmePmkidCandidateListInd));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->pmkidCandidatesCount, buffer, &offset);
    primitive->pmkidCandidates = NULL;
    if (primitive->pmkidCandidatesCount)
    {
        primitive->pmkidCandidates = (CsrWifiSmePmkidCandidate *) CsrPmemAlloc(sizeof(CsrWifiSmePmkidCandidate) * primitive->pmkidCandidatesCount);
    }
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->pmkidCandidatesCount; i1++)
        {
            CsrMemCpyDes(primitive->pmkidCandidates[i1].bssid.a, buffer, &offset, ((CsrUint16) (6)));
            CsrUint8Des((CsrUint8 *) &primitive->pmkidCandidates[i1].preAuthAllowed, buffer, &offset);
        }
    }

    return primitive;
}

void CsrWifiSmePmkidCandidateListIndSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmePmkidCandidateListInd *primitive = (CsrWifiSmePmkidCandidateListInd *) voidPrimitivePointer;
    CsrPmemFree(primitive->pmkidCandidates);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmePmkidCfmSizeof(void *msg)
{
    CsrWifiSmePmkidCfm *primitive = (CsrWifiSmePmkidCfm *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 31) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 2; /* CsrResult primitive->status */
    bufferSize += 1; /* CsrWifiSmeListAction primitive->action */
    bufferSize += 1; /* CsrUint8 primitive->getPmkidsCount */
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->getPmkidsCount; i1++)
        {
            bufferSize += 6; /* CsrUint8 primitive->getPmkids[i1].bssid.a[6] */
            bufferSize += 16; /* CsrUint8 primitive->getPmkids[i1].pmkid[16] */
        }
    }
    return bufferSize;
}

CsrUint8 *CsrWifiSmePmkidCfmSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmePmkidCfm *primitive = (CsrWifiSmePmkidCfm *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->status);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->action);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->getPmkidsCount);
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->getPmkidsCount; i1++)
        {
            CsrMemCpySer(ptr, len, (const void *) primitive->getPmkids[i1].bssid.a, ((CsrUint16) (6)));
            CsrMemCpySer(ptr, len, (const void *) primitive->getPmkids[i1].pmkid, ((CsrUint16) (16)));
        }
    }
    return ptr;
}

void *CsrWifiSmePmkidCfmDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmePmkidCfm *primitive = (CsrWifiSmePmkidCfm *) CsrPmemAlloc(sizeof(CsrWifiSmePmkidCfm));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->status, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->action, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->getPmkidsCount, buffer, &offset);
    primitive->getPmkids = NULL;
    if (primitive->getPmkidsCount)
    {
        primitive->getPmkids = (CsrWifiSmePmkid *) CsrPmemAlloc(sizeof(CsrWifiSmePmkid) * primitive->getPmkidsCount);
    }
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->getPmkidsCount; i1++)
        {
            CsrMemCpyDes(primitive->getPmkids[i1].bssid.a, buffer, &offset, ((CsrUint16) (6)));
            CsrMemCpyDes(primitive->getPmkids[i1].pmkid, buffer, &offset, ((CsrUint16) (16)));
        }
    }

    return primitive;
}

void CsrWifiSmePmkidCfmSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmePmkidCfm *primitive = (CsrWifiSmePmkidCfm *) voidPrimitivePointer;
    CsrPmemFree(primitive->getPmkids);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeRoamCompleteIndSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 7) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 2; /* CsrResult primitive->status */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeRoamCompleteIndSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeRoamCompleteInd *primitive = (CsrWifiSmeRoamCompleteInd *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->status);
    return ptr;
}

void *CsrWifiSmeRoamCompleteIndDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeRoamCompleteInd *primitive = (CsrWifiSmeRoamCompleteInd *) CsrPmemAlloc(sizeof(CsrWifiSmeRoamCompleteInd));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->status, buffer, &offset);

    return primitive;
}

CsrSize CsrWifiSmeRoamStartIndSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 8) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 1; /* CsrWifiSmeRoamReason primitive->roamReason */
    bufferSize += 2; /* CsrWifiSmeIEEE80211Reason primitive->reason80211 */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeRoamStartIndSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeRoamStartInd *primitive = (CsrWifiSmeRoamStartInd *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->roamReason);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->reason80211);
    return ptr;
}

void *CsrWifiSmeRoamStartIndDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeRoamStartInd *primitive = (CsrWifiSmeRoamStartInd *) CsrPmemAlloc(sizeof(CsrWifiSmeRoamStartInd));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->roamReason, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->reason80211, buffer, &offset);

    return primitive;
}

CsrSize CsrWifiSmeScanResultIndSizeof(void *msg)
{
    CsrWifiSmeScanResultInd *primitive = (CsrWifiSmeScanResultInd *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 77) */
    bufferSize += 32; /* CsrUint8 primitive->result.ssid.ssid[32] */
    bufferSize += 1; /* CsrUint8 primitive->result.ssid.length */
    bufferSize += 6; /* CsrUint8 primitive->result.bssid.a[6] */
    bufferSize += 2; /* CsrInt16 primitive->result.rssi */
    bufferSize += 2; /* CsrInt16 primitive->result.snr */
    bufferSize += 2; /* CsrUint16 primitive->result.beaconPeriodTu */
    bufferSize += 8; /* CsrUint8 primitive->result.timeStamp.data[8] */
    bufferSize += 8; /* CsrUint8 primitive->result.localTime.data[8] */
    bufferSize += 2; /* CsrUint16 primitive->result.channelFrequency */
    bufferSize += 2; /* CsrUint16 primitive->result.capabilityInformation */
    bufferSize += 2; /* CsrUint16 primitive->result.channelInfo */
    bufferSize += 1; /* CsrWifiSmeBasicUsability primitive->result.usability */
    bufferSize += 1; /* CsrWifiSmeBssType primitive->result.bssType */
    bufferSize += 4; /* CsrUint32 primitive->result.informationElementsLength */
    bufferSize += primitive->result.informationElementsLength; /* CsrUint8 primitive->result.informationElements */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeScanResultIndSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeScanResultInd *primitive = (CsrWifiSmeScanResultInd *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrMemCpySer(ptr, len, (const void *) primitive->result.ssid.ssid, ((CsrUint16) (32)));
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->result.ssid.length);
    CsrMemCpySer(ptr, len, (const void *) primitive->result.bssid.a, ((CsrUint16) (6)));
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->result.rssi);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->result.snr);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->result.beaconPeriodTu);
    CsrMemCpySer(ptr, len, (const void *) primitive->result.timeStamp.data, ((CsrUint16) (8)));
    CsrMemCpySer(ptr, len, (const void *) primitive->result.localTime.data, ((CsrUint16) (8)));
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->result.channelFrequency);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->result.capabilityInformation);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->result.channelInfo);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->result.usability);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->result.bssType);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->result.informationElementsLength);
    if (primitive->result.informationElementsLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->result.informationElements, ((CsrUint16) (primitive->result.informationElementsLength)));
    }
    return ptr;
}

void *CsrWifiSmeScanResultIndDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeScanResultInd *primitive = (CsrWifiSmeScanResultInd *) CsrPmemAlloc(sizeof(CsrWifiSmeScanResultInd));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrMemCpyDes(primitive->result.ssid.ssid, buffer, &offset, ((CsrUint16) (32)));
    CsrUint8Des((CsrUint8 *) &primitive->result.ssid.length, buffer, &offset);
    CsrMemCpyDes(primitive->result.bssid.a, buffer, &offset, ((CsrUint16) (6)));
    CsrUint16Des((CsrUint16 *) &primitive->result.rssi, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->result.snr, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->result.beaconPeriodTu, buffer, &offset);
    CsrMemCpyDes(primitive->result.timeStamp.data, buffer, &offset, ((CsrUint16) (8)));
    CsrMemCpyDes(primitive->result.localTime.data, buffer, &offset, ((CsrUint16) (8)));
    CsrUint16Des((CsrUint16 *) &primitive->result.channelFrequency, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->result.capabilityInformation, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->result.channelInfo, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->result.usability, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->result.bssType, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->result.informationElementsLength, buffer, &offset);
    if (primitive->result.informationElementsLength)
    {
        primitive->result.informationElements = (CsrUint8 *) CsrPmemAlloc(primitive->result.informationElementsLength);
        CsrMemCpyDes(primitive->result.informationElements, buffer, &offset, ((CsrUint16) (primitive->result.informationElementsLength)));
    }
    else
    {
        primitive->result.informationElements = NULL;
    }

    return primitive;
}

void CsrWifiSmeScanResultIndSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeScanResultInd *primitive = (CsrWifiSmeScanResultInd *) voidPrimitivePointer;
    CsrPmemFree(primitive->result.informationElements);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeScanResultsGetCfmSizeof(void *msg)
{
    CsrWifiSmeScanResultsGetCfm *primitive = (CsrWifiSmeScanResultsGetCfm *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 81) */
    bufferSize += 2; /* CsrResult primitive->status */
    bufferSize += 2; /* CsrUint16 primitive->scanResultsCount */
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->scanResultsCount; i1++)
        {
            bufferSize += 32; /* CsrUint8 primitive->scanResults[i1].ssid.ssid[32] */
            bufferSize += 1; /* CsrUint8 primitive->scanResults[i1].ssid.length */
            bufferSize += 6; /* CsrUint8 primitive->scanResults[i1].bssid.a[6] */
            bufferSize += 2; /* CsrInt16 primitive->scanResults[i1].rssi */
            bufferSize += 2; /* CsrInt16 primitive->scanResults[i1].snr */
            bufferSize += 2; /* CsrUint16 primitive->scanResults[i1].beaconPeriodTu */
            bufferSize += 8; /* CsrUint8 primitive->scanResults[i1].timeStamp.data[8] */
            bufferSize += 8; /* CsrUint8 primitive->scanResults[i1].localTime.data[8] */
            bufferSize += 2; /* CsrUint16 primitive->scanResults[i1].channelFrequency */
            bufferSize += 2; /* CsrUint16 primitive->scanResults[i1].capabilityInformation */
            bufferSize += 2; /* CsrUint16 primitive->scanResults[i1].channelInfo */
            bufferSize += 1; /* CsrWifiSmeBasicUsability primitive->scanResults[i1].usability */
            bufferSize += 1; /* CsrWifiSmeBssType primitive->scanResults[i1].bssType */
            bufferSize += 4; /* CsrUint32 primitive->scanResults[i1].informationElementsLength */
            bufferSize += primitive->scanResults[i1].informationElementsLength; /* CsrUint8 primitive->scanResults[i1].informationElements */
        }
    }
    return bufferSize;
}

CsrUint8 *CsrWifiSmeScanResultsGetCfmSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeScanResultsGetCfm *primitive = (CsrWifiSmeScanResultsGetCfm *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->status);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->scanResultsCount);
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->scanResultsCount; i1++)
        {
            CsrMemCpySer(ptr, len, (const void *) primitive->scanResults[i1].ssid.ssid, ((CsrUint16) (32)));
            CsrUint8Ser(ptr, len, (CsrUint8) primitive->scanResults[i1].ssid.length);
            CsrMemCpySer(ptr, len, (const void *) primitive->scanResults[i1].bssid.a, ((CsrUint16) (6)));
            CsrUint16Ser(ptr, len, (CsrUint16) primitive->scanResults[i1].rssi);
            CsrUint16Ser(ptr, len, (CsrUint16) primitive->scanResults[i1].snr);
            CsrUint16Ser(ptr, len, (CsrUint16) primitive->scanResults[i1].beaconPeriodTu);
            CsrMemCpySer(ptr, len, (const void *) primitive->scanResults[i1].timeStamp.data, ((CsrUint16) (8)));
            CsrMemCpySer(ptr, len, (const void *) primitive->scanResults[i1].localTime.data, ((CsrUint16) (8)));
            CsrUint16Ser(ptr, len, (CsrUint16) primitive->scanResults[i1].channelFrequency);
            CsrUint16Ser(ptr, len, (CsrUint16) primitive->scanResults[i1].capabilityInformation);
            CsrUint16Ser(ptr, len, (CsrUint16) primitive->scanResults[i1].channelInfo);
            CsrUint8Ser(ptr, len, (CsrUint8) primitive->scanResults[i1].usability);
            CsrUint8Ser(ptr, len, (CsrUint8) primitive->scanResults[i1].bssType);
            CsrUint32Ser(ptr, len, (CsrUint32) primitive->scanResults[i1].informationElementsLength);
            if (primitive->scanResults[i1].informationElementsLength)
            {
                CsrMemCpySer(ptr, len, (const void *) primitive->scanResults[i1].informationElements, ((CsrUint16) (primitive->scanResults[i1].informationElementsLength)));
            }
        }
    }
    return ptr;
}

void *CsrWifiSmeScanResultsGetCfmDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeScanResultsGetCfm *primitive = (CsrWifiSmeScanResultsGetCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeScanResultsGetCfm));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->status, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->scanResultsCount, buffer, &offset);
    primitive->scanResults = NULL;
    if (primitive->scanResultsCount)
    {
        primitive->scanResults = (CsrWifiSmeScanResult *) CsrPmemAlloc(sizeof(CsrWifiSmeScanResult) * primitive->scanResultsCount);
    }
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->scanResultsCount; i1++)
        {
            CsrMemCpyDes(primitive->scanResults[i1].ssid.ssid, buffer, &offset, ((CsrUint16) (32)));
            CsrUint8Des((CsrUint8 *) &primitive->scanResults[i1].ssid.length, buffer, &offset);
            CsrMemCpyDes(primitive->scanResults[i1].bssid.a, buffer, &offset, ((CsrUint16) (6)));
            CsrUint16Des((CsrUint16 *) &primitive->scanResults[i1].rssi, buffer, &offset);
            CsrUint16Des((CsrUint16 *) &primitive->scanResults[i1].snr, buffer, &offset);
            CsrUint16Des((CsrUint16 *) &primitive->scanResults[i1].beaconPeriodTu, buffer, &offset);
            CsrMemCpyDes(primitive->scanResults[i1].timeStamp.data, buffer, &offset, ((CsrUint16) (8)));
            CsrMemCpyDes(primitive->scanResults[i1].localTime.data, buffer, &offset, ((CsrUint16) (8)));
            CsrUint16Des((CsrUint16 *) &primitive->scanResults[i1].channelFrequency, buffer, &offset);
            CsrUint16Des((CsrUint16 *) &primitive->scanResults[i1].capabilityInformation, buffer, &offset);
            CsrUint16Des((CsrUint16 *) &primitive->scanResults[i1].channelInfo, buffer, &offset);
            CsrUint8Des((CsrUint8 *) &primitive->scanResults[i1].usability, buffer, &offset);
            CsrUint8Des((CsrUint8 *) &primitive->scanResults[i1].bssType, buffer, &offset);
            CsrUint32Des((CsrUint32 *) &primitive->scanResults[i1].informationElementsLength, buffer, &offset);
            if (primitive->scanResults[i1].informationElementsLength)
            {
                primitive->scanResults[i1].informationElements = (CsrUint8 *) CsrPmemAlloc(primitive->scanResults[i1].informationElementsLength);
                CsrMemCpyDes(primitive->scanResults[i1].informationElements, buffer, &offset, ((CsrUint16) (primitive->scanResults[i1].informationElementsLength)));
            }
            else
            {
                primitive->scanResults[i1].informationElements = NULL;
            }
        }
    }

    return primitive;
}

void CsrWifiSmeScanResultsGetCfmSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeScanResultsGetCfm *primitive = (CsrWifiSmeScanResultsGetCfm *) voidPrimitivePointer;
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < primitive->scanResultsCount; i1++)
        {
            CsrPmemFree(primitive->scanResults[i1].informationElements);
        }
    }
    CsrPmemFree(primitive->scanResults);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeTspecIndSizeof(void *msg)
{
    CsrWifiSmeTspecInd *primitive = (CsrWifiSmeTspecInd *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 15) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 4; /* CsrUint32 primitive->transactionId */
    bufferSize += 1; /* CsrWifiSmeTspecResultCode primitive->tspecResultCode */
    bufferSize += 4; /* CsrUint32 primitive->tspecLength */
    bufferSize += primitive->tspecLength; /* CsrUint8 primitive->tspec */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeTspecIndSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeTspecInd *primitive = (CsrWifiSmeTspecInd *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->transactionId);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->tspecResultCode);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->tspecLength);
    if (primitive->tspecLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->tspec, ((CsrUint16) (primitive->tspecLength)));
    }
    return ptr;
}

void *CsrWifiSmeTspecIndDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeTspecInd *primitive = (CsrWifiSmeTspecInd *) CsrPmemAlloc(sizeof(CsrWifiSmeTspecInd));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->transactionId, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->tspecResultCode, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->tspecLength, buffer, &offset);
    if (primitive->tspecLength)
    {
        primitive->tspec = (CsrUint8 *) CsrPmemAlloc(primitive->tspecLength);
        CsrMemCpyDes(primitive->tspec, buffer, &offset, ((CsrUint16) (primitive->tspecLength)));
    }
    else
    {
        primitive->tspec = NULL;
    }

    return primitive;
}

void CsrWifiSmeTspecIndSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeTspecInd *primitive = (CsrWifiSmeTspecInd *) voidPrimitivePointer;
    CsrPmemFree(primitive->tspec);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeTspecCfmSizeof(void *msg)
{
    CsrWifiSmeTspecCfm *primitive = (CsrWifiSmeTspecCfm *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 17) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 2; /* CsrResult primitive->status */
    bufferSize += 4; /* CsrUint32 primitive->transactionId */
    bufferSize += 1; /* CsrWifiSmeTspecResultCode primitive->tspecResultCode */
    bufferSize += 4; /* CsrUint32 primitive->tspecLength */
    bufferSize += primitive->tspecLength; /* CsrUint8 primitive->tspec */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeTspecCfmSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeTspecCfm *primitive = (CsrWifiSmeTspecCfm *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->status);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->transactionId);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->tspecResultCode);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->tspecLength);
    if (primitive->tspecLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->tspec, ((CsrUint16) (primitive->tspecLength)));
    }
    return ptr;
}

void *CsrWifiSmeTspecCfmDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeTspecCfm *primitive = (CsrWifiSmeTspecCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeTspecCfm));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->status, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->transactionId, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->tspecResultCode, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->tspecLength, buffer, &offset);
    if (primitive->tspecLength)
    {
        primitive->tspec = (CsrUint8 *) CsrPmemAlloc(primitive->tspecLength);
        CsrMemCpyDes(primitive->tspec, buffer, &offset, ((CsrUint16) (primitive->tspecLength)));
    }
    else
    {
        primitive->tspec = NULL;
    }

    return primitive;
}

void CsrWifiSmeTspecCfmSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeTspecCfm *primitive = (CsrWifiSmeTspecCfm *) voidPrimitivePointer;
    CsrPmemFree(primitive->tspec);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeWifiOnCfmSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 13) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 2; /* CsrResult primitive->status */
    bufferSize += 6; /* CsrUint8 primitive->address.a[6] */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeWifiOnCfmSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeWifiOnCfm *primitive = (CsrWifiSmeWifiOnCfm *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->status);
    CsrMemCpySer(ptr, len, (const void *) primitive->address.a, ((CsrUint16) (6)));
    return ptr;
}

void *CsrWifiSmeWifiOnCfmDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeWifiOnCfm *primitive = (CsrWifiSmeWifiOnCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeWifiOnCfm));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->status, buffer, &offset);
    CsrMemCpyDes(primitive->address.a, buffer, &offset, ((CsrUint16) (6)));

    return primitive;
}

CsrSize CsrWifiSmeCloakedSsidsGetCfmSizeof(void *msg)
{
    CsrWifiSmeCloakedSsidsGetCfm *primitive = (CsrWifiSmeCloakedSsidsGetCfm *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 39) */
    bufferSize += 2; /* CsrResult primitive->status */
    bufferSize += 1; /* CsrUint8 primitive->cloakedSsids.cloakedSsidsCount */
    {
        CsrUint16 i2;
        for (i2 = 0; i2 < primitive->cloakedSsids.cloakedSsidsCount; i2++)
        {
            bufferSize += 32; /* CsrUint8 primitive->cloakedSsids.cloakedSsids[i2].ssid[32] */
            bufferSize += 1; /* CsrUint8 primitive->cloakedSsids.cloakedSsids[i2].length */
        }
    }
    return bufferSize;
}

CsrUint8 *CsrWifiSmeCloakedSsidsGetCfmSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeCloakedSsidsGetCfm *primitive = (CsrWifiSmeCloakedSsidsGetCfm *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->status);
    CsrUint8Ser(ptr, len, (CsrUint8) primitive->cloakedSsids.cloakedSsidsCount);
    {
        CsrUint16 i2;
        for (i2 = 0; i2 < primitive->cloakedSsids.cloakedSsidsCount; i2++)
        {
            CsrMemCpySer(ptr, len, (const void *) primitive->cloakedSsids.cloakedSsids[i2].ssid, ((CsrUint16) (32)));
            CsrUint8Ser(ptr, len, (CsrUint8) primitive->cloakedSsids.cloakedSsids[i2].length);
        }
    }
    return ptr;
}

void *CsrWifiSmeCloakedSsidsGetCfmDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeCloakedSsidsGetCfm *primitive = (CsrWifiSmeCloakedSsidsGetCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeCloakedSsidsGetCfm));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->status, buffer, &offset);
    CsrUint8Des((CsrUint8 *) &primitive->cloakedSsids.cloakedSsidsCount, buffer, &offset);
    primitive->cloakedSsids.cloakedSsids = NULL;
    if (primitive->cloakedSsids.cloakedSsidsCount)
    {
        primitive->cloakedSsids.cloakedSsids = (CsrWifiSsid *) CsrPmemAlloc(sizeof(CsrWifiSsid) * primitive->cloakedSsids.cloakedSsidsCount);
    }
    {
        CsrUint16 i2;
        for (i2 = 0; i2 < primitive->cloakedSsids.cloakedSsidsCount; i2++)
        {
            CsrMemCpyDes(primitive->cloakedSsids.cloakedSsids[i2].ssid, buffer, &offset, ((CsrUint16) (32)));
            CsrUint8Des((CsrUint8 *) &primitive->cloakedSsids.cloakedSsids[i2].length, buffer, &offset);
        }
    }

    return primitive;
}

void CsrWifiSmeCloakedSsidsGetCfmSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeCloakedSsidsGetCfm *primitive = (CsrWifiSmeCloakedSsidsGetCfm *) voidPrimitivePointer;
    CsrPmemFree(primitive->cloakedSsids.cloakedSsids);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeWifiOnIndSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 11) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 6; /* CsrUint8 primitive->address.a[6] */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeWifiOnIndSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeWifiOnInd *primitive = (CsrWifiSmeWifiOnInd *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrMemCpySer(ptr, len, (const void *) primitive->address.a, ((CsrUint16) (6)));
    return ptr;
}

void *CsrWifiSmeWifiOnIndDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeWifiOnInd *primitive = (CsrWifiSmeWifiOnInd *) CsrPmemAlloc(sizeof(CsrWifiSmeWifiOnInd));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrMemCpyDes(primitive->address.a, buffer, &offset, ((CsrUint16) (6)));

    return primitive;
}

CsrSize CsrWifiSmeCoreDumpIndSizeof(void *msg)
{
    CsrWifiSmeCoreDumpInd *primitive = (CsrWifiSmeCoreDumpInd *) msg;
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 8) */
    bufferSize += 4; /* CsrUint32 primitive->dataLength */
    bufferSize += primitive->dataLength; /* CsrUint8 primitive->data */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeCoreDumpIndSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeCoreDumpInd *primitive = (CsrWifiSmeCoreDumpInd *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint32Ser(ptr, len, (CsrUint32) primitive->dataLength);
    if (primitive->dataLength)
    {
        CsrMemCpySer(ptr, len, (const void *) primitive->data, ((CsrUint16) (primitive->dataLength)));
    }
    return ptr;
}

void *CsrWifiSmeCoreDumpIndDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeCoreDumpInd *primitive = (CsrWifiSmeCoreDumpInd *) CsrPmemAlloc(sizeof(CsrWifiSmeCoreDumpInd));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint32Des((CsrUint32 *) &primitive->dataLength, buffer, &offset);
    if (primitive->dataLength)
    {
        primitive->data = (CsrUint8 *) CsrPmemAlloc(primitive->dataLength);
        CsrMemCpyDes(primitive->data, buffer, &offset, ((CsrUint16) (primitive->dataLength)));
    }
    else
    {
        primitive->data = NULL;
    }

    return primitive;
}

void CsrWifiSmeCoreDumpIndSerFree(void *voidPrimitivePointer)
{
    CsrWifiSmeCoreDumpInd *primitive = (CsrWifiSmeCoreDumpInd *) voidPrimitivePointer;
    CsrPmemFree(primitive->data);
    CsrPmemFree(primitive);
}

CsrSize CsrWifiSmeInterfaceAddIndSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 11) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 6; /* CsrUint8 primitive->address.a[6] */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeInterfaceAddIndSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeInterfaceAddInd *primitive = (CsrWifiSmeInterfaceAddInd *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrMemCpySer(ptr, len, (const void *) primitive->address.a, ((CsrUint16) (6)));
    return ptr;
}

void *CsrWifiSmeInterfaceAddIndDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeInterfaceAddInd *primitive = (CsrWifiSmeInterfaceAddInd *) CsrPmemAlloc(sizeof(CsrWifiSmeInterfaceAddInd));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrMemCpyDes(primitive->address.a, buffer, &offset, ((CsrUint16) (6)));

    return primitive;
}

CsrSize CsrWifiSmeInterfaceAddCfmSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 13) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 2; /* CsrResult primitive->status */
    bufferSize += 6; /* CsrUint8 primitive->address.a[6] */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeInterfaceAddCfmSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeInterfaceAddCfm *primitive = (CsrWifiSmeInterfaceAddCfm *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->status);
    CsrMemCpySer(ptr, len, (const void *) primitive->address.a, ((CsrUint16) (6)));
    return ptr;
}

void *CsrWifiSmeInterfaceAddCfmDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeInterfaceAddCfm *primitive = (CsrWifiSmeInterfaceAddCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeInterfaceAddCfm));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->status, buffer, &offset);
    CsrMemCpyDes(primitive->address.a, buffer, &offset, ((CsrUint16) (6)));

    return primitive;
}

CsrSize CsrWifiSmeInterfaceDelCfmSizeof(void *msg)
{
    CsrSize bufferSize = CSR_WIFI_EVENT_SIZE;

    /* Calculate the Size of the Serialised Data. Could be more efficient (Try 7) */
    bufferSize += 2; /* CsrUint16 primitive->interfaceTag */
    bufferSize += 2; /* CsrResult primitive->status */
    return bufferSize;
}

CsrUint8 *CsrWifiSmeInterfaceDelCfmSer(CsrUint8 *ptr, CsrSize *len, void *msg)
{
    CsrWifiSmeInterfaceDelCfm *primitive = (CsrWifiSmeInterfaceDelCfm *) msg;
    *len = 0;
    CsrWifiEventHeaderSer(ptr, len, &primitive->common);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->interfaceTag);
    CsrUint16Ser(ptr, len, (CsrUint16) primitive->status);
    return ptr;
}

void *CsrWifiSmeInterfaceDelCfmDes(CsrUint8 *buffer, CsrSize length)
{
    CsrWifiSmeInterfaceDelCfm *primitive = (CsrWifiSmeInterfaceDelCfm *) CsrPmemAlloc(sizeof(CsrWifiSmeInterfaceDelCfm));
    CsrSize offset;
    offset = 0;

    CsrWifiEventHeaderDes(&primitive->common, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->interfaceTag, buffer, &offset);
    CsrUint16Des((CsrUint16 *) &primitive->status, buffer, &offset);

    return primitive;
}
