/*****************************************************************************

        Copyright Cambridge Silicon Radio Limited 2014
        All rights reserved

        Refer to LICENSE.txt included with this source for details
        on the license terms.

*****************************************************************************/

/* Note: this is an auto-generated file. */

#include "csr_synergy.h"

#include "csr_pmem.h"
#include "csr_wifi_sme_prim.h"
#include "csr_wifi_sme_lib.h"

static void CsrWifiSmeAssociationCompleteIndFreeContents(CsrWifiSmeAssociationCompleteInd *message)
{
    CsrPmemFree(message->connectionInfo.beaconFrame);
    message->connectionInfo.beaconFrame = NULL;
    CsrPmemFree(message->connectionInfo.associationReqFrame);
    message->connectionInfo.associationReqFrame = NULL;
    CsrPmemFree(message->connectionInfo.associationRspFrame);
    message->connectionInfo.associationRspFrame = NULL;
    CsrPmemFree(message->connectionInfo.assocScanInfoElements);
    message->connectionInfo.assocScanInfoElements = NULL;
    CsrPmemFree(message->connectionInfo.assocReqInfoElements);
    message->connectionInfo.assocReqInfoElements = NULL;
    CsrPmemFree(message->connectionInfo.assocRspInfoElements);
    message->connectionInfo.assocRspInfoElements = NULL;
}

static void CsrWifiSmeBlacklistCfmFreeContents(CsrWifiSmeBlacklistCfm *message)
{
    CsrPmemFree(message->getAddresses);
    message->getAddresses = NULL;
}

static void CsrWifiSmeCalibrationDataGetCfmFreeContents(CsrWifiSmeCalibrationDataGetCfm *message)
{
    CsrPmemFree(message->calibrationData);
    message->calibrationData = NULL;
}

static void CsrWifiSmeConnectCfmFreeContents(CsrWifiSmeConnectCfm *message)
{
    CsrPmemFree(message->errorValues);
    message->errorValues = NULL;
}

static void CsrWifiSmeMediaStatusIndFreeContents(CsrWifiSmeMediaStatusInd *message)
{
    CsrPmemFree(message->connectionInfo.beaconFrame);
    message->connectionInfo.beaconFrame = NULL;
    CsrPmemFree(message->connectionInfo.associationReqFrame);
    message->connectionInfo.associationReqFrame = NULL;
    CsrPmemFree(message->connectionInfo.associationRspFrame);
    message->connectionInfo.associationRspFrame = NULL;
    CsrPmemFree(message->connectionInfo.assocScanInfoElements);
    message->connectionInfo.assocScanInfoElements = NULL;
    CsrPmemFree(message->connectionInfo.assocReqInfoElements);
    message->connectionInfo.assocReqInfoElements = NULL;
    CsrPmemFree(message->connectionInfo.assocRspInfoElements);
    message->connectionInfo.assocRspInfoElements = NULL;
}

static void CsrWifiSmeGetCfmFreeContents(CsrWifiSmeGetCfm *message)
{
    CsrPmemFree(message->values);
    message->values = NULL;
    CsrPmemFree(message->errorValues);
    message->errorValues = NULL;
}

static void CsrWifiSmeSetCfmFreeContents(CsrWifiSmeSetCfm *message)
{
    CsrPmemFree(message->errorValues);
    message->errorValues = NULL;
}

static void CsrWifiSmeMulticastAddressCfmFreeContents(CsrWifiSmeMulticastAddressCfm *message)
{
    CsrPmemFree(message->getAddresses);
    message->getAddresses = NULL;
}

static void CsrWifiSmePmkidCandidateListIndFreeContents(CsrWifiSmePmkidCandidateListInd *message)
{
    CsrPmemFree(message->pmkidCandidates);
    message->pmkidCandidates = NULL;
}

static void CsrWifiSmePmkidCfmFreeContents(CsrWifiSmePmkidCfm *message)
{
    CsrPmemFree(message->getPmkids);
    message->getPmkids = NULL;
}

static void CsrWifiSmeScanResultIndFreeContents(CsrWifiSmeScanResultInd *message)
{
    CsrPmemFree(message->result.informationElements);
    message->result.informationElements = NULL;
}

static void CsrWifiSmeScanResultsGetCfmFreeContents(CsrWifiSmeScanResultsGetCfm *message)
{
    {
        CsrUint16 i1;
        for (i1 = 0; i1 < message->scanResultsCount; i1++)
        {
            CsrPmemFree(message->scanResults[i1].informationElements);
            message->scanResults[i1].informationElements = NULL;
        }
    }
    CsrPmemFree(message->scanResults);
    message->scanResults = NULL;
}

static void CsrWifiSmeTspecIndFreeContents(CsrWifiSmeTspecInd *message)
{
    CsrPmemFree(message->tspec);
    message->tspec = NULL;
}

static void CsrWifiSmeTspecCfmFreeContents(CsrWifiSmeTspecCfm *message)
{
    CsrPmemFree(message->tspec);
    message->tspec = NULL;
}

static void CsrWifiSmeCloakedSsidsGetCfmFreeContents(CsrWifiSmeCloakedSsidsGetCfm *message)
{
    CsrPmemFree(message->cloakedSsids.cloakedSsids);
    message->cloakedSsids.cloakedSsids = NULL;
}

static void CsrWifiSmeCoreDumpIndFreeContents(CsrWifiSmeCoreDumpInd *message)
{
    CsrPmemFree(message->data);
    message->data = NULL;
}

/*----------------------------------------------------------------------------*
 *  NAME
 *      CsrWifiSmeFreeUpstreamMessageContents
 *
 *  DESCRIPTION
 *
 *
 *  PARAMETERS
 *      eventClass: only the value CSR_WIFI_SME_PRIM will be handled
 *      message:    the message to free
 *----------------------------------------------------------------------------*/
void CsrWifiSmeFreeUpstreamMessageContents(CsrUint16 eventClass, void *message)
{
    CsrWifiFsmEvent *evt = (CsrWifiFsmEvent *) message;
    if (evt && (eventClass == CSR_WIFI_SME_PRIM))
    {
        switch (evt->type)
        {
            case CSR_WIFI_SME_ASSOCIATION_COMPLETE_IND:
                CsrWifiSmeAssociationCompleteIndFreeContents((CsrWifiSmeAssociationCompleteInd *) message);
                break;
            case CSR_WIFI_SME_BLACKLIST_CFM:
                CsrWifiSmeBlacklistCfmFreeContents((CsrWifiSmeBlacklistCfm *) message);
                break;
            case CSR_WIFI_SME_CALIBRATION_DATA_GET_CFM:
                CsrWifiSmeCalibrationDataGetCfmFreeContents((CsrWifiSmeCalibrationDataGetCfm *) message);
                break;
            case CSR_WIFI_SME_CONNECT_CFM:
                CsrWifiSmeConnectCfmFreeContents((CsrWifiSmeConnectCfm *) message);
                break;
            case CSR_WIFI_SME_MEDIA_STATUS_IND:
                CsrWifiSmeMediaStatusIndFreeContents((CsrWifiSmeMediaStatusInd *) message);
                break;
            case CSR_WIFI_SME_GET_CFM:
                CsrWifiSmeGetCfmFreeContents((CsrWifiSmeGetCfm *) message);
                break;
            case CSR_WIFI_SME_SET_CFM:
                CsrWifiSmeSetCfmFreeContents((CsrWifiSmeSetCfm *) message);
                break;
            case CSR_WIFI_SME_MULTICAST_ADDRESS_CFM:
                CsrWifiSmeMulticastAddressCfmFreeContents((CsrWifiSmeMulticastAddressCfm *) message);
                break;
            case CSR_WIFI_SME_PMKID_CANDIDATE_LIST_IND:
                CsrWifiSmePmkidCandidateListIndFreeContents((CsrWifiSmePmkidCandidateListInd *) message);
                break;
            case CSR_WIFI_SME_PMKID_CFM:
                CsrWifiSmePmkidCfmFreeContents((CsrWifiSmePmkidCfm *) message);
                break;
            case CSR_WIFI_SME_SCAN_RESULT_IND:
                CsrWifiSmeScanResultIndFreeContents((CsrWifiSmeScanResultInd *) message);
                break;
            case CSR_WIFI_SME_SCAN_RESULTS_GET_CFM:
                CsrWifiSmeScanResultsGetCfmFreeContents((CsrWifiSmeScanResultsGetCfm *) message);
                break;
            case CSR_WIFI_SME_TSPEC_IND:
                CsrWifiSmeTspecIndFreeContents((CsrWifiSmeTspecInd *) message);
                break;
            case CSR_WIFI_SME_TSPEC_CFM:
                CsrWifiSmeTspecCfmFreeContents((CsrWifiSmeTspecCfm *) message);
                break;
            case CSR_WIFI_SME_CLOAKED_SSIDS_GET_CFM:
                CsrWifiSmeCloakedSsidsGetCfmFreeContents((CsrWifiSmeCloakedSsidsGetCfm *) message);
                break;
            case CSR_WIFI_SME_CORE_DUMP_IND:
                CsrWifiSmeCoreDumpIndFreeContents((CsrWifiSmeCoreDumpInd *) message);
                break;
            default:
                break;
        }
    }
}
